<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class DBTechvBShout_DataManager_Instance extends vB_DataManager
{
	/**
	* Array of recognised and required fields for instances, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'instanceid' 		=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_INCR, vB_DataManager_Constants::VF_METHOD, 	'verify_nonzero'),
		'varname' 			=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_YES, 	vB_DataManager_Constants::VF_METHOD),
		'name' 				=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_YES, 	vB_DataManager_Constants::VF_METHOD),
		'description' 		=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_NO),
		'active' 			=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_NO, 	vB_DataManager_Constants::VF_METHOD, 	'verify_onoff'),
		'displayorder' 		=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_NO),
		//'autodisplay' 		=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_YES),
		'permissions' 		=> array(vB_Cleaner::TYPE_NOCLEAN, 	vB_DataManager_Constants::REQ_NO, 	vB_DataManager_Constants::VF_METHOD, 	'verify_serialized'),
		'bbcodepermissions' => array(vB_Cleaner::TYPE_NOCLEAN, 	vB_DataManager_Constants::REQ_NO, 	vB_DataManager_Constants::VF_METHOD, 	'verify_serialized'),
		'options' 			=> array(vB_Cleaner::TYPE_NOCLEAN, 	vB_DataManager_Constants::REQ_YES, 	vB_DataManager_Constants::VF_METHOD, 	'verify_serialized'),
		'forumids' 			=> array(vB_Cleaner::TYPE_NOCLEAN, 	vB_DataManager_Constants::REQ_NO, 	vB_DataManager_Constants::VF_METHOD, 	'verify_serialized'),
		'sticky' 			=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_NO),
		'sticky_raw' 		=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_NO),
		'notices' 			=> array(vB_Cleaner::TYPE_NOCLEAN, 	vB_DataManager_Constants::REQ_NO, 	vB_DataManager_Constants::VF_METHOD, 	'verify_serialized'),
		'shoutsound' 		=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_NO),
		'invitesound' 		=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_NO),
		'pmsound' 			=> array(vB_Cleaner::TYPE_STR, 		vB_DataManager_Constants::REQ_NO),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'DBTechvBShout:dbtech_vbshout_instance';

	//Primary Key
	protected $keyField = 'instanceid';

	/**
	* Verifies that the name is valid
	*
	* @param	string	name of the block
	*
	* @return	boolean
	*/
	function verify_name(&$name)
	{
		$name = strval($name);
		if ($name === '')
		{
			// Invalid
			return false;
		}
		
		/*
		// Check for existing block of this name
		if ($existing = vB::getDbAssertor()->getRow('DBTechvBShout:dbtech_vbshout_instance', array(
			vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
			vB_dB_Query::CONDITIONS_KEY => array( 
				array('field' => 'name', 		'value' => $name, 								'operator' => vB_dB_Query::OPERATOR_EQ),
				array('field' => 'instanceid', 	'value' => (int)$this->existing['instanceid'], 	'operator' => vB_dB_Query::OPERATOR_NE),
			),
			vB_dB_Query::PARAM_LIMIT => 1))
		)
		{
			// Whoopsie, exists
			$this->error('dbtech_vbshout_x_already_exists_y', (string) new vB_Phrase('hooks', 'dbtech_vbshout_instance'), $name);
			return false;
		}
		 */
		
		return true;
	}

	/**
	* Verifies that the varname is valid
	*
	* @param	string	varname of the block
	*
	* @return	boolean
	*/
	function verify_varname(&$varname)
	{
		$varname = strval($varname);
		if ($varname === '')
		{
			// Invalid
			return false;
		}
		
		// Check for existing block of this varname
		if ($existing = vB::getDbAssertor()->getRow('DBTechvBShout:dbtech_vbshout_instance', array(
			vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
			vB_dB_Query::CONDITIONS_KEY => array( 
				array('field' => 'varname', 	'value' => $varname, 							'operator' => vB_dB_Query::OPERATOR_EQ),
				array('field' => 'instanceid', 	'value' => (int)$this->existing['instanceid'], 	'operator' => vB_dB_Query::OPERATOR_NE),
			),
			vB_dB_Query::PARAM_LIMIT => 1))
		)
		{
			// Whoopsie, exists
			$this->error('dbtech_vbshout_x_already_exists_y', (string) new vB_Phrase('hooks', 'dbtech_vbshout_instance'), $varname);
			return false;
		}
		
		return true;
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_onoff(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array(0, 1)) ? 1 : $onoff);
		
		return true;
	}

	/**
	* Saves the data from the object into the specified database tables
	*
	* @param	boolean	Do the query?
	* @param	mixed	Whether to run the query now; see db_update() for more info
	* @param bool 	Whether to return the number of affected rows.
	* @param bool		Perform REPLACE INTO instead of INSERT
	* @param bool		Perfrom INSERT IGNORE instead of INSERT
	*
	* @return	mixed	If this was an INSERT query, the INSERT ID is returned
	*/
	function save($doquery = true, $delayed = false, $affected_rows = false, $replace = false, $ignore = false)
	{
		if (!$this->pre_save($doquery))
		{
			// Pre-save failed
			if (!empty($this->errors))
			{
				// Set the errors
				vB_Api::instance('vbshout_shoutbox')->setFetchedValue('errors', $this->errors);
				
				return false;
			}
			
			return false;
		}
		
		// Call and get the new id
		$result = parent::save($doquery, $delayed, $affected_rows, $replace, $ignore);
		
		// Legacy hook 'dbtech_vbshout_shout_insert' removed				

		return $result;		
	}	

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		// Rebuild the cache
		vB_Api::instance('vbshout_core')->buildCache('instance');

		// Grab the definition
		$widgetDefinition = vB::getDbAssertor()->getRow('widgetdefinition', array(
			'name' => 'dbtech_vbshout_instanceid',
			'field' => 'Select'
		));
		$widgetDefinition['data'] = unserialize($widgetDefinition['data']);
		$widgetDefinition['data'] = is_array($widgetDefinition['data']) ? $widgetDefinition['data'] : array();

		// Update title
		$widgetDefinition['data'][$this->fetch_field('instanceid')] = $this->fetch_field('name');

		foreach ($widgetDefinition['data'] as $defaultInstanceId => $defaultInstance)
		{
			// Grab first value
			break;
		}

		// Update
		vB::getDbAssertor()->update('widgetdefinition', array(
			'data' => trim(serialize($widgetDefinition['data'])),
			'defaultvalue' => $defaultInstanceId,
		), array(
			'name' => 'dbtech_vbshout_instanceid',
			'field' => 'Select'
		));

		return true;
	}

	/**
	* Deletes the specified data item from the database
	*
	* @return	integer	The number of rows deleted
	*/
	function delete($doquery = true)
	{
		if (!$this->pre_delete($doquery))
		{
			// Pre-save failed
			if (!empty($this->errors))
			{
				// Set the errors
				vB_Api::instance('vbshout_shoutbox')->setFetchedValue('errors', $this->errors);
				
				return false;
			}
			
			return false;
		}
		
		$result = parent::delete($doquery);
		
		return $result;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		// Rebuild the cache
		vB_Api::instance('vbshout_core')->buildCache('instance');
		
		// Grab the definition
		$widgetDefinition = vB::getDbAssertor()->getRow('widgetdefinition', array(
			'name' => 'dbtech_vbshout_instanceid',
			'field' => 'Select'
		));
		$widgetDefinition['data'] = unserialize($widgetDefinition['data']);
		$widgetDefinition['data'] = is_array($widgetDefinition['data']) ? $widgetDefinition['data'] : array();

		// Update title
		unset($widgetDefinition['data'][$this->existing['instanceid']]);

		// Update
		// Update
		vB::getDbAssertor()->update('widgetdefinition', array(
			'data' => trim(serialize($widgetDefinition['data'])),
			'defaultvalue' => $defaultInstanceId,
		), array(
			'name' => 'dbtech_vbshout_instanceid',
			'field' => 'Select'
		));

		return true;
	}
}