<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class DBTechvBShout_DataManager_Chatroom extends vB_DataManager
{
	/**
	* Array of recognised and required fields for chatrooms, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'chatroomid' 		=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_INCR, vB_DataManager_Constants::VF_METHOD, 	'verify_nonzero'),
		'title' 			=> array(vB_Cleaner::TYPE_NOHTML, 	vB_DataManager_Constants::REQ_YES, 	vB_DataManager_Constants::VF_METHOD),
		'active' 			=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_NO, 	vB_DataManager_Constants::VF_METHOD, 	'verify_onoff'),
		'instanceid' 		=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_NO, 	vB_DataManager_Constants::VF_METHOD),
		'membergroupids' 	=> array(vB_Cleaner::TYPE_NOCLEAN, 	vB_DataManager_Constants::REQ_NO, 	vB_DataManager_Constants::VF_METHOD, 	'verify_commalist'),
		'creator' 			=> array(vB_Cleaner::TYPE_UINT, 	vB_DataManager_Constants::REQ_YES, 	vB_DataManager_Constants::VF_METHOD, 	'verify_userid'),
		'members' 			=> array(vB_Cleaner::TYPE_NOCLEAN, 	vB_DataManager_Constants::REQ_NO, 	vB_DataManager_Constants::VF_METHOD, 	'verify_serialized'),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'DBTechvBShout:dbtech_vbshout_chatroom';

	//Primary Key
	protected $keyField = 'chatroomid';

	/**
	* Verifies that the title is valid
	*
	* @param	string	Title of the chatroom
	*
	* @return	boolean
	*/
	function verify_title(&$title)
	{
		$title = strval($title);
		if ($title === '')
		{
			// Invalid
			return false;
		}
		
		/*
		// Check for existing block of this name
		if ($existing = vB::getDbAssertor()->getRow('DBTechvBShout:dbtech_vbshout_chatroom', array(
			vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
			vB_dB_Query::CONDITIONS_KEY => array( 
				array('field' => 'name', 		'value' => $title, 								'operator' => vB_dB_Query::OPERATOR_EQ),
				array('field' => 'chatroomid', 	'value' => (int)$this->existing['chatroomid'], 	'operator' => vB_dB_Query::OPERATOR_NE),
			),
			vB_dB_Query::PARAM_LIMIT => 1))
		)
		{
			// Whoopsie, exists
			$this->error('dbtech_vbshout_x_already_exists_y', new vB_Phrase('hooks', 'dbtech_vbshout_chatroom'), $title);
			return false;
		}
		*/
		
		return true;
	}

	/**
	* Verifies that the instanceid is valid
	*
	* @param	integer	instanceid of the chatroom
	*
	* @return	boolean
	*/
	function verify_instanceid(&$instanceid)
	{
		return (is_array(vB_Api::instance('vbshout_core')->getCacheElement('instance', $instanceid)) OR $instanceid == 0);
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_onoff(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array(0, 1)) ? 1 : $onoff);
		
		return true;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		// Rebuild the cache
		vB_Api::instance('vbshout_core')->buildCache('chatroom');

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		// Delete shouts
		vB::getDbAssertor()->delete('DBTechvBShout:dbtech_vbshout_shout', 			array('chatroomid' => $this->existing['chatroomid']));
		vB::getDbAssertor()->delete('DBTechvBShout:dbtech_vbshout_chatroommember', 	array('chatroomid' => $this->existing['chatroomid']));
	
		// Rebuild the cache
		vB_Api::instance('vbshout_core')->buildCache('chatroom');
		
		// Rebuild shout counters
		vB::getDbAssertor()->assertQuery('DBTechvBShout:buildShoutsCounter', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_STORED));
		
		return true;
	}
}