<?php if (!defined('VB_ENTRY')) die('Access denied.');

require_once(DIR . '/packages/dbtechvbshout/class_api_core.php');

/**
 * vB_Api_DBTechvBShout
 *
 * @package DBTechvBShout
 * @access public
 */
class DBTechvBShout_Api_Vbshout_Shoutbox extends DBTechvBShout_Core
{
	public $title = 'Shoutbox Rendering API';
	public $version = '2.0.0';	
	public $extensionOrder = 9;

	/**
	* List of all info returned by the fetcher
	*
	* @protected	array
	*/	
	protected static $fetched 		= array();

	/**
	* The Tab ID we're working with
	*
	* @protected	string
	*/	
	protected static $tabid 		= '';
	
	/**
	* What instance we are working with
	*
	* @protected	array
	*/	
	protected static $instance 		= array();
	
	/**
	* What chatroom we are working with
	*
	* @protected	array
	*/	
	protected static $chatroom 		= array();

	/**
	* List of shout types
	*
	* @protected	array
	*/	
	protected static $shouttypes 	= array(
		'shout'		=> 1,
		'pm'		=> 2,
		'me'		=> 4,
		'notif'		=> 8,
		'custom'	=> 16,
		'system'	=> 32,
		'mention'	=> 64,
		'tag'		=> 128,
		'thanks'	=> 256,
	);
	
	/**
	* The list of BBCode tags enabled globally
	*
	* @protected	array
	*/	
	protected static $tag_list 		= array();
	
	/**
	* The list of active users
	*
	* @protected	array
	*/	
	protected static $activeusers 	= NULL;

	
	public function callNamed()
	{
		// since the parent method has different arguments, 
		// we need to do this to avoid strict standards notice
		list($prevResult, $method, $args) = func_get_args();
		
		// Ensure this is done
		vB_Api::instance('options')->fetch();

		switch ($method)
		{
			case 'getInstanceVars':
				return vB_Api::instance('vbshout_shoutbox')->getInstanceVars();
				break;

			case 'ajax':

				// Grab instance id
				$instanceid = array_key_exists('instanceid', $args) ? $args['instanceid'] : 0;
				
				if (!self::$instance = vB_Api::instance('vbshout_core')->getCacheElement('instance', $instanceid))
				{
					// Wrong instance
					self::$fetched['error'] = 'dbtech_vbshout_invalid_instance';
					
					// Returns the array
					return self::$fetched;
				}
				
				if (array_key_exists('chatroomid', $args))
				{
					// Check if the chatroom is active
					self::$chatroom = vB_Api::instance('vbshout_core')->getCacheElement('chatroom', $args['chatroomid']);
					
					if ($args['action'] != 'JoinChat')
					{
						if (!self::$chatroom OR !self::$chatroom['active'])
						{
							// Wrong chatroom
							self::$fetched['error'] = 'disband_' . $args['chatroomid'];
						}
						
						if (!self::$chatroom['membergroupids'])
						{
							// This is not a members-only group
							if (!isset(self::$chatroom['members'][vB::getUserContext()->fetchUserId()]))
							{
								// We're not a member
								self::$fetched['error'] = 'disband_' . $args['chatroomid'];
							}
						}
						else
						{
							if (!count(array_intersect(vB::getUserContext()->fetchUserGroups(), explode(',', self::$chatroom['membergroupids']))))
							{
								// Usergroup no longer a member
								self::$fetched['error'] = 'disband_' . $args['chatroomid'];
							}			
						}
						
						// Override tabid for AOP purposes
						self::$tabid = 'chatroom_' . $args['chatroomid'] . '_' . self::$chatroom['instanceid'];
					}
				}
				
				

				// Legacy hook 'dbtech_vbshout_ajax_handler_start' removed
				
				if (
					(array_key_exists('error', self::$fetched) AND self::$fetched['error']) OR 
					(array_key_exists('errors', self::$fetched) AND self::$fetched['errors'])
				)
				{
					// We had errors, don't bother
					return self::$fetched;
				}

				$func = '_' . $method . $args['action'];
				if (method_exists(__CLASS__, $func))
				{
					// Do it!
					self::$func($args);
				}

				return self::$fetched;
				break;
		}
	}

	/**
	 * Sets default instance options
	 *
	 * @return	array
	 */
	public static function loadDefaultOptions($prevResult, $instance)
	{
		$instance['options']['logging'] 				= (isset($instance['options']['logging']) 					? $instance['options']['logging'] 					: 0);
		$instance['options']['editors'] 				= (isset($instance['options']['editors']) 					? $instance['options']['editors'] 					: 0);
		$instance['options']['notices'] 				= (isset($instance['options']['notices']) 					? $instance['options']['notices'] 					: 0);
		//$instance['options']['optimisation'] 			= (isset($instance['options']['optimisation']) 				? $instance['options']['optimisation'] 				: 1);
		$instance['options']['allowsmilies'] 			= (isset($instance['options']['allowsmilies']) 				? $instance['options']['allowsmilies'] 				: 1);
		$instance['options']['activeusers'] 			= (isset($instance['options']['activeusers']) 				? $instance['options']['activeusers'] 				: 1);
		$instance['options']['sounds'] 					= (isset($instance['options']['sounds']) 					? $instance['options']['sounds'] 					: 1);
		$instance['options']['disableshoutsound'] 		= (isset($instance['options']['disableshoutsound']) 		? $instance['options']['disableshoutsound'] 		: 0);
		$instance['options']['disableinvitesound'] 		= (isset($instance['options']['disableinvitesound']) 		? $instance['options']['disableinvitesound'] 		: 0);
		$instance['options']['disablepmsound'] 			= (isset($instance['options']['disablepmsound']) 			? $instance['options']['disablepmsound'] 			: 0);
		//$instance['options']['enablemenu'] 				= (isset($instance['options']['enablemenu']) 				? $instance['options']['enablemenu'] 				: 1);
		$instance['options']['altshouts'] 				= (isset($instance['options']['altshouts']) 				? $instance['options']['altshouts'] 				: 0);
		$instance['options']['enableaccess'] 			= (isset($instance['options']['enableaccess']) 				? $instance['options']['enableaccess'] 				: 1);
		$instance['options']['maxshouts'] 				= (isset($instance['options']['maxshouts']) 				? $instance['options']['maxshouts'] 				: 20);
		$instance['options']['maxarchiveshouts'] 		= (isset($instance['options']['maxarchiveshouts']) 			? $instance['options']['maxarchiveshouts'] 			: 20);
		$instance['options']['height'] 					= (isset($instance['options']['height']) 					? $instance['options']['height'] 					: 150);
		$instance['options']['floodchecktime'] 			= (isset($instance['options']['floodchecktime']) 			? $instance['options']['floodchecktime'] 			: 3);
		$instance['options']['maxchars'] 				= (isset($instance['options']['maxchars']) 					? $instance['options']['maxchars'] 					: 256);
		$instance['options']['maximages'] 				= (isset($instance['options']['maximages']) 				? $instance['options']['maximages'] 				: 2);
		$instance['options']['idletimeout'] 			= (isset($instance['options']['idletimeout']) 				? $instance['options']['idletimeout'] 				: 180);
		$instance['options']['refresh'] 				= (isset($instance['options']['refresh']) 					? $instance['options']['refresh'] 					: 5);
		$instance['options']['maxchats'] 				= (isset($instance['options']['maxchats']) 					? $instance['options']['maxchats'] 					: 5);
		$instance['options']['shoutorder'] 				= (isset($instance['options']['shoutorder']) 				? $instance['options']['shoutorder'] 				: 'DESC');
		$instance['options']['maxsize'] 				= (isset($instance['options']['maxsize']) 					? $instance['options']['maxsize'] 					: 3);
		$instance['options']['postping_interval'] 		= (isset($instance['options']['postping_interval']) 		? $instance['options']['postping_interval'] 		: 50);
		$instance['options']['threadping_interval'] 	= (isset($instance['options']['threadping_interval']) 		? $instance['options']['threadping_interval'] 		: 50);
		$instance['options']['memberping_interval'] 	= (isset($instance['options']['memberping_interval']) 		? $instance['options']['memberping_interval'] 		: 50);
		$instance['options']['shoutboxtabs'] 			= (isset($instance['options']['shoutboxtabs']) 				? $instance['options']['shoutboxtabs'] 				: 0);
		$instance['options']['logging_deep'] 			= (isset($instance['options']['logging_deep']) 				? $instance['options']['logging_deep'] 				: 0);
		$instance['options']['logging_deep_system'] 	= (isset($instance['options']['logging_deep_system']) 		? $instance['options']['logging_deep_system'] 		: 0);
		$instance['options']['enablepms'] 				= (isset($instance['options']['enablepms']) 				? $instance['options']['enablepms'] 				: 1);
		$instance['options']['enablepmnotifs'] 			= (isset($instance['options']['enablepmnotifs']) 			? $instance['options']['enablepmnotifs'] 			: 1);
		$instance['options']['enable_sysmsg'] 			= (isset($instance['options']['enable_sysmsg']) 			? $instance['options']['enable_sysmsg'] 			: 1);
		$instance['options']['sounds_idle'] 			= (isset($instance['options']['sounds_idle']) 				? $instance['options']['sounds_idle'] 				: 0);
		$instance['options']['avatars_normal'] 			= (isset($instance['options']['avatars_normal']) 			? $instance['options']['avatars_normal'] 			: 0);
		$instance['options']['avatar_width_normal'] 	= (isset($instance['options']['avatar_width_normal']) 		? $instance['options']['avatar_width_normal'] 		: 11);
		$instance['options']['avatar_height_normal'] 	= (isset($instance['options']['avatar_height_normal']) 		? $instance['options']['avatar_height_normal'] 		: 11);
		$instance['options']['avatars_full'] 			= (isset($instance['options']['avatars_full']) 				? $instance['options']['avatars_full'] 				: 0);
		$instance['options']['avatar_width_full'] 		= (isset($instance['options']['avatar_width_full']) 		? $instance['options']['avatar_width_full'] 		: 22);
		$instance['options']['avatar_height_full'] 		= (isset($instance['options']['avatar_height_full']) 		? $instance['options']['avatar_height_full'] 		: 22);
		$instance['options']['maxshouts_detached'] 		= (isset($instance['options']['maxshouts_detached']) 		? $instance['options']['maxshouts_detached'] 		: 40);
		$instance['options']['height_detached'] 		= (isset($instance['options']['height_detached']) 			? $instance['options']['height_detached'] 			: 300);
		$instance['options']['refresh_idle'] 			= (isset($instance['options']['refresh_idle']) 				? $instance['options']['refresh_idle'] 				: 5);
		$instance['options']['archive_numtopshouters'] 	= (isset($instance['options']['archive_numtopshouters']) 	? $instance['options']['archive_numtopshouters'] 	: 10);
		$instance['options']['autodelete'] 				= (isset($instance['options']['autodelete']) 				? $instance['options']['autodelete'] 				: 0);
		$instance['options']['shoutarea'] 				= (isset($instance['options']['shoutarea']) 				? $instance['options']['shoutarea'] 				: 'left');
		$instance['options']['archive_link'] 			= (isset($instance['options']['archive_link']) 				? $instance['options']['archive_link'] 				: 0);
		$instance['options']['minposts'] 				= (isset($instance['options']['minposts']) 					? $instance['options']['minposts'] 					: 0);
		$instance['options']['timeformat'] 				= (isset($instance['options']['timeformat']) 				? $instance['options']['timeformat'] 				: vB::getDatastore()->getOption('timeformat'));
		$instance['options']['blogping_interval'] 		= (isset($instance['options']['blogping_interval']) 		? $instance['options']['blogping_interval'] 		: 50);
		$instance['options']['shoutping_interval'] 		= (isset($instance['options']['shoutping_interval']) 		? $instance['options']['shoutping_interval'] 		: 50);
		$instance['options']['aptlping_interval'] 		= (isset($instance['options']['aptlping_interval']) 		? $instance['options']['aptlping_interval'] 		: 50);
		$instance['options']['tagping_interval'] 		= (isset($instance['options']['tagping_interval']) 			? $instance['options']['tagping_interval'] 			: 50);
		$instance['options']['mentionping_interval'] 	= (isset($instance['options']['mentionping_interval']) 		? $instance['options']['mentionping_interval'] 		: 50);
		$instance['options']['quoteping_interval'] 		= (isset($instance['options']['quoteping_interval']) 		? $instance['options']['quoteping_interval'] 		: 50);
		$instance['options']['quizmadeping_interval'] 	= (isset($instance['options']['quizmadeping_interval']) 	? $instance['options']['quizmadeping_interval'] 	: 50);
		$instance['options']['quiztakenping_interval'] 	= (isset($instance['options']['quiztakenping_interval']) 	? $instance['options']['quiztakenping_interval'] 	: 50);		

		return $instance;
	}

	/**
	 * Sets instance permissions
	 *
	 * @return	array
	 */
	public static function loadDefaultPermissions($prevResult, $instance)
	{
		// Set the completed permissions array
		$instance['permissions_parsed'] = vB_Api::instance('vbshout_shoutbox')->buildPermissionsArray($instance);

		return $instance;
	}

	/**
	 * Sets instance BBCode permissions
	 *
	 * @return	array
	 */
	public static function loadDefaultBbcodePermissions($prevResult, $instance)
	{
		// Set the completed permissions array
		$instance['bbcodepermissions_parsed'] = vB_Api::instance('vbshout_shoutbox')->buildBbcodePermissionsArray($instance);

		return $instance;
	}

	/**
	 * Sets some additional instance options based on our context
	 *
	 * @return	array
	 */
	public static function fetchInstanceOptions($prevResult, $instanceId, $detached = false)
	{
		if (!$instance = vB_Api::instance('vbshout_core')->getCacheElement('instance', $instanceId))
		{
			// Git oot
			return false;
		}

		// Shorthand
		$userInfo = vB_User::fetchUserinfo();

		// Ensure this is an array
		$userInfo['dbtech_vbshout_shoutstyle'] = @unserialize($userInfo['dbtech_vbshout_shoutstyle']);
		$userInfo['dbtech_vbshout_shoutstyle'] = is_array($userInfo['dbtech_vbshout_shoutstyle']) ? $userInfo['dbtech_vbshout_shoutstyle'] : array();

		// ######################## Start Value Fallback #########################
		// @TODO: Convert the default font size to a instance option
		$instance['options']['size'] = '11px';
		$instance['options']['addedPx'] = 0;
		$instance['options']['csshack'] = !$instance['permissions_parsed']['canshout'] ? ' dbtech_shouts_full' : '';

		// Maximum Characters Per Shout
		$instance['options']['maxchars'] 		= ($instance['options']['maxchars'] 				> 0 	? $instance['options']['maxchars'] 	: vB::getDatastore()->getOption('postmaxchars'));
		$instance['options']['maxchars'] 		= ($instance['permissions_parsed']['ismanager'] 	> 0 	? 0 								: $instance['options']['maxchars']);
		
		// Maximum Images Per Shout
		$instance['options']['maximages'] 		= ($instance['options']['maximages'] 				> 0 	? $instance['options']['maximages'] : vB::getDatastore()->getOption('maximages'));
		
		// Flood check time
		$instance['options']['floodchecktime'] 	= ($instance['permissions_parsed']['ismanager'] 	> 0 	? 0 								: $instance['options']['floodchecktime']);
		
		if ($detached)
		{
			$instance['options']['height'] 		= $instance['options']['height_detached'];
			$instance['options']['maxshouts'] 	= $instance['options']['maxshouts_detached'];
		}
		// ######################## End Value Fallback ###########################

		// Init this
		$suffix = '';

		

		

		if ($instance['permissions_parsed']['canshout'])
		{
			switch ($instance['options']['shoutarea'])
			{
				case 'above':
				case 'below':
					$instance['options']['addedPx'] = 60;
					break;
			}
		}

		return $instance['options'];
	}

	/**
	 * Grab all the instance vars we need
	 *
	 * @return	array
	 */
	public static function getInstanceVars($prevResult)
	{
		$retval = array(
			'editorOptions' 		=> array(),
			'instanceOptions' 		=> array(),
			'instancePermissions' 	=> array(),
			'bbcodePermissions' 	=> array(),
			'userOptions' 			=> array(),
			'tabs' 					=> array()
		);

		// Shorthand
		$userInfo = vB_User::fetchUserinfo();

		foreach (array(
			'dbtech_vbshout_general_settings' 	=> vB::getDatastore()->getValue('bf_misc_dbtech_vbshout_general_settings'),
			'dbtech_vbshout_editor_settings' 	=> vB::getDatastore()->getValue('bf_misc_dbtech_vbshout_editor_settings')
		) as $settinggroup => $settings)
		{
			foreach ($settings as $settingname => $bit)
			{
				$retval['userOptions'][substr($settingname, vB_String::vbStrlen('dbtech_vbshout_'))] = ((int)$userInfo['dbtech_vbshout_settings'] & (int)$bit) ? 1 : 0;
			}
		}		

		// Set this
		$retval['userOptions']['soundSettings'] = unserialize($userInfo['dbtech_vbshout_soundsettings']);
		$retval['userOptions']['soundSettings'] = is_array($retval['userOptions']['soundSettings']) ? $retval['userOptions']['soundSettings'] : array();

		foreach (vB_Api::instance('vbshout_core')->getCache('instance') as $instanceId => $instance)
		{
			if ($userInfo['userid'] AND $instance['permissions_parsed']['canshout'])
			{
				$shoutStyle = @unserialize($userInfo['dbtech_vbshout_shoutstyle']);
				
				if (!($instance['options']['editors'] & 1))
				{
					// Bold
					$retval['editorOptions'][$instanceId]['bold'] = !in_array($shoutStyle[$instanceId]['bold'], array('', 'null', 'false'));
				}
				
				if (!($instance['options']['editors'] & 2))
				{
					// Italic
					$retval['editorOptions'][$instanceId]['italic'] = !in_array($shoutStyle[$instanceId]['italic'], array('', 'null', 'false'));
				}
				
				if (!($instance['options']['editors'] & 4))
				{
					// Underline
					$retval['editorOptions'][$instanceId]['underline'] = !in_array($shoutStyle[$instanceId]['underline'], array('', 'null', 'false'));
				}
								
				if (!($instance['options']['editors'] & 8))
				{
					// Color
					$retval['editorOptions'][$instanceId]['color'] = !in_array($shoutStyle[$instanceId]['color'], array('', 'null', 'false'));
				}						
								
				if (!($instance['options']['editors'] & 16))
				{
					// Font
					$retval['editorOptions'][$instanceId]['font'] = $shoutStyle[$instanceId]['font'] ? $shoutStyle[$instanceId]['font'] : 'Tahoma';
				}
				
				
			}

			// To avoid JS hass
			$retval['userOptions']['idle'][$instanceId]['unIdle'] = false;
			$retval['userOptions']['idle'][$instanceId]['unPause'] = false;
			
			// Do detached check
			// @TODO: change this
			$retval['userOptions']['is_detached'] = 0; //$retval['userOptions']['is_detached'] = (int)(vB_Api::instance('vbshout_core')->isPro() AND THIS_SCRIPT == 'vbshout' AND $_REQUEST['do'] == 'detach');
			$retval['userOptions']['pmtime'] = $userInfo['dbtech_vbshout_pm'];

			// Set these per-instance arrays
			$retval['instanceOptions'][$instanceId] 		= $instance['options'];
			$retval['instancePermissions'][$instanceId] 	= $instance['permissions_parsed'];
			$retval['bbcodePermissions'][$instanceId] 		= $instance['bbcodepermissions_parsed'];
			$retval['tabs'][$instanceId] 					= self::_sortTabs(vB_Api::instance('vbshout_shoutbox')->fetchTabs($instance), $instanceId); // Done via vB_Api to allow other mods to extend the tabs array
		}

		// We need to convert $data charset if we're not using UTF-8
		if (vB_String::getCharset() != 'UTF-8')
		{
			$retval = vB_String::toCharset($retval, vB_String::getCharset(), 'UTF-8');
		}

		return json_encode($retval);
	}

	/**
	 * Fetches tabs for a specified instance
	 *
	 * @return	array
	 */
	public static function fetchTabs($prevResult, array $instance)
	{
		// Shorthand
		$userInfo = vB_User::fetchUserinfo();

		$unsortedTabs = array();
		do
		{
			if (!$instance['permissions_parsed']['canmodchat'])
			{
				// No mod perms
				break;
			}

			

			/*
			$unsortedTabs['shoutreports'] = array(
				'text' 			=> (string) new vB_Phrase('hooks', 'dbtech_vbshout_unhandled_reports') . ': <span name="dbtech_vbshout_shoutreports" data-instanceid="' . $instance['instanceid'] . '">0</span>',
				'canclose' 		=> '0',
				'extraparams' 	=> array(
					'loadurl' => 'vbshout.php?' . vB::getCurrentSession()->get('sessionurl_js') . 'do=reportlist&instanceid=' . $instance['instanceid']
				)				
			);
			 */			
		}
		while (false);

		// Put the two create tabs here for the sysmsg and notif
		if (!($instance['options']['shoutboxtabs'] & 1))
		{
			$unsortedTabs['shoutnotifs'] = array(
				'text' 		=> (string) new vB_Phrase('hooks', 'dbtech_vbshout_notifications'),
				'canclose' 	=> '0',
			);
		}

		if (!($instance['options']['shoutboxtabs'] & 2))
		{
			$unsortedTabs['systemmsgs'] = array(
				'text' 		=> (string) new vB_Phrase('hooks', 'dbtech_vbshout_system_messages'),
				'canclose' 	=> '0',
			);
		}		
		
		foreach ((array)vB_Api::instance('vbshout_core')->getCache('chatroom') as $chatroomid => $chatroom)
		{
			if (!$chatroom['active'])
			{
				// Inactive chat room
				continue;
			}
			
			if ($chatroom['instanceid'] != $instance['instanceid'] AND $chatroom['instanceid'])
			{
				// Wrong instance id
				continue;
			}
			
			if ($chatroom['membergroupids'])
			{
				if (count(array_intersect(vB::getUserContext()->fetchUserGroups(), explode(',', $chatroom['membergroupids']))) > 0)
				{
					// Do join it
					$unsortedTabs['chatroom_' . $chatroomid . '_' . $chatroom['instanceid']] = array(
						'text' 			=> $chatroom['title'],
						'canclose' 		=> '0',
						'extraparams' 	=> array(
							'chatroomid' => $chatroomid
						)
					);
				}
			}
			else
			{
				if ($chatroom['members'][$userInfo['userid']] == '1')
				{
					// Do join it
					$unsortedTabs['chatroom_' . $chatroomid . '_' . $chatroom['instanceid']] = array(
						'text' 			=> $chatroom['title'],
						'canclose' 		=> '1',
						'extraparams' 	=> array(
							'chatroomid' => $chatroomid
						)
					);
				}
			}
		}

		return $unsortedTabs;
	}

	/**
	 * Sorts the tabs presented
	 *
	 * @return	array
	 */
	protected static function _sortTabs($prevResult, $instanceId)
	{
		// Shorthand
		$userInfo = vB_User::fetchUserinfo();

		if (!is_array($userInfo['dbtech_vbshout_displayorder']))
		{
			// Only unserialize if it's not an array
			$userInfo['dbtech_vbshout_displayorder'] = @unserialize($userInfo['dbtech_vbshout_displayorder']);
		}
		
		$tabs = array();
		
		
		foreach ($prevResult as $tabId => $tab)
		{
			// Add remaining unsorted tabs
			$tabs[$tabId] = $tab;
		}

		return $tabs;
	}

	/**
	 * Loads instance permissions for a specific user
	 *
	 * @return	array
	 */
	public static function buildPermissionsArray($prevResult, $instance, $userinfo = NULL)
	{
		// Grab the userinfo for current user
		$userInfo = vB_User::fetchUserinfo();

		if ($userinfo === NULL)
		{
			// We're using our own user info
			$userinfo = $userInfo;
		}
		else if ($userinfo['userid'] == $userInfo['userid'] AND is_array($instance['permissions_parsed']))
		{
			// Just return parsed
			return $instance['permissions_parsed'];
		}

		foreach (vB::getUserContext($userinfo['userid'])->fetchUserGroups() as $usergroupid)
		{
			if (!$usergroupid)
			{
				// Just skip it
				continue;
			}
			
			foreach (vB::getDatastore()->getValue('bf_misc_dbtech_vbshoutpermissions') as $permname => $bit)
			{
				if (!isset($permarray[$permname]))
				{
					// Default to false
					$permarray[$permname] = false;
				}

				if (!isset($instance['permissions'][$usergroupid]))
				{
					// Default to false
					$permarray[$permname] = false;
					continue;
				}
				
				if (!$permarray[$permname] AND ((int)$instance['permissions'][$usergroupid] & (int)$bit))
				{
					// Override to true
					$permarray[$permname] = true;
				}
			}			
		}

		// Some hardcoded ones
		$permarray['ismanager'] 	= vB::getUserContext($userinfo['userid'])->hasPermission('dbtech_vbshoutpermissions', 'ismanager');
		if ($permarray['ismanager'])
		{
			// Ensure this is ticked, always
			$permarray['canpm'] = $permarray['cancreatechat'] = $permarray['canmodchat'] = true;
		}

		return $permarray;
	}

	/**
	 * Loads instance permissions for a specific user
	 *
	 * @return	array
	 */
	public static function buildBbcodePermissionsArray($prevResult, $instance, $userinfo = NULL)
	{
		// Grab the userinfo for current user
		$userInfo = vB_User::fetchUserinfo();

		// Set permissions shorthand
		$bitvalue 	= 0;
		$permarray = array();

		if ($userinfo === NULL)
		{
			// We're using our own user info
			$userinfo = $userInfo;
		}
		else if ($userinfo['userid'] == $userInfo['userid'] AND is_array($instance['bbcodepermissions_parsed']))
		{
			// Just return parsed
			return $instance['bbcodepermissions_parsed'];
		}

		foreach (vB::getUserContext($userinfo['userid'])->fetchUserGroups() as $usergroupid)
		{
			if (!$usergroupid)
			{
				// Just skip it
				continue;
			}
			
			foreach (vB::getDatastore()->getValue('bf_misc_dbtech_vbshout_allowedbbcodesfull') as $permname => $bit)
			{
				if (!isset($permarray[$permname]))
				{
					// Default to false
					$permarray[$permname] = false;
				}
				
				if (!$permarray[$permname] AND ((int)$instance['bbcodepermissions'][$usergroupid] & (int)$bit))
				{
					// Override to true
					$permarray[$permname] = true;
					$bitvalue += $bit;
				}
			}
		}

		return array('bit' => $bitvalue, 'array' => $permarray);
	}

	/**
	 * Fetches the specific shout type from the list
	 *
	 * @return	int
	 */
	public static function getShoutType($prevResult, $type)
	{
		// Grab the shout type
		return array_key_exists($type, self::$shouttypes) ? self::$shouttypes[$type] : 0;
	}

	/**
	 * Fetches the shout types
	 *
	 * @return	int
	 */
	public static function getShoutTypes($prevResult)
	{
		// Grab the shout type
		return self::$shouttypes;
	}

	/**
	 * Loads the arguments for the shoutbox based on the passed type
	 *
	 * @return	array
	 */
	public static function loadArgs($prevResult, $type, $GPC)
	{
		// Init this
		$args = array(
			'chatroomid' 	=> array_key_exists('chatroomid', self::$chatroom) ? self::$chatroom['chatroomid'] : 0,
			'types' 		=> -1,
		);

		if (substr($type, 0, 2) == 'pm')
		{
			// Fetch the userid from the PM type
			$userid = explode('_', $type);
			$userid = $userid[1];
			
			// Set shout args to only include shouts made between self and result of substr
			$args['types']		= vB_Api::instance('vbshout_shoutbox')->getShoutType('pm');
			$args['onlyuser']	= $userid;

			// Fetch AOP time
			//vB_Api::instance('vbshout_shoutbox')->fetchAop($type, '');
		}	
		
		if (substr($type, 0, 8) == 'chatroom')
		{
			// Fetch the chatroomid from the chatroom type
			$chatroomid = explode('_', $type);
			$chatroomid = $chatroomid[1];

			// Set shout args to only include shouts posted to said chat room
			$args['chatroomid']	= $chatroomid;
			
			if (!self::$chatroom = vB_Api::instance('vbshout_core')->getCacheElement('chatroom', $chatroomid))
			{
				// Wrong chatroom
				self::$fetched['error'] = 'disband_' . $chatroomid;
			}	
			else
			{
				if (!self::$chatroom['membergroupids'])
				{
					// This is not a members-only group
					if (!isset(self::$chatroom['members'][vB::getUserContext()->fetchUserId()]))
					{
						self::$fetched['error'] = 'disband_' . $chatroomid;
						unset($args['chatroomid']);
					}
				}
				else
				{
					// Override tabid for AOP purposes
					self::$tabid = 'chatroom_' . $chatroomid . '_' . self::$chatroom['instanceid'];
					
					if (!count(array_intersect(vB::getUserContext()->fetchUserGroups(), explode(',', self::$chatroom['membergroupids']))) OR !self::$chatroom['active'])
					{
						// Usergroup no longer a member
						self::$fetched['error'] = 'disband_' . $chatroomid;
						unset($args['chatroomid']);
					}			
				}
			}
			
			// Fetch AOP time
			//vB_Api::instance('vbshout_shoutbox')->fetchAop('chatroom_' . $chatroomid . '_', self::$chatroom['instanceid']);
		}							
		
		// Legacy hook 'dbtech_vbshout_ajax_handler_fetch' removed
		
		if ($type == 'shoutnotifs')
		{
			$args['types']		= vB_Api::instance('vbshout_shoutbox')->getShoutType('notif');

			// Fetch AOP time
			//vB_Api::instance('vbshout_shoutbox')->fetchAop($type, self::$instance['instanceid']);
		}
		
		if ($type == 'systemmsgs')
		{
			$args['types']		= vB_Api::instance('vbshout_shoutbox')->getShoutType('system');

			// Fetch AOP time
			//vB_Api::instance('vbshout_shoutbox')->fetchAop($type, self::$instance['instanceid']);
		}

		// Store this
		$args['shoutorder'] = $GPC['shoutorder'];
		$args['instance'] = self::$instance;

		return $args;
	}

	/**
	 * Sets the fetched value and returns it
	 *
	 * @return	mixed
	 */
	public static function setFetchedValue($prevResult, $key, $val)
	{
		// Set fetched value
		self::$fetched[$key] = $val;

		return self::$fetched[$key];
	}

	/**
	* Processes an AJAX fetching request using AOP.
	*
	* @param	string	When we last fetched shouts
	*/
	public static function fetchAop($prevResult, $tabid, $instanceid, $markread = false, $nosound = false)
	{
		if ($tabid == 'activeusers')
		{
			// Shouldn't happen
			return false;
		}
		
		if (!is_writable(DIR . '/packages/dbtechvbshout/aop/'))
		{
			// Fall back to database
			self::$fetched['error'] = (string)new vB_Phrase('hooks', 'dbtech_vbshout_aop_error');
			
			// Time now
			$mtime = vB::getRequest()->getTimeNow();
		}
		
		// File system
		$mtime = intval(@file_get_contents(DIR . '/packages/dbtechvbshout/aop/' . ($markread ? 'markread-' : '') . $tabid . $instanceid . '.txt'));
		
		if (!$mtime)
		{
			$mtime = 0;
		}
		
		if (!array_key_exists('aoptimes', self::$fetched))
		{
			// Ensure this is an array
			self::$fetched['aoptimes'] = array();
		}

		foreach (self::$fetched['aoptimes'] as $key => $info)
		{
			if ($info['tabid'] == $tabid)
			{
				// Already fetched
				self::$fetched['aoptimes'][$key]['aoptime'] = $mtime;
				self::$fetched['aoptimes'][$key]['tabid'] = $tabid;
				return true;
			}
		}
		
		//if ($mtime > $aoptime)
		//{
			// Include the new AOP time
			self::$fetched['aoptimes'][] = array(
				'aoptime' 	=> $mtime,
				'tabid' 	=> $tabid,
				'nosound' 	=> (int)$nosound
			);
		//}
	}
	
	/**
	* Sets the new AOP time.
	*/
	public static function setAop($prevResult, $tabid, $instanceid = 0, $markread = true, $nosound = false)
	{
		if ($tabid == 'activeusers')
		{
			// Shouldn't happen
			return false;
		}
		
		// Ensure this is taken into account
		clearstatcache();
		
		if (!is_writable(DIR . '/packages/dbtechvbshout/aop'))
		{
			// Fall back to database
			self::$fetched['error'] = (string)new vB_Phrase('hooks', 'dbtech_vbshout_aop_error');
			return false;			
		}
		
		// Touch the files
		@file_put_contents(DIR . '/packages/dbtechvbshout/aop/' . $tabid . $instanceid . '.txt', vB::getRequest()->getTimeNow());
		
		if ($markread)
		{
			// Duplicate this
			@file_put_contents(DIR . '/packages/dbtechvbshout/aop/markread-' . $tabid . $instanceid . '.txt', vB::getRequest()->getTimeNow());
		}

		if (!array_key_exists('aoptimes', self::$fetched))
		{
			// Ensure this is an array
			self::$fetched['aoptimes'] = array();
		}
		
		foreach (self::$fetched['aoptimes'] as $key => $info)
		{
			if ($info['tabid'] == $tabid)
			{
				// Already fetched
				self::$fetched['aoptimes'][$key]['aoptime'] 	= $info['aoptime'];
				self::$fetched['aoptimes'][$key]['tabid'] 		= $tabid;
				self::$fetched['aoptimes'][$key]['nosound'] 	= (int)$nosound;
				return true;
			}
		}
		
		// Include the new AOP time
		self::$fetched['aoptimes'][] = array(
			'aoptime' 	=> vB::getRequest()->getTimeNow(),
			'tabid' 	=> $tabid,
			'nosound' 	=> (int)$nosound
		);
	}

	/**
	* Fetches shouts based on parameters.
	*
	* @param	array		(Optional) Additional arguments
	*/
	protected static function _fetchShouts($args = array())
	{
		// Shorthand
		$userInfo = vB_User::fetchUserinfo();
		
		// Cache array for fetchMusername()
		$shoutusers = array();
		
		// Hacks
		$args[vB_dB_Query::TYPE_KEY] = vB_dB_Query::QUERY_METHOD;

		// Fetch shouts
		$shouts = vB::getDbAssertor()->getRows('DBTechvBShout:fetchShouts', $args);
			
		// Set sticky		
		self::$fetched['sticky'] = self::$instance['sticky'];
		
		if (!count($shouts))
		{
			// We have no shouts
			self::$fetched['content'] = (string) new vB_Phrase('hooks', 'dbtech_vbshout_nothing_to_display');
			return false;
		}
		
		

		$i = 1;
		foreach ($shouts as $shout)
		{
			if ($shout['userid'] == 0)
			{
				// Save some resources
				continue;
			}

			if (!$shout['message_raw'])
			{
				// Ensure we have this
				$shout['message_raw'] = $shout['message'];
			}
			
			// Parses action codes like /me
			self::_parseActionCodes($shout['message'], $shout['type']);

			// By default, we can't pm or edit
			$canpm = $canedit = false;

			if ($shout['userid'] > -1)
			{
				if (!array_key_exists($shout['userid'], $shoutusers))
				{
					// Uncached user
					$shoutusers[$shout['userid']] = array(
						'userid' 					=> $shout['userid'],
						'username' 					=> $shout['username'],
						'usergroupid' 				=> $shout['usergroupid'],
						'infractiongroupid' 		=> $shout['infractiongroupid'],
						'displaygroupid' 			=> $shout['displaygroupid'],
						'dbtech_vbshop_purchase' 	=> array_key_exists('dbtech_vbshop_purchase', $shout) ? $shout['dbtech_vbshop_purchase'] : serialize(array())
					);
				}
				
				// fetch the markup-enabled username
				$shoutusers[$shout['userid']]['musername'] = vB_Api::instance('user')->fetchMusername($shoutusers[$shout['userid']]);
				
				if ($shout['userid'] != $userInfo['userid'])
				{
					// We can PM this user
					$canpm = true;
				}
			}
			else
			{
				// This was the SYSTEM
				$shoutusers[$shout['userid']] = array(
					'userid' 	=> 0,
					'username' 	=> (string) new vB_Phrase('hooks', 'dbtech_vbshout_system'),
					'musername' => (string) new vB_Phrase('hooks', 'dbtech_vbshout_system'),
				);
				
				// We can't PM the system
				$canpm = false;
			}
			
			// Only registered users can have shoutbox styles
			if (!$shout['shoutstyle'] = @unserialize($shout['shoutstyle']))
			{
				// This shouldn't be false
				$shout['shoutstyle'] = array();
			}
			
			// Ensure it's an array for the sake of bugfix
			$instanceid = self::$instance['instanceid'];
			$shout['shoutstyle'] = (!array_key_exists($instanceid, $shout['shoutstyle']) ? array() : $shout['shoutstyle'][$instanceid]);
			
			// Init the styleprops
			$styleprops = array();

			if ($userInfo['dbtech_vbshout_settings'] & 8192)
			{
				// Override!
				$shoutStyle = @unserialize($userInfo['dbtech_vbshout_shoutstyle']);
				if (is_array($shoutStyle) AND array_key_exists($instanceId, $shoutStyle))
				{
					$shout['shoutstyle'] = $shoutStyle[$instanceid];
				}
			}

			if (!(self::$instance['options']['editors'] & 1) AND array_key_exists('bold', $shout['shoutstyle']) AND !in_array($shout['shoutstyle']['bold'], array('', 'null', 'false')))
			{
				// Bold
				$styleprops[] = 'font-weight:bold;';
			}
			
			if (!(self::$instance['options']['editors'] & 2) AND array_key_exists('italic', $shout['shoutstyle']) AND !in_array($shout['shoutstyle']['italic'], array('', 'null', 'false')))
			{
				// Italic
				$styleprops[] = 'font-style:italic;';
			}
			
			if (!(self::$instance['options']['editors'] & 4) AND array_key_exists('underline', $shout['shoutstyle']) AND !in_array($shout['shoutstyle']['underline'], array('', 'null', 'false')))
			{
				// Underline
				$styleprops[] = 'text-decoration:underline;';
			}
			
			if (!(self::$instance['options']['editors'] & 16) AND array_key_exists('font', $shout['shoutstyle']) AND !in_array($shout['shoutstyle']['font'], array('', 'null', 'false')))
			{
				// Font
				$styleprops[] = 'font-family:' . $shout['shoutstyle']['font'] . ';';
			}
			
			if (!(self::$instance['options']['editors'] & 8) AND array_key_exists('color', $shout['shoutstyle']) AND !in_array($shout['shoutstyle']['color'], array('', 'null', 'false')))
			{
				// Color
				$styleprops[] = 'color:' . $shout['shoutstyle']['color'] . ';';
			}			
			
			if (($shout['userid'] == $userInfo['userid'] AND self::$instance['permissions_parsed']['caneditown']) OR
				($shout['userid'] != $userInfo['userid'] AND self::$instance['permissions_parsed']['caneditothers']))
			{
				// We got the perms, give it to us
				$canedit = true;
			}
			
			self::$instance['permissions_parsed']['giveinfraction'] = false;
			if ($shout['userid'] > 0)
			{
				// By default, we can't add infractions
				self::$instance['permissions_parsed']['giveinfraction'] = (
					
					// Must have 'cangiveinfraction' permission. Branch dies right here majority of the time
					vB::getUserContext($userInfo['userid'])->hasPermission('genericpermissions', 'cangiveinfraction')
					
					// Can not give yourself an infraction
					AND $shout['userid'] != $userInfo['userid']
					
					// Can not give an infraction to a post that already has one
					
					// Can not give an admin an infraction
					AND !(vB::getUserContext($shout['userid'])->hasPermission('adminpermissions', 'cancontrolpanel'))
					
					// Only Admins can give a supermod an infraction
					AND (
						!(vB::getUserContext($shout['userid'])->hasPermission('adminpermissions', 'ismoderator'))
						OR vB::getUserContext($userInfo['userid'])->hasPermission('genericpermissions', 'cancontrolpanel')
					)
				);
			}

			

			// Legacy hook 'dbtech_vbshout_fetch_shouts_loop' removed
			
			$shout['message'] = str_replace(array("\r", "\n", "\r\n"), '', $shout['message']);
			
			switch ($shout['type'])
			{
				case vB_Api::instance('vbshout_shoutbox')->getShoutType('shout'):
					// Normal shout
					$template = 'shout';
					break;
					
				case vB_Api::instance('vbshout_shoutbox')->getShoutType('pm'):
					// PM
					$template = 'pm';
					break;
					
				case vB_Api::instance('vbshout_shoutbox')->getShoutType('me'):
				case vB_Api::instance('vbshout_shoutbox')->getShoutType('notif'):
					// slash me or a notification
					$template = 'me';
					break;
					
				default:
					// Error handler
					$template = 'shout';
					break;
			}
			
			if ($shout['userid'] == -1)
			{
				// System message
				$template = 'system';
			}
			
			$altclass = 'alt1';
			if (self::$instance['options']['altshouts'] AND !((int)$userInfo['dbtech_vbshout_settings'] & 131072))
			{
				$altclass = ($i % 2 == 0 ? ' alt2' : ' alt1');
			}
			
			if ($shout['message_raw'] == '/silencelist' OR $shout['message_raw'] == '/banlist')
			{
				// Special cases, allow HTML
				$shout['message'] = vB_String::unHtmlSpecialChars($shout['message']);
			}


			// Set PM user
			$shout['pmuserParsed'] = (string) new vB_Phrase('hooks', 'dbtech_vbshout_pm');

			
			
			self::$fetched['shouts'][] = array(
				'template'				=> $template,
				'shoutid' 				=> $shout['shoutid'],
				'userid' 				=> $shout['userid'],
				'instanceid' 			=> self::$instance['instanceid'],
				'message_raw'			=> str_replace('\\\\', '\\', str_replace(array("%", "$", "\\"), array("&#37;", "&#36;", "\\\\"), vB_String::htmlSpecialCharsUni($shout['message_raw']))),
				'canedit'				=> $canedit,
				'time'					=> vB5_Template_Runtime::datetime($shout['dateline'], $format = '[time]'),
				'musername'				=> str_replace(array("%", "$"), array("&#37;", "&#36;"), $shoutusers[$shout['userid']]['musername']),
				'jsusername'			=> str_replace('"', '\"', $shout['username']),
				'styleprops' 			=> implode(' ', $styleprops),
				'message'				=> str_replace('\\\\', '\\', str_replace(array("%", "$", "\\"), array("&#37;", "&#36;", "\\\\"), $shout['message'])),
				'pmuserParsed'			=> $shout['pmuserParsed'],
				'altclass'				=> $altclass,
				
				'profilelink' 			=> vB5_Route::buildUrl('profile|fullurl', array('userid' => $shout['userid'], 'username' => $shout['username'])),
				'permissions'			=> array(
					'canpm' 		=> $canpm,
					'isprotected' 	=> (!vB_Api::instance('vbshout_shoutbox')->isProtected($shout, true) AND $shout['userid'] != $userInfo['userid'] AND $shout['shoutid']),
					'caninfract' 	=> self::$instance['permissions_parsed']['giveinfraction'],
					'canban' 		=> self::$instance['permissions_parsed']['canban'],
					'cankick' 		=> (array_key_exists('creator', self::$chatroom) AND self::$chatroom['creator'] == $userInfo['userid'] AND $shout['userid'] != $userInfo['userid']),
					
				),
			);

			$i++;
		}
		
		if ((in_array($args['shoutorder'], array('ASC', 'DESC')) ? $args['shoutorder'] : self::$instance['options']['shoutorder']) == 'ASC')
		{
			// Reverse sort order
			self::$fetched['shouts'] = array_reverse(self::$fetched['shouts']);
		}
		
		if (!self::$fetched['shouts'])
		{
			// Show no content
			self::$fetched['content'] = (string) new vB_Phrase('hooks', 'dbtech_vbshout_nothing_to_display');
		}
		
		// No longer needed
		unset($shoutusers, $shout);
	}

	/**
	* Fetches a list of allowed BBCode tags
	*
	* @return	array	A list of the allowed tags
	*/
	public static function fetchTagList($prevResult)
	{
		if (!count(self::$tag_list))
		{
			if (!function_exists('fetch_tag_list'))
			{
				require_once(DIR . '/includes/class_bbcode.php');
			}
			
			// Store all possible BBCode tags
			self::$tag_list = fetch_tag_list('', true);
		}

		return self::$tag_list;
	}

	/**
	* Fetches a list of allowed BBCode tags
	*
	* @param	array	The complete list of BBCode tags
	* @param	array	The permissions array
	*
	* @return	array	A list of the allowed tags
	*/
	public static function getTagList($prevResult, $tag_list, $permarray)
	{
		if (!($permarray['bbcodepermissions_parsed']['bit'] & ALLOW_BBCODE_QUOTE))
		{			
			// [QUOTE]
			unset($tag_list['no_option']['quote']);

			// [QUOTE=XXX]
			unset($tag_list['option']['quote']);
		}

		if (!($permarray['bbcodepermissions_parsed']['bit'] & ALLOW_BBCODE_BASIC))
		{
			// [B]
			unset($tag_list['no_option']['b']);

			// [I]
			unset($tag_list['no_option']['i']);

			// [U]
			unset($tag_list['no_option']['u']);
		}

		if (!($permarray['bbcodepermissions_parsed']['bit'] & ALLOW_BBCODE_COLOR))
		{
			// [COLOR=XXX]
			unset($tag_list['option']['color']);
		}

		if (!($permarray['bbcodepermissions_parsed']['bit'] & ALLOW_BBCODE_SIZE))
		{
			// [SIZE=XXX]
			unset($tag_list['option']['size']);
		}

		if (!($permarray['bbcodepermissions_parsed']['bit'] & ALLOW_BBCODE_FONT))
		{
			// [FONT=XXX]
			unset($tag_list['option']['font']);
		}

		if (!($permarray['bbcodepermissions_parsed']['bit'] & ALLOW_BBCODE_ALIGN))
		{
			// [LEFT]
			unset($tag_list['no_option']['left']);

			// [CENTER]
			unset($tag_list['no_option']['center']);

			// [RIGHT]
			unset($tag_list['no_option']['right']);

			// [INDENT]
			unset($tag_list['no_option']['indent']);
		}

		if (!($permarray['bbcodepermissions_parsed']['bit'] & ALLOW_BBCODE_LIST))
		{
			// [LIST]
			unset($tag_list['no_option']['list']);

			// [LIST=XXX]
			unset($tag_list['option']['list']);

			// [INDENT]
			unset($tag_list['no_option']['indent']);
		}

		if (!($permarray['bbcodepermissions_parsed']['bit'] & ALLOW_BBCODE_URL))
		{
			// [EMAIL]
			unset($tag_list['no_option']['email']);

			// [EMAIL=XXX]
			unset($tag_list['option']['email']);

			// [URL]
			unset($tag_list['no_option']['url']);

			// [URL=XXX]
			unset($tag_list['option']['url']);

			// [THREAD]
			unset($tag_list['no_option']['thread']);

			// [THREAD=XXX]
			unset($tag_list['option']['thread']);

			// [POST]
			unset($tag_list['no_option']['post']);

			// [POST=XXX]
			unset($tag_list['option']['post']);
		}

		if (!($permarray['bbcodepermissions_parsed']['bit'] & ALLOW_BBCODE_PHP))
		{
			// [PHP]
			unset($tag_list['no_option']['php']);
		}

		if (!($permarray['bbcodepermissions_parsed']['bit'] & ALLOW_BBCODE_CODE))
		{
			//[CODE]
			unset($tag_list['no_option']['code']);
		}

		if (!($permarray['bbcodepermissions_parsed']['bit'] & ALLOW_BBCODE_HTML))
		{
			// [HTML]
			unset($tag_list['no_option']['html']);
		}

		return $tag_list;
	}

	/**
	* Checks for a protected usergroup
	*
	* @param	array	Usergroup information
	* @param	boolean	(Optional) Whether we should just return boolean
	*/
	public static function isProtected($prevResult, $exists, $boolreturn = false)
	{
		// Loads instance permissions
		$permarray = vB_Api::instance('vbshout_shoutbox')->buildPermissionsArray(self::$instance, $exists);
		
		if ($permarray['isprotected'])
		{
			if (!$boolreturn)
			{
				// Err0r
				self::$fetched['error'] = 'dbtech_vbshout_x_is_protected';
			}
			return true;
		}
		
		return false;
	}

	/**
	* Removes a user from a chatroom
	*
	* @return	mixed	Any new information we may have.
	*/
	public static function chatRemove($prevResult, $chatroom, $userid)
	{
		// init data manager
		$dm = new DBTechvBShout_DataManager_Chatroom(vB_DataManager_Constants::ERRTYPE_SILENT);
			$dm->set_existing($chatroom);

		$SQL = array('chatroomid' => $chatroom['chatroomid']);
		if ($chatroom['creator'] == $userid)
		{
			// Remove all members
			$newMembers = array();
			
			// Also set this
			$dm->set('active', 	'0');
		}
		else
		{
			// We weren't the creator, only we should abandon ship
			$SQL['userid'] = intval($userid);

			// Set new member rankings
			unset($chatroom['members'][$userid]);
			$newMembers = $chatroom['members'];			
		}
		
		// Leave the chat room
		vB::getDbAssertor()->delete('DBTechvBShout:dbtech_vbshout_chatroommember', $SQL);
		
		// Finish off the DM
			$dm->set('members', $newMembers);		
		$dm->save();		

		return $chatroom;
	}

	/**
	* Rebuilds the shout counter for every user.
	*
	* @param	string	The new sticky note.
	*/
	public static function setSticky($prevResult, $sticky)
	{
		// Store raw sticky
		$sticky_raw = $sticky;
		
		// Init the parser
		$parser = new vB5_Template_BbCode();
		
		if (vB::getDatastore()->getOption('allowedbbcodes') & 64)
		{
			// We can use the URL BBCode, so convert links
			$sticky = vB_Api::instance('bbcode')->convertUrlToBbcode($sticky);
		}	
		
		// BBCode parsing
		$sticky = $parser->doParse(
			$sticky,
			false, 	// allowhtml
			true, 	// allowsmilies
			true, 	// allowbbcode
			false,	// allowbbimagecode
			false 	// nl2br
		);
		
		// init data manager
		$dm = new DBTechvBShout_DataManager_Instance(vB_DataManager_Constants::ERRTYPE_SILENT);
			$dm->set_existing(self::$instance);
			$dm->set('sticky', 		$sticky);
			$dm->set('sticky_raw', 	$sticky_raw);
		$dm->save();

		// Set new sticky
		self::$instance['sticky'] = $sticky;		
	}
	
	/**
	* Logs a specified command.
	*
	* @param	string	The executed command.
	* @param	mixed	(Optional) Additional comments.
	*/
	public static function logCommand($prevResult, $command, $comment = NULL)
	{
		$bit = 0;
		switch ($command)
		{
			case 'shoutedit':
			case 'shoutdelete':
				$bit = 8;
				break;
			
			case 'prune':
				$bit = 1;
				break;
			
			case 'setsticky':
			case 'removesticky':
				$bit = 2;
				break;
				
			case 'ban':
			case 'unban':
				$bit = 4;
				break;
		}

		
		
		// Legacy hook 'dbtech_vbshout_log_process' removed
		
		if (!$bit OR (self::$instance['options']['logging'] & $bit))
		{
			// We didn't have this option on
			return;
		}
		
		vB::getDbAssertor()->insert('DBTechvBShout:dbtech_vbshout_log', array(
			'userid' 	=> vB::getUserContext()->fetchUserId(),
			'dateline' 	=> vB::getRequest()->getTimeNow(),
			'ipaddress' => vB::getDbAssertor()->escape_string(vB::getRequest()->getIpAddress()),
			'command' 	=> vB::getDbAssertor()->escape_string($command),
			'comment' 	=> vB::getDbAssertor()->escape_string($comment)
		));
	}

	/**
	* Fetch all currently active users.
	*/	
	protected static function _fetchActiveUsers()
	{
		if (self::$activeusers === NULL)
		{
			// Array of all active users
			self::$activeusers = $userids = array();
			
			// Query active users
			$activeusers = vB::getDbAssertor()->getRows('DBTechvBShout:getActiveUsers', array(
				vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_METHOD,
				'dateline' 		=> (vB::getRequest()->getTimeNow() - (self::$instance['options']['idletimeout'] ? self::$instance['options']['idletimeout'] : 600)),
				'instanceid' 	=> array_key_exists('chatroomid', self::$chatroom) ? 0 								: intval(self::$instance['instanceid']),
				'chatroomid' 	=> array_key_exists('chatroomid', self::$chatroom) ? self::$chatroom['chatroomid'] 	: 0,
			), false, 'chatroomid');
			foreach ($activeusers as $user)
			{
				if (in_array($user['userid'], $userids))
				{
					// Skip this user
					continue;
				}
				
				// fetch the markup-enabled username
				$user['musername'] = vB_Api::instance('user')->fetchMusername($user);
				
				// Fetch the SEO'd URL to a member's profile
				self::$activeusers[] = '<a href="' . vB5_Route::buildUrl('profile|fullurl', array('userid' => $user['userid'], 'username' => $user['username'])) . '">' . $user['musername'] . '</a>';

				// Set userid cache
				$userids[] = $user['userid'];
			}
		}
	}	

	/**
	* Checks for action codes, and executes their meaning.
	* 
	* @param	string	The shout.
	* @param	string	The default shout type.
	* @param	integer	(Optional) The default id.
	* @param	integer	(Optional) The default userid.
	*
	* @return	mixed	Any new information we may have.
	*/
	protected static function _parseActionCodes(&$message, &$type)
	{
		if (preg_match("#^(\/[a-z]*?)\s(.+?)$#i", $message, $matches))
		{
			// 2-stage command
			switch ($matches[1])
			{
				case '/me':
					// A slash me
					$message 	= trim($matches[2]);
					$type 		= vB_Api::instance('vbshout_shoutbox')->getShoutType('me');
					break;
					
				default:
					// Legacy hook 'dbtech_vbshout_parsecommand_2' removed
					break;
			}
		}
		
		// Legacy hook 'dbtech_vbshout_command_complete' removed
	}

	protected static function _ajaxCreateChat($GPC)
	{
		if (!self::$tabid)
		{
			// Set tabid
			self::$tabid = (in_array($GPC['tabid'], array('aop', 'activeusers', 'shoutnotifs', 'systemmsgs')) ? 'shouts' : $GPC['tabid']) . self::$instance['instanceid'];
		}

		if (empty($GPC['type']))
		{
			$GPC['type'] = 'shouts';
		}

		$type = $GPC['type'];

		if (substr($GPC['type'], 0, 8) == 'chatroom')
		{
			// Fetch the chatroomid from the chatroom type
			$chatroomid = explode('_', $GPC['type']);
			$chatroomid = $chatroomid[1];
			$chatroom = vB_Api::instance('vbshout_core')->getCacheElement('chatroom', $chatroomid);
			
			// Override tabid for AOP purposes
			self::$tabid = 'chatroom_' . $chatroomid . '_' . $chatroom['instanceid'];
		}

		// Init the Shout DM
		$shout = new DBTechvBShout_DataManager_Shout(vB_DataManager_Constants::ERRTYPE_SILENT);
			$shout->set_info('instance', self::$instance);
			$shout->set_info('is_automated', false);
			$shout->set('instanceid', self::$instance['instanceid']);
			$shout->set('chatroomid', array_key_exists('chatroomid', self::$chatroom) ? self::$chatroom['chatroomid'] : 0);
			$shout->set('message', '/createchat ' . $GPC['title']);
		$shout->save();
	}

	protected static function _ajaxDelete($GPC)
	{
		do
		{
			if (!self::$tabid)
			{
				// Set tabid
				self::$tabid = (in_array($GPC['tabid'], array('aop', 'activeusers', 'shoutnotifs', 'systemmsgs')) ? 'shouts' : $GPC['tabid']) . self::$instance['instanceid'];
			}

			if (empty($GPC['type']))
			{
				$GPC['type'] = 'shouts';
			}

			// To avoid contaminating this for the fetch method
			$type = $GPC['type'];			

			if (substr($GPC['type'], 0, 8) == 'chatroom')
			{
				// Fetch the chatroomid from the chatroom type
				$chatroomid = explode('_', $GPC['type']);
				$chatroomid = $chatroomid[1];
				$chatroom = vB_Api::instance('vbshout_core')->getCacheElement('chatroom', $chatroomid);
				
				// Override tabid for AOP purposes
				self::$tabid = 'chatroom_' . $chatroomid . '_' . $chatroom['instanceid'];
			}
			
			// Make sure it's set
			$shouttype = (vB_Api::instance('vbshout_shoutbox')->getShoutType($type) ? $type : 'shout');
			
			// Init the Shout DM
			$shout = new DBTechvBShout_DataManager_Shout(vB_DataManager_Constants::ERRTYPE_SILENT);
				$shout->set_info('instance', self::$instance);
				$shout->set_info('is_automated', false);
			
			if (!array_key_exists('shoutid', $GPC) OR !$GPC['shoutid'])
			{
				// Invalid shout ID
				break;
			}

			if (!$GPC['shoutinfo'] = vB::getDbAssertor()->getRow('DBTechvBShout:dbtech_vbshout_shout', array( 
				vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT, 
				vB_dB_Query::CONDITIONS_KEY => array(
					array('field' => 'shoutid', 'value' => intval($GPC['shoutid']), 'operator' => vB_dB_Query::OPERATOR_EQ)
				)
			)))
			{
				// Shout didn't exist
				break;
			}
			
			// To avoid references
			$existing = $GPC['shoutinfo'];
			
			// Set the existing data
			$shout->set_existing($existing);
			
			// Only thing that's changed
			$shout->delete();

			if (
				(array_key_exists('error', self::$fetched) AND self::$fetched['error']) OR 
				(array_key_exists('errors', self::$fetched) AND self::$fetched['errors'])
			)
			{
				// We haz error
				break;
			}

			// Fetch the file in question
			self::_ajaxFetch($GPC);
		}
		while (false);
	}
	
	protected static function _ajaxFetch($GPC)
	{
		do
		{
			// Shorthand
			$userInfo = vB_User::fetchUserinfo();

			// Find out all the tabs we're at
			$cleaned = vB::getCleaner()->clean($GPC, 'tabs', vB_Cleaner::TYPE_ARRAY_BOOL);
			$tabs = array_key_exists('tabs', $cleaned) ? $cleaned['tabs'] : array();
			
			// get info
			$chatrooms = vB::getDbAssertor()->getRows('DBTechvBShout:getChatRooms', array(
				vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_STORED,
				'userid' 				=> $userInfo['userid'],
			), false, 'chatroomid');
			foreach ($chatrooms as $chatroomid => $room)
			{
				$chatroom = vB_Api::instance('vbshout_core')->getCacheElement('chatroom', $chatroomid);
				if (!$chatroom['active'] OR ($chatroom['instanceid'] != self::$instance['instanceid'] AND $chatroom['instanceid'] != 0))
				{
					// Inactive chat room
					continue;
				}
				
				// Store information regarding the chatroom
				self::$fetched['chatrooms'][] = array(
					'chatroomid' 	=> $chatroomid,
					'instanceid' 	=> $chatroom['instanceid'],
					'title' 		=> $chatroom['title'],
					'username' 		=> $room['username']
				);
			}
			
			foreach ($tabs as $tabid => $enabled)
			{
				if ($tabid == 'activeusers')
				{
					// Shouldn't happen
					continue;
				}
				
				if (substr($tabid, 0, 8) == 'chatroom')
				{
					// Get the chatroom id
					$chatroomid = explode('_', $tabid);
					$chatroomid = $chatroomid[1];
					
					// Already set
					$instanceid = '';
				}
				else if (substr($tabid, 0, 2) == 'pm')
				{
					// Already set
					$instanceid = '';
				}
				else
				{
					// Just use the normal instance id
					$instanceid = self::$instance['instanceid'];
				}

				// Fetch AOP
				vB_Api::instance('vbshout_shoutbox')->fetchAop($tabid, $instanceid, true, false);
			}
			
			$pmtime = (int)$GPC['pmtime'];
			if ($userInfo['dbtech_vbshout_pm'] > $pmtime)
			{
				// Set new PM time
				self::$fetched['pmtime'] = $userInfo['dbtech_vbshout_pm'];
			}

			if (!array_key_exists('type', $GPC))
			{
				$GPC['type'] = 'shouts';
			}
			
			if (!self::$tabid)
			{
				// Set tabid
				self::$tabid = (in_array($GPC['type'], array('aop', 'activeusers', 'shoutnotifs', 'systemmsgs')) ? 'shouts' : $GPC['type']) . self::$instance['instanceid'];
			}

			if ((
				!isset(self::$instance['options']['shoutboxtabs']) OR !(self::$instance['options']['shoutboxtabs'] & 4)) AND
				self::$instance['permissions_parsed']['canmodchat']
			)
			{
				$unhandledreports = vB::getDbAssertor()->getRow('DBTechvBShout:dbtech_vbshout_report', array( 
					vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_COUNT, 
					vB_dB_Query::CONDITIONS_KEY => array(
						array('field' => 'handled', 	'value' => 0, 								'operator' => vB_dB_Query::OPERATOR_EQ),
						array('field' => 'instanceid', 	'value' => self::$instance['instanceid'], 	'operator' => vB_dB_Query::OPERATOR_EQ)
					)
				));
				self::$fetched['activereports'] = $unhandledreports['count'];
			}

			// Grab the args
			$args = vB_Api::instance('vbshout_shoutbox')->loadArgs($GPC['type'], $GPC);

			// Grab active users
			self::_fetchActiveUsers();

			if (self::$instance['options']['activeusers'])
			{
				if ($args['chatroomid'])
				{
					// Array of all active users
					self::$fetched['activeusers']['usernames'] = (count(self::$activeusers) ? implode('<br />', self::$activeusers) : (string) new vB_Phrase('hooks', 'dbtech_vbshout_no_chat_users'));
					
					
				}
				else
				{
					// Array of all active users
					self::$fetched['activeusers']['usernames'] = (count(self::$activeusers) ? implode('<br />', self::$activeusers) : (string) new vB_Phrase('hooks', 'dbtech_vbshout_no_active_users'));
				}
			}

			// Count active users
			self::$fetched['activeusers']['count'] = count(self::$activeusers);

			switch ($GPC['type'])
			{
				case 'activeusers':
					// Array of all active users
					self::_fetchActiveUsers();
					
					// Finally set the content
					self::$fetched['content'] = (count(self::$activeusers) ? implode(', ', self::$activeusers) : (string) new vB_Phrase('hooks', 'dbtech_vbshout_no_active_users'));
					
					if (self::$instance['options']['activeusers'])
					{
						// Array of all active users
						self::$fetched['activeusers2'] = (count(self::$activeusers) ? implode('<br />', self::$activeusers) : (string) new vB_Phrase('hooks', 'dbtech_vbshout_no_active_users'));
					}
					break;

				case 'shout':
					// What shout we want to be editing
					$shoutid 	= (int)$args['shoutid'];
					
					if (!$exists = vB::getDbAssertor()->getRow('DBTechvBShout:dbtech_vbshout_shout', array( 
						'shoutid' => $shoutid
					)))
					{
						// The shout doesn't exist
						self::$fetched['error'] = (string) new vB_Phrase('hooks', 'dbtech_vbshout_invalid_shout');
						break;
					}
					
					if ($exists['userid'] == $userInfo['userid'] AND !self::$instance['permissions_parsed']['caneditown'])
					{
						// We can't edit our own shouts
						self::$fetched['error'] = (string) new vB_Phrase('error', 'dbtech_vbshout_may_not_edit_own');
						break;
					}
					
					if ($exists['userid'] != $userInfo['userid'] AND !self::$instance['permissions_parsed']['caneditothers'])
					{
						// We don't have permission to edit others' shouts
						self::$fetched['error'] = (string) new vB_Phrase('error', 'dbtech_vbshout_may_not_edit_others');
						break;
					}					
					
					// Set the editor content
					self::$fetched['editor'] = $exists['message'];
					break;

				default:
					if (!count($args))
					{
						// Skip this
						break;
					}

					// Fetch AOP time
					vB_Api::instance('vbshout_shoutbox')->fetchAop('shouts', self::$instance['instanceid']);
					
					// Fetch shouts
					self::_fetchShouts($args);
					break;
			}
		}
		while (false);
	}

	protected static function _ajaxFetchSticky($GPC)
	{
		// Fetch sticky
		self::$fetched['editor'] = '/sticky ' . self::$instance['sticky_raw'];		
	}

	protected static function _ajaxJoinChat($GPC)
	{
		if (!$chatroom = vB_Api::instance('vbshout_shoutbox')->getCacheElement('chatroom', $GPC['chatroomid']))
		{
			// Skip this
			return;
		}

		// Join the chat room
		vB::getDbAssertor()->update('DBTechvBShout:dbtech_vbshout_chatroommember', array( 
			'status' => 1,
		), array(
			'chatroomid' => intval($GPC['chatroomid']),
			'userid' => vB::getUserContext()->fetchUserId()
		));
		
		// init data manager
		$dm = new DBTechvBShout_DataManager_Chatroom(vB_DataManager_Constants::ERRTYPE_SILENT);
			$dm->set_existing($chatroom);
			
		// We're now fully joined
		$chatroom['members'][vB::getUserContext()->fetchUserId()] = '1';
			
			$dm->set('members', 	$chatroom['members']);
		$dm->save();
	}

	protected static function _ajaxLeaveChat($GPC)
	{
		// Chat leave
		vB_Api::instance('vbshout_shoutbox')->chatRemove(self::$chatroom, vB::getUserContext()->fetchUserId());
	}

	protected static function _ajaxLookup($GPC)
	{
		$userInfo = vB_User::fetchUserinfo();

		do
		{
			if (!self::$instance['options']['enablepms'])
			{
				self::$fetched['error'] = (string) new vB_Phrase('hooks', 'dbtech_vbshout_pms_disabled');
				break;
			}
			
			if ($GPC['username'] == $userInfo['username'])
			{
				self::$fetched['error'] = (string) new vB_Phrase('hooks', 'dbtech_vbshout_invalid_username');
				break;
			}
			
			if (!$exists = vB::getDbAssertor()->getRow('user', array( 
				'username' => vB::getDbAssertor()->escape_string(vB_String::htmlSpecialCharsUni($GPC['username']))
			)))
			{
				self::$fetched['error'] = (string) new vB_Phrase('hooks', 'dbtech_vbshout_invalid_username');
				break;
			}
			
			// Return the userid
			self::$fetched['pmuserid'] = $exists['userid'];
		}
		while (false);
	}

	protected static function _ajaxSave($GPC)
	{
		do
		{
			if (!self::$tabid)
			{
				// Set tabid
				self::$tabid = (in_array($GPC['tabid'], array('aop', 'activeusers', 'shoutnotifs', 'systemmsgs')) ? 'shouts' : $GPC['tabid']) . self::$instance['instanceid'];
			}

			if (empty($GPC['type']))
			{
				$GPC['type'] = 'shouts';
			}

			// To avoid contaminating this for the fetch method
			$type = $GPC['type'];			

			if (substr($GPC['type'], 0, 8) == 'chatroom')
			{
				// Fetch the chatroomid from the chatroom type
				$chatroomid = explode('_', $GPC['type']);
				$chatroomid = $chatroomid[1];
				$chatroom = vB_Api::instance('vbshout_core')->getCacheElement('chatroom', $chatroomid);
				
				// Override tabid for AOP purposes
				self::$tabid = 'chatroom_' . $chatroomid . '_' . $chatroom['instanceid'];
			}
			
			if (substr(self::$tabid, 0, 2) == 'pm')
			{
				// Override this type
				$type = 'pm';
			}	
			
			// Make sure it's set
			$shouttype = (vB_Api::instance('vbshout_shoutbox')->getShoutType($type) ? $type : 'shout');
			
			// Init the Shout DM
			$shout = new DBTechvBShout_DataManager_Shout(vB_DataManager_Constants::ERRTYPE_SILENT);
				$shout->set_info('instance', self::$instance);
				$shout->set_info('is_automated', false);
			
			if (array_key_exists('shoutid', $GPC) AND $GPC['shoutid'])
			{
				if (!$GPC['shoutinfo'] = vB::getDbAssertor()->getRow('DBTechvBShout:dbtech_vbshout_shout', array( 
					vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT, 
					vB_dB_Query::CONDITIONS_KEY => array(
						array('field' => 'shoutid', 'value' => intval($GPC['shoutid']), 'operator' => vB_dB_Query::OPERATOR_EQ)
					)
				)))
				{
					// Shout didn't exist
					break;
				}
				
				// To avoid references
				$existing = $GPC['shoutinfo'];
				
				// Set the existing data
				$shout->set_existing($existing);
				
				// Only thing that's changed
				$GPC['shoutinfo']['message'] = $GPC['message'];
			}
			else
			{
				// Construct the shout info on the fly
				$GPC['shoutinfo'] = array(
					'id' 			=> array_key_exists('pmuserid', $GPC) ? $GPC['pmuserid'] : 0,
					'message' 		=> $GPC['message'],
					'type'			=> vB_Api::instance('vbshout_shoutbox')->getShoutType($shouttype),
					'instanceid' 	=> self::$instance['instanceid'],
					'chatroomid'	=> array_key_exists('chatroomid', $GPC) ? $GPC['chatroomid'] : 0,
				);
			}
			
			// Shorthand
			if ($chatroom = vB_Api::instance('vbshout_shoutbox')->getCacheElement('chatroom', $GPC['shoutinfo']['chatroomid']))
			{
				// Ensure the proper instance id is set
				$GPC['shoutinfo']['instanceid'] = $chatroom['instanceid'];
			}
			
			foreach ($GPC['shoutinfo'] as $varname => $value)
			{
				// Set everything
				$shout->set($varname, $value);
			}
			
			// Now finally save
			$shout->save();

			if (
				(array_key_exists('error', self::$fetched) AND self::$fetched['error']) OR 
				(array_key_exists('errors', self::$fetched) AND self::$fetched['errors'])
			)
			{
				// We haz error
				break;
			}
			
			$markread = true;
			if (substr(self::$tabid, 0, 2) == 'pm')
			{
				self::$tabid = 'shouts' . self::$instance['instanceid'];
				$markread = false;
			}
			
			// Update the AOP
			vB_Api::instance('vbshout_shoutbox')->setAop('shouts', self::$instance['instanceid'], $markread, true);
			
			if ($shouttype == vB_Api::instance('vbshout_shoutbox')->getShoutType('notif'))
			{
				// Update the AOP
				vB_Api::instance('vbshout_shoutbox')->setAop('shoutnotifs', self::$instance['instanceid'], false, true);
			}
			
			if ($shouttype == vB_Api::instance('vbshout_shoutbox')->getShoutType('system'))
			{
				// Update the AOP
				vB_Api::instance('vbshout_shoutbox')->setAop('systemmsgs', self::$instance['instanceid'], false, true);
			}

			// Fetch the file in question
			self::_ajaxFetch($GPC);
		}
		while (false);
	}

	protected static function _ajaxSounds($GPC)
	{
		// Shorthand
		$userInfo = vB_User::fetchUserinfo();
		$userInfo['dbtech_vbshout_soundsettings'] = unserialize($userInfo['dbtech_vbshout_soundsettings']);
		$userInfo['dbtech_vbshout_soundsettings'] = is_array($userInfo['dbtech_vbshout_soundsettings']) ? $userInfo['dbtech_vbshout_soundsettings'] : array();

		$instanceid = self::$instance['instanceid'];
		$userInfo['dbtech_vbshout_soundsettings'][$GPC['instanceid']] = $GPC['tabs'];

		// Update the user's editor styles
		vB::getDbAssertor()->update('user', array(
			'dbtech_vbshout_soundsettings' => trim(serialize($userInfo['dbtech_vbshout_soundsettings']))
		), array('userid' => intval($userInfo['userid'])));
	}

	protected static function _ajaxStyleProps($GPC)
	{
		// Grab shout styles array
		$userInfo = vB_User::fetchUserinfo();
		$userInfo['dbtech_vbshout_shoutstyle'] = @unserialize($userInfo['dbtech_vbshout_shoutstyle']);
		$userInfo['dbtech_vbshout_shoutstyle'] = is_array($userInfo['dbtech_vbshout_shoutstyle']) ? $userInfo['dbtech_vbshout_shoutstyle'] : array();

		// Set shout styles array
		$GPC['editor']['color'] = preg_replace('/[^A-Za-z0-9 #(),]/', '', $GPC['editor']['color']);
		$userInfo['dbtech_vbshout_shoutstyle'][$GPC['instanceid']] = $GPC['editor'];

		// Update the user's editor styles
		
		vB::getDbAssertor()->update('user', array(
			'dbtech_vbshout_shoutstyle' => trim(serialize($userInfo['dbtech_vbshout_shoutstyle']))
		), array('userid' => intval($userInfo['userid'])));

		// Purge the userinfo cache
		// Not using API because we're explicitly wanting to purge the cache
		vB_User::fetchUserinfo(0, array(), 0, true);

		// Set the AOP
		vB_Api::instance('vbshout_shoutbox')->setAop('shouts', $GPC['instanceid'], false, true);

		// Fetch the file in question
		self::_ajaxFetch($GPC);
	}

	protected static function _ajaxUserManage($GPC)
	{
		do
		{
			if (!self::$tabid)
			{
				// Set tabid
				self::$tabid = (in_array($GPC['tabid'], array('aop', 'activeusers', 'shoutnotifs', 'systemmsgs')) ? 'shouts' : $GPC['tabid']) . self::$instance['instanceid'];
			}
			
			if (empty($GPC['type']))
			{
				$GPC['type'] = 'shouts';
			}
			
			$type = $GPC['type'];
			
			if (substr($GPC['type'], 0, 8) == 'chatroom')
			{
				// Fetch the chatroomid from the chatroom type
				$chatroomid = explode('_', $GPC['type']);
				$chatroomid = $chatroomid[1];
				$chatroom = vB_Api::instance('vbshout_core')->getCacheElement('chatroom', $chatroomid);
				
				// Override tabid for AOP purposes
				self::$tabid = 'chatroom_' . $chatroomid . '_' . $chatroom['instanceid'];
			}

			if (!$exists = vB::getDbAssertor()->getRow('user', array( 
				'userid' => $GPC['userid']
			)))
			{
				// User didn't exist
				break;
			}
			
			// Init the Shout DM
			$shout = new DBTechvBShout_DataManager_Shout(vB_DataManager_Constants::ERRTYPE_SILENT);
				$shout->set_info('is_automated', false);	
				$shout->set_info('instance', self::$instance);	
				$shout->set('instanceid', self::$instance['instanceid']);
				$shout->set('chatroomid', array_key_exists('chatroomid', self::$chatroom) ? self::$chatroom['chatroomid'] : 0);
			
			$skip = false;
			switch ($GPC['manageaction'])
			{
				case 'ignoreunignore':
					$isignored = vB::getDbAssertor()->getRow('DBTechvBShout:dbtech_vbshout_ignorelist', array( 
						'userid' => vB::getUserContext()->fetchUserId(),
						'ignoreuserid' => intval($GPC['userid'])
					));
					$shout->set('message', (isset($isignored['userid']) ? '/unignore ' : '/ignore ') . $exists['username']);
					break;
					
				case 'chatremove':
					// Remove an user from chat
					
					// Leave the chat room
					vB_Api::instance('vbshout_shoutbox')->chatRemove(self::$chatroom, $GPC['userid']);
					
					$shout->set('message', (string) new vB_Phrase('hooks', 'dbtech_vbshout_x_removed_successfully', $exists['username']));
					$shout->set('userid', -1);
					$shout->set('type', self::$shouttypes['system']);
					break;
					
				case 'banunban':
					$shout->set('message', ($exists['dbtech_vbshout_banned'] ? '/unban ' : '/ban ') . $exists['username']);
					break;
					
				case 'silenceunsilence':
					$shout->set('message', ($exists['dbtech_vbshout_silenced'] ? '/unsilence ' : '/silence ') . $exists['username']);			
					break;
					
				case 'pruneshouts':
					// Prune an user's posts			
					$shout->set('message', '/prune ' . $exists['username']);
					break;

				default:
					$skip = true;
					break;
			}
			
			if (!$skip)
			{
				// Now save it
				$shout->save();
				
				if (
					(array_key_exists('error', self::$fetched) AND self::$fetched['error']) OR 
					(array_key_exists('errors', self::$fetched) AND self::$fetched['errors'])
				)
				{
					// We haz error
					break;
				}
				
				// Update the AOP
				vB_Api::instance('vbshout_shoutbox')->setAop('shouts', self::$instance['instanceid'], false, true);		

				// We want to fetch shouts
				self::_ajaxFetch($GPC);
			}
			unset($shout);
		}
		while (false);
	}

	protected static function _ajaxSetAop($GPC)
	{
		$cleaned = vB::getCleaner()->clean($GPC, 'tabs', vB_Cleaner::TYPE_ARRAY_BOOL);		
		$tabs = array_key_exists('tabs', $cleaned) ? $cleaned['tabs'] : array();

		foreach ($tabs as $tabid => $enabled)
		{
			if ($tabid == 'activeusers')
			{
				// Shouldn't happen
				continue;
			}
			
			if (substr($tabid, 0, 8) == 'chatroom')
			{
				// Get the chatroom id
				$chatroomid = explode('_', $tabid);
				$chatroomid = $chatroomid[1];
				
				// Already set
				$instanceid = '';
			}
			else if (substr($tabid, 0, 2) == 'pm')
			{
				// Already set
				$instanceid = '';
			}
			else
			{
				// Just use the normal instance id
				$instanceid = self::$instance['instanceid'];
			}

			// Fetch AOP
			vB_Api::instance('vbshout_shoutbox')->setAop($tabid, $instanceid, true, true);
		}

		// Fetch the file in question
		self::_ajaxFetch($GPC);
	}

}