<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

$_cache = array(
	'instance' 	=> vB_Api::instance('vbshout_core')->getCache('instance'),
);

// #############################################################################
if ($_REQUEST['action'] == 'notifications' OR empty($_REQUEST['action']))
{
	$channels = vB_Api::instance('search')->getChannels(true);

	$channelids = array();
	foreach ((array)$channels as $channelid => $channel)
	{
		/*DBTECH_LITE_START*/
		if (!vB_Api::instance('vbshout_core')->isPro() AND $channel['parentid'] != 0)
		{
			// This channel isn't a parent channel
			continue;
		}
		/*DBTECH_LITE_END*/
		
		$channelids[] = $channelid;
	}
	
	$headings = array();
	$headings[] = new vB_Phrase('global', 'channel');
	foreach ((array)$_cache['instance'] as $instanceid => $instance)
	{
		$headings[] = $instance['name'];
	}
	
	print_cp_header(strip_tags(new vB_Phrase('hooks', 'dbtech_vbshout_editing_x_y', new vB_Phrase('cppermission', 'permissions'), new vB_Phrase('hooks', 'dbtech_vbshout_instance'))));
	print_form_header('vbshout', 'notifications');
	construct_hidden_code('action', 'update');
	print_table_header(new vB_Phrase('hooks', 'dbtech_vbshout_editing_x_y', new vB_Phrase('cppermission', 'permissions'), new vB_Phrase('hooks', 'dbtech_vbshout_instance')), count($headings));
	print_cells_row($headings, 0, 'thead');
	
	foreach ((array)$channelids as $channelid)
	{
		// Shorthand
		$channel = $channels[$channelid];

		$cell = array();
		$cell[] = construct_depth_mark($channel['depth'],'- - ') . $channel['title'];
		foreach ((array)$_cache['instance'] as $instanceid => $instance)
		{
			$cell[] = '
				<center>
					<input type="hidden" name="channel[' . $instanceid . '][' . $channelid . '][newthread]" value="0" />
					<label for="cb_channel_' . $instanceid . '_' . $channelid . '_newthread">
						<input type="checkbox" name="channel[' . $instanceid . '][' . $channelid . '][newthread]" id="cb_channel_' . $instanceid . '_' . $channelid . '_newthread" value="1"' . (($instance['notices'][$channelid] & 1) ? ' checked="checked"' : '') . '/>
						' . new vB_Phrase('hooks', 'dbtech_vbshout_new_thread') . '
					</label>
					
					<input type="hidden" name="channel[' . $instanceid . '][' . $channelid . '][newreply]" value="0" />
					<label for="cb_channel_' . $instanceid . '_' . $channelid . '_newreply">
						<input type="checkbox" name="channel[' . $instanceid . '][' . $channelid . '][newreply]" id="cb_channel_' . $instanceid . '_' . $channelid . '_newreply" value="2"' . (($instance['notices'][$channelid] & 2) ? ' checked="checked"' : '') . '/>
						' . new vB_Phrase('hooks', 'dbtech_vbshout_new_reply') . '
					</label>
				</center>
			';
		}
		print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);	
	}
	print_submit_row(new vB_Phrase('global', 'save'), false, count($headings));
}

// #############################################################################
if ($_POST['action'] == 'update')
{
	// Grab stuff
	$cleaned = vB::getCleaner()->cleanArray($_POST, array(
		'channel' 	=> vB_Cleaner::TYPE_ARRAY,
	));
	
	foreach ($cleaned['channel'] as $instanceid => $channel)
	{
		if (!$existing = $_cache['instance'][$instanceid])
		{
			// Invalid isntance
			continue;
		}
		
		$SQL = array();	
		foreach ($channel as $channelid => $config)
		{
			foreach ($config as $val)
			{
				// Notice flag
				$SQL[$channelid] += $val;
			}
		}
		
		// init data manager
		$dm = new DBTechvBShout_DataManager_Instance(vB_DataManager_Constants::ERRTYPE_CP);
			$dm->set_existing($existing);
			$dm->set('notices', $SQL);
		$dm->save();
		unset($dm);	
	}
	
	print_stop_message2(array('dbtech_vbshout_x_y',
		new vB_Phrase('hooks', 'dbtech_vbshout_instance'),
		new vB_Phrase('hooks', 'dbtech_vbshout_edited')
	), 'vbshout', array(
		'do' => 'notifications',
	));
}

print_cp_footer();