<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

$_cache = array(
	'chatroom' 	=> vB_Api::instance('vbshout_core')->getCache('chatroom'),
	'instance' 	=> vB_Api::instance('vbshout_core')->getCache('instance'),
);

// #############################################################################
if ($_REQUEST['action'] == 'download' OR empty($_REQUEST['action']))
{
	print_cp_header(new vB_Phrase('cpglobal', 'dbtech_vbshout_download_archive'));
	
	$instances = array();
	$instances[0] = new vB_Phrase('hooks', 'dbtech_vbshout_all_instances');
	foreach ($_cache['instance'] as $instanceid => $instance)
	{
		// Store the instance
		$instances[$instanceid] = $instance['name'];
	}
	asort($instances);
	
	print_form_header('vbshout', 'download');
	construct_hidden_code('action', 'file');
	print_table_header(new vB_Phrase('cpglobal', 'dbtech_vbshout_download_archive'));
	print_select_row(new vB_Phrase('hooks', 'dbtech_vbshout_file_format'), 'format', array('csv' => 'CSV', 'xml' => 'XML', 'txt' => 'TXT'), 'txt');
	print_time_row(new vB_Phrase('global', 'start_date'), 'startdate', 0, 0);
	print_time_row(new vB_Phrase('global', 'end_date'), 'enddate', 0, 0);
	print_yes_no_row(new vB_Phrase('hooks', 'dbtech_vbshout_include_bbcode'), 'bbcode', 1);
	print_select_row(new vB_Phrase('hooks', 'dbtech_vbshout_instance'), 'instanceid', $instances, 0);
	print_submit_row(new vB_Phrase('cpglobal', 'dbtech_vbshout_download_archive'), 0);
}

// #############################################################################
if ($_POST['action'] == 'file')
{
	$cleaned = vB::getCleaner()->cleanArray($_POST, array(
		'startdate'  => vB_Cleaner::TYPE_UNIXTIME,
		'enddate'    => vB_Cleaner::TYPE_UNIXTIME,
		'instanceid' => vB_Cleaner::TYPE_STR,
		'format'     => vB_Cleaner::TYPE_STR,
		'bbcode'	 => vB_Cleaner::TYPE_BOOL
	));

	$logs = $assertor->assertQuery('DBTechvBShout:fetchDownloadEntries',
		array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_METHOD, 
			'startdate' 	=> $cleaned['startdate'],
			'enddate' 		=> $cleaned['enddate'],
			'instanceid' 	=> $cleaned['instanceid'],
		)
	);
	
	if (!count($logs))
	{
		print_stop_message2('no_results_matched_your_query');
	}
	
	switch ($cleaned['format'])
	{
		case 'txt':
		case 'csv':
			$output = '';
			break;
			
		case 'xml':
			$xml = new vB_XML_Builder();
			$xml->add_group('archive');
			break;
	}
	
	$lastinstanceid = -1;
	foreach ($logs as $log)
	{
		if ($log['userid'] == -1)
		{
			// System user
			$log['username'] = new vB_Phrase('hooks', 'dbtech_vbshout_system');
		}
		
		if ($log['type'] == vB_Api::instance('vbshout_shoutbox')->getShoutType('pm'))
		{
			// Add PM flag
			$log['username'] .= ' (' . new vB_Phrase('hooks', 'dbtech_vbshout_pm') . ')';
		}
		
		// Strip bbcode if needed
		$log['message'] = (!$cleaned['bbcode'] ? vB_String::stripBbcode($log['message']) : $log['message']);
		
		// Store date and time
		$time = vbdate(vB::getDatastore()->getOption('dateformat'), $log['dateline']) . ' ' . vbdate(vB::getDatastore()->getOption('timeformat'), $log['dateline']);
		
		// Shorthand
		$instance = $_cache['instance'][$log['instanceid']];

		switch ($cleaned['format'])
		{
			case 'txt':
				if ($log['instanceid'] != $lastinstanceid)
				{
					$lastinstanceid = $log['instanceid'];
					$output .= "\t\t" . ($instance['name'] ? $instance['name'] : 'N/A') . "\n";
				}
				$output .= "[$time] $log[username]: $log[message]\n";
				break;
			
			case 'csv':
				$output .= ($instance['name'] ? $instance['name'] : new vB_Phrase('global', 'n_a')) . "\t$time\t$log[username]\t$log[message]\n";
				break;
			
			case 'xml':
				$xml->add_group('shout');
					$xml->add_tag('instance', ($instance['name'] ? $instance['name'] : 'N/A'));
					$xml->add_tag('timestamp', $time);
					$xml->add_tag('username', $log['username']);
					$xml->add_tag('message', $log['message']);
				$xml->close_group();
				break;
		}
	}
	
	switch ($cleaned['format'])
	{
		case 'txt':
			$mimetype = 'text/plain';
			$extension = 'txt';
			break;
			
		case 'csv':
			$mimetype = 'text/csv';
			$extension = 'csv';
			break;
			
		case 'xml':
			$mimetype = 'text/xml';
			$extension = 'xml';
		
			$xml->close_group();
			
			$output = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n\r\n";
			$output .= $xml->output();
			
			$xml = null;
			break;
	}
	
	require_once(DIR . '/includes/functions_file.php');
	file_download($output, 'shoutbox-archive.' . $extension, $mimetype);
}

print_cp_footer();