<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'commandlog' OR empty($_REQUEST['action']))
{
	print_cp_header(new vB_Phrase('cpglobal', 'dbtech_vbshout_command_log'));
	
	// ###################### Start modify #######################
	$users = $assertor->getRows('DBTechvBShout:fetchCommandLogUsers', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_STORED));
	$userlist = array('no_value' => new vB_Phrase('logging', 'all_log_entries'));
	foreach ($users as $user)
	{
		$userlist[$user['userid']] = $user['username'];
	}
	
	print_form_header('vbshout', 'commandlog');
	construct_hidden_code('action', 'view');
	print_table_header(new vB_Phrase('hooks', 'dbtech_vbshout_command_log_viewer'));
	print_input_row(new vB_Phrase('logging', 'log_entries_to_show_per_page'), 'perpage', 15);
	print_select_row(new vB_Phrase('logging', 'show_only_entries_generated_by'), 'userid', $userlist);
	print_time_row(new vB_Phrase('global', 'start_date'), 'startdate', 0, 0);
	print_time_row(new vB_Phrase('global', 'end_date'), 'enddate', 0, 0);
	print_select_row(new vB_Phrase('cpglobal', 'order_by_gcpglobal'), 'orderby', array('date' => new vB_Phrase('global', 'date'), 'user' => new vB_Phrase('global', 'username')), 'date');
	print_submit_row(new vB_Phrase('global', 'view'), 0);
	
	print_form_header('vbshout', 'commandlog');
	construct_hidden_code('action', 'prune');
	print_table_header(new vB_Phrase('logging', 'prune_log_entries'));
	print_yes_no_row(new vB_Phrase('logging', 'are_you_sure_you_want_to_prune_x_log_entries_from_moderator_log', ''), 'doprune', 0);
	print_submit_row(new vB_Phrase('logging', 'prune_log_entries'), 0);	
}

// #############################################################################
if ($_POST['action'] == 'prune')
{
	$cleaned = vB::getCleaner()->cleanArray($_POST, array(
		'doprune'    => vB_Cleaner::TYPE_BOOL,
	));
	
	if (!$cleaned['doprune'])
	{
		print_stop_message2('nothing_to_do');
	}
	
	// Truncate
	$assertor->assertQuery('truncateTable', array('table' => 'dbtech_vbshout_log'));
	
	print_stop_message2('pruned_moderator_log_successfully', 'vbshout', array(
		'do' => 'commandlog',
	));
}

// #############################################################################
if ($_REQUEST['action'] == 'view')
{
	print_cp_header(new vB_Phrase('cpglobal', 'dbtech_vbshout_command_log'));
	
	$cleaned = vB::getCleaner()->cleanArray($_REQUEST, array(
		'perpage'    => vB_Cleaner::TYPE_UINT,
		'pagenumber' => vB_Cleaner::TYPE_UINT,
		'userid'     => vB_Cleaner::TYPE_UINT,
		'modaction'  => vB_Cleaner::TYPE_STR,
		'orderby'    => vB_Cleaner::TYPE_NOHTML,
		'product'    => vB_Cleaner::TYPE_STR,
		'startdate'  => vB_Cleaner::TYPE_UNIXTIME,
		'enddate'    => vB_Cleaner::TYPE_UNIXTIME,
	));
	
	// Hacks
	$cleaned[vB_dB_Query::TYPE_KEY] = vB_dB_Query::QUERY_METHOD;

	if (!array_key_exists('perpage', $cleaned) OR $cleaned['perpage'] < 1)
	{
		$cleaned['perpage'] = 15;
	}
	
	// Count the rows
	$counter = $assertor->getRow('DBTechvBShout:countCommandLogEntries', $cleaned);
	$totalpages = ceil($counter['total'] / $cleaned['perpage']);
	
	if ($cleaned['pagenumber'] < 1)
	{
		$cleaned['pagenumber'] = 1;
	}
	$cleaned['startat'] = ($cleaned['pagenumber'] - 1) * $cleaned['perpage'];
	
	$logusers = array();
	$users = $assertor->getRows('DBTechvBShout:fetchCommandLogUsers2', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_STORED));
	foreach ($users as $user)
	{
		// Cache the users mentioned in the command
		$logusers[$user['userid']] = ($user['username'] ? $user['username'] : 'N/A');
	}
	
	$logs = $assertor->getRows('DBTechvBShout:fetchCommandLogEntries', $cleaned);
	if (!count($logs))
	{
		print_stop_message2('no_results_matched_your_query');
	}

	$cleaned['modaction'] = vB_String::htmlSpecialCharsUni($cleaned['modaction']);

	if ($cleaned['pagenumber'] != 1)
	{
		$prv = $cleaned['pagenumber'] - 1;
		$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . new vB_Phrase('global', 'first_page') . "\" tabindex=\"1\" onclick=\"window.location='vbshout.php?" . vB::getCurrentSession()->get('sessionurl') . "do=commandlog&action=view&modaction=" . $cleaned['modaction'] . "&u=" . $cleaned['userid'] . "&pp=" . $cleaned['perpage'] . "&orderby=" . $cleaned['orderby'] . "&page=1'\">";
		$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . new vB_Phrase('global', 'prev_page') . "\" tabindex=\"1\" onclick=\"window.location='vbshout.php?" . vB::getCurrentSession()->get('sessionurl') . "do=commandlog&action=view&modaction=" . $cleaned['modaction'] . "&u=" . $cleaned['userid'] . "&pp=" . $cleaned['perpage'] . "&orderby=" . $cleaned['orderby'] . "&page=$prv'\">";
	}

	if ($cleaned['pagenumber'] != $totalpages)
	{
		$nxt = $cleaned['pagenumber'] + 1;
		$nextpage = "<input type=\"button\" class=\"button\" value=\"" . new vB_Phrase('global', 'next_page') . " &gt;\" tabindex=\"1\" onclick=\"window.location='vbshout.php?" . vB::getCurrentSession()->get('sessionurl') . "do=commandlog&action=view&modaction=" . $cleaned['modaction'] . "&u=" . $cleaned['userid'] . "&pp=" . $cleaned['perpage'] . "&orderby=" . $cleaned['orderby'] . "&page=$nxt'\">";
		$lastpage = "<input type=\"button\" class=\"button\" value=\"" . new vB_Phrase('global', 'last_page') . " &raquo;\" tabindex=\"1\" onclick=\"window.location='vbshout.php?" . vB::getCurrentSession()->get('sessionurl') . "do=commandlog&action=view&modaction=" . $cleaned['modaction'] . "&u=" . $cleaned['userid'] . "&pp=" . $cleaned['perpage'] . "&orderby=" . $cleaned['orderby'] . "&page=$totalpages'\">";
	}
	
	$headings = array();
	$headings[] = new vB_Phrase('logging', 'id');
	$headings[] = "<a href=\"vbshout.php?" . vB::getCurrentSession()->get('sessionurl') . "do=commandlog&action=view&modaction=" . $cleaned['modaction'] . "&u=" . $cleaned['userid'] . "&pp=" . $cleaned['perpage'] . "&orderby=user&page=" . $cleaned['pagenumber'] . "\">" . str_replace(' ', '&nbsp;', new vB_Phrase('global', 'username')) . "</a>";
	$headings[] = "<a href=\"vbshout.php?" . vB::getCurrentSession()->get('sessionurl') . "do=commandlog&action=view&modaction=" . $cleaned['modaction'] . "&u=" . $cleaned['userid'] . "&pp=" . $cleaned['perpage'] . "&orderby=date&page=" . $cleaned['pagenumber'] . "\">" . new vB_Phrase('global', 'date') . "</a>";
	$headings[] = "<a href=\"vbshout.php?" . vB::getCurrentSession()->get('sessionurl') . "do=commandlog&action=view&modaction=" . $cleaned['modaction'] . "&u=" . $cleaned['userid'] . "&pp=" . $cleaned['perpage'] . "&orderby=modaction&page=" . $cleaned['pagenumber'] . "\">" . new vB_Phrase('global', 'action') . "</a>";
	$headings[] = new vB_Phrase('global', 'info');
	$headings[] = str_replace(' ', '&nbsp;', new vB_Phrase('global', 'ip_address'));		

	print_form_header('', '');
	print_description_row(construct_link_code(new vB_Phrase('cpglobal', 'restart'), "vbshout.php?" . vB::getCurrentSession()->get('sessionurl') . "do=commandlog"), false, count($headings), 'thead', 'right');
	print_table_header(new vB_Phrase('hooks', 'dbtech_vbshout_command_log_viewer_page_x_y_there_are_z_total_log_entries', vb_number_format($cleaned['pagenumber']), vb_number_format($totalpages), vb_number_format($counter['total'])), count($headings));
	print_cells_row($headings, 1);

	foreach ($logs as $log)
	{
		$cell = array();
		$cell[] = $log['logid'];
		if ($log['userid'])
		{
			// This user still exists
			$cell[] = "<a href=\"user.php?" . vB::getCurrentSession()->get('sessionurl') . "do=edit&u=$log[userid]\"><b>$log[username]</b></a>";
		}
		else
		{
			// User has been deleted
			$cell[] = ($log['username'] ? $log['username'] : 'N/A');
		}
		$cell[] = '<span class="smallfont">' . vbdate(vB::getDatastore()->getOption('logdateformat'), $log['dateline']) . '</span>';
		$cell[] = new vB_Phrase('hooks', "dbtech_vbshout_logcommand_$log[command]");

		$celldata = '';
		switch ($log['command'])
		{
			case 'ban':
			case 'unban':
				$celldata =  new vB_Phrase('hooks', "dbtech_vbshout_log_{$log[command]}", $logusers[$log['comment']]);
				break;
				
			case 'shoutedit':
				$shouts = unserialize($log['comment']);
				$celldata = new vB_Phrase('hooks', "dbtech_vbshout_log_{$log[command]}", $shouts['old'], $shouts['new']);
				break;
			
			case 'shoutdelete':
				$celldata = new vB_Phrase('hooks', "dbtech_vbshout_log_{$log[command]}", $log['comment']);
				break;
		}
		
		

		$cell[] = $celldata;
		$cell[] = '<span class="smallfont">' . ($log['ipaddress'] ? "<a href=\"usertools.php?" . vB::getCurrentSession()->get('sessionurl') . "do=gethost&ip=$log[ipaddress]\">$log[ipaddress]</a>" : '&nbsp;') . '</span>';

		print_cells_row($cell, 0, 0, -4);
	}

	print_table_footer(count($headings), "$firstpage $prevpage &nbsp; $nextpage $lastpage");
}

print_cp_footer();