<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Rotating Banner System - Banner Statistics                             # ||
|| # ---------------------------------------------------------------------- # ||
|| # (C) Copyright Y2K Software s.a.s. 2008-2012 - All Rights Reserved.     # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| ########################################################################## ||
\*============================================================================*/

/**
 * @author Y2K Software
 * @copyright (C) Copyright Y2K Software 2008-2012 - All Rights Reserved
 * @version 2.4.0
 * @link www.pagerobot.com
 */

error_reporting(0);

define('THIS_SCRIPT', 'rbs_stats');
define('VB_AREA', 'Forum');
define('CSRF_PROTECTION', false);

define('NOSHUTDOWNFUNC', 1);
define('NOCOOKIES', 1);
define('NOPMPOPUP', 1);
define('SKIP_SESSIONCREATE', 1);
define('SKIP_USERINFO', 1);
define('SKIP_DEFAULTDATASTORE', 1);
define('CWD', (($getcwd = getcwd()) ? $getcwd : '.'));

define('ENABLE_TEXT', 0);
define('AUTO_REFRESH', 0);

$phrasegroups = array();
$specialtemplates = array();
$globaltemplates = array();
$actiontemplates = array();

require_once (CWD . '/includes/init.php');

$vbulletin->input->clean_array_gpc('r', array('key' => TYPE_STR));

$key = $vbulletin->db->escape_string($vbulletin->GPC['key']);

$vbulletin->db->hide_errors();

// Get banner settings and statistics
$SQL = "SELECT *
    FROM " . TABLE_PREFIX . "rbs_banners
    WHERE md5key='$key'
    LIMIT 1";
if(!$rs = $vbulletin->db->query_first($SQL))
{
    echo "Invalid request"; die;
}

// Get additional click track info
$extended = 0;
$firstclick = 0;
$lastclick = 0;
$ips = array();
$referers = array();
$servernames = array();
$users = array();
$SQL = "SELECT *
    FROM " . TABLE_PREFIX . "rbs_hits
    WHERE bannerid=$rs[id]
    ORDER BY dateline";
$rss = $vbulletin->db->query_read($SQL);
while($rs2 = $vbulletin->db->fetch_array($rss))
{
    $extended++;
    $lastclick = $rs2['dateline'];
	if(!$firstclick)
    {
        $firstclick = $lastclick;
    }
    $ips["$rs2[ip]"]++;
    $referers["$rs2[referer]"]++;
    $servernames["$rs2[servername]"]++;
    $users[$rs2['userid']]++;
}
$vbulletin->db->free_result($rss);
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
    <head>
    	<title>Banner Statistics</title>
<?php
if(AUTO_REFRESH)
{
?>
        <meta http-equiv="refresh" content="<?php echo AUTO_REFRESH; ?>" />
<?php
}
?>
        <style>
        h1
        {
            font-size: 24px;
            font-family: sans-serif;
        }
        h4
        {
            font-size: 14px;
            font-family: sans-serif;
        }
        div
        {
            font-size: 12px;
            font-family: sans-serif;
            width: 800px;
        }
        .lft
        {
            float: left;
            width: 100px;
        }
        .rgt
        {
            text-align: right;
            width: 700px;
        }
        .clear
        {
            clear: both;
        }
        </style>
    </head>
    <body>
    	<h1>Banner Statistics</h1>
    	<h4>Options</h4>
        <div>
            <div class="lft">ID:</div>
            <div class="rgt"><?php echo $rs['id']; ?></div>
        </div>
        <div>
            <div class="lft">Enabled:</div>
            <div class="rgt"><?php echo $rs['enabled'] ? 'Yes' : 'No'; ?></div>
        </div>
        <div>
            <div class="lft">Name / Popup:</div>
            <div class="rgt"><?php echo $rs['name'] ? htmlspecialchars($rs['name']) : 'N/A'; ?></div>
        </div>
        <div>
            <div class="lft">Image / Flash:</div>
            <div class="rgt"><?php echo $rs['image'] ? htmlspecialchars($rs['image']) : 'N/A'; ?></div>
        </div>
        <div>
            <div class="lft">Landing Page:</div>
            <div class="rgt"><?php echo $rs['url'] ? htmlspecialchars($rs['url']) : 'N/A'; ?></div>
        </div>
        <div>
            <div class="lft">Start Date:</div>
            <div class="rgt"><?php echo gmdate('D, d-M-Y H:i:s', $rs['startdate']) . ' GMT'; ?></div>
        </div>
        <div>
            <div class="lft">End Date:</div>
            <div class="rgt"><?php echo gmdate('D, d-M-Y H:i:s', $rs['enddate']) . ' GMT'; ?></div>
        </div>
        <div>
            <div class="lft">Max. Impressions:</div>
            <div class="rgt"><?php echo $rs['maximpressions'] ? vb_number_format($rs['maximpressions']) : 'N/A'; ?></div>
        </div>
        <div>
            <div class="lft">Max. Clicks:</div>
            <div class="rgt"><?php echo $rs['maxclicks'] ? vb_number_format($rs['maxclicks']) : 'N/A'; ?></div>
        </div>
        <div>
            <div class="lft">Click Tracking:</div>
            <div class="rgt"><?php echo $rs['clicktrack'] ? 'Yes' : 'No'; ?></div>
        </div>
<?php
if(ENABLE_TEXT)
{
?>
        <div>
            <div class="lft">Text:</div>
            <div class="rgt"><textarea cols="40" rows="5" readonly="readonly"><?php echo htmlspecialchars($rs['text']); ?></textarea></div>
        </div>
<?php
}
?>
        <div class="clear"></div>
    	<h4>Results</h4>
        <div>
            <div class="lft">Impressions:</div>
            <div class="rgt"><?php echo vb_number_format($rs['impressions']); ?></div>
        </div>
        <div>
            <div class="lft">Clicks:</div>
            <div class="rgt"><?php echo vb_number_format($rs['clicks']); ?></div>
        </div>
        <div>
            <div class="lft">CTR:</div>
            <div class="rgt"><?php echo vb_number_format($rs['impressions'] ? $rs['clicks'] / $rs['impressions'] * 100 : 0, 2) . '%'; ?></div>
        </div>
        <div class="clear"></div>
<?php
if($extended)
{
?>
    	<h4>Extended Results</h4>
        <div>
            <div class="lft">Records:</div>
            <div class="rgt"><?php echo vb_number_format($extended); ?></div>
        </div>
        <div>
            <div class="lft">Unique IP's:</div>
            <div class="rgt"><?php echo vb_number_format(count($ips)); ?></div>
        </div>
        <div>
            <div class="lft">Unique Referers:</div>
            <div class="rgt"><?php echo vb_number_format(count($referers)); ?></div>
        </div>
        <div>
            <div class="lft">Unique Servers:</div>
            <div class="rgt"><?php echo vb_number_format(count($servernames)); ?></div>
        </div>
        <div>
            <div class="lft">Unique Users:</div>
            <div class="rgt"><?php echo vb_number_format(count($users)); ?></div>
        </div>
        <div>
            <div class="lft">Anonymous:</div>
            <div class="rgt"><?php echo vb_number_format($users[0]); ?></div>
        </div>
        <div>
            <div class="lft">First Click:</div>
            <div class="rgt"><?php echo $firstclick ? gmdate('D, d-M-Y H:i:s', $firstclick) . ' GMT' : 'N/A'; ?></div>
        </div>
        <div>
            <div class="lft">Last Click:</div>
            <div class="rgt"><?php echo $lastclick ? gmdate('D, d-M-Y H:i:s', $lastclick) . ' GMT' : 'N/A'; ?></div>
        </div>
        <div class="clear"></div>
<?php
}
?>
    	<h4>Unwanted Results</h4>
        <div>
            <div class="lft">Direct Access:</div>
            <div class="rgt"><?php echo vb_number_format(intval($referers[''])); ?></div>
        </div>
    </body>
</html>
