<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Rotating Banner System - Functions                                     # ||
|| # ---------------------------------------------------------------------- # ||
|| # (C) Copyright Y2K Software s.a.s. 2008-2012 - All Rights Reserved.     # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| ########################################################################## ||
\*============================================================================*/

/**
 * @author Y2K Software
 * @copyright (C) Copyright Y2K Software 2008-2012 - All Rights Reserved
 * @version 2.4.0
 * @link www.pagerobot.com
 */

/**
 * rbs_remove_empty_placeholders()
 * 
 * Remove empty placeholders.
 * 
 * @param mixed $output
 * @param mixed $rbs_max_position_count
 * @param mixed $rbs_n_placeholder
 * @return void
 */
function rbs_remove_empty_placeholders(&$output, $rbs_max_position_count, $rbs_n_placeholder)
{
    $phs = array();

    for($i = 0; $i < $rbs_max_position_count; $i++)
    {
        $phs[] = @sprintf($rbs_n_placeholder, $i);
    }

    $output = str_replace($phs, '', $output);
}

/**
 * rbs_set_impression_counters()
 * 
 * Increment impression counters.
 * 
 * @param mixed $ids
 * @return void
 */
function rbs_set_impression_counters(&$ids)
{
    global $vbulletin;

    if(!$ids || $vbulletin->options['rbs_disable_impression_counter'])
    {
        return;
    }

    $SQL = "UPDATE " . TABLE_PREFIX . "rbs_banners 
        SET impressions=impressions+1 
        WHERE id IN(" . implode(',', $ids) . ")";
    $vbulletin->db->shutdown_query($SQL);
}

/**
 * rbs_url_sanity()
 * 
 * @param string $url
 * @return URL
 */
function rbs_url_sanity($url = '')
{
    global $vbulletin;

    if(strpos($url, '://') === false)
    {
        $bburl = $vbulletin->options['bburl'];
        $url = (strpos($url, '/') === 0 ? $bburl . $url : $bburl . '/' . $url);
    }

    return $url;
}

/**
 * rbs_get_banners()
 * 
 * @return array $ids
 */
function rbs_get_banners()
{
    global $vbulletin;

    $ids = array();

    $rbs_forumid = intval($vbulletin->GPC['forumid']);

    $SQL = "SELECT *
        FROM " . TABLE_PREFIX . "rbs_banners 
        WHERE enabled=1
            AND startdate<=" . TIMENOW . "
            AND enddate>=" . TIMENOW . "
            AND IF(forumhome, $rbs_forumid=0, IF(forumids='', 1, FIND_IN_SET('$rbs_forumid', forumids)))
            AND IF(maximpressions>0, impressions<maximpressions, 1)
            AND IF(clicktrack, maxclicks=0 OR (maxclicks>0 AND clicks<maxclicks), 1)";
    $rss = $vbulletin->db->query_read($SQL);
    while($rs = $vbulletin->db->fetch_array($rss))
    {
        // Handle primary and secondary usergroups
        if($rs['usergroups'])
        {
            // Field defined
            $usergroups = explode(',', $rs['usergroups']);
            if(!is_member_of($vbulletin->userinfo, $usergroups))
            {
                // Not member of these groups, skip
                continue;
            }
        }
        $ids["$rs[position]"][] = $rs;
    }
    $vbulletin->db->free_result($rss);

    return $ids;
}

/**
 * rbs_insert_banners()
 * 
 * Inserts banners into final output code.
 * 
 * @param mixed $output
 * @return void
 */
function rbs_insert_banners(&$output)
{
    global $vbulletin;

    $qids = array();

    // Read all product options
    $productid = 'rbs_';
    $n = strlen($productid);
    foreach($vbulletin->options as $key => $value)
    {
        if(substr($key, 0, $n) == $productid)
        {
            $$key = $value;
        }
    }

    // Sanitize parameters
    if(!$rbs_target)
    {
        $rbs_target = '_blank';
    }

    // Other variables
    $rbs_userid = $vbulletin->userinfo['userid'];
    $bburl = $vbulletin->options['bburl'];

    // Get banners
    $ids = rbs_get_banners();

    // For each banner location
    foreach($ids as $key => $rss)
    {
        $lph = strtolower(@sprintf($rbs_n_placeholder, $key));
        if(!$len = strlen($lph))
        {
            // Invalid placeholder (should not occur, but hey ...)
        	continue;
        }

        // Shuffle (mix) the banners of this location randomly
        shuffle($rss);

        // Check for available replacements
        foreach($rss as $rs)
        {
            if(!$npos = strpos(strtolower($output), $lph))
            {
                // No more banners for this location
                break;
            }

            // Build banner code
            $html = '';
            $embed = '';
            $image = rbs_url_sanity($rs['image']);
            $name = htmlspecialchars($rs['name']);
            if($rs['clicktrack'])
            {
                // Click tracker receives the user click, which then redirects to final landing page
                $url = sprintf('%s/rbs_banner.php?id=%d&userid=%d', $bburl, $rs['id'], $rbs_userid);
            }
            else
            {
                // Build landing page
                $url = rbs_url_sanity($rs['url']);
            }
            if($rs['flash'])
            {
                // Build embed tag (Internet Explorer)
                $embed = '<embed src="' . $bburl . '/rbs_wrapper.swf" FlashVars="banner=' . $image . '&jlink=' . $url . iif($rs['width'] > 0, '&bwidth=' . $rs['width']) . iif($rs['height'] > 0, '&bheight=' . $rs['height']) .
                    '" loop="false" pluginspage="http://www.macromedia.com/go/get/flashplayer" type="application/x-shockwave-flash" ' . iif($rs['width'], ' width="' . $rs['width'] . '"') . iif($rs['height'], ' height="' . $rs['height'] . '"') . '></embed>';
                if($rs['object'])
                {
                    // Build object tag (FireFox et al), eventually 'embed'
                    $html = '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0" border="0" ' . iif($rs['width'], ' width="' . $rs['width'] . '"') . iif($rs['height'],
                        ' height="' . $rs['height'] . '"') . '><param name="movie" value="' . $bburl . '/rbs_wrapper.swf"/><param name="FlashVars" value="banner=' . $image . '&jlink=' . $url . iif($rs['width'], '&bwidth=' . $rs['width']) . iif($rs['height'], '&bheight=' . $rs['height']) .
                        '"/>' . iif($rs['embed'], $embed) . '</object>';
                }
                else
                {
                    // Default to 'embed' tag
                    $html = $embed;
                }
            }
            elseif($rs['image'])
            {
                // Build image banner html
                $wh = iif($rs['width'] > 0, "width=\"$rs[width]\" ") . iif($rs['height'] > 0, "height=\"$rs[height]\" ");
                $html = sprintf('<a rel="nofollow" href="%s" target="%s"><img src="%s" border="0" alt="%s" %s/></a>', $url, $rbs_target, $image, $name, $wh);
            }
            else
            {
                // Build Text / Script banner html
                $html = $rs['text'];
            }

            if(!$html)
            {
                // Invalid entry, skip
                continue;
            }

            // Replace placeholder in final output with banner html
            $output = substr($output, 0, $npos) . $html . substr($output, $npos + $len);

            // Add ID to list for impression counter
            $qids[] = $rs['id'];
        }
    }

    // Remove remaining, empty placeholders
    rbs_remove_empty_placeholders($output, $rbs_max_position_count, $rbs_n_placeholder);

    // Increment impression counters
    rbs_set_impression_counters($qids);
}
