<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Rotating Banner System                                                 # ||
|| # ---------------------------------------------------------------------- # ||
|| # (C) Copyright Y2K Software s.a.s. 2008-2012 - All Rights Reserved.     # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| ########################################################################## ||
\*============================================================================*/

/**
 * @author Y2K Software
 * @copyright (C) Copyright Y2K Software 2008-2012 - All Rights Reserved
 * @version 2.4.0
 * @link www.pagerobot.com
 */

error_reporting(E_ALL & ~ E_NOTICE);
if(!is_object($vbulletin->db))
{
    exit;
}

if($vbulletin->options['rbs_send_mail_before'] >= 0)
{
    $time = TIMENOW + $vbulletin->options['rbs_send_mail_before'] * 86400;
}
else
{
    $time = TIMENOW;
}

// Mail notifications to expired banners
vbmail_start();
$ids = array();
$n = 0;
$datetimeformat = $vbulletin->options['timeformat'] . ' ' . $vbulletin->options['dateformat'];
$SQL = "SELECT id, name, impressions, clicks, mails, enddate 
    FROM " . TABLE_PREFIX . "rbs_banners 
    WHERE enabled=1 
        AND m_expired=0
        AND enddate<$time
        AND LENGTH(mails)>0";
//echo $SQL; die;
$rss = $vbulletin->db->query_read($SQL);
while($rs = $vbulletin->db->fetch_array($rss))
{
    // Convert record to normal variables with $rbs_ prefix:
    extract($rs, EXTR_PREFIX_ALL, 'rbs');
    unset($rbs_mails);

    $rbs_id = vb_number_format($rbs_id);
    $rbs_impressions = vb_number_format($rbs_impressions);
    $rbs_clicks = vb_number_format($rbs_clicks);
    $rbs_enddate = date($datetimeformat, $rs['enddate']);
    $rbs_name = $rs['name'];
    // Handle all specified email addresses (now also new line separated)
    $mails = str_replace("\r\n", ' ', $rs['mails']);
    $values = explode(' ', $mails);
    $values = array_map('trim', $values);
    $values = array_unique($values);
    // Parse variables into email phrase
    eval(fetch_email_phrases('rbs_expired_banner'));
    foreach($values as $key => $value)
    {
        // Send mail
        if($value)
        {
            vbmail($value, $subject, $message, true);
            $n++;
        }
    }
    $ids[] = $rs['id'];
}
$vbulletin->db->free_result($rss);
vbmail_end();

// Update records & log
if($ids)
{
    $SQL = "UPDATE " . TABLE_PREFIX . "rbs_banners 
        SET m_expired=1 
        WHERE id IN (" . implode(',', $ids) . ")";
    $vbulletin->db->query_write($SQL);
    log_cron_action("$n expired banner email notifications sent", $nextitem, 0);
}
