<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Rotating Banner System                                                 # ||
|| # ---------------------------------------------------------------------- # ||
|| # (C) Copyright Y2K Software s.a.s. 2008-2012 - All Rights Reserved.     # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| ########################################################################## ||
\*============================================================================*/

/**
 * @author Y2K Software
 * @copyright (C) Copyright Y2K Software 2008-2012 - All Rights Reserved
 * @version 2.4.0
 * @link www.pagerobot.com
 */

error_reporting(E_ALL & ~ E_NOTICE);

$phrasegroups = array();
$specialtemplates = array();

require_once './global.php';

// #############################################################################
// ######################### START MAIN SCRIPT #################################
// #############################################################################

if(!can_administer('canadminmaintain'))
{
    print_cp_no_permission();
}

log_admin_action();

$vbulletin->input->clean_array_gpc('r', array(
    'o' => TYPE_UINT,
    'd' => TYPE_UINT,
    'e' => TYPE_UINT,
    'p' => TYPE_UINT,
    'x' => TYPE_UINT,
    ));

$ptype = '';
if(isset($_REQUEST['p']))
{
    $ptype .= 'p=' . $vbulletin->GPC['p'] . '&amp;';
}
if(isset($_REQUEST['e']))
{
    $ptype .= 'e=' . $vbulletin->GPC['e'] . '&amp;';
}
if(isset($_REQUEST['x']))
{
    $ptype .= 'x=' . $vbulletin->GPC['x'] . '&amp;';
}
print_cp_header($vbphrase['rbs_rotating_banner_system']);
print_form_header('admin_rbs');
print_table_header($vbphrase['rbs_banner_list'], 5);
$listitems = array();
if($vbulletin->GPC['o'] <= 1 || $vbulletin->GPC['o'] > 5)
{
    $direction = $vbulletin->GPC['d'] ? '0' : '1';
}
else
{
    $direction = '0';
}
$listitems[] = sprintf('<a href="admin_rbs_banner_list.php?%so=1&amp;d=%d">%s</a>', $ptype, $direction, $vbphrase['rbs_id']);
if($vbulletin->GPC['o'] == 2)
{
    $direction = $vbulletin->GPC['d'] ? '0' : '1';
}
else
{
    $direction = '0';
}
$listitems[] = sprintf('<a href="admin_rbs_banner_list.php?%so=2&amp;d=%d">%s</a>', $ptype, $direction, $vbphrase['rbs_short_name']);
if($vbulletin->GPC['o'] == 3)
{
    $direction = $vbulletin->GPC['d'] ? '0' : '1';
}
else
{
    $direction = '0';
}
$listitems[] = sprintf('<a href="admin_rbs_banner_list.php?%so=3&amp;d=%d">%s</a>', $ptype, $direction, $vbphrase['rbs_short_position']);
if($vbulletin->GPC['o'] == 4)
{
    $direction = $vbulletin->GPC['d'] ? '0' : '1';
}
else
{
    $direction = '0';
}
$listitems[] = sprintf('<a href="admin_rbs_banner_list.php?%so=4&amp;d=%d">%s</a>', $ptype, $direction, $vbphrase['rbs_short_impressions']);
if($vbulletin->GPC['o'] == 5)
{
    $direction = $vbulletin->GPC['d'] ? '0' : '1';
}
else
{
    $direction = '0';
}
$listitems[] = sprintf('<a href="admin_rbs_banner_list.php?%so=5&amp;d=%d">%s</a>', $ptype, $direction, $vbphrase['rbs_short_clicks']);
print_cells_row($listitems, true);

$SQL = "SELECT id, name, enabled, position, impressions, clicks, m_expired 
    FROM " . TABLE_PREFIX . "rbs_banners";

if(isset($_REQUEST['x']))
{
    // Show (not) expired items
    if($vbulletin->GPC['x'])
    {
        // Get expired items
        $SQL .= " WHERE enddate<" . TIMENOW;
    }
    else
    {
        // Get not expired items
        $SQL .= " WHERE enddate>=" . TIMENOW;
    }
}
elseif(isset($_REQUEST['e']))
{
    // Show (not) enabled items
    $SQL .= " WHERE enabled=" . $vbulletin->GPC['e'];
}
elseif(isset($_REQUEST['p']))
{
    // Show position 0...9 items
    $SQL .= " WHERE position=" . $vbulletin->GPC['p'];
}

switch($vbulletin->GPC['o'])
{
    case 2:
        $SQL .= ' ORDER BY name';
        break;
    case 3:
        $SQL .= ' ORDER BY position';
        break;
    case 4:
        $SQL .= ' ORDER BY impressions';
        break;
    case 5:
        $SQL .= ' ORDER BY clicks';
        break;
    default:
        $SQL .= ' ORDER BY id';
}

$SQL .= ($vbulletin->GPC['d'] ? ' DESC' : ' ASC');

// Show items
$fmt = '<a href="admin_rbs.php?rbs_id=%d">%s</a>';
$n = 0;

$rss = $vbulletin->db->query_read($SQL);
while($rs = $vbulletin->db->fetch_array($rss))
{
    $id = sprintf($fmt, $rs['id'], vb_number_format($rs['id']));
    if(!$rs['name'])
    {
        $rs['name'] = $vbphrase['None'];
    }
    if($rs['m_expired'])
    {
        $rs['name'] = '*' . $rs['name'];
    }
    if($rs['enabled'])
    {
        $rs['name'] = '<b>' . htmlspecialchars_uni($rs['name']) . '</b>';
    }
    else
    {
        $rs['name'] = htmlspecialchars_uni($rs['name']);
    }

    $name = sprintf($fmt, $rs['id'], $rs['name']);
    $impressions = vb_number_format($rs['impressions']);
    $clicks = vb_number_format($rs['clicks']);
    $position = $rs['position'];
    print_cells_row(array(
        $id,
        $name,
        $position,
        $impressions,
        $clicks), false, '', -1);
    $n++;
}

if(!$n)
{
    print_description_row($vbphrase['none'], false, 5);
}

print_table_footer();
print_cp_footer();
