<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Rotating Banner System                                                 # ||
|| # ---------------------------------------------------------------------- # ||
|| # (C) Copyright Y2K Software s.a.s. 2008-2011 - All Rights Reserved.     # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| ########################################################################## ||
\*============================================================================*/

/**
 * @author Y2K Software
 * @copyright (C) Copyright Y2K Software 2008-2011 - All Rights Reserved
 * @version 2.3.2
 * @link www.pagerobot.com
 */

error_reporting(E_ALL & ~ E_NOTICE);

$phrasegroups = array();
$specialtemplates = array();

require_once './global.php';

/**
 * rbs_positions()
 * 
 * @param mixed $max
 * @return array
 */
function rbs_positions($max)
{
    $values = array();
    
    for($i = 0; $i < $max; $i++)
    {
        switch($i)
        {
            case 0:
                $values[] = 'Position 0 (horizontal)';
                break;
            case 1:
                $values[] = 'Position 1 (vertical)';
                break;
            default:
                $values[] = 'Position ' . $i;
        }
    }
    
    return $values;
}

/**
 * rbs_browse_buttons()
 * 
 * @return string
 */
function rbs_browse_buttons()
{
    global $vbphrase;
    
    return sprintf('
    <input type="submit" class="button" value="%s" accesskey="s" tabindex="1" onClick="rbs_action.value=\'save\'; return true;" />
    <input type="reset" class="button" value="%s" tabindex="1" accesskey="r" />
    <input type="submit" class="button" value="%s" tabindex="1" onClick="rbs_action.value=\'duplicate\'; return true;" />
    <input type="submit" class="button" value="&lt;&lt;" tabindex="1" onClick="rbs_action.value=\'first\'; return true;" />
    <input type="submit" class="button" value="&lt;" accesskey="p" tabindex="1" onClick="rbs_action.value=\'prev\'; return true;" />
    <input type="submit" class="button" value="%s" tabindex="1" onClick="rbs_action.value=\'new\'; return true;" />
    <input type="submit" class="button" value="%s" tabindex="1" onClick="rbs_action.value=\'delete\'; return true;" />
    <input type="submit" class="button" value="&gt;" accesskey="n" tabindex="1" onClick="rbs_action.value=\'next\'; return true;" />
    <input type="submit" class="button" value="&gt;&gt;" tabindex="1" onClick="rbs_action.value=\'last\'; return true;" />', 
    $vbphrase['rbs_save'], $vbphrase['reset'], $vbphrase['rbs_duplicate'], $vbphrase['rbs_new'], $vbphrase['rbs_delete']);
}
/**
 * rbs_auto_save()
 *
 * Auto-saves a record.
 *
 * @return void
 */
function rbs_auto_save($id, $action, $autosave)
{
    global $vbulletin;
    
    if($id && $autosave)
    {
        switch($action)
        {
            case 'duplicate':
            case 'first':
            case 'prev':
            case 'new':
            case 'next':
            case 'last':
                rbs_save();
        }
    }
}

/**
 * rbs_save()
 *
 * Saves a record and returns a selection query.
 *
 * @return
 */
function rbs_save()
{
    global $vbulletin;

    if($vbulletin->GPC['rbs_id'])
    {
        // Save and reset email notifications
        $SQL = "UPDATE " . TABLE_PREFIX . "rbs_banners SET 
                name='" . $vbulletin->db->escape_string($vbulletin->GPC['rbs_name']) . "',
                url='" . $vbulletin->db->escape_string($vbulletin->GPC['rbs_url']) . "',
                image='" . $vbulletin->db->escape_string($vbulletin->GPC['rbs_image']) . "',
                text='" . $vbulletin->db->escape_string($vbulletin->GPC['rbs_text']) . "',
                startdate='" . $vbulletin->GPC['rbs_start_date'] . "',
                enddate='" . $vbulletin->GPC['rbs_end_date'] . "',
                notes='" . $vbulletin->db->escape_string($vbulletin->GPC['rbs_notes']) . "',
                maximpressions='" . $vbulletin->GPC['rbs_max_impressions'] . "',
                maxclicks='" . $vbulletin->GPC['rbs_max_clicks'] . "',
                position='" . $vbulletin->GPC['rbs_position'] . "',
                forumids='" . implode(',', $vbulletin->GPC['rbs_forums']) . "',
                enabled='" . $vbulletin->GPC['rbs_enabled'] . "',
                forumhome='" . $vbulletin->GPC['rbs_forumhome'] . "',
                clicktrack='" . $vbulletin->GPC['rbs_clicktrack'] . "',
                mails='" . $vbulletin->db->escape_string($vbulletin->GPC['rbs_mails']) . "'" . iif($vbulletin->GPC['rbs_reset_notifications'], ', m_expired=0') . ",
                usergroups='" . $vbulletin->GPC['rbs_usergroups'] . "', 
                flash='" . $vbulletin->GPC['rbs_flash'] . "', 
                object='" . $vbulletin->GPC['rbs_object'] . "', 
                embed='" . $vbulletin->GPC['rbs_embed'] . "', 
                width='" . $vbulletin->GPC['rbs_width'] . "', 
                height='" . $vbulletin->GPC['rbs_height'] . "'
            WHERE id=" . $vbulletin->GPC['rbs_id'] . "
            LIMIT 1";
        $vbulletin->db->query_write($SQL);
        $SQL = "SELECT *
            FROM " . TABLE_PREFIX . "rbs_banners
            WHERE id=" . $vbulletin->GPC['rbs_id'] . "
            LIMIT 1";
    }
    else
    {
        $SQL = "INSERT INTO " . TABLE_PREFIX . "rbs_banners SET
            name='" . $vbulletin->db->escape_string($vbulletin->GPC['rbs_name']) . "',
            url='" . $vbulletin->db->escape_string($vbulletin->GPC['rbs_url']) . "',
            image='" . $vbulletin->db->escape_string($vbulletin->GPC['rbs_image']) . "',
            text='" . $vbulletin->db->escape_string($vbulletin->GPC['rbs_text']) . "',
            startdate='" . $vbulletin->GPC['rbs_start_date'] . "',
            enddate='" . $vbulletin->GPC['rbs_end_date'] . "',
            notes='" . $vbulletin->db->escape_string($vbulletin->GPC['rbs_notes']) . "',
            maximpressions='" . $vbulletin->GPC['rbs_max_impressions'] . "',
            maxclicks='" . $vbulletin->GPC['rbs_max_clicks'] . "',
            position='" . $vbulletin->GPC['rbs_position'] . "',
            forumids='" . $vbulletin->db->escape_string(',', $vbulletin->GPC['rbs_forums']) . "',
            enabled='" . $vbulletin->GPC['rbs_enabled'] . "',
            forumhome='" . $vbulletin->GPC['rbs_forumhome'] . "',
            clicktrack='" . $vbulletin->GPC['rbs_clicktrack'] . "',
            mails='" . $vbulletin->db->escape_string($vbulletin->GPC['rbs_mails']) . "',
            usergroups='" . $vbulletin->GPC['rbs_usergroups'] . "', 
            flash='" . $vbulletin->GPC['rbs_flash'] . "', 
            object='" . $vbulletin->GPC['rbs_object'] . "', 
            embed='" . $vbulletin->GPC['rbs_embed'] . "', 
            width='" . $vbulletin->GPC['rbs_width'] . "', 
            height='" . $vbulletin->GPC['rbs_height'] . "', 
            md5key='" . md5(TIMENOW . SESSION_HOST . microtime() . uniqid(mt_rand(), true)) . "'";
        $vbulletin->db->query_write($SQL);
        $SQL = "SELECT *
            FROM " . TABLE_PREFIX . "rbs_banners
            WHERE id=LAST_INSERT_ID()
            LIMIT 1";
    }

    return $SQL;
}

// #############################################################################
// ######################### START MAIN SCRIPT #################################
// #############################################################################

if(!can_administer('canadminmaintain'))
{
    print_cp_no_permission();
}

log_admin_action();

// Read all product options
$productid = 'rbs_';
$n = strlen($productid);
foreach($vbulletin->options AS $key => $value)
{
	if(substr($key, 0, $n) == $productid)
    {
        $$key = $value;
    }
}

$vbulletin->input->clean_array_gpc('r', array('rbs_id' => TYPE_UINT, 'rbs_action' => TYPE_STR, 'rbs_name' => TYPE_STR, 'rbs_position' => TYPE_UINT, 'rbs_url' => TYPE_STR, 'rbs_image' => TYPE_STR, 'rbs_text' => TYPE_STR, 'rbs_start_date' => TYPE_ARRAY,
    'rbs_end_date' => TYPE_ARRAY, 'rbs_max_impressions' => TYPE_UINT, 'rbs_forums' => TYPE_ARRAY_UINT, 'rbs_notes' => TYPE_STR, 'rbs_enabled' => TYPE_BOOL, 'rbs_forumhome' => TYPE_BOOL, 'rbs_clicktrack' => TYPE_BOOL, 'rbs_max_clicks' => TYPE_UINT, 'rbs_mails' =>
    TYPE_STR, 'rbs_reset_notifications' => TYPE_BOOL, 'rbs_usergroups' => TYPE_STR, 'rbs_flash' => TYPE_BOOL, 'rbs_object' => TYPE_BOOL, 'rbs_embed' => TYPE_BOOL, 'rbs_width' => TYPE_UINT, 'rbs_height' => TYPE_UINT, ));

// Date sanity
$a = $vbulletin->GPC['rbs_start_date'];
if(count($a))
{
    $vbulletin->GPC['rbs_start_date'] = mktime($a['hour'], $a['minute'], 0, $a['month'], $a['day'], $a['year']);
}
else
{
    $vbulletin->GPC['rbs_start_date'] = TIMENOW;
}
$a = $vbulletin->GPC['rbs_end_date'];
if(count($a))
{
    $vbulletin->GPC['rbs_end_date'] = mktime($a['hour'], $a['minute'], 0, $a['month'], $a['day'], $a['year']);
}
else
{
    $vbulletin->GPC['rbs_end_date'] = TIMENOW + 86400 * 365;
}

// Usergroups Sanity
if($values = $vbulletin->GPC['rbs_usergroups'])
{
    $values = explode(',', $values);
    array_map('intval', $values);
    $values = array_unique($values);
    sort($values, SORT_NUMERIC);
    $vbulletin->GPC['rbs_usergroups'] = implode(',', $values);
}
else
{
    $vbulletin->GPC['rbs_usergroups'] = '';
}

// Panner Placeholder Sanity
if($vbulletin->GPC['rbs_position'] > $rbs_max_position_count)
{
    $vbulletin->GPC['rbs_position'] = 0;
}

// Page output / handling
print_cp_header($vbphrase['rbs_rotating_banner_system']);

if(empty($_REQUEST['do']))
{
    $_REQUEST['do'] = 'edit';
}

/**
 * Deletion of a record.
 */
if($_REQUEST['do'] == 'kill')
{
    $SQL = "DELETE
        FROM " . TABLE_PREFIX . "rbs_banners
        WHERE id=" . $vbulletin->GPC['rbs_id'] . "
        LIMIT 1";
    $vbulletin->db->query_write($SQL);
    $_REQUEST['do'] = 'edit';
    $vbulletin->GPC['rbs_action'] = 'last';
}

/**
 * Edit/View.
 */
$doquery = true;
$id = $vbulletin->GPC['rbs_id'];
$action = $vbulletin->GPC['rbs_action'];
rbs_auto_save($id, $action, $rbs_save_on_scroll);
switch($action)
{
    case 'first':
        $SQL = "SELECT *
            FROM " . TABLE_PREFIX . "rbs_banners
            ORDER BY id
            LIMIT 1";
        break;
    case 'prev':
        $SQL = "SELECT *
            FROM " . TABLE_PREFIX . "rbs_banners
            WHERE id<$id
            ORDER BY id DESC
            LIMIT 1";
        break;
    case 'new':
        $doquery = false;
        break;
    case 'delete':
        $SQL = "SELECT *
            FROM " . TABLE_PREFIX . "rbs_banners
            WHERE id=$id
            LIMIT 1";
        if($rs = $vbulletin->db->query_first($SQL))
        {
            print_form_header('admin_rbs', 'kill');
            construct_hidden_code('rbs_id', $rs['id']);
            construct_hidden_code('rbs_action', 'kill');
            print_table_header($vbphrase['rbs_delete_banner']);
            print_description_row(construct_phrase($vbphrase['rbs_are_you_sure_you_want_to_delete_the_banner_x_called_y'], $rs['id'], $rs['name']));
            print_submit_row($vbphrase['yes'], 0, 0, $vbphrase['no']);
            print_cp_footer();
        }
        else
        {
            print_stop_message('rbs_no_entries_matched_your_query');
        }
    case 'save':
        $SQL = rbs_save();
        break;
    case 'next':
        $SQL = "SELECT *
            FROM " . TABLE_PREFIX . "rbs_banners
            WHERE id>$id
            ORDER BY id
            LIMIT 1";
        break;
    case 'duplicate':
        // duplicate current ID, then select last entry
        $vbulletin->GPC['rbs_id'] = 0;
        $SQL = rbs_save();
        break;
    case 'last':
        $id = 0;
    default:
        if($id)
        {
            $SQL = "SELECT *
                FROM " . TABLE_PREFIX . "rbs_banners
                WHERE id=$id
                LIMIT 1";
        }
        else
        {
            $SQL = "SELECT *
                FROM " . TABLE_PREFIX . "rbs_banners
                ORDER BY id DESC
                LIMIT 1";
        }
}

if($doquery)
{
    $rs = $vbulletin->db->query_first($SQL);
}

if(!$rs)
{
    $rs = array('id' => 0, 'name' => 'New banner', 'url' => '', 'image' => '', 'text' => '', 'startdate' => 0, 'enddate' => 0, 'impressions' => 0, 'notes' => '', 'maximpressions' => 0, 'position' => 0, 'forumids' => '', 'enabled' => 1, 'mails' => '',
        'usergroups' => '', 'flash' => 0, 'object' => 1, 'embed' => 1, 'width' => 0, 'height' => 0);
}

if(!$rs['startdate'])
{
    $rs['startdate'] = TIMENOW;
}
if(!$rs['enddate'])
{
    $rs['enddate'] = TIMENOW + 86400 * 365;
}
$rs['forumids'] = explode(',', $rs['forumids']);

if($_REQUEST['do'] == 'edit')
{
    $browse_buttons = rbs_browse_buttons();
    $positions = rbs_positions($rbs_max_position_count);

    print_form_header('admin_rbs', 'edit');
    construct_hidden_code('rbs_id', $rs['id']);
    construct_hidden_code('rbs_action', '');
    print_hidden_fields();
    print_table_header($vbphrase['rbs_banners']);
    print_description_row("<center>$browse_buttons</center>");
    print_description_row('<center><a href="' . $vbulletin->options['bburl'] . '/rbs_stats.php?key=' . $rs['md5key'] . '" target="_blank">' . $vbphrase['rbs_statistics_link'] . '</a></center>');
    print_cells_row(array('ID', $rs['id']), true);
    print_cells_row(array($vbphrase['rbs_impressions'], vb_number_format($rs['impressions'])), true);
    print_cells_row(array($vbphrase['rbs_clicks'], vb_number_format($rs['clicks'])), true);
    print_checkbox_row($vbphrase['rbs_enabled'], 'rbs_enabled', $rs['enabled'], 1);
    print_input_row($vbphrase['rbs_name'], 'rbs_name', $rs['name']);
    print_select_row($vbphrase['rbs_position'], 'rbs_position', $positions, $rs['position']);
    print_input_row($vbphrase['rbs_url'], 'rbs_url', $rs['url']);
    print_input_row($vbphrase['rbs_image'], 'rbs_image', $rs['image']);
    print_checkbox_row($vbphrase['rbs_click_tracking'], 'rbs_clicktrack', $rs['clicktrack'], 1);
    print_input_row($vbphrase['rbs_max_clicks'], 'rbs_max_clicks', $rs['maxclicks']);

    print_checkbox_row($vbphrase['rbs_flash'], 'rbs_flash', $rs['flash'], 1);
    print_checkbox_row($vbphrase['rbs_flash_object'], 'rbs_object', $rs['object'], 1);
    print_checkbox_row($vbphrase['rbs_flash_embed'], 'rbs_embed', $rs['embed'], 1);
    print_input_row($vbphrase['rbs_flash_width'], 'rbs_width', $rs['width']);
    print_input_row($vbphrase['rbs_flash_height'], 'rbs_height', $rs['height']);

    print_textarea_row($vbphrase['rbs_text'], 'rbs_text', $rs['text']);
    print_time_row($vbphrase['rbs_start_date'], 'rbs_start_date', $rs['startdate']);
    print_time_row($vbphrase['rbs_end_date'], 'rbs_end_date', $rs['enddate']);
    print_input_row($vbphrase['rbs_max_impressions'], 'rbs_max_impressions', $rs['maximpressions']);
    print_checkbox_row($vbphrase['rbs_forumhome'], 'rbs_forumhome', $rs['forumhome'], 1);
    print_forum_chooser($vbphrase['rbs_forums'], 'rbs_forums[]', $rs['forumids'], null, false, true);
    print_input_row($vbphrase['rbs_usergroups'], 'rbs_usergroups', $rs['usergroups']);
    print_textarea_row($vbphrase['rbs_mails'], 'rbs_mails', $rs['mails']);
    print_textarea_row($vbphrase['rbs_notes'], 'rbs_notes', $rs['notes']);
    print_checkbox_row($vbphrase['rbs_reset_notifications'], 'rbs_reset_notifications', false);
    print_table_footer(2, $browse_buttons);
    print_cp_footer();
}
