<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.6.2
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2006 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile: index.php,v $ - $Revision: 1.302 $');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('cphome');
$specialtemplates = array('maxloggedin', 'acpstats');

// ########################## REQUIRE BACK-END ############################
require_once('global.php');

// #############################################################################
// ########################### START MAIN SCRIPT ###############################
// #############################################################################

// ############################## Start build_acpstats_datastore ####################################
/**
* Stores a cache of various data for ACP Home Quick Stats into the datastore.
*/
function build_acpstats_datastore()
{
	global $vbulletin, $starttime, $mysqlversion;

	$data = $vbulletin->db->query_first("SELECT SUM(filesize) AS size FROM " . TABLE_PREFIX . "attachment");
	$vbulletin->acpstats['attachsize'] = $data['size'];
	$data = $vbulletin->db->query_first("SELECT SUM(filesize) AS size FROM " . TABLE_PREFIX . "customavatar");
	$vbulletin->acpstats['avatarsize'] = $data['size'];
	$data = $vbulletin->db->query_first("SELECT SUM(filesize) AS size FROM " . TABLE_PREFIX . "customprofilepic");
	$vbulletin->acpstats['profilepicsize'] = $data['size'];

	$data = $vbulletin->db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "user WHERE joindate >= $starttime");
	$vbulletin->acpstats['newusers'] = $data['count'];
	$data = $vbulletin->db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "user WHERE lastactivity >= $starttime");
	$vbulletin->acpstats['userstoday'] = $data['count'];

	$data = $vbulletin->db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "post WHERE dateline >= $starttime");
	$vbulletin->acpstats['newposts'] = $data['count'];

	$vbulletin->acpstats['indexsize'] = 0;
	$vbulletin->acpstats['datasize'] = 0;
	if ($mysqlversion['version'] >= '3.23')
	{
		$vbulletin->db->hide_errors();
		$tables = $vbulletin->db->query_write("SHOW TABLE STATUS");
		$errno = $vbulletin->db->errno;
		$vbulletin->db->show_errors();
		if (!$errno)
		{
			while ($table = $vbulletin->db->fetch_array($tables))
			{
				$vbulletin->acpstats['datasize'] += $table['Data_length'];
				$vbulletin->acpstats['indexsize'] += $table['Index_length'];
			}
		}
	}
	if (!$vbulletin->acpstats['indexsize'])
	{
		$vbulletin->acpstats['indexsize'] = -1;
	}
	if (!$vbulletin->acpstats['datasize'])
	{
		$vbulletin->acpstats['datasize'] = -1;
	}
	$vbulletin->acpstats['lastupdate'] = TIMENOW;
	build_datastore('acpstats', serialize($vbulletin->acpstats), 1);
}

if (empty($_REQUEST['do']))
{
	log_admin_action();
}

// #############################################################################

$vbulletin->input->clean_array_gpc('r', array(
	'redirect' => TYPE_STR,
	'nojs' 		=> TYPE_BOOL,
));

// #############################################################################
// ################################## REDIRECTOR ###############################
// #############################################################################

if (!empty($vbulletin->GPC['redirect']))
{
	require_once(DIR . '/includes/functions_login_fake.php');
	$redirect = htmlspecialchars_uni(fetch_replaced_session_url($vbulletin->GPC['redirect']));

	print_cp_header($vbphrase['redirecting_please_wait'], '', "<meta http-equiv=\"Refresh\" content=\"0; URL=$redirect\" />");
	echo "<p>&nbsp;</p><blockquote><p>$vbphrase[redirecting_please_wait]</p></blockquote>";
	print_cp_footer();
	exit;
}

// #############################################################################
// ################################# SAVE NOTES ################################
// #############################################################################

if ($_POST['do'] == 'notes')
{
	$vbulletin->input->clean_array_gpc('p', array('notes' => TYPE_STR));

	$admindm =& datamanager_init('Admin', $vbulletin, ERRTYPE_CP);
	$admindm->set_existing($vbulletin->userinfo);
	$admindm->set('notes', $vbulletin->GPC['notes']);
	$admindm->save();
	unset($admindm);

	$vbulletin->userinfo['notes'] = htmlspecialchars_uni($vbulletin->GPC['notes']);
	$_REQUEST['do'] = 'home';
}

// #############################################################################
// ############################### SAVE NAV PREFS ##############################
// #############################################################################

if ($_REQUEST['do'] == 'navprefs')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'groups'	=> TYPE_STR,
		'expand'	=> TYPE_BOOL,
		'navprefs'	=> TYPE_STR
	));


	if ($vbulletin->GPC['expand'])
	{
		$groups = explode(',', $vbulletin->GPC['groups']);

		foreach ($groups AS $group)
		{
			if (empty($group))
			{
				continue;
			}

			$vbulletin->input->clean_gpc('r', "num$group", TYPE_UINT);

			for ($i = 0; $i < $vbulletin->GPC["num$group"]; $i++)
			{
				$vbulletin->GPC['navprefs'][] = $group . "_$i";
			}
		}

		$vbulletin->GPC['navprefs'] = implode(',', $vbulletin->GPC['navprefs']);
	}
	else
	{
		$vbulletin->GPC['navprefs'] = '';
	}

	$_REQUEST['do'] = 'savenavprefs';
}

if ($_REQUEST['do'] == 'buildbitfields')
{
	require_once(DIR . '/includes/class_bitfield_builder.php');
	vB_Bitfield_Builder::save($db);
	build_forum_permissions();

	define('CP_REDIRECT', 'index.php');
	print_stop_message('rebuilt_bitfields_successfully');

}

if ($_REQUEST['do'] == 'buildnavprefs')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'prefs' 	=> TYPE_STR,
		'dowhat'	=> TYPE_STR,
		'id'		=> TYPE_INT
	));

	$_tmp = preg_split('#,#', $vbulletin->GPC['prefs'], -1, PREG_SPLIT_NO_EMPTY);
	$_navprefs = array();

	foreach ($_tmp AS $_val)
	{
		$_navprefs["$_val"] = $_val;
	}
	unset($_tmp);

	if ($vbulletin->GPC['dowhat'] == 'collapse')
	{
		// remove an item from the list
		unset($_navprefs[$vbulletin->GPC['id']]);
	}
	else
	{
		// add an item to the list
		$_navprefs[$vbulletin->GPC['id']] = $vbulletin->GPC['id'];
		ksort($_navprefs);
	}

	$vbulletin->GPC['navprefs'] = implode(',', $_navprefs);
	$_REQUEST['do'] = 'savenavprefs';
}

if ($_REQUEST['do'] == 'savenavprefs')
{
	$admindm =& datamanager_init('Admin', $vbulletin, ERRTYPE_CP);
	$admindm->set_existing($vbulletin->userinfo);
	$admindm->set('navprefs', $vbulletin->GPC['navprefs']);
	$admindm->save();
	unset($admindm);

	$_NAVPREFS = preg_split('#,#', $vbulletin->GPC['navprefs'], -1, PREG_SPLIT_NO_EMPTY);
	$_REQUEST['do'] = 'nav';
}

/*======================================================================*\
|| ####################################################################
|| # CVS: $RCSfile: index.php,v $ - $Revision: 1.302 $
|| ####################################################################
\*======================================================================*/
?>
