<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for tabs
*
* @package	postbit
*/
class vBDownloads_DataManager_Category extends vB_DataManager
{
	/**
	* Array of recognised and required fields for tabs, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'categoryid' 		=> array(TYPE_UINT, 	REQ_INCR, 	VF_METHOD, 	'verify_nonzero'),
		'title' 			=> array(TYPE_STR, 		REQ_YES, 	VF_METHOD),
		'description' 		=> array(TYPE_STR, 		REQ_NO),
		'displayorder' 		=> array(TYPE_UINT, 	REQ_NO),
		'extensiongroups' 	=> array(TYPE_NOCLEAN, 	REQ_YES, 	VF_METHOD, 	'verify_serialized'),
		'canprivate' 		=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'canpassword' 		=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'moderation' 		=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'permissions' 		=> array(TYPE_NOCLEAN, 	REQ_YES, 	VF_METHOD, 	'verify_serialized'),
		'parentid' 			=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_categoryid'),
		'forumid' 			=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD),
		'image' 			=> array(TYPE_STR, 		REQ_NO),
		'moderated' 		=> array(TYPE_UINT, 	REQ_NO),
		'ownerid' 			=> array(TYPE_UINT, 	REQ_NO, 	VF_METHOD, 	'verify_userid'),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_downloads_category';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('categoryid = \'%1$s\'', 'categoryid');

	/**
	* Verifies that the extensionid is valid
	*
	* @param	string	extensionid of the tab
	*
	* @return	boolean
	*/
	function verify_title(&$title)
	{
		global $vbphrase;
		
		$title = strval($title);
		if ($title === '')
		{
			// Invalid
			return false;
		}
		
		if (!$this->condition OR $this->existing['title'] != $title)
		{
			// Check for existing download of this name
			if ($existing = VBDOWNLOADS::$db->fetchRow('
				SELECT categoryid
				FROM $dbtech_downloads_category
				WHERE title = ?', array($title)
			))
			{
				// Whoopsie, exists
				$this->error('dbtech_downloads_x_already_exists_y', $vbphrase['dbtech_downloads_category'], $title);
				return false;
			}
		}

		return true;
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_onoff(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array(0, 1)) ? 1 : $onoff);
		
		return true;
	}

	/**
	* Verifies that the categoryid is valid
	*
	* @param	string	categoryid
	*
	* @return	boolean
	*/
	function verify_categoryid(&$categoryid)
	{
		// Validate categoryid
		return (is_array(VBDOWNLOADS::$cache['category'][$categoryid]) OR $categoryid == 0);
	}

	/**
	* Verifies that the forumid is valid
	*
	* @param	string	forumid
	*
	* @return	boolean
	*/
	function verify_forumid(&$forumid)
	{
		// Validate forumid
		return (is_array($this->registry->forumcache[$forumid]) OR $forumid == 0);
	}

	/**
	* Verifies that the specified user exists
	*
	* @param	integer	User ID
	*
	* @return 	boolean	Returns true if user exists
	*/
	function verify_userid(&$userid)
	{
		return ($userid == 0 OR parent::verify_userid($userid));
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		global $vbphrase;

		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_categorydata_presave')) ? eval($hook) : false;		

		if ($this->condition !== NULL AND $this->fetch_field('parentid') == $this->fetch_field('categoryid'))
		{
		$this->error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category_parent_dm'], $this->fetch_field('parentid'));
		}

		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_categorydata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_categorydata_postsave')) ? eval($hook) : false;

		// Rebuild the cache
		VBDOWNLOADS_CACHE::build_cache('category', '
			ORDER BY displayorder ASC
		');

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_categorydata_delete')) ? eval($hook) : false;
 
		// Rebuild the cache
		VBDOWNLOADS_CACHE::build_cache('category', '
			ORDER BY displayorder ASC
		');
		
		return true;
	}
}