<?php
if (!VBDOWNLOADS::$permissions['ismanager'] AND $_REQUEST['action'] != 'report')
{
	// Git oot.
	print_no_permissions();
}

// #############################################################################
if ($_REQUEST['action'] == 'modcp' OR empty($_REQUEST['action']))
{
	// Init this
	$moderation = array('reports' => '', 'modqueue' => '');
	
	// Whether at least one of the above array was set
	$hasOne = false;

	require_once (DIR . '/includes/class_bbcode.php');
	$parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());

	// Init this
	$downloadIds = $commentIds = array();

	// Grab list of moderated downloads
	$reportList = VBDOWNLOADS::$db->fetchAll('
		SELECT user.*, report.*
		FROM $dbtech_downloads_report AS report
		INNER JOIN $user AS user USING(userid)
	', array());
	foreach ($reportList as $report)
	{
		switch ($report['type'])
		{
			case 'comment':
				$commentIds[] = $report['targetid'];
				break;

			default:
				$downloadIds[] = $report['targetid'];
				break;
		}
	}

	if ($commentIds)
	{
		// Grab list of moderated comments
		$commentList = VBDOWNLOADS::$db->fetchAllKeyed('
			SELECT *
			FROM $dbtech_downloads_comment
			WHERE commentid :queryList
		', 'commentid', array(
			':queryList' => VBDOWNLOADS::$db->queryList($commentIds)
		));
		foreach ($commentList as $comment)
		{
			// We need this too
			$downloadIds[] = $comment['downloadid'];
		}
	}

	if ($downloadIds)
	{
		// Grab list of moderated downloads
		$downloadList = VBDOWNLOADS::$db->fetchAllKeyed('
			SELECT *
			FROM $dbtech_downloads_download
			WHERE downloadid :queryList
		', 'downloadid', array(
			':queryList' => VBDOWNLOADS::$db->queryList($downloadIds)
		));
	}

	foreach ($reportList as $report)
	{
		$continue = false;
		switch ($report['type'])
		{
			case 'comment':
				if (!isset($commentList[$report['targetid']]) OR !is_array($commentList[$report['targetid']]))
				{
					// Skip this
					VBDOWNLOADS::$db->delete('dbtech_downloads_report', array($report['reportid']), 'WHERE reportid = ?');
					$continue = true;
					break;
				}

				// Grab comment info
				$comment = $commentList[$report['targetid']];
				
				if (!isset($downloadList[$report['targetid']]) OR !is_array($downloadList[$report['targetid']]))
				{
					// Skip this
					VBDOWNLOADS::$db->delete('dbtech_downloads_report', array($report['reportid']), 'WHERE reportid = ?');
					$continue = true;
					break;
				}

				// Grab download info
				$download = $downloadList[$comment['downloadid']];

				// Fix description
				$comment['comment'] = $parser->parse($comment['comment'], 'nonforum', true, false);
				break;

			default:
				if (!isset($downloadList[$report['targetid']]) OR !is_array($downloadList[$report['targetid']]))
				{
					// Skip this
					VBDOWNLOADS::$db->delete('dbtech_downloads_report', array($report['reportid']), 'WHERE reportid = ?');
					$continue = true;
					break;
				}

				// Grab download info
				$download = $downloadList[$report['targetid']];
				break;
		}

		if ($continue)
		{
			// Broken report
			continue;
		}

		// We still have one
		$hasOne = true;

		// Sort date and time
		$report['date'] = vbdate($vbulletin->options['dateformat'], $report['dateline'], true);
		$report['time'] = vbdate($vbulletin->options['timeformat'], $report['dateline']);

		// Amazing hacks to get the reason from the prepared variables
		$report['reason'] = ${$report['type'] . 'ReportReasons'}[$report['reason']];

		// Grab markup username
		fetch_musername($report);

		// No hacsors here please
		$download['title'] = htmlspecialchars_uni($download['title']);

		// Display the download
		$templater = vB_Template::create('dbtech_downloads_modcp_report');
			$templater->register('download', 	$download);
			$templater->register('comment', 	$comment);
			$templater->register('report', 		$report);
		$moderation['reports'] .= $templater->render();
	}

	// Grab list of moderated downloads
	$downloadList = VBDOWNLOADS::$db->fetchAll('
		SELECT *
		FROM $dbtech_downloads_download
		WHERE moderation = 1
	', array());
	foreach ($downloadList as $download)
	{
		$hasOne = true;

		// No hacsors here please
		$download['title'] = htmlspecialchars_uni($download['title']);

		// Fix description
		$download['description'] = $parser->parse($download['description'], 'nonforum', true, false);

		// Display the download
		$templater = vB_Template::create('dbtech_downloads_modcp_moderation');
			$templater->register('download', 	$download);
		$moderation['modqueue'] .= $templater->render();
	}

	if (!$hasOne)
	{
		// We need at least one type of moderation
		standard_error(fetch_error('no_results_matched_your_query'));
	}

	// Add to the navbits
	$navbits[''] = $pagetitle = $vbphrase['dbtech_downloads_modcp'];

	// Advanced search
	$page_templater = vB_Template::create('dbtech_downloads_modcp');
		$page_templater->register('pagetitle', 	$pagetitle);
		$page_templater->register('moderation', $moderation);
	$HTML = $page_templater->render();
}

// #############################################################################
if ($_POST['action'] == 'updatereports')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'modaction' 		=> TYPE_ARRAY,
	));

	$reportIds = array();
	foreach ($vbulletin->GPC['modaction'] as $type => $actions)
	{
		foreach ($actions as $reportid => $action)
		{
			if (!$action)
			{
				// No action
				continue;
			}

			if ($action == 1)
			{
				// Dismiss report
				VBDOWNLOADS::$db->delete('dbtech_downloads_report', array($reportid), 'WHERE reportid = ?');
				continue;
			}

			// Add this to the download query
			$reportIds[] = $reportid;			
		}
	}

	if (!$reportIds)
	{
		// We need at least one type of moderation
		$vbulletin->url = $vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modcp';
		eval(print_standard_redirect('redirect_dbtech_downloads_reports_handled'));
	}

	// Init this
	$downloadIds = $commentIds = array();

	// Grab list of moderated downloads
	$reportList = VBDOWNLOADS::$db->fetchAll('
		SELECT *
		FROM $dbtech_downloads_report
		WHERE reportid :queryList
	', array(
		':queryList' => VBDOWNLOADS::$db->queryList($reportIds)
	));
	foreach ($reportList as $report)
	{
		switch ($report['type'])
		{
			case 'comment':
				$commentIds[] = $report['targetid'];
				break;

			default:
				$downloadIds[] = $report['targetid'];
				break;
		}
	}

	if ($commentIds)
	{
		// Grab list of moderated comments
		$commentList = VBDOWNLOADS::$db->fetchAllKeyed('
			SELECT *
			FROM $dbtech_downloads_comment
			WHERE commentid :queryList
		', 'commentid', array(
			':queryList' => VBDOWNLOADS::$db->queryList($commentIds)
		));
		foreach ($commentList as $comment)
		{
			// We need this too
			$downloadIds[] = $comment['downloadid'];
		}
	}

	if ($downloadIds)
	{
		// Grab list of moderated downloads
		$downloadList = VBDOWNLOADS::$db->fetchAllKeyed('
			SELECT *
			FROM $dbtech_downloads_download
			WHERE downloadid :queryList
		', 'downloadid', array(
			':queryList' => VBDOWNLOADS::$db->queryList($downloadIds)
		));
	}

	foreach ($reportList as $report)
	{
		switch ($report['type'])
		{
			case 'comment':
				if (!isset($commentList[$report['targetid']]) OR !is_array($commentList[$report['targetid']]))
				{
					// Skip this
					break;
				}

				// init data manager
				$dm =& VBDOWNLOADS::initDataManager('Comment', $vbulletin, ERRTYPE_SILENT);
					$dm->set_existing($commentList[$report['targetid']]);
				$dm->delete();
				unset($dm);
				break;

			default:
				if (!isset($downloadList[$report['targetid']]) OR !is_array($downloadList[$report['targetid']]))
				{
					// Skip this
					break;
				}

				// init data manager
				$dm =& VBDOWNLOADS::initDataManager('Download', $vbulletin, ERRTYPE_SILENT);
					$dm->set_existing($downloadList[$report['targetid']]);
				$dm->delete();
				unset($dm);
				break;
		}
	}

	$vbulletin->url = $vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modcp';
	eval(print_standard_redirect('redirect_dbtech_downloads_reports_handled'));
}

// #############################################################################
if ($_POST['action'] == 'updatemoderation')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'modaction' => TYPE_ARRAY_UINT,
	));

	$downloadIds = array();
	foreach ($vbulletin->GPC['modaction'] as $downloadid => $action)
	{
		if (!$action)
		{
			// No action
			continue;
		}

		// Add this to the download query
		$downloadIds[] = $downloadid;
	}

	if (!$downloadIds)
	{
		// We need at least one type of moderation
		$vbulletin->url = $vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modcp';
		eval(print_standard_redirect('redirect_dbtech_downloads_reports_handled'));
	}

	// Grab list of moderated downloads
	$downloadList = VBDOWNLOADS::$db->fetchAll('
		SELECT *
		FROM $dbtech_downloads_download
		WHERE downloadid :queryList
	', array(
		':queryList' => VBDOWNLOADS::$db->queryList($downloadIds)
	));
	foreach ($downloadList as $download)
	{
		// init data manager
		$dm =& VBDOWNLOADS::initDataManager('Download', $vbulletin, ERRTYPE_SILENT);
			$dm->set_existing($download);

		if ($vbulletin->GPC['modaction'][$download['downloadid']] == 2)
		{
			// Deny
			$dm->delete();
		}
		else
		{
			// Allow
			$moderation = 0;
			$dm->set('moderation', $moderation);
			$dm->save();
		}

		// Done
		unset($dm);
	}

	$vbulletin->url = $vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modcp';
	eval(print_standard_redirect('redirect_dbtech_downloads_moderation_handled'));
}

// #############################################################################
if ($_POST['action'] == 'report')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'type' 			=> TYPE_STR,
		'contentid' 	=> TYPE_UINT,
		'reason' 		=> TYPE_UINT,
		'downloadid' 	=> TYPE_UINT,
	));

	// Insert new favourites
	VBDOWNLOADS::$db->insert('dbtech_downloads_report', array(
		'type' => $vbulletin->GPC['type'], 
		'userid' => $vbulletin->userinfo['userid'],
		'targetid' => $vbulletin->GPC['contentid'],
		'reason' => $vbulletin->GPC['reason'],
		'dateline' => TIMENOW,
	));

	if ($vbulletin->GPC['type'] == 'comment')
	{
		// Override this
		$vbulletin->GPC['contentid'] = VBDOWNLOADS::$db->fetchOne('SELECT downloadid FROM $dbtech_downloads_comment WHERE commentid = ?', array($vbulletin->GPC['contentid']));
	}

	$vbulletin->url = $vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=download&amp;downloadid=' . $vbulletin->GPC['contentid'];
	eval(print_standard_redirect('redirect_dbtech_downloads_report_sent', true, true));
}

?>