<?php

// Init this
$HTML = '';

// #############################################################################
if ($_REQUEST['action'] == 'download' OR empty($_REQUEST['action']))
{
	if ($vbulletin->userinfo['posts'] < $vbulletin->options['dbtech_downloads_min_posts'])
	{
		// Lacking necessary post count
		standard_error(construct_phrase($vbphrase['dbtech_downloads_you_need_x_posts_to_download'], $vbulletin->options['dbtech_downloads_min_posts']));
	}

	$vbulletin->input->clean_gpc('r', 'fileid', TYPE_UINT);

	$file = VBDOWNLOADS::$db->fetchRow('
		SELECT download.*, file.*
		FROM $dbtech_downloads_file AS file
		INNER JOIN $dbtech_downloads_download AS download USING(downloadid)
		WHERE fileid = ?
	', array(
		$vbulletin->GPC['fileid'],
	));

	if ($file['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
	{
		// File is under moderation
		standard_error(fetch_error('dbtech_downloads_file_being_reviewed'));
	}

	$file['private'] = @unserialize($file['private']);
	if (
		is_array($file['private']) AND
		count($file['private']) AND
		!VBDOWNLOADS::$permissions['ismanager'] AND 
		!in_array($vbulletin->userinfo['userid'], $file['private']) AND 
		$file['userid'] != $vbulletin->userinfo['userid']
	)
	{
		// Private screenshot and we're not authorised to view it
		standard_error(fetch_error('dbtech_downloads_private_file_error'));
	}

	if (in_array($file['categoryid'], $_excludeCategories))
	{
		// Can't view category
		print_no_permission();
	}

	if (!$category = VBDOWNLOADS::$cache['category'][$file['categoryid']])
	{
		// Invalid category
		standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $file['categoryid']));
	}

	// Update cookie if we have one
	$vbulletin->input->clean_array_gpc('c', array(
		COOKIE_PREFIX . 'downloadpass_' . $file['downloadid'] => TYPE_STR,
	));

	if (
		$file['password'] AND 
		!VBDOWNLOADS::$permissions['ismanager'] AND 
		$file['userid'] != $vbulletin->userinfo['userid'] AND 
		md5($file['password'] . COOKIE_SALT) != $vbulletin->GPC[COOKIE_PREFIX . 'downloadpass_' . $file['downloadid']]
	)
	{
		// We're missing password
		standard_error(fetch_error('dbtech_downloads_private_file_error'));
	}

	

	if (!$HTML)
	{
		// Finally grab file info
		$fileinfo = pathinfo($file['filename']);

		$fileExtension = array();
		foreach (VBDOWNLOADS::$cache['extension'] as $extension)
		{
			if ($extension['extension'] == $fileinfo['extension'])
			{
				// This is the extension we are looking for
				$fileExtension = $extension;
				break;
			}
		}

		if (empty($fileExtension))
		{
			standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_extension'], $fileinfo['extension']));
		}

		// Update the download
		$dm =& VBDOWNLOADS::initDataManager('Download', $vbulletin, ERRTYPE_SILENT);
			$dm->set_existing($file);
			$dm->set('totaldownloads', 'totaldownloads + 1', false);
		$dm->save();

		// Update the file
		$dm =& VBDOWNLOADS::initDataManager('File', $vbulletin, ERRTYPE_SILENT);
			$dm->set_existing($file);
			$dm->set('downloads', 'downloads + 1', false);
		$dm->save();

		// Increment downloads per day and download size today
		VBDOWNLOADS::$db->query('
			UPDATE $user
			SET 
				dbtech_downloads_downloads_today = dbtech_downloads_downloads_today + 1,
				dbtech_downloads_download_size_today = dbtech_downloads_download_size_today + ?
			WHERE userid = ?
		', array(
			$file['downloadid'],
			$file['filesize']
		));

		// Add to download log
		VBDOWNLOADS::$db->insert('dbtech_downloads_downloadlog', array(
			'userid' 		=> $vbulletin->userinfo['userid'],
			'fileid' 		=> $file['fileid'],
			'downloadid' 	=> $file['downloadid'],
			'ipaddress' 	=> IPADDRESS,
			'dateline' 		=> TIMENOW,
			'filesize' 		=> $file['filesize']
		));

		// Now finally download the file
		require_once(DIR . '/includes/functions_file.php');
		file_download(file_get_contents($file['filepath'] . $file['filename']), $file['filename'], $fileExtension['mime']);
		die();
	}
}



// #############################################################################
if ($_REQUEST['action'] == 'screenshot')
{
	$vbulletin->input->clean_gpc('r', 'screenshotid', TYPE_UINT);

	$file = VBDOWNLOADS::$db->fetchRow('
		SELECT download.*, file.*
		FROM $dbtech_downloads_file AS file
		INNER JOIN $dbtech_downloads_download AS download USING(downloadid)
		WHERE file.fileid = ?
			AND file.image = ?
			AND file.screenshot = ?
	', array(
		$vbulletin->GPC['screenshotid'],
		1,
		1
	));

	// Default image info
	$imageinfo = array(
		'extension' => 'png',
		'filename' => 'noimage',
		'path' => 'dbtech/downloads/images',
	);

	do
	{
		if (!$file)
		{
			// Couldn't find it
			break;
		}

		if ($file['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
		{
			// File is under moderation
			break;
		}

		$file['private'] = @unserialize($file['private']);
		if (
			is_array($file['private']) AND
			count($file['private']) AND
			!VBDOWNLOADS::$permissions['ismanager'] AND 
			!in_array($vbulletin->userinfo['userid'], $file['private']) AND 
			$file['userid'] != $vbulletin->userinfo['userid']
		)
		{
			// Private screenshot and we're not authorised to view it
			break;
		}

		if (in_array($file['categoryid'], $_excludeCategories))
		{
			// Can't view category
			break;
		}

		if (!$category = VBDOWNLOADS::$cache['category'][$file['categoryid']])
		{
			// Invalid category
			break;
		}

		// Update cookie if we have one
		$vbulletin->input->clean_array_gpc('c', array(
			COOKIE_PREFIX . 'downloadpass_' . $file['downloadid'] => TYPE_STR,
		));

		if (
			$file['password'] AND 
			!VBDOWNLOADS::$permissions['ismanager'] AND 
			$file['userid'] != $vbulletin->userinfo['userid'] AND 
			md5($file['password'] . COOKIE_SALT) != $vbulletin->GPC[COOKIE_PREFIX . 'downloadpass_' . $file['downloadid']]
		)
		{
			// We're missing password
			break;
		}

		// Ensure filepath is set
		if ($file['filepath'])
		{
			$file['filepath'] = $file['filepath'] . '/';
		}
		else
		{
			$file['filepath'] = $vbulletin->options['dbtech_downloads_path_to_downloads'] . '/';
			$file['filename'] = $file['fileid'] . '-' . $file['filename'];
		}

		// We found the screenshot
		$imageinfo = pathinfo($file['filename']);
		$imageinfo['path'] = $file['filepath'];
	}
	while (false);
}

// #############################################################################
if ($_REQUEST['action'] == 'thumbnail')
{
	$vbulletin->input->clean_gpc('r', 'downloadid', TYPE_UINT);

	$fileList = VBDOWNLOADS::$db->fetchAll('
		SELECT download.*, file.*
		FROM $dbtech_downloads_file AS file
		INNER JOIN $dbtech_downloads_download AS download USING(downloadid)
		WHERE file.downloadid = ?
	', array(
		$vbulletin->GPC['downloadid'],
	));

	// Default image info
	$imageinfo = array(
		'extension' => 'png',
		'filename' => 'noimage',
		'path' => 'dbtech/downloads/images',
	);

	do
	{
		// First do permission checks
		foreach ($fileList as $file)
		{
			if (!$file)
			{
				// Couldn't find it
				break 2;
			}

			if ($file['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
			{
				// File is under moderation
				break 2;
			}

			$file['private'] = @unserialize($file['private']);
			if (
				is_array($file['private']) AND
				count($file['private']) AND
				!VBDOWNLOADS::$permissions['ismanager'] AND 
				!in_array($vbulletin->userinfo['userid'], $file['private']) AND 
				$file['userid'] != $vbulletin->userinfo['userid']
			)
			{
				// Private screenshot and we're not authorised to view it
				break 2;
			}

			if (in_array($file['categoryid'], $_excludeCategories))
			{
				// Can't view category
				break 2;
			}

			if (!$category = VBDOWNLOADS::$cache['category'][$file['categoryid']])
			{
				// Invalid category
				break 2;
			}

			// Update cookie if we have one
			$vbulletin->input->clean_array_gpc('c', array(
				COOKIE_PREFIX . 'downloadpass_' . $file['downloadid'] => TYPE_STR,
			));

			if (
				$file['password'] AND 
				!VBDOWNLOADS::$permissions['ismanager'] AND 
				$file['userid'] != $vbulletin->userinfo['userid'] AND 
				md5($file['password'] . COOKIE_SALT) != $vbulletin->GPC[COOKIE_PREFIX . 'downloadpass_' . $file['downloadid']]
			)
			{
				// We're missing password
				break 2;
			}
		}

		// First check for screenshot		
		foreach ($fileList as $file)
		{
			// Ensure filepath is set
			if ($file['filepath'])
			{
				$file['filepath'] = $file['filepath'] . '/';
			}
			else
			{
				$file['filepath'] = $vbulletin->options['dbtech_downloads_path_to_downloads'] . '/';
				$file['filename'] = $file['fileid'] . '-' . $file['filename'];
			}

			if ($file['image'] AND $file['screenshot'])
			{				
				// Lucky
				$imageinfo = pathinfo($file['filename']);
				$imageinfo['path'] = $file['filepath'];
				break 2;
			}
		}

		// Then check for image
		foreach ($fileList as $file)
		{
			// Ensure filepath is set
			if ($file['filepath'])
			{
				$file['filepath'] = $file['filepath'] . '/';
			}
			else
			{
				$file['filepath'] = $vbulletin->options['dbtech_downloads_path_to_downloads'] . '/';
				$file['filename'] = $file['fileid'] . '-' . $file['filename'];
			}

			if ($file['image'] AND !$file['screenshot'])
			{
				// Lucky
				$imageinfo = pathinfo($file['filename']);
				$imageinfo['path'] = $file['filepath'];
				break 2;
			}
		}
	}
	while (false);
}

// #############################################################################
if (in_array($_REQUEST['action'], array('screenshot', 'thumbnail')))
{
	//run any registered shutdown functions
	if (intval($vbulletin->versionnumber) > 3)
	{
		$GLOBALS['vbulletin']->shutdown->shutdown();
	}
	if (defined('NOSHUTDOWNFUNC'))
	{
		if ($full_shutdown)
		{
			exec_shut_down();
		}
		else
		{
			$vbulletin->db->close();
		}
	}

	if (!isset($imageinfo) OR !is_array($imageinfo))
	{
		// Unknown error, die silently
		die();
	}

	if (!$_REQUEST['debug'])
	{
	header('Pragma:'); // VBIV-8269 
	header('Cache-control: max-age=31536000');
	header('Expires: ' . gmdate('D, d M Y H:i:s', (time() + 31536000)) . ' GMT');
	header('Content-disposition: inline; filename=' . $imageinfo['filename'] . '.' . $imageinfo['extension']);
	header('Content-transfer-encoding: binary');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s', time()) . ' GMT');
	switch ($imageinfo['extension'])
	{
		case 'jpg':
		case 'jpeg':
			header('Content-type: image/jpeg');
			break;

		case 'png':
			header('Content-type: image/png');
			break;

		case 'gif':
			header('Content-type: image/gif');
			break;

		default:
			header('Content-Length: ' . filesize('clear.gif'));
			header('Content-type: image/gif');
			echo readfile('clear.gif');
			die();

			break;
	}
	header('Content-Length: ' . filesize($imageinfo['path'] . '/' . $imageinfo['filename'] . '.' . $imageinfo['extension']));
	}
	echo readfile($imageinfo['path'] . '/' . $imageinfo['filename'] . '.' . $imageinfo['extension']);

	die();
}

// #############################################################################
if ($_REQUEST['action'] == 'handler')
{
	$vbulletin->input->clean_gpc('r', 'downloadid', TYPE_UINT);

	if (substr($vbulletin->options['dbtech_downloads_path_to_downloads'], 0, 2) == './')
	{
		// Prepare this
		$vbulletin->options['dbtech_downloads_path_to_downloads'] = str_replace('./', DIR . '/', $vbulletin->options['dbtech_downloads_path_to_downloads']);
	}

	$extensions = array();
	foreach (VBDOWNLOADS::$cache['extension'] as $extension)
	{
		// Add to allowed extensions
		$extensions[] = $extension['extension'];
	}

	require_once(DIR . '/dbtech/downloads/includes/class_uploadhandler.php');
	$upload_handler = new UploadHandler(array(
		'script_url' => $vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=file&action=handler&downloadid=' . $vbulletin->GPC['downloadid'],
		'upload_dir' => $vbulletin->options['dbtech_downloads_path_to_downloads'] . '/',
		'mkdir_mode' => 0755, // Replace this with a setting
		'accept_file_types' => '/.(' . implode('|', $extensions) . ')$/i',	// Defines which files (based on their names) are accepted for upload
		'max_number_of_files' => $vbulletin->options['dbtech_downloads_max_downloads'],
	));

	//run any registered shutdown functions
	if (intval($vbulletin->versionnumber) > 3)
	{
		$GLOBALS['vbulletin']->shutdown->shutdown();
	}
	if (defined('NOSHUTDOWNFUNC'))
	{
		if ($full_shutdown)
		{
			exec_shut_down();
		}
		else
		{
			$vbulletin->db->close();
		}
	}

	die();
}


// #############################################################################
if ($_REQUEST['action'] == 'mirror')
{
	$vbulletin->input->clean_gpc('r', 'downloadid', TYPE_UINT);
	$vbulletin->input->clean_gpc('r', 'mirrorid', TYPE_UINT);

	if ($vbulletin->userinfo['posts'] < $vbulletin->options['dbtech_downloads_min_posts'])
	{
		// Lacking necessary post count
		standard_error(construct_phrase($vbphrase['dbtech_downloads_you_need_x_posts_to_download'], $vbulletin->options['dbtech_downloads_min_posts']));
	}

	$download = VBDOWNLOADS::$db->fetchRow('
		SELECT *
		FROM $dbtech_downloads_download
		WHERE downloadid = ?
	', array(
		$vbulletin->GPC['downloadid'],
	));

	if ($download['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
	{
		// File is under moderation
		standard_error(fetch_error('dbtech_downloads_file_being_reviewed'));
	}

	$download['private'] = @unserialize($download['private']);
	if (
		is_array($download['private']) AND
		count($download['private']) AND
		!VBDOWNLOADS::$permissions['ismanager'] AND 
		!in_array($vbulletin->userinfo['userid'], $download['private']) AND 
		$download['userid'] != $vbulletin->userinfo['userid']
	)
	{
		// Private screenshot and we're not authorised to view it
		standard_error(fetch_error('dbtech_downloads_private_file_error'));
	}

	if (in_array($download['categoryid'], $_excludeCategories))
	{
		// Can't view category
		print_no_permission();
	}

	if (!$category = VBDOWNLOADS::$cache['category'][$download['categoryid']])
	{
		// Invalid category
		standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $download['categoryid']));
	}

	// Update cookie if we have one
	$vbulletin->input->clean_array_gpc('c', array(
		COOKIE_PREFIX . 'downloadpass_' . $download['downloadid'] => TYPE_STR,
	));

	if (
		$download['password'] AND 
		!VBDOWNLOADS::$permissions['ismanager'] AND 
		$download['userid'] != $vbulletin->userinfo['userid'] AND 
		md5($download['password'] . COOKIE_SALT) != $vbulletin->GPC[COOKIE_PREFIX . 'downloadpass_' . $download['downloadid']]
	)
	{
		// We're missing password
		standard_error(fetch_error('dbtech_downloads_private_file_error'));
	}

	// Ensure we can't have 0
	$vbulletin->GPC['mirrorid'] = $vbulletin->GPC['mirrorid'] ? $vbulletin->GPC['mirrorid'] : 1;

	$i = 1;
	$mirrorList = @unserialize($download['mirrors']);
	$mirrorList = is_array($mirrorList) ? $mirrorList : array();

	if (!isset($mirrorList[$vbulletin->GPC['mirrorid'] - 1]))
	{
		// @TODO: REAL ERROR
		standard_error(fetch_error('dbtech_downloads_private_file_error'));
	}

	// Shorthand
	$mirror =& $mirrorList[$vbulletin->GPC['mirrorid'] - 1];

	if (!is_array($mirrorList[$vbulletin->GPC['mirrorid'] - 1]))
	{
		// Convert to new format
		foreach ($mirrorList as &$file)
		{
			if (!is_array($file))
			{
				$file = array(
					'link' => $file,
					'hits' => 0,
				);
			}
		}
	}

	// Increment hits counter
	$mirror['hits']++;

	// Update the download
	$dm =& VBDOWNLOADS::initDataManager('Download', $vbulletin, ERRTYPE_SILENT);
		$dm->set_existing($download);
		$dm->set('mirrors', $mirrorList);
	$dm->save();

	//run any registered shutdown functions
	if (intval($vbulletin->versionnumber) > 3)
	{
		$GLOBALS['vbulletin']->shutdown->shutdown();
	}
	if (defined('NOSHUTDOWNFUNC'))
	{
		if ($full_shutdown)
		{
			exec_shut_down();
		}
		else
		{
			$vbulletin->db->close();
		}
	}

	// Redirect to the actual mirror url
	header('Location: ' . $mirror['link']);
	die();
}

?>