<?php
if (!$vbulletin->options['dbtech_downloads_favourites'])
{
	// Favourite system disabled
	standard_error(fetch_error('dbtech_downloads_favourite_disabled'));
}

// #############################################################################
if ($_REQUEST['action'] == 'favourites' OR empty($_REQUEST['action']))
{
	$vbulletin->input->clean_array_gpc('r', array(
		'pagenumber'  	=> TYPE_UINT,
		'perpage'     	=> TYPE_UINT,
	));

	if (!$count = VBDOWNLOADS::$db->fetchOne('
		SELECT COUNT(*)
		FROM $dbtech_downloads_download AS download
		WHERE download.downloadid IN(
			SELECT downloadid FROM $dbtech_downloads_favourite
			WHERE userid = ?
		)
			AND download.categoryid NOT :queryList
			AND download.moderation = 0
	', array(
		$vbulletin->userinfo['userid'],
		':queryList' => VBDOWNLOADS::$db->queryList($_excludeCategories)
	)))
	{
		// We need at least one limiter
		standard_error(fetch_error('no_results_matched_your_query'));
	}

	// Ensure every result is as it should be
	sanitize_pageresults($count, $pagenumber, $perpage);

	$startat = ($pagenumber - 1) * $perpage;

	// Constructs the page navigation
	$pagenav = construct_page_nav(
		$pagenumber,
		$perpage,
		$count,
		$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . "do=favourites",
		"&amp;perpage=$perpage"
	);

	if (!$results = VBDOWNLOADS::$db->fetchAll('
		SELECT download.*, user.*
		FROM $dbtech_downloads_download AS download
		INNER JOIN $user AS user USING(userid)
		WHERE download.downloadid IN(
			SELECT downloadid FROM $dbtech_downloads_favourite
			WHERE userid = ?
		)
			AND download.categoryid NOT :queryList
			AND download.moderation = 0
		ORDER BY download.updated DESC
		LIMIT :limitStart, :limitEnd
	', array(
		$vbulletin->userinfo['userid'],
		':queryList' => VBDOWNLOADS::$db->queryList($_excludeCategories),
		':limitStart' => $startat,
		':limitEnd' => $perpage
	)))
	{
		// We need at least one limiter
		standard_error(fetch_error('no_results_matched_your_query'));
	}

	require_once (DIR . '/includes/class_bbcode.php');
	$parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());

	$downloads = '';
	foreach ($results as $download)
	{
		// No hacsors here please
		$download['title'] = htmlspecialchars_uni($download['title']);

		// Fix date
		$download['date'] = vbdate($vbulletin->options['dateformat'], $download['updated'], true);
		$download['time'] = vbdate($vbulletin->options['timeformat'], $download['updated']);
		
		// Grab markup username
		$download['musername'] = fetch_musername($download);

		if (strlen($download['description']) > $vbulletin->options['dbtech_downloads_previewlength'])
		{
			// Shorten the description
			$download['description'] = substr($download['description'], 0, $vbulletin->options['dbtech_downloads_previewlength']) . '...';
		}

		// Fix description
		$download['description'] = $parser->parse($download['description'], 'nonforum', true, false);

		// Fix numbers
		$download['numfiles'] = vb_number_format($download['numfiles'], 0);
		$download['totaldownloads'] = vb_number_format($download['totaldownloads'], 0);

		// Advanced search
		$templater = vB_Template::create('dbtech_downloads_searchresults_bit');
			$templater->register('download', 	$download);
		$downloads .= $templater->render();
	}

	// Add to the navbits
	$navbits[''] = $pagetitle = $vbphrase['dbtech_downloads_favourites'];

	// Advanced search
	$page_templater = vB_Template::create('dbtech_downloads_searchresults');
		$page_templater->register('pagetitle', 	$pagetitle);
		$page_templater->register('downloads', 	$downloads);
		$page_templater->register('pagenav', 	$pagenav);
	$HTML = $page_templater->render();
}

?>