<?php

// #############################################################################
if ($_REQUEST['action'] == 'download' OR empty($_REQUEST['action']))
{
	$vbulletin->input->clean_gpc('r', 'downloadid', TYPE_UINT);
	$vbulletin->input->clean_gpc('r', 'fileid', TYPE_UINT);

	if ($vbulletin->GPC['fileid'] AND !$vbulletin->GPC['downloadid'])
	{
		// Override to support old links
		$vbulletin->GPC['downloadid'] = $vbulletin->GPC['fileid'];
	}

	$download = VBDOWNLOADS::$db->fetchRow('
		SELECT
			user.*,
			download.*
		FROM $dbtech_downloads_download AS download
		INNER JOIN $user AS user USING(userid)
		WHERE downloadid = ?
	', array(
		$vbulletin->GPC['downloadid'],
	));

	// No hacsors here please
	$download['title'] = htmlspecialchars_uni($download['title']);	

	if ($download['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
	{
		// File is under moderation
		standard_error(fetch_error('dbtech_downloads_file_being_reviewed'));
	}

	$download['private'] = @unserialize($download['private']);
	if (
		!is_array($download['private']) OR 
		!count($download['private']) OR 
		VBDOWNLOADS::$permissions['ismanager'] OR 
		(
			in_array($vbulletin->userinfo['userid'], $download['private']) AND
			$vbulletin->userinfo['userid']
		) OR
		(
			$download['userid'] == $vbulletin->userinfo['userid'] AND
			$vbulletin->userinfo['userid']
		)
	)
	{
		// Grab musername
		$download['musername'] = fetch_musername($download);
		
		// Sort date and time
		$download['date'] = vbdate($vbulletin->options['dateformat'], $download['updated'], true);
		$download['time'] = vbdate($vbulletin->options['timeformat'], $download['updated']);
	}
	else
	{
		// Private download
		standard_error(fetch_error('dbtech_downloads_private_file_error'));
	}

	if (in_array($download['categoryid'], $_excludeCategories))
	{
		// Can't view category
		print_no_permission();
	}

	if (!$category = VBDOWNLOADS::$cache['category'][$download['categoryid']])
	{
		// Invalid category
		standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $download['categoryid']));
	}

	if ($category['parentid'])
	{
		// Store immediate category
		$parentCategory = VBDOWNLOADS::$cache['category'][$category['parentid']];

		do
		{
			// Add to the navbits
			$navbits[$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'categoryid=' . $parentCategory['categoryid']] = $parentCategory['title'];

			if (isset(VBDOWNLOADS::$cache['category'][$parentCategory['parentid']]))
			{
				// Store -its-
				$parentCategory = VBDOWNLOADS::$cache['category'][$parentCategory['parentid']];
			}
		}
		while (isset(VBDOWNLOADS::$cache['category'][$parentCategory['parentid']]));
	}

	// Add to the navbits
	$navbits[$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'categoryid=' . $category['categoryid']] = $category['title'];
	$navbits[''] = $pagetitle = $download['title'];

	// Update cookie if we have one
	$vbulletin->input->clean_array_gpc('c', array(
		COOKIE_PREFIX . 'downloadpass_' . $download['downloadid'] => TYPE_STR,
	));

	if (
		$download['password'] AND 
		!VBDOWNLOADS::$permissions['ismanager'] AND 
		$download['userid'] != $vbulletin->userinfo['userid'] AND 
		md5($download['password'] . COOKIE_SALT) != $vbulletin->GPC[COOKIE_PREFIX . 'downloadpass_' . $download['downloadid']]
	)
	{
		// We need to confirm password
		$page_templater = vB_Template::create('dbtech_downloads_download_password');
			$page_templater->register('pagetitle', 	$pagetitle);
			$page_templater->register('download', 	$download);
		$HTML = $page_templater->render();
	}
	else
	{
		// Grab our permissions
		$permissions = VBDOWNLOADS::fetchPermissions($download, $category);

		if (!$permissions['canview'])
		{
			// We can't view
			print_no_permission();
		}

		if ($vbulletin->userinfo['dbtech_downloads_favourites'])
		{
			// Legacy code
			$favourites = @unserialize($vbulletin->userinfo['dbtech_downloads_favourites']);
			foreach ((array)$favourites as $downloadid)
			{
				// Insert new favourites
				VBDOWNLOADS::$db->insert('dbtech_downloads_favourite', array('userid' => $vbulletin->userinfo['userid'], 'downloadid' => $downloadid));
			}

			// Update old favourites
			VBDOWNLOADS::$db->update('user', array('dbtech_downloads_favourites' => ''), 'WHERE userid = ' . $vbulletin->userinfo['userid']);
		}

		$isFavourite = VBDOWNLOADS::$db->fetchRow('
			SELECT * FROM $dbtech_downloads_favourite
			WHERE userid = ?
				AND downloadid = ?
		', array(
			$vbulletin->userinfo['userid'],
			$download['downloadid'],
		));
		$show['is_favourite'] = ($isFavourite !== false AND count($isFavourite));

		// We either don't need a password or we're all good
		require_once (DIR . '/includes/class_bbcode.php');
		$parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());

		// Fix description
		$download['description'] = $parser->parse($download['description'], 'nonforum', true, false);

		

		$fileList = VBDOWNLOADS::$db->fetchAll('
			SELECT *
			FROM $dbtech_downloads_file
			WHERE downloadid = ?
		', array(
			$vbulletin->GPC['downloadid'],
		));

		// Init these
		$download['fileList'] = $download['mirrorList'] = $download['screenshotList'] = $download['moreList'] = '';

		foreach ($fileList as $file)
		{
			if ($file['screenshot'])
			{
				// This was a screenshot
				$templater = vB_Template::create('dbtech_downloads_download_screenshotbit');
					$templater->register('file', $file);
				$download['screenshotList'] .= $templater->render();
				continue;
			}

			// Do file size
			$file['filesize'] = vb_number_format($file['filesize'], 2, true);

			// Regular file
			$templater = vB_Template::create('dbtech_downloads_download_filebit');
				$templater->register('file', 		$file);
				$templater->register('permissions', $permissions);
			$download['fileList'] .= $templater->render();
		}

		$moreList = VBDOWNLOADS::$db->fetchAll('
			SELECT *
			FROM $dbtech_downloads_download
			WHERE downloadid != ?
				AND userid = ?
				AND moderation = 0				
			ORDER BY RAND()
			LIMIT 5
		', array(
			$download['downloadid'],
			$download['userid']
		));
		foreach ($moreList as $file)
		{
			// No hacsors please
			$file['title'] = htmlspecialchars_uni($file['title']);

			// Add this download
			$templater = vB_Template::create('dbtech_downloads_download_morebit');
				$templater->register('download', $file);
			$download['moreList'] .= $templater->render();
		}

		

		$i = 1;
		$mirrorList = @unserialize($download['mirrors']);
		$mirrorList = is_array($mirrorList) ? $mirrorList : array();
		foreach ($mirrorList as $file)
		{
			if (!is_array($file))
			{
				$file = array(
					'link' => $file,
					'hits' => 0,
				);
			}

			if ($file['link'] == 'http://')
			{
				// Skip this
				continue;
			}

			

			// Format the hit counter
			$file['hits'] = vb_number_format($file['hits']);

			// Add this download
			$templater = vB_Template::create('dbtech_downloads_download_mirrorbit');
				$templater->register('i', $i++);
				$templater->register('mirror', $file);
				$templater->register('download', $download);
			$download['mirrorList'] .= $templater->render();
		}

		if (($download['userid'] == $vbulletin->userinfo['userid'] AND $vbulletin->userinfo['userid']) OR VBDOWNLOADS::$permissions['ismanager'])
		{
			// We can manage screenshots and the file itself
			$show['screenshot'] = $show['edit_file'] = $show['delete_file'] = true;
		}

		// Init this
		$download['comments'] = '';

		// Display file list
		do
		{
			if (!$count = VBDOWNLOADS::$db->fetchOne('
				SELECT COUNT(*)
				FROM $dbtech_downloads_comment
				WHERE downloadid = ?
			', array(
				$download['downloadid']
			)))
			{
				// We need at least one file
				break;
			}

			$vbulletin->input->clean_array_gpc('r', array(
				'pagenumber'  	=> TYPE_UINT,
				'perpage'     	=> TYPE_UINT,
			));

			// Ensure there's no errors or out of bounds with the page variables
			if ($vbulletin->GPC['pagenumber'] < 1)
			{
				$vbulletin->GPC['pagenumber'] = 1;
			}
			$pagenumber = $vbulletin->GPC['pagenumber'];
			$perpage = (!$vbulletin->GPC['perpage'] OR $vbulletin->GPC['perpage'] > 25) ? 25 : $vbulletin->GPC['perpage'];

			// Ensure every result is as it should be
			sanitize_pageresults($count, $pagenumber, $perpage);

			$startat = ($pagenumber - 1) * $perpage;

			// Constructs the page navigation
			$pagenav = construct_page_nav(
				$pagenumber,
				$perpage,
				$count,
				$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . "do=download",
				"&amp;perpage=$perpage&amp;tab=comments&amp;downloadid=" . $download['downloadid']
			);

			if (!$results = VBDOWNLOADS::$db->fetchAll('
				SELECT user.*, comment.*
				' . ($vbulletin->options['avatarenabled'] ? ', avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, customavatar.height_thumb AS avheight_thumb, customavatar.width_thumb AS avwidth_thumb, customavatar.filedata_thumb' : '') . '
				FROM $dbtech_downloads_comment AS comment
				INNER JOIN $user AS user USING(userid)
				' . ($vbulletin->options['avatarenabled'] ? "
				LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = user.avatarid)
				LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = user.userid)
				" : '') . '
				WHERE comment.downloadid = ?
				ORDER BY comment.dateline DESC
				LIMIT :limitStart, :limitEnd
			', array(
				':limitStart' => $startat,
				':limitEnd' => $perpage,
				$download['downloadid']
			)))
			{
				// We need at least one limiter
				break;
			}

			require_once (DIR . '/includes/class_bbcode.php');
			$parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());

			if (!function_exists('fetch_avatar_from_userinfo'))
			{
				// Get the avatar function
				require_once(DIR . '/includes/functions_user.php');
			}

			$comments = '';
			foreach ($results as $comment)
			{
				// Fix date
				$comment['date'] = vbdate($vbulletin->options['dateformat'], $comment['dateline'], true);
				$comment['time'] = vbdate($vbulletin->options['timeformat'], $comment['dateline']);
				
				// Grab markup username
				$comment['musername'] = fetch_musername($comment);

				// Fix description
				$comment['comment'] = $parser->parse($comment['comment'], 'nonforum', true, false);

				// grab avatar from userinfo
				fetch_avatar_from_userinfo($comment);

				// Set delete permissions
				$comment['canmanage'] = (($comment['userid'] == $vbulletin->userinfo['userid'] AND $vbulletin->userinfo['userid']) OR VBDOWNLOADS::$permissions['ismanager']);

				// Advanced search
				$templater = vB_Template::create('dbtech_downloads_comment_bit');
					$templater->register('comment', 	$comment);
				$comments .= $templater->render();
			}

			// Advanced search
			$templater = vB_Template::create('dbtech_downloads_comment_wrapper');
				$templater->register('comments', 	$comments);
				$templater->register('pagenav', 	$pagenav);
			$download['comments'] = $templater->render();			
		}
		while (false);		

		$page_templater = vB_Template::create('dbtech_downloads_download');
			$page_templater->register('pagetitle', 		$pagetitle);
			$page_templater->register('download', 		$download);
			$page_templater->register('category', 		$category);
			$page_templater->register('permissions', 	$permissions);
		$HTML = $page_templater->render();
	}
}

// #############################################################################
if ($_POST['action'] == 'setpassword')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'downloadid'               => TYPE_UINT,
		'vb_login_password'        => TYPE_STR,
		'vb_login_md5password'     => TYPE_STR,
		'vb_login_md5password_utf' => TYPE_STR,
	));

	$downloadPass = VBDOWNLOADS::$db->fetchOne('
		SELECT password
		FROM $dbtech_downloads_download AS download
		WHERE downloadid = ?
	', array(
		$vbulletin->GPC['downloadid'],
	));

	if (
		$downloadPass != ($vbulletin->GPC['vb_login_password'] AND !$vbulletin->GPC['vb_login_md5password'] ? md5($vbulletin->GPC['vb_login_password']) : '') AND
		$downloadPass != ($vbulletin->GPC['vb_login_md5password'] ? $vbulletin->GPC['vb_login_md5password'] : '') AND
		$downloadPass != ($vbulletin->GPC['vb_login_md5password_utf'] ? $vbulletin->GPC['vb_login_md5password_utf'] : '')
	)
	{
		// Wrong password
		standard_error(fetch_error('dbtech_downloads_invalid_password'));
	}

	// Set the password cookie
	vbsetcookie('downloadpass_' . $vbulletin->GPC['downloadid'], md5($downloadPass . COOKIE_SALT), true, true, true);

	// Do ze redirect
	exec_header_redirect($vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=download&downloadid=' . $vbulletin->GPC['downloadid']);
}


// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$vbulletin->input->clean_gpc('r', 'downloadid', TYPE_UINT);
	$vbulletin->input->clean_gpc('r', 'categoryid', TYPE_UINT);

	if (!$vbulletin->GPC['downloadid'] AND !$vbulletin->GPC['categoryid'])
	{
		// Git oot.
		print_no_permission();
	}

	$download = array(
		'title' 		=> '',
		'description' 	=> '',
		'mirrors' 		=> array(),
		'private' 		=> '',
		'categoryid' 	=> $vbulletin->GPC['categoryid'],
	);
	if ($vbulletin->GPC['downloadid'])
	{
		// Grab the download
		if (!$download = VBDOWNLOADS::$db->fetchRow('SELECT * FROM $dbtech_downloads_download WHERE downloadid = ?', array($vbulletin->GPC['downloadid']))) 
		{
			// Invalid download
			standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_download'], $vbulletin->GPC['downloadid']));
		}

		if ($download['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
		{
			// File is under moderation
			standard_error(fetch_error('dbtech_downloads_file_being_reviewed'));
		}

		if (
			!VBDOWNLOADS::$permissions['ismanager'] AND 
			$download['userid'] != $vbulletin->userinfo['userid'] AND
			$vbulletin->userinfo['userid']
		)
		{
			// Private download
			standard_error(fetch_error('dbtech_downloads_private_file_error'));
		}

		// No hacsors here please
		$download['title'] = htmlspecialchars_uni($download['title']);

		// Unserialize these
		$download['private'] = @unserialize($download['private']);
		$download['mirrors'] = @unserialize($download['mirrors']);		

		if (!is_array($download['private']) OR !count($download['private']))
		{
			// Init this
			$download['private'] = '';
		}
		else
		{
			// Construct a comma-separated list of users
			$download['private'] = implode(',', VBDOWNLOADS::$db->fetchAllSingleKeyed('
				SELECT username, userid 
				FROM $user 
				WHERE userid :queryList
			', 'userid', 'username', array(
				':queryList' => VBDOWNLOADS::$db->queryList($download['private'])
			)));
		}
	}

	if (!$category = VBDOWNLOADS::$cache['category'][$download['categoryid']])
	{
		// Invalid category
		standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $download['categoryid']));
	}

	if ($vbulletin->GPC['downloadid'])
	{
		// Grab our permissions
		$permissions = VBDOWNLOADS::fetchPermissions($download, $category);
	}
	else
	{
		// Grab our permissions
		$permissions = VBDOWNLOADS::fetchPermissions(NULL, $category);
	}

	if (!$permissions['canupload'])
	{
		// We can't upload
		print_no_permission();
	}

	if ($category['parentid'])
	{
		// Store immediate category
		$parentCategory = VBDOWNLOADS::$cache['category'][$category['parentid']];

		do
		{
			// Add to the navbits
			$navbits[$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'categoryid=' . $parentCategory['categoryid']] = $parentCategory['title'];

			if (isset(VBDOWNLOADS::$cache['category'][$parentCategory['parentid']]))
			{
				// Store -its-
				$parentCategory = VBDOWNLOADS::$cache['category'][$parentCategory['parentid']];
			}
		}
		while (isset(VBDOWNLOADS::$cache['category'][$parentCategory['parentid']]));
	}

	if ($vbulletin->GPC['downloadid'])
	{
		// Add to the navbits
		$navbits[$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'categoryid=' . $category['categoryid']] = $category['title'];
		$navbits[$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=download&amp;downloadid=' . $download['downloadid']] = $download['title'];
		$navbits[''] = $pagetitle = construct_phrase($vbphrase['dbtech_downloads_editing_download_x'], $download['title']);
	}
	else
	{
		// Add to the navbits
		$navbits[$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'categoryid=' . $category['categoryid']] = $category['title'];
		$navbits[''] = $pagetitle = $vbphrase['dbtech_downloads_add_new_download'];
	}


	for ($i = 0; $i < 10; $i++)
	{
		if (!isset($download['mirrors'][$i]))
		{
			// Default value		
			$download['mirrors'][$i] = array(
				'link' => 'http://',
				'hits' => 0,
			);
		}
		else
		{
			if (!is_array($download['mirrors'][$i]))
			{
				// Need to convert it to array
				$download['mirrors'][$i] = array(
					'link' => $download['mirrors'][$i],
					'hits' => 0,
				);
			}

			if (!$download['mirrors'][$i]['link'])
			{
				// Set this to default
				$download['mirrors'][$i]['link'] = 'http://';
			}
			else
			{
				// Ensure this is safe
				$download['mirrors'][$i]['link'] = htmlspecialchars_uni($download['mirrors'][$i]['link']);
			}
		}
	}

	if ($download['password'])
	{
		// Set placeholder password
		$download['password'] = '!>=Password=<!';
	}

	// Grab ordered list
	$categoryList = construct_ordered_categories();

	// Construct the list of select options
	construct_category_select_options($categories, $categoryList);

	$categoryOptions = '';
	foreach ($categories as $categoryid => $title)
	{
		if (in_array($categoryid, $_excludeCategories))
		{
			// Can't view category
			continue;
		}

		$templater = vB_Template::create('option');
			$templater->register('optionselected', 	$download['categoryid'] == $categoryid ? 'selected="selected"' : '');
			$templater->register('optionvalue', 	$categoryid);
			$templater->register('optiontitle', 	htmlspecialchars_uni($title));
		$categoryOptions .= $templater->render();
	}

	$extensioninfo = '';
	$extensions = array();
	foreach (VBDOWNLOADS::$cache['extension'] as $extension)
	{
		if (!in_array($extension['extensiongroupid'], $category['extensiongroups']))
		{
			// Not in allowed extension group
			continue;
		}

		// Add to allowed extensions
		$extensions[] = $extension['extension'];

		$templater = vB_Template::create('dbtech_downloads_modify_extensionbit');
			$templater->register('extension', 	$extension['extension']);
			$templater->register('maxsize', 	vb_number_format($extension['maxsize'], 2, true));
		$extensioninfo .= $templater->render();
	}

	require_once(DIR . '/includes/functions_editor.php');
	$editorid = construct_edit_toolbar($download['description'], false, 'nonforum', false, false, false);
	
	// Mail sending form
	$page_templater = vB_Template::create('dbtech_downloads_modify');
		$page_templater->register('download', 		$download);
		$page_templater->register('editorid', 		$editorid);
		$page_templater->register('messagearea', 	$messagearea);
		$page_templater->register('categories', 	$categoryOptions);
		$page_templater->register('extensioninfo', 	$extensioninfo);
		$page_templater->register('extensions', 	implode('|', $extensions));
		$page_templater->register('jQueryPath',		VBDOWNLOADS::jQueryPath());		
		$page_templater->register('jQueryUiPath',	VBDOWNLOADS::jQueryUiPath());		
	$HTML = $page_templater->render();
}

// #############################################################################
if ($_POST['action2'] == 'update')
{
	// Grab stuff
	$vbulletin->input->clean_array_gpc('p', array(
		'downloadid' 	=> TYPE_UINT,
		'download' 		=> TYPE_ARRAY,
		'wysiwyg' 		=> TYPE_BOOL,
		'subject' 		=> TYPE_STR,
		'message' 		=> TYPE_STR,
		'users' 		=> TYPE_STR,
		'filelist' 		=> TYPE_ARRAY,
	));

	if ($vbulletin->GPC['subject'] == '' OR $vbulletin->GPC['message'] == '')
	{
		// Something was missin'
		eval(standard_error(fetch_error('please_complete_required_fields')));
	}

	if (in_array($vbulletin->GPC['download']['categoryid'], $_excludeCategories))
	{
		// Can't view category
		print_no_permission();
	}

	if ($vbulletin->GPC['wysiwyg'])
	{
		// We were using WYSIWYG editor
		if (!file_exists(DIR . '/includes/functions_wysiwyg.php'))
		{
			// New editor
			require_once(DIR . '/includes/class_wysiwygparser.php');
			$html_parser = new vB_WysiwygHtmlParser($vbulletin);
			$message = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], true);
		}
		else
		{
			// Old editor
			require_once(DIR . '/includes/functions_wysiwyg.php');
			$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], true);
		}
	}
	else
	{
		// Not WYSIWYG, interpret as-is
		$message = $vbulletin->GPC['message'];
	}
	
	if (!function_exists('convert_url_to_bbcode'))
	{
		// Ensure we can convert URL to BBCode
		require_once(DIR . '/includes/functions_newpost.php');
	}
	
	// Convert URL to BBCode
	$vbulletin->GPC['download']['description'] = convert_url_to_bbcode($message);

	if (!$category = VBDOWNLOADS::$cache['category'][$vbulletin->GPC['download']['categoryid']])
	{
		// Invalid category
		standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $vbulletin->GPC['download']['categoryid']));
	}

	$vbulletin->GPC['download']['private'] = array();
	if ($category['canprivate'])
	{
		// We can have private downloads
		$users = preg_split('#\s*,\s*#s', $vbulletin->GPC['users'], -1, PREG_SPLIT_NO_EMPTY);
		
		$lookup = array();
		foreach ($users as $username)
		{
			if (!$username)
			{
				// Just in case
				continue;
			}
			
			// Lookup userid
			$lookup[] = htmlspecialchars_uni($username);
		}
		
		if (count($lookup))
		{
			$vbulletin->GPC['download']['private'] = VBDOWNLOADS::$db->fetchAllSingleKeyed('SELECT username, userid FROM $user WHERE username :queryList', 'username', 'userid', array(':queryList' => VBDOWNLOADS::$db->queryList($lookup)));
		}
	}

	if ($vbulletin->GPC['download']['password'])
	{
		// We have a password of some description
		if (!$category['canpassword'])
		{
			// We couldn't have passworded downloads
			$vbulletin->GPC['download']['password'] = '';
		}
		else if ($vbulletin->GPC['download']['password'] != '!>=Password=<!')
		{
			// hash the new password
			$vbulletin->GPC['download']['password'] = md5($vbulletin->GPC['download']['password']);
		}
		else
		{
			// Our password was the PH pass, don't update it
			unset($vbulletin->GPC['download']['password']);
		}
	}

	if ($vbulletin->GPC['downloadid'])
	{
		// Grab the download
		$download = VBDOWNLOADS::$db->fetchRow('SELECT * FROM $dbtech_downloads_download WHERE downloadid = ?', array($vbulletin->GPC['downloadid']));

		if ($download['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
		{
			// File is under moderation
			standard_error(fetch_error('dbtech_downloads_file_being_reviewed'));
		}

		if (
			!VBDOWNLOADS::$permissions['ismanager'] AND 
			$download['userid'] != $vbulletin->userinfo['userid'] AND
			$vbulletin->userinfo['userid']
		)
		{
			// Private download
			standard_error(fetch_error('dbtech_downloads_private_file_error'));
		}
	}
	else
	{
		// I'm being lazy
		$vbulletin->GPC['download']['userid'] = $vbulletin->userinfo['userid'];
	}

	for ($i = 0; $i < 10; $i++)
	{
		if (!isset($vbulletin->GPC['download']['mirrors'][$i]))
		{
			// Default value		
			$vbulletin->GPC['download']['mirrors'][$i] = array(
				'link' => 'http://',
				'hits' => 0,
			);
		}
		else
		{
			if (!is_array($vbulletin->GPC['download']['mirrors'][$i]))
			{
				// Need to convert it to array
				$vbulletin->GPC['download']['mirrors'][$i] = array(
					'link' => $vbulletin->GPC['download']['mirrors'][$i],
					'hits' => 0,
				);
			}

			if (!$vbulletin->GPC['download']['mirrors'][$i]['link'])
			{
				// Set this to default
				$vbulletin->GPC['download']['mirrors'][$i]['link'] = 'http://';
			}
		}
	}

	// I'm being lazy
	$vbulletin->GPC['download']['title'] = $vbulletin->GPC['subject'];

	// Update numfiles from form
	$vbulletin->GPC['download']['numfiles'] = count($vbulletin->GPC['filelist']);

	// init data manager
	$dm =& VBDOWNLOADS::initDataManager('Download', $vbulletin, ERRTYPE_STANDARD);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['downloadid'])
	{
		// Set existing
		$dm->set_existing($download);
	}
	
	// download fields
	foreach ($vbulletin->GPC['download'] AS $key => $val)
	{
		if (!$vbulletin->GPC['downloadid'] OR $existing[$key] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	// Save! Hopefully.
	$downloadid = $vbulletin->GPC['download']['downloadid'] = $dm->save();

	if ($vbulletin->GPC['downloadid'])
	{
		// Ensure this is set
		$downloadid = $vbulletin->GPC['download']['downloadid'] = $vbulletin->GPC['downloadid'];
	}
	

	$fileIds = array();
	foreach ($vbulletin->GPC['filelist'] as $fileid => $fileinfo)
	{
		$fileIds[] = $fileid;
	}

	$fileList = VBDOWNLOADS::$db->fetchAllKeyed('
		SELECT *
		FROM $dbtech_downloads_file
		WHERE fileid :queryList
	', 'fileid', array(
		':queryList' => VBDOWNLOADS::$db->queryList($fileIds),
	));

	foreach ($vbulletin->GPC['filelist'] as $fileid => $fileinfo)
	{
		if (!is_array($fileList[$fileid]))
		{
			if (!$vbulletin->GPC['downloadid'])
			{
				VBDOWNLOADS::$db->delete('dbtech_downloads_file', array($fileid), 'WHERE fileid = ?');
				VBDOWNLOADS::$db->query('UPDATE $dbtech_downloads_download SET numfiles = numfiles - 1 WHERE downloadid = ?', array($downloadid));
			}

			// Skip this
			continue;
		}

		// Update the file
		$dm =& VBDOWNLOADS::initDataManager('File', $vbulletin, ERRTYPE_SILENT);
			$dm->set_existing($fileList[$fileid]);
			$dm->set('downloadid', $downloadid);
			$dm->set('screenshot', $fileinfo['screenshot']);
		$dm->save();
	}	
	
	$vbulletin->url = $vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=download&amp;downloadid=' . $downloadid;
	eval(print_standard_redirect('redirect_dbtech_downloads_file_added'));
}
?>