<?php

// #############################################################################
if ($_REQUEST['action'] == 'modify' OR empty($_REQUEST['action']))
{
	if (!$vbulletin->options['dbtech_downloads_comments'])
	{
		// Can't comment
		print_no_permission();
	}

	$vbulletin->input->clean_gpc('r', 'commentid', TYPE_UINT);
	$vbulletin->input->clean_gpc('r', 'downloadid', TYPE_UINT);

	// Grab the download
	if (!$download = VBDOWNLOADS::$db->fetchRow('SELECT * FROM $dbtech_downloads_download WHERE downloadid = ?', array($vbulletin->GPC['downloadid'])))
	{
		// Invalid download
		standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_download'], $vbulletin->GPC['downloadid']));
	}

	if ($download['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
	{
		// File is under moderation
		standard_error(fetch_error('dbtech_downloads_no_permissions_modifycomment'));
	}

	if ($vbulletin->GPC['commentid'])
	{
		// Grab the download
		if (!$comment = VBDOWNLOADS::$db->fetchRow('SELECT * FROM $dbtech_downloads_comment WHERE commentid = ?', array($vbulletin->GPC['commentid'])))
		{
			// Invalid comment
			standard_error(fetch_error('dbtech_downloads_invalid_comment'));
		}

		if ($comment['downloadid'] != $download['downloadid'])
		{
			// Comment belongs to different download
			standard_error(fetch_error('dbtech_downloads_belongs_to_different_download'));
		}

		if (
			!VBDOWNLOADS::$permissions['ismanager'] AND 
			$comment['userid'] != $vbulletin->userinfo['userid'] AND
			$vbulletin->userinfo['userid']
		)
		{
			// No permissions to modify
			standard_error(fetch_error('dbtech_downloads_no_permissions_modifycomment'));
		}
	}

	if (!$category = VBDOWNLOADS::$cache['category'][$download['categoryid']])
	{
		// Invalid category
		standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $download['categoryid']));
	}

	// Grab our permissions
	$permissions = VBDOWNLOADS::fetchPermissions($download, $category);

	if (!$permissions['cancomment'])
	{
		// We can't view
		print_no_permission();
	}

	// No hacsors here please
	$download['title'] = htmlspecialchars_uni($download['title']);	

	if ($category['parentid'])
	{
		// Store immediate category
		$parentCategory = VBDOWNLOADS::$cache['category'][$category['parentid']];

		do
		{
			// Add to the navbits
			$navbits[$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'categoryid=' . $parentCategory['categoryid']] = $parentCategory['title'];

			if (isset(VBDOWNLOADS::$cache['category'][$parentCategory['parentid']]))
			{
				// Store -its-
				$parentCategory = VBDOWNLOADS::$cache['category'][$parentCategory['parentid']];
			}
		}
		while (isset(VBDOWNLOADS::$cache['category'][$parentCategory['parentid']]));
	}

	// Add category to navbits
	$navbits[$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'categoryid=' . $category['categoryid']] = $category['title'];	

	// Add download itself to navits
	$navbits[$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=download&amp;downloadid=' . $download['downloadid']] = $download['title'];

	// And finally what we're doing
	if ($vbulletin->GPC['commentid'])
	{
		$navbits[''] = $pagetitle = construct_phrase($vbphrase['dbtech_downloads_editing_comment_x'], $download['title']);
	}
	else
	{
		$navbits[''] = $pagetitle = construct_phrase($vbphrase['dbtech_downloads_adding_comment_x'], $download['title']);
	}

	require_once(DIR . '/includes/functions_editor.php');
	$editorid = construct_edit_toolbar($comment['comment'], false, 'nonforum', false, false, false);

	// Advanced search
	$page_templater = vB_Template::create('dbtech_downloads_comment_modify');
		$page_templater->register('pagetitle', 		$pagetitle);
		$page_templater->register('download', 		$download);
		$page_templater->register('comment', 		$comment);
		$page_templater->register('editorid', 		$editorid);
		$page_templater->register('messagearea', 	$messagearea);		
	$HTML = $page_templater->render();
}

// #############################################################################
if ($_REQUEST['action'] == 'update')
{
	if (!$vbulletin->options['dbtech_downloads_comments'])
	{
		// Comments system is disabled
		standard_error(fetch_error('dbtech_downloads_comments_system_disabled'));
	}

	// Grab stuff
	$vbulletin->input->clean_array_gpc('p', array(
		'downloadid' 	=> TYPE_UINT,
		'commentid' 	=> TYPE_UINT,
		'wysiwyg' 		=> TYPE_BOOL,
		'message' 		=> TYPE_STR,
	));

	if ($vbulletin->GPC['message'] == '')
	{
		// Something was missin'
		standard_error(fetch_error('please_complete_required_fields'));
	}

	// Grab the download
	if (!$download = VBDOWNLOADS::$db->fetchRow('SELECT * FROM $dbtech_downloads_download WHERE downloadid = ?', array($vbulletin->GPC['downloadid'])))
	{
		// Invalid download
		standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_download'], $vbulletin->GPC['downloadid']));
	}

	if ($download['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
	{
		// File is under moderation
		standard_error(fetch_error('dbtech_downloads_file_being_reviewed'));
	}

	if ($vbulletin->GPC['commentid'])
	{
		// Grab the download
		if (!$comment = VBDOWNLOADS::$db->fetchRow('SELECT * FROM $dbtech_downloads_comment WHERE commentid = ?', array($vbulletin->GPC['commentid'])))
		{
			// Invalid comment
			print_no_permission();
		}

		if ($comment['downloadid'] != $download['downloadid'])
		{
			// Comment belongs to different download
			standard_error(fetch_error('dbtech_downloads_belongs_to_different_download'));
		}

		if (
			!VBDOWNLOADS::$permissions['ismanager'] AND 
			$comment['userid'] != $vbulletin->userinfo['userid'] AND
			$vbulletin->userinfo['userid']
		)
		{
			// No permissions to modify
			standard_error(fetch_error('dbtech_downloads_no_permissions_modifycomment'));
		}
	}

	if (!$category = VBDOWNLOADS::$cache['category'][$download['categoryid']])
	{
		// Invalid category
		standard_error(fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $download['categoryid']));
	}

	// Grab our permissions
	$permissions = VBDOWNLOADS::fetchPermissions($download, $category);

	if (!$permissions['cancomment'])
	{
		// We can't view
		print_no_permission();
	}

	if ($vbulletin->GPC['wysiwyg'])
	{
		// We were using WYSIWYG editor
		if (!file_exists(DIR . '/includes/functions_wysiwyg.php'))
		{
			// New editor
			require_once(DIR . '/includes/class_wysiwygparser.php');
			$html_parser = new vB_WysiwygHtmlParser($vbulletin);
			$message = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], true);
		}
		else
		{
			// Old editor
			require_once(DIR . '/includes/functions_wysiwyg.php');
			$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], true);
		}
	}
	else
	{
		// Not WYSIWYG, interpret as-is
		$message = $vbulletin->GPC['message'];
	}
	
	if (!function_exists('convert_url_to_bbcode'))
	{
		// Ensure we can convert URL to BBCode
		require_once(DIR . '/includes/functions_newpost.php');
	}
	
	// Convert URL to BBCode
	$message = convert_url_to_bbcode($message);	

	// Create the file in the DM
	$dm =& VBDOWNLOADS::initDataManager('Comment', $vbulletin, ERRTYPE_STANDARD);
	if ($vbulletin->GPC['commentid'])
	{
		$dm->set_existing($comment);
	}
	else
	{
		$dm->set('downloadid', $download['downloadid']);		
		$dm->set('userid', $vbulletin->userinfo['userid']);
	}
		$dm->set('comment', $message);
	$dm->save();

	$vbulletin->url = $vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'do=download&amp;downloadid=' . $download['downloadid'];
	eval(print_standard_redirect('redirect_dbtech_downloads_comment_added'));	
}

// #############################################################################
if ($_REQUEST['action'] == 'kill')
{
	if (!$vbulletin->options['dbtech_downloads_comments'])
	{
		// Can't comment
		print_no_permission();
	}

}

?>