<?php

// #############################################################################
if (in_array($_POST['action'], array('rating', 'favourite', 'delete', 'moderate')))
{
	$vbulletin->input->clean_array_gpc('r', array(
		'downloadid' 	=> TYPE_UINT,
	));

	if (!$vbulletin->userinfo['userid'])
	{
		// No guests
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_no_guests'),
		));
	}

	if (!$download = VBDOWNLOADS::$db->fetchRow('
		SELECT *
		FROM $dbtech_downloads_download
		WHERE downloadid = ?
	', array(
		$vbulletin->GPC['downloadid'],
	)))
	{
		// File is under moderation
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_download'], $vbulletin->GPC['downloadid']),
		));
	}

	if ($download['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
	{
		// File is under moderation
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_file_being_reviewed'),
		));
	}

	$download['private'] = @unserialize($download['private']);
	if (
		is_array($download['private']) AND
		count($download['private']) AND
		!VBDOWNLOADS::$permissions['ismanager'] AND 
		!in_array($vbulletin->userinfo['userid'], $download['private']) AND 
		$download['userid'] != $vbulletin->userinfo['userid']
	)
	{
		// Private download
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_private_file_error'),
		));
	}

	if (in_array($download['categoryid'], $_excludeCategories))
	{
		// Can't view category
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_category_permission_error'),
		));
	}

	if (!$category = VBDOWNLOADS::$cache['category'][$download['categoryid']])
	{
		// Invalid category
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $download['categoryid']),
		));
	}

	// Grab our permissions
	$permissions = VBDOWNLOADS::fetchPermissions($download, $category);	
}

// #############################################################################
if ($_POST['action'] == 'delete')
{
	if (
		!VBDOWNLOADS::$permissions['ismanager'] AND 
		$download['userid'] != $vbulletin->userinfo['userid']
	)
	{
		// Private download
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_private_file_error'),
		));
	}

	// Update the download
	$dm =& VBDOWNLOADS::initDataManager('Download', $vbulletin, ERRTYPE_SILENT);
		$dm->set_existing($download);
	$dm->delete();

	VBDOWNLOADS::outputXML(array(
		'success' => $vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'categoryid=' . $download['categoryid'],
	));
}

// #############################################################################
if ($_POST['action'] == 'moderate')
{
	if (!VBDOWNLOADS::$permissions['ismanager'])
	{
		// Private download
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_private_file_error'),
		));
	}

	// Switch moderation status
	$moderation = $download['moderation'] ? 0 : 1;

	// Update the download
	$dm =& VBDOWNLOADS::initDataManager('Download', $vbulletin, ERRTYPE_SILENT);
		$dm->set_existing($download);
		$dm->set('moderation', $moderation);
	$dm->save();

	VBDOWNLOADS::outputXML(array(
		'success' => true,
	));
}

// #############################################################################
if ($_POST['action'] == 'deletecomment')
{
	if (!$vbulletin->options['dbtech_downloads_comments'])
	{
		// Comments disabled
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_comments_system_disabled'),
		));
	}

	// Grab stuff
	$vbulletin->input->clean_array_gpc('p', array(
		'downloadid' 	=> TYPE_UINT,
		'commentid' 	=> TYPE_UINT,
	));

	// Grab the download
	if (!$download = VBDOWNLOADS::$db->fetchRow('SELECT * FROM $dbtech_downloads_download WHERE downloadid = ?', array($vbulletin->GPC['downloadid'])))
	{
		// Invalid download
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_download'], $vbulletin->GPC['downloadid']),
		));
	}

	if ($download['moderation'] AND !VBDOWNLOADS::$permissions['ismanager'])
	{
		// File is under moderation
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_file_being_reviewed'),
		));
	}

	// Grab the download
	if (!$comment = VBDOWNLOADS::$db->fetchRow('SELECT * FROM $dbtech_downloads_comment WHERE commentid = ?', array($vbulletin->GPC['commentid'])))
	{
		// Invalid comment
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_invalid_comment'),
		));
	}

	if ($comment['downloadid'] != $download['downloadid'])
	{
		// Comment belongs to different download
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_belongs_to_different_download'),
		));
	}

	if (
		!VBDOWNLOADS::$permissions['ismanager'] AND 
		$comment['userid'] != $vbulletin->userinfo['userid'] AND
		$vbulletin->userinfo['userid']
	)
	{
		// No permissions to modify
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_no_permissions_modifycomment'),
		));
	}

	if (!$category = VBDOWNLOADS::$cache['category'][$download['categoryid']])
	{
		// Invalid category
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $download['categoryid']),
		));
	}

	// Grab our permissions
	$permissions = VBDOWNLOADS::fetchPermissions($download, $category);

	if (!$permissions['cancomment'])
	{
		// No permissions to modify this comment
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_no_permissions_modifycomment'),
		));
	}

	// Update the download
	$dm =& VBDOWNLOADS::initDataManager('Comment', $vbulletin, ERRTYPE_SILENT);
		$dm->set_existing($comment);
	$dm->delete();

	VBDOWNLOADS::outputXML(array(
		'success' => true
	));
}



// #############################################################################
if ($_POST['action'] == 'favourite')
{
	if (!$permissions['canfavourite'])
	{
		// No permissions to favourite downloads
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_no_permissions_favourite'),
		));
	}

	if (!$vbulletin->options['dbtech_downloads_favourites'])
	{
		// Rating is off
		VBDOWNLOADS::outputXML(array(
			'error' 		=> fetch_error('dbtech_downloads_favourites_disabled'),
		));
	}

	if ($hasFavourites = VBDOWNLOADS::$db->fetchRow('
		SELECT * FROM $dbtech_downloads_favourite
		WHERE userid = ?
			AND downloadid = ?
	', array(
		$vbulletin->userinfo['userid'],
		$download['downloadid'],
	)))
	{
		// We're un-favouriting
		VBDOWNLOADS::$db->delete('dbtech_downloads_favourite', array(
			$vbulletin->GPC['downloadid'],
			$vbulletin->userinfo['userid'],
		), 'WHERE downloadid = ? AND userid = ?');

		// For the return
		$download['numfavourites']--;
	}
	else
	{
		// We're favouriting
		VBDOWNLOADS::$db->insert('dbtech_downloads_favourite', array(
			'downloadid' => $vbulletin->GPC['downloadid'],
			'userid' => $vbulletin->userinfo['userid'],
		));

		// For the return
		$download['numfavourites']++;
	}

	$dm =& VBDOWNLOADS::initDataManager('Download', $vbulletin, ERRTYPE_SILENT);
		$dm->set_existing($download);
		$dm->set('numfavourites', 'numfavourites ' . (empty($hasFavourites) ? '+' : '-') . ' 1', false);
	$dm->save();
	
	VBDOWNLOADS::outputXML(array(
		'success' => $download['numfavourites'],
	));
}
?>