<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'extension' OR empty($_REQUEST['action']))
{
	$extensions_by_extensiongroup 	= array();
	foreach ((array)VBDOWNLOADS::$cache['extension'] as $extensionid => $extension)
	{
		// Index by extensiongroupid
		$extensions_by_extensiongroup[$extension['extensiongroupid']][$extensionid] = $extension;
	}

	print_cp_header($vbphrase['dbtech_downloads_extensions']);

	// Table header
	$headings = array();
	$headings[] = $vbphrase['dbtech_downloads_extension'];
	$headings[] = $vbphrase['dbtech_downloads_mime_type'];
	$headings[] = $vbphrase['dbtech_downloads_max_file_size'];
	$headings[] = $vbphrase['dbtech_downloads_max_width'];
	$headings[] = $vbphrase['dbtech_downloads_max_height'];
	$headings[] = $vbphrase['dbtech_downloads_controls'];

	print_table_start();
	print_table_header($vbphrase['dbtech_downloads_extensions'], count($headings));
	print_cells_row($headings, true);

	foreach ($extensions_by_extensiongroup as $extensiongroupid => $extensions)
	{
		print_description_row(VBDOWNLOADS::$cache['extensiongroup'][$extensiongroupid]['title'] . '<span style="float:right;">' . 
			construct_link_code($vbphrase['dbtech_downloads_manage'], 'vbdownloads.php?' . $vbulletin->session->vars['sessionurl'] . 'do=extension&amp;action=modifygroup&amp;extensiongroupid=' . $extensiongroupid) . ' ' .
			construct_link_code($vbphrase['dbtech_downloads_remove'], 'vbdownloads.php?' . $vbulletin->session->vars['sessionurl'] . 'do=extension&amp;action=deletegroup&amp;extensiongroupid=' . $extensiongroupid) . 
		'</span>', false, count($headings), 'optiontitle');
		
		foreach ($extensions as $extensionid => $extension)
		{
			// Table data
			$cell = array();
			$cell[] = $extension['extension'];
			$cell[] = $extension['mime'];
			$cell[] = vb_number_format($extension['maxsize'], 0, true);
			$cell[] = $extension['isimage'] ? $extension['maxwidth'] . ' px' : $vbphrase['n_a'];
			$cell[] = $extension['isimage'] ? $extension['maxheight'] . ' px' : $vbphrase['n_a'];
			$cell[] = 		
				construct_link_code($vbphrase['dbtech_downloads_manage'], 'vbdownloads.php?' . $vbulletin->session->vars['sessionurl'] . 'do=extension&amp;action=modify&amp;extensionid=' . $extensionid) . ' ' . 
				construct_link_code($vbphrase['dbtech_downloads_remove'], 'vbdownloads.php?' . $vbulletin->session->vars['sessionurl'] . 'do=extension&amp;action=delete&amp;extensionid=' . $extensionid)
			;

			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
	}

	print_table_footer(count($headings), 
		construct_link_code($vbphrase['dbtech_downloads_add_new_extension'], 'vbdownloads.php?' . $vbulletin->session->vars['sessionurl'] . 'do=extension&amp;action=modify') . ' ' . 
		construct_link_code($vbphrase['dbtech_downloads_add_extension_group'], 'vbdownloads.php?' . $vbulletin->session->vars['sessionurl'] . 'do=extension&amp;action=modifygroup')
	);
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$extensionid = $vbulletin->input->clean_gpc('r', 'extensionid', TYPE_STR);
	$extension = ($extensionid ? VBDOWNLOADS::$cache['extension'][$extensionid] : false);

	$extensiongroups = array();
	foreach ((array)VBDOWNLOADS::$cache['extensiongroup'] as $extensiongroupid => $extensiongroup)
	{
		// Add the extensiongroup name to the array
		$extensiongroups[$extensiongroupid] = $extensiongroup['title'];
	}
	
	// Sort the array as a string
	asort($extensiongroups, SORT_STRING);	
	
	if (!count($extensiongroups))
	{
		// Missing categories
		print_stop_message('dbtech_downloads_missing_x',
			$vbphrase['dbtech_downloads_extensiongroup'],
			$vbulletin->session->vars['sessionurl'],
			'extension',
			'modifygroup'
		);
	}

	if (!is_array($extension))
	{
		// Non-existing tab
		$extensionid = 0;
	}
	
	$defaults = array(
		'extension' 	=> 'zip',
		'mime' 			=> 'application/zip',
		'maxsize' 		=> 5242880,
		'maxheight'		=> 0,
		'maxwidth'		=> 0,
		'isimage'		=> 0,
	);
	
	if ($extensionid)
	{
		// Edit
		print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_downloads_editing_x_y'], $vbphrase['dbtech_downloads_extension'], $extension['extension'])));
		print_form_header('vbdownloads', 'extension');
		construct_hidden_code('action', 'update');
		construct_hidden_code('extensionid', $extensionid);
		print_table_header(construct_phrase($vbphrase['dbtech_downloads_editing_x_y'], $vbphrase['dbtech_downloads_extension'], $extension['extension']));
	}
	else
	{
		// Add
		print_cp_header($vbphrase['dbtech_downloads_add_new_extension']);
		print_form_header('vbdownloads', 'extension');
		construct_hidden_code('action', 'update');
		print_table_header($vbphrase['dbtech_downloads_add_new_extension']);
		
		$extension = $defaults;
	}
	print_input_row($vbphrase['dbtech_downloads_extension_name'], 			'extension[extension]', 							$extension['extension']);
	print_select_row($vbphrase['dbtech_downloads_extension_group_admin'], 	'extension[extensiongroupid]', 	$extensiongroups, 	$extension['extensiongroupid']);
	print_yes_no_row($vbphrase['dbtech_downloads_is_image'], 				'extension[isimage]', 								$extension['isimage']);
	print_input_row($vbphrase['dbtech_downloads_mime_type_admin'], 			'extension[mime]', 									$extension['mime']);
	print_input_row($vbphrase['dbtech_downloads_extension_max_file_size'], 	'extension[maxsize]', 								$extension['maxsize']);
	print_input_row($vbphrase['dbtech_downloads_extension_max_height'], 	'extension[maxheight]', 							$extension['maxheight']);
	print_input_row($vbphrase['dbtech_downloads_extension_max_width'], 		'extension[maxwidth]', 								$extension['maxwidth']);
	print_submit_row(($extensionid ? $vbphrase['save'] : $vbphrase['dbtech_downloads_add_new_extension']));	
}

// #############################################################################
if ($_POST['action'] == 'update')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'extensionid' 	=> TYPE_UINT,
		'extension' 	=> TYPE_ARRAY,
	));
	
	// init data manager
	$dm =& VBDOWNLOADS::initDatamanager('Extension', $vbulletin, ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['extensionid'])
	{
		if (!$existing = VBDOWNLOADS::$cache['extension'][$vbulletin->GPC['extensionid']])
		{
			// Couldn't find the tab
			print_stop_message('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_extension'], $vbulletin->GPC['extensionid']);
		}
		
		// Set existing
		$dm->set_existing($existing);
		
		// Added
		$phrase = $vbphrase['dbtech_downloads_edited'];
	}
	else
	{
		// Added
		$phrase = $vbphrase['dbtech_downloads_added'];
	}
	
	// tab fields
	foreach ($vbulletin->GPC['extension'] AS $key => $val)
	{
		if (!$vbulletin->GPC['extensionid'] OR $existing[$key] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	// Save! Hopefully.
	$dm->save();
	
	define('CP_REDIRECT', 'vbdownloads.php?do=extension');
	print_stop_message('dbtech_downloads_x_y', $vbphrase['dbtech_downloads_extension'], $phrase);	
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$vbulletin->input->clean_gpc('r', 'extensionid', TYPE_UINT);
	
	print_cp_header(construct_phrase($vbphrase['dbtech_downloads_delete_x'], $vbphrase['dbtech_downloads_extension']));
	print_delete_confirmation('dbtech_downloads_extension', $vbulletin->GPC['extensionid'], 'vbdownloads', 'extension', 'dbtech_downloads_extension', array('action' => 'kill'), '', 'extension', 'extensionid');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'extensionid' 	=> TYPE_UINT,
		'kill' 			=> TYPE_BOOL
	));
	
	if (!$existing = VBDOWNLOADS::$cache['extension'][$vbulletin->GPC['extensionid']])
	{
		// Couldn't find the tab
		print_stop_message('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_extension'], $vbulletin->GPC['extensionid']);
	}
	
	// init data manager
	$dm =& VBDOWNLOADS::initDatamanager('Extension', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	define('CP_REDIRECT', 'vbdownloads.php?do=extension');
	print_stop_message('dbtech_downloads_x_y', $vbphrase['dbtech_downloads_extension'], $vbphrase['dbtech_downloads_deleted']);	
}

// #############################################################################
if ($_REQUEST['action'] == 'modifygroup')
{
	$extensiongroupid = $vbulletin->input->clean_gpc('r', 'extensiongroupid', TYPE_STR);
	$extensiongroup = ($extensiongroupid ? VBDOWNLOADS::$cache['extensiongroup'][$extensiongroupid] : false);

	if (!is_array($extensiongroup))
	{
		// Non-existing tab
		$extensiongroupid = 0;
	}
	
	$defaults = array(
		'title' => 'Files',
	);
	
	if ($extensiongroupid)
	{
		// Edit
		print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_downloads_editing_x_y'], $vbphrase['dbtech_downloads_extensiongroup'], $extensiongroup['title'])));
		print_form_header('vbdownloads', 'extension');
		construct_hidden_code('action', 'updategroup');
		construct_hidden_code('extensiongroupid', $extensiongroupid);
		print_table_header(construct_phrase($vbphrase['dbtech_downloads_editing_x_y'], $vbphrase['dbtech_downloads_extensiongroup'], $extensiongroup['title']));
	}
	else
	{
		// Add
		print_cp_header($vbphrase['dbtech_downloads_add_extension_group']);
		print_form_header('vbdownloads', 'extension');
		construct_hidden_code('action', 'updategroup');
		print_table_header($vbphrase['dbtech_downloads_add_extension_group']);
		
		$extensiongroup = $defaults;
	}
	print_input_row($vbphrase['dbtech_downloads_extgroup_name'], 'extensiongroup[title]', $extensiongroup['title']);
	print_submit_row(($extensionid ? $vbphrase['save'] : $vbphrase['dbtech_downloads_add_extension_group']));	
}

// #############################################################################
if ($_POST['action'] == 'updategroup')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'extensiongroupid' 	=> TYPE_UINT,
		'extensiongroup' 	=> TYPE_ARRAY,
	));
	
	// init data manager
	$dm =& VBDOWNLOADS::initDatamanager('Extensiongroup', $vbulletin, ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['extensiongroupid'])
	{
		if (!$existing = VBDOWNLOADS::$cache['extensiongroup'][$vbulletin->GPC['extensiongroupid']])
		{
			// Couldn't find the tab
			print_stop_message('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_extensiongroup'], $vbulletin->GPC['extensionid']);
		}
		
		// Set existing
		$dm->set_existing($existing);
		
		// Added
		$phrase = $vbphrase['dbtech_downloads_edited'];
	}
	else
	{
		// Added
		$phrase = $vbphrase['dbtech_downloads_added'];
	}
	
	// tab fields
	foreach ($vbulletin->GPC['extensiongroup'] AS $key => $val)
	{
		if (!$vbulletin->GPC['extensiongroupid'] OR $existing[$key] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	// Save! Hopefully.
	$dm->save();
	
	define('CP_REDIRECT', 'vbdownloads.php?do=extension');
	print_stop_message('dbtech_downloads_x_y', $vbphrase['dbtech_downloads_extensiongroup'], $phrase);	
}

// #############################################################################
if ($_REQUEST['action'] == 'deletegroup')
{
	$vbulletin->input->clean_gpc('r', 'extensiongroupid', TYPE_UINT);
	
	print_cp_header(construct_phrase($vbphrase['dbtech_downloads_delete_x'], $vbphrase['dbtech_downloads_extensiongroup']));
	print_delete_confirmation('dbtech_downloads_extensiongroup', $vbulletin->GPC['extensionid'], 'vbdownloads', 'extension', 'dbtech_downloads_extensiongroup', array('action' => 'killgroup'), '', 'extensiongroup', 'extensiongroupid');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'killgroup')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'extensiongroupid' 	=> TYPE_UINT,
		'kill' 				=> TYPE_BOOL
	));
	
	if (!$existing = VBDOWNLOADS::$cache['extensiongroup'][$vbulletin->GPC['extensiongroupid']])
	{
		// Couldn't find the tab
		print_stop_message('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_extensiongroup'], $vbulletin->GPC['extensiongroupid']);
	}
	
	// init data manager
	$dm =& VBDOWNLOADS::initDatamanager('Extensiongroup', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	define('CP_REDIRECT', 'vbdownloads.php?do=extension');
	print_stop_message('dbtech_downloads_x_y', $vbphrase['dbtech_downloads_extensiongroup'], $vbphrase['dbtech_downloads_deleted']);	
}
print_cp_footer();
?>