<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'category' OR empty($_REQUEST['action']))
{
	print_cp_header($vbphrase['dbtech_downloads_category_management']);
	
	// Table header
	$headings = array();
	$headings[] = $vbphrase['dbtech_downloads_category_name'];
	$headings[] = $vbphrase['description'];
	$headings[] = $vbphrase['display_order'];
	
	$headings[] = $vbphrase['edit'];
	$headings[] = $vbphrase['delete'];
	
	
	if (count(VBDOWNLOADS::$cache['category']))
	{
		$lookup = array();
		

		// Organise our categories
		$categories = construct_ordered_categories();

		print_form_header('vbdownloads', 'category');	
		construct_hidden_code('action', 'displayorder');
		print_table_header($vbphrase['dbtech_downloads_category_management'], count($headings));
		print_description_row($vbphrase['dbtech_downloads_category_management_descr'], false, count($headings));	
		print_cells_row($headings, 0, 'thead');
		
		foreach ($categories as $categoryid => $category)
		{
			// Table data
			$cell = array();
			$cell[] = $category['title'];
			$cell[] = nl2br($category['description']);
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$categoryid]\" value=\"$category[displayorder]\" tabindex=\"1\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
			
			$cell[] = construct_link_code($vbphrase['edit'], 'vbdownloads.php?' . $vbulletin->session->vars['sessionurl'] . 'do=category&amp;action=modify&amp;categoryid=' . $categoryid);
			$cell[] = construct_link_code($vbphrase['delete'], 'vbdownloads.php?' . $vbulletin->session->vars['sessionurl'] . 'do=category&amp;action=delete&amp;categoryid=' . $categoryid);
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);

			// Print children
			print_category_rows($category['children'], 1, $lookup);
		}
		print_submit_row($vbphrase['save_display_order'], false, count($headings), false, "<input type=\"button\" id=\"addnew\" class=\"button\" value=\"" . str_pad($vbphrase['dbtech_downloads_add_new_category'], 8, ' ', STR_PAD_BOTH) . "\" tabindex=\"1\" onclick=\"window.location = 'vbdownloads.php?do=category&amp;action=modify'\" />");
	}
	else
	{
		print_form_header('vbdownloads', 'category');	
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_downloads_category_management'], count($headings));
		print_description_row($vbphrase['dbtech_downloads_no_categories'], false, count($headings));
		print_submit_row($vbphrase['dbtech_downloads_add_new_category'], false, count($headings));	
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$categoryid = $vbulletin->input->clean_gpc('r', 'categoryid', TYPE_UINT);
	$category = ($categoryid ? VBDOWNLOADS::$cache['category'][$categoryid] : false);
	
	if (!is_array($category))
	{
		// Non-existing category
		$categoryid = 0;
	}
	
	$defaults = array(
		'title' 		=> 'Category',
		'description' 	=> 'A category that holds a number of downloadable files.',
		'displayorder'	=> 10,
		'image' 		=> '',
		'ownerid' 		=> 0,
	);

	// Default value
	$lookup = array(0 => '');

	if ($categoryid)
	{
		// Edit
		print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_downloads_editing_x_y'], $vbphrase['dbtech_downloads_category'], $category['title'])));
		print_form_header('vbdownloads', 'category');
		construct_hidden_code('action', 'update');
		construct_hidden_code('categoryid', $categoryid);
		print_table_header(construct_phrase($vbphrase['dbtech_downloads_editing_x_y'], $vbphrase['dbtech_downloads_category'], $category['title']));

		if ($category['ownerid'])
		{
			// If we have an owner
			$lookup = VBDOWNLOADS::$db->fetchAllSingleKeyed('SELECT username, userid FROM $user WHERE userid = ?', 'userid', 'username', array($category['ownerid']));
		}
	}
	else
	{
		// Add
		print_cp_header($vbphrase['dbtech_downloads_add_new_category']);
		print_form_header('vbdownloads', 'category');
		construct_hidden_code('action', 'update');
		print_table_header($vbphrase['dbtech_downloads_add_new_category']);
		
		$category = $defaults;
	}

	$extensiongroups = array();
	foreach (VBDOWNLOADS::$cache['extensiongroup'] as $extensiongroupid => $extensiongroup)
	{
		$extensiongroups[$extensiongroupid] = $extensiongroup['title'];
	}

	$categories = array(0 => $vbphrase['n_a']);

	// Grab ordered list
	$categoryList = construct_ordered_categories();

	// Construct the list of select options
	construct_category_select_options($categories, $categoryList);
	
	print_description_row($vbphrase['dbtech_downloads_main_settings'], false, 2, 'optiontitle');	
	print_input_row($vbphrase['dbtech_downloads_category_name'], 				'category[title]', 									$category['title']);
	print_textarea_row($vbphrase['dbtech_downloads_category_desc'], 			'category[description]', 							$category['description']);
	print_input_row($vbphrase['display_order'], 								'category[displayorder]', 							$category['displayorder']);
	print_input_row($vbphrase['dbtech_downloads_category_owner'], 				'category[ownerid]', 								$lookup[$category['ownerid']]);
	print_yes_no_row($vbphrase['dbtech_downloads_moderated_category'], 			'category[moderated]', 								$category['moderated']);	
	print_input_row($vbphrase['dbtech_downloads_category_image'], 				'category[image]', 									$category['image']);
	print_checkbox_array_row($vbphrase['dbtech_downloads_category_extgroup'], 	'category[extensiongroups][]', 	$extensiongroups, 	(array)$category['extensiongroups']);
	print_yes_no_row($vbphrase['dbtech_downloads_allow_moderation'], 			'category[moderation]', 							$category['moderation']);
	

	print_table_break();
	
	// Table header
	$headings = array();
	$headings[] = '<label><input type="checkbox" rel="^-category[permissions]" />' . $vbphrase['usergroup'] . '</label>';
	$headings[] = '<label><input type="checkbox" rel="^-category[permissions][view]" />' . $vbphrase['dbtech_downloads_canview'] . '</label>';
	$headings[] = '<label><input type="checkbox" rel="^-category[permissions][download]" />' . $vbphrase['dbtech_downloads_candownload'] . '</label>';
	$headings[] = '<label><input type="checkbox" rel="^-category[permissions][upload]" />' . $vbphrase['dbtech_downloads_canupload'] . '</label>';
	
	$cells = array();
	$cells[] = 'view';
	$cells[] = 'download';
	$cells[] = 'upload';
	
	print_table_header($vbphrase['dbtech_downloads_permissions'], count($headings));
	print_cells_row($headings, 0, 'thead');
	foreach ($vbulletin->usergroupcache as $usergroupid => $usergroup)
	{
		// Table data
		$cell = array();
		$cell[] = $usergroup['title'];
		foreach ($cells as $permtitle)
		{
			if (is_array($category['permissions'][$permtitle][0]))
			{
				// Old permissions format
				$backup = $category['permissions'][$permtitle];
				$category['permissions'][$permtitle] = array();
				
				foreach ($backup as $ugid)
				{
					// Store this as it's supposed to be
					$category['permissions'][$permtitle][$ugid] = 1;
				}
			}

			$cell[] = '<center>
				<input type="hidden" name="category[permissions][' . $permtitle . '][' . $usergroupid . ']" value="0" />
				<input type="checkbox" name="category[permissions][' . $permtitle . '][' . $usergroupid . ']" value="1"' . ($category['permissions'][$permtitle][$usergroupid] ? ' checked="checked"' : '') . ($vbulletin->debug ? ' title="name=&quot;category[permissions][' . $permtitle . '][' . $usergroupid . ']&quot;"' : '') . '/>
			</center>';
		}
		
		// Print the data
		print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
	}
	print_table_break();

	print_submit_row(($categoryid ? $vbphrase['save'] : $vbphrase['dbtech_downloads_add_new_category']));
	echo '<script type="text/javascript" src="' . VBDOWNLOADS::jQueryPath() . '"></script>';
	VBDOWNLOADS::js('_admin');
}

// #############################################################################
if ($_REQUEST['action'] == 'update')
{
	// Grab stuff
	$vbulletin->input->clean_array_gpc('p', array(
		'categoryid' 	=> TYPE_UINT,
		'category' 		=> TYPE_ARRAY,
	));

	if ($vbulletin->GPC['category']['ownerid'])
	{
		// If we have an owner
		$vbulletin->GPC['category']['ownerid'] = VBDOWNLOADS::$db->fetchOne('SELECT userid FROM $user WHERE username = ?', array(htmlspecialchars_uni($vbulletin->GPC['category']['ownerid'])));

		if (!$vbulletin->GPC['category']['ownerid'])
		{
			// Invalid user
			$vbulletin->GPC['category']['ownerid'] = 0;
		}
	}	
	
	// init data manager
	$dm =& VBDOWNLOADS::initDataManager('Category', $vbulletin, ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['categoryid'])
	{
		if (!$existing = VBDOWNLOADS::$cache['category'][$vbulletin->GPC['categoryid']])
		{
			// Couldn't find the category
			print_stop_message('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $vbulletin->GPC['categoryid']);
		}
		
		// Set existing
		$dm->set_existing($existing);
				
		// Added
		$phrase = $vbphrase['dbtech_downloads_edited'];
	}
	else
	{
		// Added
		$phrase = $vbphrase['dbtech_downloads_added'];
	}
	
	// category fields
	foreach ($vbulletin->GPC['category'] AS $key => $val)
	{
		if (!$vbulletin->GPC['categoryid'] OR $existing[$key] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	// Save! Hopefully.
	$dm->save();
		
	define('CP_REDIRECT', 'vbdownloads.php?do=category');
	print_stop_message('dbtech_downloads_x_y', $vbphrase['dbtech_downloads_category'], $phrase);
}

// #############################################################################
if ($_POST['action'] == 'displayorder')
{
	$vbulletin->input->clean_array_gpc('p', array('order' => TYPE_ARRAY));
	
	if (is_array($vbulletin->GPC['order']))
	{
		foreach ($vbulletin->GPC['order'] as $categoryid => $displayorder)
		{
			if (!$existing = VBDOWNLOADS::$cache['category'][$categoryid])
			{
				// Couldn't find the category
				continue;
			}
			
			if ($existing['displayorder'] == $displayorder)
			{
				// No change
				continue;
			}
			
			// init data manager
			$dm =& VBDOWNLOADS::initDataManager('Category', $vbulletin, ERRTYPE_CP);
				$dm->set_existing($existing);
				$dm->set('displayorder', $displayorder);
			$dm->save();
			unset($dm);	
		}
	}
	
	define('CP_REDIRECT', 'vbdownloads.php?do=category');
	print_stop_message('saved_display_order_successfully');	
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$vbulletin->input->clean_gpc('r', 'categoryid', TYPE_UINT);
	
	print_cp_header(construct_phrase($vbphrase['dbtech_downloads_delete_x'], $vbphrase['dbtech_downloads_category']));
	print_delete_confirmation('dbtech_downloads_category', $vbulletin->GPC['categoryid'], 'vbdownloads', 'category', 'dbtech_downloads_category', array('action' => 'kill'), '', 'title', 'categoryid');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$vbulletin->input->clean_gpc('r', 'categoryid', TYPE_UINT);
	
	if (!$existing = VBDOWNLOADS::$cache['category'][$vbulletin->GPC['categoryid']])
	{
		// Couldn't find the category
		print_stop_message('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_category'], $vbulletin->GPC['categoryid']);
	}
	
	// init data manager
	$dm =& VBDOWNLOADS::initDataManager('Category', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	define('CP_REDIRECT', 'vbdownloads.php?do=category');
	print_stop_message('dbtech_downloads_x_y', $vbphrase['dbtech_downloads_category'], $vbphrase['dbtech_downloads_deleted']);	
}

print_cp_footer();