<?php

/**
 * TeamSpeak 3 PHP Framework
 *
 * $Id: serverlog.php 10/13/2010 7:39:50 scp@orilla $
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * @package   TeamSpeak3
 * @version   1.0.38-beta
 * @author    Sven 'ScP' Paulsen
 * @copyright Copyright (c) 2010 by Planet TeamSpeak. All rights reserved.
 */

try
{
  /* connect to server, login and get TeamSpeak3_Node_Host object by URI */
  $ts3_ServerInstance = TeamSpeak3::factory("serverquery://" . $config["user"] . ":" . $config["pass"] . "@" . $config["host"] . ":" . $config["port"] . "/");

  /* access server instance address using __toString() */
  echo "<h1>Virtual Server Logs - " . $ts3_ServerInstance . "</h1>\n";
  
  /* display server select form */
  $selected_sid = form_server_selector($ts3_ServerInstance->serverList());
  
  /* get TeamSpeak3_Node_Server object by ID */
  $ts3_VirtualServer = $ts3_ServerInstance->serverGetById($selected_sid);
    
  /* display server logs */
  echo "<div class=\"log\">\n";
  echo "<table>\n";
  echo "<tr>\n" .
       "  <th>Date/Time</th>\n" .
       "  <th>Level</th>\n" .
       "  <th>Channel</th>\n" .
       "  <th>Event</th>\n" .
       "</tr>\n";
  foreach($ts3_VirtualServer->logView(250) as $log)
  {
    $level = TeamSpeak3_Helper_Convert::logLevel($log["level"]);
    
    echo "<tr class=\"" . strtolower($level) . "\">\n" .
         "  <td>" . date(DATE_ATOM, $log["timestamp"]) . "</td>\n" .
         "  <td>" . $level . "</td>\n" .
         "  <td>" . $log["channel"] . "</td>\n" .
         "  <td>" . $log["msg"] . "</td>\n" .
         "</tr>\n";
  }
  echo "</table>\n";
  echo "</div>\n";
  
  /* display runtime from adapter profiler */
  echo "<p>Executed " . $ts3_ServerInstance->getAdapter()->getQueryCount() . " queries in " . $ts3_ServerInstance->getAdapter()->getQueryRuntime() . " seconds</p>\n";
}
catch(Exception $e)
{
  /* catch exceptions and display error message if anything went wrong */
  echo "<span class='error'><b>Error " . $e->getCode() . ":</b> " . $e->getMessage() . "</span>\n";
}
