<?php
if ($vbulletin->options['neots_enable_product']) {
	/* load framework library */
	require_once("./teamspeak/TeamSpeak3.php");
	/* initialize */
	TeamSpeak3::init();
	$userinfo = $vbulletin->userinfo;
	$vbops = $vbulletin->options;
	
	$fields = array(
		'generate' => 2,
		'reset' => 4,
		'setuid' => 8,
		'viewer' => 16,
		'inherit' => 32,
	);
	$neots_perms = convert_bits_to_array($usergroup['neots_perms'], $fields);
	
	print_table_header($vbphrase['neots_perms']);
	foreach($neots_perms as $key => $value) {
		print_yes_no_row($vbphrase['neots_'.$key], 'usergroup[neots_perms]['.$key.']', $value);
	}	
	print_input_row($vbphrase['neots_tokenlimit'], 'usergroup[neots_tokenlimit]', $usergroup['neots_tokenlimit'], NULL, '20');
	print_table_break();
	
	
	print_table_header($vbphrase['neots_ugp_sperms']);
	try {
		$ts3_VirtualServer = TeamSpeak3::factory("serverquery://".$vbops['neots_uname'].":".$vbops['neots_pass']."@".$vbops['neots_ip'].":".$vbops['neots_port']."/?server_port=".$vbops['neots_id']);
	}
	catch(Exception $e) {
		print_label_row($vbphrase['neo_teamspeak'],fetch_error('neo_teamspeak_error', $e->getCode(), $e->getMessage()));
		$tsconnecterror = 1;
	}
	if(!$tsconnecterror) {
		try {
			
			$sgroups = $ts3_VirtualServer->serverGroupList();
			if ($usergroup['neots_sgroup'] != NULL) {
				$neots_sgroup = unserialize($usergroup['neots_sgroup']);
			}
			else {
				$neots_sgroup = array();
			}
			foreach($sgroups as $sgid => $sgroup) {
				if($sgroup["type"] != TeamSpeak3::GROUP_DBTYPE_REGULAR) continue;
				if (in_array($sgid, $neots_sgroup)) {
					$sgroup_select .= '<input type="checkbox" name="neots_sgroup[]" value="' . $sgid . '" checked="checked" />' . $sgroup . ' ';	
				}
				else
				{
					$sgroup_select .= '<input type="checkbox" name="neots_sgroup[]" value="' . $sgid . '" />' . $sgroup . ' ';	
				}
			}
			print_label_row($vbphrase['neots_default_groupid'],$sgroup_select);
			print_table_footer('2','','',FALSE);
		}
		catch(Exception $e) {
			print_label_row($vbphrase['neo_teamspeak'],fetch_error('neo_teamspeak_error', $e->getCode(), $e->getMessage()));
		}
	?>
	<script type="text/javascript">
		function setAll(val) {
			var parent = document.getElementById('neots_cgroup');
			var chks = parent.getElementsByTagName('input');
			for(var i = 0; i < chks.length; i++) {
				if(chks[i].type == 'radio') {
					if(chks[i].value == val)
					chks[i].checked = 'true';
				}
			}
		}
	</script>
	<?PHP
		print_table_start(FALSE, '90%', 0, 'neots_cgroup');
		try {
			$cgroups = $ts3_VirtualServer->channelGroupList();
			$clist = $ts3_VirtualServer->channelList();
			if ($usergroup['neots_cgroup'] != NULL) {
				$neots_cgroup = unserialize($usergroup['neots_cgroup']);
			}
			else {
				$neots_cgroup = array();
			}
			foreach($cgroups as $cgid => $cgroup) {
				if($cgroup["type"] != TeamSpeak3::GROUP_DBTYPE_REGULAR) continue;
				$cgroupall .= '<input type="button" class="button" id="neots_cgroup" value="All '.$cgroup.'" onclick="setAll('.$cgid.');" />';
			}
			$cgroupall .= '<input type="button" class="button" id="neots_cgroup" value="All None" onclick="setAll(0);" />';
			print_label_row("<b>Channel Groups</b>",$cgroupall.'<input type="submit" class="button" value="Okay" class="button" />', 'tcat', 'middle');
			foreach($clist as $cid => $channel_name) {
				$cgroup_select = '<div id="ctrl_usergroup[neots_cgroup]['.$cid.']" class="smallfont" style="white-space:nowrap">';
				$uniqueid = fetch_uniqueid_counter();
				foreach($cgroups as $cgid => $cgroup) {
					if($cgroup["type"] != TeamSpeak3::GROUP_DBTYPE_REGULAR) continue;
					if($neots_cgroup[$cid] == $cgid) {
						$cgroup_select .= '<label for="rb_'.$cgid.'_usergroup[neots_cgroup]['.$cid.']_'.$uniqueid.'"><input type="radio" name="neots_cgroup['.$cid.']" id="rb_'.$cgid.'_usergroup[neots_cgroup]['.$cid.']_'.$uniqueid.'" value="'.$cgid.'" checked="checked" />'.$cgroup.'</label>';
					}
					else {
						$cgroup_select .= '<label for="rb_'.$cgid.'_usergroup[neots_cgroup]['.$cid.']_'.$uniqueid.'"><input type="radio" name="neots_cgroup['.$cid.']" id="rb_'.$cgid.'_usergroup[neots_cgroup]['.$cid.']_'.$uniqueid.'" value="'.$cgid.'" />'.$cgroup.'</label>';
					}
				}
				$cgroup_select .= '<label for="rb_0_usergroup[neots_cgroup]['.$cid.']_'.$uniqueid.'"><input type="radio" name="neots_cgroup['.$cid.']" id="rb_0_usergroup[neots_cgroup]['.$cid.']_'.$uniqueid.'" value="0" />None</label></div>';
				print_label_row($channel_name,$cgroup_select);
				unset($cid,$channel_name,$cgroup_select,$uniqueid);
			}
			print_label_row("<b>Channel Groups</b>",$cgroupall.'<input type="submit" class="button" value="Okay" class="button" />', 'tcat', 'middle');
		}
		catch(Exception $e) {
			print_label_row($vbphrase['neo_teamspeak'],fetch_error('neo_teamspeak_error', $e->getCode(), $e->getMessage()));
		}
	}
	print_table_break();
}
?>