<?php
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'neoteamspeaklog');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('logging', 'threadmanage');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_log_error.php');

// ############################# LOG ACTION ###############################
if (!can_administer('canadminmodlog'))
{
	print_cp_no_permission();
}

log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['moderator_log']);

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'choose';
}

// ###################### Start view #######################
if ($_REQUEST['do'] == 'view')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'perpage'    => TYPE_UINT,
		'pagenumber' => TYPE_UINT,
		'userid'     => TYPE_UINT,
		'orderby'    => TYPE_NOHTML,
		'startdate'  => TYPE_UNIXTIME,
		'enddate'    => TYPE_UNIXTIME,
		'uid'		 => TYPE_STR,
	));


	$sqlconds = array();
	$hook_query_fields = $hook_query_joins = '';

	if ($vbulletin->GPC['perpage'] < 1)
	{
		$vbulletin->GPC['perpage'] = 15;
	}

	if ($vbulletin->GPC['userid'])
	{
		$sqlconds[] = "teamspeaklog.userid = " . $vbulletin->GPC['userid'];
	}
	
	if ($vbulletin->GPC['uid']) 
	{
		$sqlconds[] = "teamspeaklog.old_uid LIKE '%" . $vbulletin->GPC['uid'] . "%' OR teamspeaklog.new_uid LIKE '%" . $vbulletin->GPC['uid'] . "%'";
	}	

	if ($vbulletin->GPC['startdate'])
	{
		$sqlconds[] = "teamspeaklog.dateline >= " . $vbulletin->GPC['startdate'];
	}

	if ($vbulletin->GPC['enddate'])
	{
 		$sqlconds[] = "teamspeaklog.dateline <= " . $vbulletin->GPC['enddate'];
	}

	$counter = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "teamspeaklog AS teamspeaklog
		" . (!empty($sqlconds) ? "WHERE " . implode("\r\n\tAND ", $sqlconds) : "") . "
	");
	$totalpages = ceil($counter['total'] / $vbulletin->GPC['perpage']);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	$startat = ($vbulletin->GPC['pagenumber'] - 1) * $vbulletin->GPC['perpage'];

	switch($vbulletin->GPC['orderby'])
	{
		case 'user':
			$order = 'username ASC, dateline DESC';
			break;
		case 'date':
		default:
			$order = 'dateline DESC';
	}

	$logs = $db->query_read("
		SELECT teamspeaklog.*, user.username, changeduser.username as changedusername
			$hook_query_fields
		FROM " . TABLE_PREFIX . "teamspeaklog AS teamspeaklog
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid=teamspeaklog.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS changeduser ON (changeduser.userid=teamspeaklog.changeduserid)
		$hook_join_fields
		" . (!empty($sqlconds) ? "WHERE " . implode("\r\n\tAND ", $sqlconds) : "") . "
		ORDER BY $order
		LIMIT $startat, " . $vbulletin->GPC['perpage'] . "
	");

	if ($db->num_rows($logs))
	{
		if ($vbulletin->GPC['pagenumber'] != 1)
		{
			$prv = $vbulletin->GPC['pagenumber'] - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='neoteamspeaklog.php?" . $vbulletin->session->vars['sessionurl'] . "do=view&uid=" . $vbulletin->GPC['uid'] . "&u=" . $vbulletin->GPC['userid'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='neoteamspeaklog.php?" . $vbulletin->session->vars['sessionurl'] . "do=view&uid=" . $vbulletin->GPC['uid'] . "&u=" . $vbulletin->GPC['userid'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$prv'\">";
		}

		if ($vbulletin->GPC['pagenumber'] != $totalpages)
		{
			$nxt = $vbulletin->GPC['pagenumber'] + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='neoteamspeaklog.php?" . $vbulletin->session->vars['sessionurl'] . "do=view&uid=" . $vbulletin->GPC['uid'] . "&u=" . $vbulletin->GPC['userid'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='neoteamspeaklog.php?" . $vbulletin->session->vars['sessionurl'] . "do=view&uid=" . $vbulletin->GPC['uid'] . "&u=" . $vbulletin->GPC['userid'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$totalpages'\">";
		}

		print_form_header('neoteamspeaklog', 'remove');
		print_description_row(construct_link_code($vbphrase['restart'], "neoteamspeaklog.php?" . $vbulletin->session->vars['sessionurl'] . ""), 0, 7, 'thead', vB_Template_Runtime::fetchStyleVar('right'));
		print_table_header(construct_phrase($vbphrase['moderator_log_viewer_page_x_y_there_are_z_total_log_entries'], vb_number_format($vbulletin->GPC['pagenumber']), vb_number_format($totalpages), vb_number_format($counter['total'])), 7);

		$headings = array();
		$headings[] = $vbphrase['id'];
		$headings[] = "<a href=\"neoteamspeaklog.php?" . $vbulletin->session->vars['sessionurl'] . "do=view&uid=" . $vbulletin->GPC['uid'] . "&u=" . $vbulletin->GPC['userid'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=user&page=" . $vbulletin->GPC['pagenumber'] . "\">" . str_replace(' ', '&nbsp;', $vbphrase['username']) . "</a>";
		$headings[] = "<a href=\"neoteamspeaklog.php?" . $vbulletin->session->vars['sessionurl'] . "do=view&uid=" . $vbulletin->GPC['uid'] . "&u=" . $vbulletin->GPC['userid'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=date&page=" . $vbulletin->GPC['pagenumber'] . "\">" . str_replace(' ', '&nbsp;', $vbphrase['changed_username']) . "</a>";
		$headings[] = "<a href=\"neoteamspeaklog.php?" . $vbulletin->session->vars['sessionurl'] . "do=view&uid=" . $vbulletin->GPC['uid'] . "&u=" . $vbulletin->GPC['userid'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=date&page=" . $vbulletin->GPC['pagenumber'] . "\">" . $vbphrase['date'] . "</a>";
		$headings[] = "Old UID";
		$headings[] = "New UID";
		$headings[] = str_replace(' ', '&nbsp;', $vbphrase['ip_address']);
		print_cells_row($headings, 1);

		while ($log = $db->fetch_array($logs))
		{
			$cell = array();
			$cell[] = $log['teamspeaklogid'];
			$cell[] = "<a href=\"user.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&u=$log[userid]\"><b>$log[username]</b></a>";
			$cell[] = "<a href=\"user.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&u=$log[changeduserid]\"><b>$log[changedusername]</b></a>";
			$cell[] = '<span class="smallfont">' . vbdate($vbulletin->options['logdateformat'], $log['dateline']) . '</span>';
			if (is_array(unserialize($log['old_uid']))) {
				foreach (unserialize($log['old_uid']) as $old_uid_id => $old_uid_uid) {
					if($old_uid_uid)
					$old_uid_cell .= $old_uid_uid.', ';
				}
			}
			else {
				$old_uid_cell = $log['old_uid'];
			}
			if (is_array(unserialize($log['new_uid']))) {
				foreach (unserialize($log['new_uid']) as $new_uid_id => $new_uid_uid) {
					if($new_uid_uid)
					$new_uid_cell .= $new_uid_uid.', ';
				}
			}
			else {
				$new_uid_cell = $log['new_uid'];
			}

			$cell[] = substr($old_uid_cell, 0, -2);
			
			$cell[] = substr($new_uid_cell, 0, -2);

			$cell[] = '<span class="smallfont">' . iif($log['ipaddress'], "<a href=\"usertools.php?" . $vbulletin->session->vars['sessionurl'] . "do=gethost&ip=$log[ipaddress]\">$log[ipaddress]</a>", '&nbsp;') . '</span>';

			print_cells_row($cell, 0, 0, -4);
			unset($old_uid_cell, $new_uid_cell);
		}

		print_table_footer(7, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		print_stop_message('no_results_matched_your_query');
	}
}

// ###################### Start prune log #######################
if ($_REQUEST['do'] == 'prunelog')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'daysprune' => TYPE_UINT,
		'userid'    => TYPE_UINT,
	));

	$datecut = TIMENOW - (86400 * $vbulletin->GPC['daysprune']);

	$sqlconds = array("dateline < $datecut");
	if ($vbulletin->GPC['userid'])
	{
		$sqlconds[] = "userid = " . $vbulletin->GPC['userid'];

	}

	$logs = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "teamspeaklog
		WHERE " . (!empty($sqlconds) ? implode("\r\n\tAND ", $sqlconds) : "") . "
	");
	if ($logs['total'])
	{
		print_form_header('neoteamspeaklog', 'doprunelog');
		construct_hidden_code('datecut', $datecut);
		construct_hidden_code('userid', $vbulletin->GPC['userid']);
		print_table_header($vbphrase['prune_moderator_log']);
		print_description_row(construct_phrase($vbphrase['are_you_sure_you_want_to_prune_x_log_entries_from_moderator_log'], vb_number_format($logs['total'])));
		print_submit_row($vbphrase['yes'], 0, 0, $vbphrase['no']);
	}
	else
	{
		print_stop_message('no_logs_matched_your_query');
	}

}

// ###################### Start do prune log #######################
if ($_POST['do'] == 'doprunelog')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'datecut'   => TYPE_UINT,
		'userid'    => TYPE_UINT,
	));

	$sqlconds = array("dateline < " . $vbulletin->GPC['datecut']);
	if (!empty($vbulletin->GPC['userid']))
	{
		$sqlconds[] = "userid = " . $vbulletin->GPC['userid'];
	}

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "teamspeaklog
		WHERE " . (!empty($sqlconds) ? implode("\r\n\tAND ", $sqlconds) : "") . "
	");

	define('CP_REDIRECT', 'neoteamspeaklog.php?do=choose');
	print_stop_message('pruned_moderator_log_successfully');
}

// ###################### Start modify #######################
if ($_REQUEST['do'] == 'choose')
{
	$users = $db->query_read("
		SELECT DISTINCT teamspeaklog.userid, user.username
		FROM " . TABLE_PREFIX . "teamspeaklog AS teamspeaklog
		INNER JOIN " . TABLE_PREFIX . "user AS user USING(userid)
		ORDER BY username
	");
	$userlist = array('no_value' => $vbphrase['all_log_entries']);
	while ($user = $db->fetch_array($users))
	{
		$userlist["$user[userid]"] = $user['username'];
	}
	$perpage_options = array(
		5 => 5,
		10 => 10,
		15 => 15,
		20 => 20,
		25 => 25,
		30 => 30,
		40 => 40,
		50 => 50,
		100 => 100,
	);

	print_form_header('neoteamspeaklog', 'view');
	print_table_header($vbphrase['moderator_log_viewer']);
	print_select_row($vbphrase['log_entries_to_show_per_page'], 'perpage', $perpage_options, 15);
	print_input_row('Search by UID', 'uid');
	print_select_row($vbphrase['show_only_entries_generated_by'], 'userid', $userlist);
	print_time_row($vbphrase['start_date'], 'startdate', 0, 0);
	print_time_row($vbphrase['end_date'], 'enddate', 0, 0);
	print_select_row($vbphrase['order_by'], 'orderby', array('date' => $vbphrase['date'], 'user' => $vbphrase['username']), 'date');
	print_submit_row($vbphrase['view'], 0);

	print_form_header('neoteamspeaklog', 'prunelog');
	print_table_header($vbphrase['prune_moderator_log']);
	print_select_row($vbphrase['remove_entries_logged_by_user'], 'userid', $userlist);
	print_input_row($vbphrase['remove_entries_older_than_days'], 'daysprune', 30);
	print_submit_row($vbphrase['prune_log_entries'], 0);

}

print_cp_footer();

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 00:42, Mon Jan 10th 2011
|| # CVS: $RCSfile$ - $Revision: 32878 $
|| ####################################################################
\*======================================================================*/
?>