<?PHP
/*======================================================================*\
|| #################################################################### ||
|| # Neoobs - TeamSpeak 3 Integration 
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2011 Neoobs. All Rights Reserved.                     # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('cpglobal');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

/* load framework library */
require_once(DIR . '/teamspeak/TeamSpeak3.php');
/* initialize */
TeamSpeak3::init();
/* set standard variables */

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminsettings')) {
	print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################
function fetch_userid_from_username($username)
{
	global $vbulletin;
	if ($user = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . $vbulletin->db->escape_string(trim($username)) . "'")) {
		return $user['userid'];
	}
	else {
		return false;
	}
}

$post_userid = $_POST['userid'];
$post_cluid = $_POST['cluid'];
$post_vbid = $_POST['vbid'];
$post_vbuser = $_POST['vbuser'];
$userinfo = $vbulletin->userinfo;
$perms = cache_permissions($userinfo);
$vbops = $vbulletin->options;

if($_REQUEST['do'] != 'install') {
	print_cp_header('Neoobs\'s Teamspeak Integration Settings');
}
if (empty($_REQUEST['do'])) {
	$_REQUEST['do'] = 'index';
}
if (isset($vbulletin->options['neots_uname'], $vbulletin->options['neots_pass'], $vbulletin->options['neots_ip'], $vbulletin->options['neots_port'], $vbulletin->options['neots_id'])) {
	try {
		$ts3_VirtualServer = TeamSpeak3::factory("serverquery://".$vbops['neots_uname'].":".$vbops['neots_pass']."@".$vbops['neots_ip'].":".$vbops['neots_port']."/?server_port=".$vbops['neots_id']."#no_query_clients");
		
		// ###################### Add Token ########################
		if ($_REQUEST['do'] == 'create') {
			$customuser = fetch_userinfo($post_userid, 2);
			$custperms = cache_permissions($customuser);
			$tokens = $customuser['neots_token'];
			if ($tokens >= $custperms['neots_tokenlimit']) {
				// Create override to allow admin to give out tokens
				print_cp_message(construct_phrase($vbphrase['neots_tokenlimit'], $customuser['username'], $tokens), NULL, '1', 'neoteamspeak.php?do=index');
			}
			elseif ($tokens < $custperms['neots_tokenlimit']) {
				$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_ARRAY);
				$existing = array( 
					'userid' => $customuser['userid'],
					'username' => $customuser['username'],
				);
				$userdata->set_existing($existing);
				$userdata->set('neots_token', $tokens+1);
				$userdata->pre_save();
				if (!empty($userdata->errors)) { 
					$errorlist = ''; 
					foreach ($userdata->errors AS $index => $error) { 
						$errorlist .= "<li>$error</li>";
						break; 
					}
					eval(standard_error(fetch_error('neo_db_error', $errorlist)));
				}
				else {
					$customFieldSet = "ident=vbuser value=".$customuser['username']."|ident=vbid value=".$customuser['userid'];
					if($custperms['neots_sgroup']) {
						$ugid = unserialize($custperms['neots_sgroup']);
						$ugid = $ugid[0];
					}
					try {
						if (isset($customFieldSet, $ugid, $vbulletin->userinfo['username'])) {
							$token=$ts3_VirtualServer->privilegeKeyCreate(0,$ugid,0,"Auto Generated For ".$customuser['username'],$customFieldSet);
							$ts_group = $ts3_VirtualServer->serverGroupGetById($ugid);
						}
					}
					catch(Exception $e) {
						print_stop_message('neo_teamspeak_error', $e->getCode(), $e->getMessage());
					}
					$userdata->save();
					print_cp_message(construct_phrase($vbphrase['neots_createtoken'], $customuser['username'], $tokens, $custperms['neots_tokenlimit'], $token, $ts_group, $vbops['neots_ip'], $vbops['neots_id'], $vbops['neots_bookmark']), 'neoteamspeak.php?do=index', NULL, NULL, TRUE);
				}
			}
		}
		
		// ##################### Reset Token #######################
		if ($_REQUEST['do'] == 'reset') {
			$customuser = fetch_userinfo($post_userid, 2);
			$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_ARRAY);
			$existing = array( 
				'userid' => $customuser['userid'],
				'username' => $customuser['username'],
			);
			$userdata->set_existing($existing);
			$userdata->set('neots_token', '0');
			$userdata->pre_save();
			if (!empty($userdata->errors)) { 
				$errorlist = ''; 
				foreach ($userdata->errors AS $index => $error) { 
					$errorlist .= "<li>$error</li>";
					break; 
				}
				eval(standard_error(fetch_error('neo_db_error', $errorlist)));
			}
			else {
				$userdata->save();
				print_cp_message(construct_phrase($vbphrase['neots_resetsuccess'], $customuser['username']), 'neoteamspeak.php?do=index', '1');
			}
		}
		
		// ###################### Group IDs #######################
		if ($_REQUEST['do'] == 'groupids') {
			print_table_start(TRUE, '200px');
			print_table_header('Server Group IDs', '2');
			$rowheader = array( 
				'Group ID',
				'Group Name', );
			print_cells_row($rowheader, TRUE);
			try {
				$sgroups = $ts3_VirtualServer->serverGroupList();
				$cgroups = $ts3_VirtualServer->channelGroupList();
				$s = 0;
				$c = 0;
				if(is_array($sgroups)) {
					foreach($sgroups as $sgid => $sgroup) {
						if($sgroup["type"] != TeamSpeak3::GROUP_DBTYPE_REGULAR) continue;
						$row = array(
							$sgid,
							$sgroup, );
							
						print_cells_row($row);
						$s++;
						if(!($s % 10)) {
							print_cells_row($rowheader, TRUE);
						}
						unset($sgroup, $sgid, $row);
					}
				}
				print_table_header('Channel Group IDs', '2');
				print_cells_row($rowheader, TRUE);
				if(is_array($cgroups)) {
					foreach($cgroups as $cgid => $cgroup) {
						if($cgroup["type"] != TeamSpeak3::GROUP_DBTYPE_REGULAR) continue;
						$row = array(
							$cgid,
							$cgroup, );
						print_cells_row($row);
						$c++;
						if(!($c % 10)) {
							print_cells_row($rowheader, TRUE);
						}
						unset($cgroup, $cgid, $row);
					}
				}
			}
			catch(Exception $e) {
				print_stop_message('neo_teamspeak_error', $e->getCode(), $e->getMessage());
			}
			print_cells_row($rowheader, TRUE);
			print_table_footer('2');
		}
		
		
		// ##################### Lookup Start #######################
		if ($_REQUEST['do'] == 'dolookup') {
			$vbulletin->input->clean_array_gpc('r', array(
				'limitstart'        => TYPE_UINT,
				'limitnumber'       => TYPE_UINT,
				'vbuser'			=> TYPE_NOTRIM,
				'cluid'				=> TYPE_STR
			));	
			if (empty($vbulletin->GPC['limitstart'])) {
				$vbulletin->GPC['limitstart'] = 0;
			}
			else {
				$vbulletin->GPC['limitstart']--;
			}
			if (empty($vbulletin->GPC['limitnumber']) OR $vbulletin->GPC['limitnumber'] == 0) {
				$vbulletin->GPC['limitnumber'] = 25;
			}
			if (!empty($vbulletin->GPC['cluid'])) {
				try {
					$searchquery1 = $ts3_VirtualServer->clientFindDb($vbulletin->GPC['cluid'], true);
					foreach ($searchquery1 as $dbid) {
						$searchquery2 = $ts3_VirtualServer->clientInfoDb($dbid);
						$searchquery2['cldbid'] = $searchquery2['client_database_id'];
						unset($searchquery2['client_database_id']);
						$searchquery[] = $searchquery2;
					}
					$countusers = count($searchquery);
				}
				catch (Exception $e) {
					print_stop_message('neo_teamspeak_error', $e->getCode(), $e->getMessage());
				}
			}
			if (!empty($vbulletin->GPC['vbuser'])) {
				try {
					$searchquery1 = $ts3_VirtualServer->clientFindDb($vbulletin->GPC['vbuser']);
					foreach ($searchquery1 as $dbid) {
						$searchquery2 = $ts3_VirtualServer->clientInfoDb($dbid);
						$searchquery2['cldbid'] = $searchquery2['client_database_id'];
						unset($searchquery2['client_database_id']);
						$searchquery[] = $searchquery2;
					}
					$countusers = count($searchquery);
				}
				catch (Exception $e) {
					print_stop_message('neo_teamspeak_error', $e->getCode(), $e->getMessage());
				}
			}
			if (empty($vbulletin->GPC['vbuser']) AND empty($vbulletin->GPC['cluid'])) {
				try {
					$searchquery = $ts3_VirtualServer->clientListDb($vbulletin->GPC['limitstart'], $vbulletin->GPC['limitnumber']);
					while ($count = current($searchquery)) {
						if ($count['count']) {
							$countusers = $count['count'];
						}
						next($searchquery);
					}
				}
				catch (Exception $e) {
					print_stop_message('neo_teamspeak_error', $e->getCode(), $e->getMessage());
				}
			}
			
			$users = $searchquery;
			if ($countusers == 0)
			{
				// no users found!
				print_stop_message('no_users_matched_your_query');
			}
			define('DONEFIND', true);
			$_REQUEST['do'] = 'dolookup2';
		}
		// ####################### Lookup #########################
		if ($_REQUEST['do'] == 'dolookup2' AND defined('DONEFIND')) {
			// carries on from do == find at top of script
			$limitfinish = $vbulletin->GPC['limitstart'] + $vbulletin->GPC['limitnumber'];
			// display the column headings
			$header = array();
			$header[] = 'Database ID';
			$header[] = 'Unique ID';
			$header[] = 'Nickname';
			$header[] = 'Created';
			$header[] = 'Last Connected';
			$header[] = 'Description';
			//$header[] = $vbphrase['options'];
			// get number of cells for use in 'colspan=' attributes
			$colspan = sizeof($header);
			// a little javascript for the options menus
			?>
			<script type="text/javascript">
			function js_usergroup_jump(userinfo)
			{
				var value = eval("document.cpform.u" + userinfo + ".options[document.cpform.u" + userinfo + ".selectedIndex].value");
				if (value != "")
				{
					switch (value)
					{
						case 'edit': page = "edit&u=" + userinfo; break;
						case 'kill': page = "remove&u=" + userinfo; break;
						case 'access': page = "editaccess&u=" + userinfo; break;
						default: page = "emailpassword&u=" + userinfo + "&email=" + value; break;
					}
					window.location = "user.php?<?php echo $vbulletin->session->vars['sessionurl_js']; ?>do=" + page;
				}
			}
			</script>
			<?php
			print_form_header('neoteamspeak', 'dolookup');
			print_table_header(
				construct_phrase(
					$vbphrase['showing_users_x_to_y_of_z'],
					($vbulletin->GPC['limitstart'] + 1),
					iif($limitfinish > $countusers['users'], $countusers['users'], $limitfinish),
					$countusers['users']
				), $colspan);
			print_cells_row($header, 1);
			// now display the results
			if (is_array($users)) {
				foreach ($users as $id => $user) {
					if ($user['client_nickname']) $user['userid'] = fetch_userid_from_username($user['client_nickname']);
					$cell = array();
					$cell[] = "<a href=\"neoteamspeak.php?".$vbulletin->session->vars['sessionurl']."do=edit&u=$user[cldbid]\">$user[cldbid]</a>&nbsp;";
					if ($user['userid']) $cell[] = "<a href=\"neoteamspeak.php?".$vbulletin->session->vars['sessionurl']."do=setuid&uid=$user[client_unique_identifier]&userid=$user[userid]\">$user[client_unique_identifier]</a>&nbsp;";
					else $cell[] = "<a href=\"neoteamspeak.php?".$vbulletin->session->vars['sessionurl']."do=setuid&uid=$user[client_unique_identifier]\">$user[client_unique_identifier]</a>&nbsp;";
					if ($user['userid']) $cell[] = "<a href=\"user.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&u=$user[userid]\"><b>$user[client_nickname]</b></a>&nbsp;";
					else $cell[] = "<b>$user[client_nickname]</b>&nbsp;";
					$cell[] = '<span class="smallfont">'.vbdate($vbulletin->options['dateformat'].' '.$vbulletin->options['timeformat'], $user['client_created']).'</span>';
					$cell[] = '<span class="smallfont">'.vbdate($vbulletin->options['dateformat'].' '.$vbulletin->options['timeformat'], $user['client_lastconnected']).'</span>';
					$cell[] = $user['client_description'];
					//$cell[] = "\n\t<select name=\"u$user[userid]\" onchange=\"js_usergroup_jump($user[userid]);\" class=\"bginput\"><option value=\"edit\">$vbphrase[view] / " . $vbphrase['edit_user'] . "</option>". iif(!empty($user['email']), "<option value=\"" . unhtmlspecialchars($user[email]) . "\">" . $vbphrase['send_password_to_user'] . "</option>") . "<option value=\"access\">" . $vbphrase['edit_access_masks'] . "</option><option value=\"kill\">" . $vbphrase['delete_user'] . "</option>\n\t</select><input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"js_usergroup_jump($user[userid]);\" />\n\t";
					print_cells_row($cell);
				}
			}
			construct_hidden_code('limitnumber', $vbulletin->GPC['limitnumber']);
			construct_hidden_code('orderby', $vbulletin->GPC['orderby']);
			construct_hidden_code('direction', $vbulletin->GPC['direction']);
			if ($vbulletin->GPC['limitstart'] == 0 AND $countusers['users'] > $vbulletin->GPC['limitnumber']) {
				construct_hidden_code('limitstart', $vbulletin->GPC['limitstart'] + $vbulletin->GPC['limitnumber'] + 1);
				print_submit_row($vbphrase['next_page'], 0, $colspan);
			}
			else if ($limitfinish < $countusers['users']) {
				construct_hidden_code('limitstart', $vbulletin->GPC['limitstart'] + $vbulletin->GPC['limitnumber'] + 1);
				print_submit_row($vbphrase['next_page'], 0, $colspan, $vbphrase['prev_page'], '', true);
			}
			else if ($vbulletin->GPC['limitstart'] > 0 AND $limitfinish >= $countusers['users']) {
				print_submit_row($vbphrase['first_page'], 0, $colspan, $vbphrase['prev_page'], '', true);
			}
			else {
				print_table_footer();
			}
		}
		
		// ####################### Set UID #########################
		if ($_REQUEST['do'] == 'dosetuid') {
			$vbulletin->input->clean_array_gpc('r', array(
				'neots'              => TYPE_NOCLEAN,
			));
			$neots = $vbulletin->GPC['neots'];
			foreach($neots as $id => $neots_user) {
				if($neots_user['userid']) {
					$user = fetch_userinfo($neots_user["userid"], 2);
					$vbulletin->GPC['user']['neots_uid'] = array($neots_user["neots_uid"]);
					$user['neots_uid'] = $vbulletin->GPC['user']['neots_uid'];
					$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_ARRAY);
					$existing = array( 
						'userid' => $user['userid'],
						'username' => $user['username'],
						'usergroupid' => $user['usergroupid'],
						'membergroupids' => $user['membergroupids'],
					);
					$userdata->set_existing($existing);
					$userdata->set('neots_uid', $user['neots_uid']);
					$userdata->pre_save();
					if (!empty($userdata->errors)) { 
						$errorlist = ''; 
						foreach ($userdata->errors AS $index => $error) { 
							$errorlist .= "<li>$error</li>";
							break; 
						}
						eval(standard_error(fetch_error('neo_db_error', $errorlist)));
					}
					else {
						$userdata->save();
					}
				}
			}
			print_cp_message('User UIDs saved', 'neoteamspeak.php?do=dolookup', '1');
		}	
		
		// ###################### Token List #######################
		if ($_REQUEST['do'] == 'tokenlist') {
			$vbulletin->input->clean_array_gpc('p', array('token' => TYPE_ARRAY));
			print_form_header('neoteamspeak', 'tokenlist');
			print_table_header('Token List', '5');
			$rowheader = array(
				'Token',
				'Group',
				'Created', 
				'Description',
				'Delete',);
			print_cells_row($rowheader, TRUE);
			if($vbulletin->GPC['token']) {
				foreach($vbulletin->GPC['token'] as $id => $token) {
					try {
						$ts3_VirtualServer->privilegeKeyDelete($token);
					}
					catch (Exception $e) {
						echo "Token delete unsuccessful";
					}
				}
			}
			try {
				$tokenlist = $ts3_VirtualServer->privilegeKeyList(TRUE);
				foreach($tokenlist as $token) {
					$token[token_created] = date("M j, Y, g:i a", $token[token_created]);
					$row = array(
						$token['token'],
						$token['token_id1'],
						$token['token_created'],
						$token['token_description'],
						'<input type="checkbox" name="token[]" value="'.$token["token"].'" />',);
					print_cells_row($row);
				}
			}
			catch (Exception $e) {
				print_description_row('Token List Unsuccessful', false, '5');
			}
			print_submit_row('Delete', 'Reset', '5');	
		}
		
		// #################### Install Script #####################
		if($_REQUEST['do'] == 'install') {
			if(!$vbulletin->options['neots_installed']) {
				if(!$_REQUEST['step']) {
					$_REQUEST['step'] = '1.0';
				}
				if($_REQUEST['step'] == '1.0') {
					$ts3_ServerInstance = TeamSpeak3::factory("serverquery://".$vbops['neots_uname'].":".$vbops['neots_pass']."@".$vbops['neots_ip'].":".$vbops['neots_port']."/");
					try {
						echo "Checking Permissions";
						$perm_snapshot_create = $ts3_ServerInstance->selfPermCheck('b_virtualserver_snapshot_create');
						$perm_snapshot_create = $perm_snapshot_create[b_virtualserver_snapshot_create][permvalue];
					}
					catch(exception $e) {
						print($e->getCode().' = '.$e->getMessage());
					}
				}
				if($_REQUEST['step'] == '1.2') {
					echo "Permission Error";
				}
				if($_REQUEST['step'] == '2.0') {
				}
				//print_r($snapshotxml);
				// Print form to be used in step 2
				
				// Step 2 (create if statement)
				// Try Template
				try {
					// Set permissions for server groups (ignore server admin)
					// Set permissions for channel groups (ignore channel admin)
					// Reset everyone to guest except for those in server admin (reset channel groups too, even those in channel admin)
					// 
				}
				catch(exception $e) {
					//echo "This Failed<br />";
					print($e->getCode().' = '.$e->getMessage());
					//print_stop_message('neo_teamspeak_error', $e->getCode(), $e->getMessage());
				}
				//echo "Did This<br />";
				// End Template
				// Set installed in db
				//$vbulletin->db->hide_errors();
				//$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = '1' WHERE varname = 'neots_installed' LIMIT 1");
				//$vbulletin->db->show_errors();
				//echo "Installed Successfully";
				// End of Install
			}
		}
		
		// ##################### Index Script ######################
		if($_REQUEST['do'] == 'index') {
			//Online Users
			print_table_start();
			print_table_header('Online Users');
			try {
				$clist = $ts3_VirtualServer->clientList();
				$online = 0;
				foreach($clist as $client) {
					if($onlinenames) {
						$onlinenames = $onlinenames.', '.$client['client_nickname'];
					}
					else {
						$onlinenames = $client['client_nickname'];
					}
					$online++;
				}
				if ($online == 1) {
					print_label_row('There is currently '.$online.' user online', 'With the following nickname: '.$onlinenames);
				}
				elseif ($online > 1) {
					print_label_row('There are currently '.$online.' users online', 'With the following nicknames: '.$onlinenames);
				}
				elseif ($online == 0) {
					print_description_row('There are currently no users online');
				}
			}
			catch (Exception $e) {
				print_description_row('Online List Failed');
			}
			print_table_footer();
			
			//Create Tokens
			print_form_header('neoteamspeak', 'create');
			print_table_header('Create Token');
			print_input_row($vbphrase['neots_userid'], 'userid');
			print_submit_row();
			
			//Reset Tokens
			print_form_header('neoteamspeak', 'reset');
			print_table_header('Reset Token');
			print_input_row($vbphrase['neots_userid'], 'userid');
			print_submit_row();
			
			//Lookup Search
			print_form_header('neoteamspeak', 'dolookup');
			print_table_header('Lookup Users');
			//print_input_row($vbphrase['neots_userid'], 'vbid');
			print_input_row($vbphrase['neots_username'], 'vbuser');
			print_input_row($vbphrase['neots_cluid'], 'cluid');
			print_submit_row();
			
			//Latest Clients
			print_form_header('neoteamspeak', 'dosetuid');
			print_table_header('10 Clients', '6');
			$rowheader = array(
				'Database ID',
				'Nickname',
				'Unique ID', 
				'Created',
				'Last Online',
				'Description',
				//'Add UID',
				);
			print_cells_row($rowheader, TRUE);
			try {
				$sortnum = count($ts3_VirtualServer->clientListDb());
				if($sortnum > 10) {
					$sortnum = $sortnum-10;
					$customsearch = $ts3_VirtualServer->clientListDb($sortnum,'10');
				}
				else {
					$customsearch = $ts3_VirtualServer->clientListDb('0',$sortnum);
				}
				if ($customsearch) {
					foreach ($customsearch as $dbid => $search) {
						$client = $ts3_VirtualServer->clientInfoDb($search[cldbid]);
						$client[cldbid] = $search[cldbid];
						$client[client_created] = date("M j, Y, g:i a", $client[client_created]);
						$client[client_lastconnected] = date("M j, Y, g:i a", $client[client_lastconnected]);
						$row = array(
							$client['cldbid'],
							$client['client_nickname'],
							$client['client_unique_identifier'],
							$client['client_created'],
							$client['client_lastconnected'],
							$client['client_description'],
							//'User ID:<input type="text" name="neots['.$client['cldbid'].'][userid]" size="5" /><input type="hidden" name="neots['.$client['cldbid'].'][neots_uid]" value="'.$client["client_unique_identifier"].'" />',
							);
						print_cells_row($row);
						unset($search, $row);
					}
				}
				else {
				}
			}
			catch (Exception $e) {
				print_description_row('Client List Unsuccessful', false, '6');
			}
			print_submit_row('Save', 'Reset', '6');
			
			//Token List
			print_form_header('neoteamspeak', 'tokenlist');
			print_table_header('Token List', '5');
			$rowheader = array(
				'Token',
				'Group',
				'Created', 
				'Description',
				'Delete',);
			print_cells_row($rowheader, TRUE);
			try {
				$tokenlist = $ts3_VirtualServer->privilegeKeyList(TRUE);
				$offset = count($tokenlist);
				if($offset > 10) {
					$offset = $offset-10;
				}
				else {
					$offset = 0;
				}
				asort($tokenlist, SORT_NUMERIC);
				$tokenlist = array_splice($tokenlist, $offset, 10);
				foreach($tokenlist as $token) {
					$token[token_created] = date("M j, Y, g:i a", $token[token_created]);
					$row = array(
						$token['token'],
						$token['token_id1'],
						$token['token_created'],
						$token['token_description'],
						'<input type="checkbox" name="token[]" value="'.$token["token"].'" />',);
					print_cells_row($row);
				}
			}
			catch (Exception $e) {
				print_description_row('Token List Unsuccessful', false, '5');
			}
			print_submit_row('Delete', 'Reset', '5');
		}
		
		// ###################### Test Only ########################
		if ($_REQUEST['do'] == 'test') {
			//$ts3_VirtualServer->message('Testing 1 2 3');
			try {
			}
			catch(Exception $e) {
				print_label_row($vbphrase['neo_teamspeak'],fetch_error('neo_teamspeak_error', $e->getCode(), $e->getMessage()));
			}
		}
	}
	catch(Exception $e) {
		print_stop_message('neo_teamspeak_error', $e->getCode(), $e->getMessage());
	}
}
if($_REQUEST['do'] != 'install') {
	print_cp_footer();
}
/*======================================================================*\
|| ####################################################################
|| Copyright Neoobs. This file may not be redistributed
|| ####################################################################
\*======================================================================*/
?>