function toggle_active(formobj, active)
{
	for (var i =0; i < formobj.elements.length; i++)
	{
		var elm = formobj.elements[i];
		if (elm.type == 'checkbox' && !elm.disabled)
		{
			elm.checked = active;
		}
	}
}

// -------------------------------------------

function TMS_AJAX_StyleVarEditor(styleid)
{
	this.styleid = styleid;
	this.stylevarid = null;
	this.messageobj = null;
	this.container = null;
	this.originalhtml = null;
	this.ajax = null;
	this.pending = false;
}

TMS_AJAX_StyleVarEditor.prototype.ready = function()
{
	if (this.pending)
	{
		return false;
	}
	else
	{
		return true;
	}
};

TMS_AJAX_StyleVarEditor.prototype.edit = function()
{
	var test_ajax = new vB_AJAX_Handler(true);
	if (!test_ajax.init())
	{
		// couldn't initialize, return true to allow click to go through
		alert('not inited');
		return true;
	}

	if (this.pending)
	{
		// something is waiting to complete
		return false;
	}
	else if (!this.ready())
	{
		alert('no ready');
		return true;
	}

	//this.styleid = styleid;
	this.stylevarid = 'left';
	this.fetch_editor();

	return false;
};

TMS_AJAX_StyleVarEditor.prototype.fetch_editor = function()
{
	document.body.style.cursor = 'wait';
	this.ajax = new vB_AJAX_Handler(true);
	this.ajax.onreadystatechange(this.display_editor);
	this.ajax.send('templateedits.php?do=fetchstylevareditor&stylevarid=' + document.tmsstylevars.stylevarid.options[document.tmsstylevars.stylevarid.selectedIndex].innerHTML + '&dostyleid' + this.styleid, 'do=fetchstylevareditor&stylevarid=' + document.tmsstylevars.stylevarid.options[document.tmsstylevars.stylevarid.selectedIndex].innerHTML + '&dostyleid=' + this.styleid + '&adminhash=' + ADMINHASH + '&ajax=1');
	this.pending = true;
};

TMS_AJAX_StyleVarEditor.prototype.display_editor = function()
{
	var AJAX = tmsstylevareditor.ajax.handler;

	if (AJAX.readyState == 4 && AJAX.status == 200)
	{
		document.body.style.cursor = 'auto';
		tmsstylevareditor.pending = false;

/*
		if (fetch_tag_count(AJAX.responseXML, 'errors'))
		{
			var errors = fetch_tags(AJAX.responseXML, 'error');
			for (var i = 0; i < errors.length; i++)
			{
				alert(tmseditor.ajax.fetch_data(errors[i]));
			}
		}
		else
		{
			var templateedit = fetch_tags(AJAX.responseXML, 'templateedit')[0];

			// display the editor
			fetch_object('tmsedit').innerHTML = tmseditor.ajax.fetch_data(templateedit);		
		}
*/
			fetch_object('tmsstylevaredits').innerHTML = AJAX.responseText;
			init_color_preview();
			var tds = fetch_tags(fetch_object("swatches"), "td");
			for (var i = 0; i < tds.length; i++)
			{
				tds[i].onclick = swatch_click;
				tds[i].onmouseover = swatch_over;
			}

		if (is_ie)
		{
			AJAX.abort();
		}
		
		return false;
	}
};

TMS_AJAX_StyleVarEditor.prototype.abort = function(e)
{
	document.body.style.cursor = 'auto';
	fetch_object('tmsstylevaredits').innerHTML = '';
};

TMS_AJAX_StyleVarEditor.prototype.save = function(e)
{
	tmsform = fetch_object('tmsstylevar');

	document.body.style.cursor = 'wait';

	tmsstylevareditor.ajax = new vB_AJAX_Handler(true);
	tmsstylevareditor.ajax.onreadystatechange(tmsstylevareditor.update);
	var url = 'stylevar.php?do=savestylevar';
	var submitstring = 'do=savestylevar&adminhash=' + ADMINHASH;

	for (i = 0; i < tmsform.elements.length; i++)
	{
		var obj = tmsform.elements[i];

		if (obj.name && !obj.disabled)
		{
			switch (obj.type)
			{
				case 'text':
				case 'textarea':
				case 'hidden':
					submitstring += '&' + obj.name + '=' + PHP.urlencode(obj.value);
					break;
				case 'checkbox':
				case 'radio':
					submitstring += obj.checked ? '&' + obj.name + '=' + PHP.urlencode(obj.value) : '';
					break;
				case 'select':
				case 'select-one':
					submitstring += '&' + obj.name + '=' + PHP.urlencode(obj.options[obj.selectedIndex].value);
					break;
			}
		}
	}

	tmsstylevareditor.ajax.send(url, submitstring);

	tmsstylevareditor.pending = true;
	
	return false;
};

TMS_AJAX_StyleVarEditor.prototype.update = function()
{
	var AJAX = tmsstylevareditor.ajax.handler;

	if (AJAX.readyState == 4 && AJAX.status == 200)
	{
		document.body.style.cursor = 'auto';
		//var templateedits = fetch_tags(AJAX.responseXML, 'templateedits')[0];
		fetch_object('tmsstylevaredits').innerHTML = '';
		//fetch_object('tmsedits').innerHTML = tmseditor.ajax.fetch_data(templateedits);
		tmsstylevareditor.pending = false;

		if (is_ie)
		{
			AJAX.abort();
		}
	}

	return false;
};

// -------------------------------------------

function TMS_AJAX_UpdateActive()
{
	this.ajax = null;
	this.pending = false;
}


TMS_AJAX_UpdateActive.prototype.update_active = function()
{
	var test_ajax = new vB_AJAX_Handler(true);
	
	if (!test_ajax.init())
	{
		return true;
	}

	if (this.pending)
	{
		// something is waiting to complete
		return false;
	}

	document.body.style.cursor = 'wait';

	this.ajax = new vB_AJAX_Handler(true);
	this.ajax.onreadystatechange(this.status_updated);

	tmsform = fetch_object('tmsstatus');

	document.body.style.cursor = 'wait';

	var url = 'templateedits.php?do=updateactive&ajax=1';
	var submitstring = 'do=updateactive&ajax=1';

	for (i = 0; i < tmsform.elements.length; i++)
	{
		var obj = tmsform.elements[i];

		if (obj.name && !obj.disabled)
		{
			switch (obj.type)
			{
				case 'text':
				case 'textarea':
				case 'hidden':
					submitstring += '&' + obj.name + '=' + PHP.urlencode(obj.value);
					break;
				case 'checkbox':
				case 'radio':
					submitstring += obj.checked ? '&' + obj.name + '=' + PHP.urlencode(obj.value) : '';
					break;
				case 'select':
				case 'select-one':
					submitstring += '&' + obj.name + '=' + PHP.urlencode(obj.options[obj.selectedIndex].value);
					break;
			}
		}
	}

	this.ajax.send(url, submitstring);

	this.pending = true;

	return false;
};

TMS_AJAX_UpdateActive.prototype.status_updated = function()
{
	var AJAX = tmsupdate.ajax.handler;

	if (AJAX.readyState == 4 && AJAX.status == 200)
	{
		tmsupdate.pending = false;

		document.body.style.cursor = 'auto';

		var templateedits = fetch_tags(AJAX.responseXML, 'templateedits')[0];
		fetch_object('tmsedits').innerHTML = tmsupdate.ajax.fetch_data(templateedits);
		
		if (fetch_tag_count(AJAX.responseXML, 'errors'))
		{
			alert(tmsupdate.ajax.fetch_data(fetch_tags(AJAX.responseXML, 'errors')[0]));
		}

		if (is_ie)
		{
			AJAX.abort();
		}
	}
};


// -------------------------------------------


function TMS_AJAX_TemplateFetch()
{
	this.ajax = null;
	this.pending = false;
}


TMS_AJAX_TemplateFetch.prototype.fetch_template = function()
{
	var test_ajax = new vB_AJAX_Handler(true);
	var template = fetch_object('tmsform').template.value;
	var styleid = fetch_object('tmsform').styleid.value;
	
	if (!test_ajax.init())
	{
		// couldn't initialize, return true to allow click to go through
		window.open('templateedits.php?' + SESSIONURL + 'do=viewtemplate&amp;title=' + template  + '&amp;styleid=' + styleid, 'templateview','resizable=yes,width=' + (screen.width - (screen.width/10)) + ',height=600');
		return false;
	}

	if (this.pending)
	{
		// something is waiting to complete
		return false;
	}

	document.body.style.cursor = 'wait';

	this.ajax = new vB_AJAX_Handler(true);
	this.ajax.onreadystatechange(this.display_template);
	this.ajax.send('templateedits.php?' + SESSIONURL + 'do=viewtemplate&ajax=1&title=' + template  + '&styleid=' + styleid);

	this.pending = true;

	return false;
};


TMS_AJAX_TemplateFetch.prototype.fetch_modified_template = function()
{
	var test_ajax = new vB_AJAX_Handler(true);
	var template = fetch_object('tmsform').template.value;
	var styleid = fetch_object('tmsform').styleid.value;
	var showcomments = fetch_object('rb_1_showcomments_3').checked;
	var adminhash = fetch_object('tmsform').adminhash.value;
	
	if (!test_ajax.init())
	{
		// couldn't initialize, return true to allow click to go through
		return true;
	}

	if (this.pending)
	{
		// something is waiting to complete
		return false;
	}

	document.body.style.cursor = 'wait';

	this.ajax = new vB_AJAX_Handler(true);
	this.ajax.onreadystatechange(this.display_template);
	this.ajax.send('templateedits.php?' + SESSIONURL + 'do=doviewmodifiedtemplate&ajax=1', 'do=doviewmodifiedtemplate&template=' + template  + '&styleid=' + styleid + '&showcomments=' + showcomments + '&adminhash=' + adminhash);

	this.pending = true;

	return false;
};

TMS_AJAX_TemplateFetch.prototype.display_template = function()
{
	var AJAX = tmstemplate.ajax.handler;

	if (AJAX.readyState == 4 && AJAX.status == 200)
	{
		document.body.style.cursor = 'auto';
		tmstemplate.pending = false;

		// display the editor
		var container = fetch_object('tmstemplate').innerHTML = AJAX.responseText;

		if (is_ie)
		{
			AJAX.abort();
		}
	}
};

TMS_AJAX_TemplateFetch.prototype.abort = function(e)
{
	document.body.style.cursor = 'auto';
	fetch_object('tmstemplate').innerHTML = '';
};


// -------------------------------------------

function TMS_AJAX_Editor()
{
	this.styleid = null;
	this.templateeditid = null;
	this.messageobj = null;
	this.container = null;
	this.originalhtml = null;
	this.ajax = null;
	this.pending = false;
}

TMS_AJAX_Editor.prototype.ready = function()
{
	if (this.pending)
	{
		return false;
	}
	else
	{
		return true;
	}
};

TMS_AJAX_Editor.prototype.edit = function(styleid, templateeditid)
{
	var test_ajax = new vB_AJAX_Handler(true);
	if (!test_ajax.init())
	{
		// couldn't initialize, return true to allow click to go through
		return true;
	}

	if (this.pending)
	{
		// something is waiting to complete
		return false;
	}
	else if (!this.ready())
	{
		return true;
	}

	this.styleid = styleid;
	this.templateeditid = templateeditid;
	this.fetch_editor();

	return false;
};

TMS_AJAX_Editor.prototype.fetch_editor = function()
{
	document.body.style.cursor = 'wait';
	this.ajax = new vB_AJAX_Handler(true);
	this.ajax.onreadystatechange(this.display_editor);
	if (this.styleid == '')
	{
		this.ajax.send('templateedits.php?do=edit&ajax=1&templateeditid=' + this.templateeditid);
	}
	else
	{
		this.ajax.send('templateedits.php?do=add&ajax=1&dostyleid=' + this.styleid + '&templateeditid=' + this.templateeditid);
	}
	this.pending = true;
};

TMS_AJAX_Editor.prototype.display_editor = function()
{
	var AJAX = tmseditor.ajax.handler;

	if (AJAX.readyState == 4 && AJAX.status == 200)
	{
		document.body.style.cursor = 'auto';
		tmseditor.pending = false;

		if (fetch_tag_count(AJAX.responseXML, 'errors'))
		{
			var errors = fetch_tags(AJAX.responseXML, 'error');
			for (var i = 0; i < errors.length; i++)
			{
				alert(tmseditor.ajax.fetch_data(errors[i]));
			}
		}
		else
		{
			var templateedit = fetch_tags(AJAX.responseXML, 'templateedit')[0];

			// display the editor
			fetch_object('tmsedit').innerHTML = tmseditor.ajax.fetch_data(templateedit);		
		}


		if (is_ie)
		{
			AJAX.abort();
		}
		
		return false;
	}
};

TMS_AJAX_Editor.prototype.abort = function(e)
{
	document.body.style.cursor = 'auto';
	fetch_object('tmsedit').innerHTML = '';
};

TMS_AJAX_Editor.prototype.save = function(e)
{
	tmsform = fetch_object('tmsform');

	document.body.style.cursor = 'wait';

	tmseditor.ajax = new vB_AJAX_Handler(true);
	tmseditor.ajax.onreadystatechange(tmseditor.update);
	if (this.styleid == '')
	{
		var url = 'templateedits.php?do=update&ajax=1';
		var submitstring = 'do=update&ajax=1' + '&templateeditid=' + this.templateeditid;
	}
	else
	{
		var url = 'templateedits.php?do=insert&ajax=1';
		var submitstring = 'do=insert&ajax=1';
	}

	for (i = 0; i < tmsform.elements.length; i++)
	{
		var obj = tmsform.elements[i];

		if (obj.name && !obj.disabled)
		{
			switch (obj.type)
			{
				case 'text':
				case 'textarea':
				case 'hidden':
					submitstring += '&' + obj.name + '=' + PHP.urlencode(obj.value);
					break;
				case 'checkbox':
				case 'radio':
					submitstring += obj.checked ? '&' + obj.name + '=' + PHP.urlencode(obj.value) : '';
					break;
				case 'select':
				case 'select-one':
					submitstring += '&' + obj.name + '=' + PHP.urlencode(obj.options[obj.selectedIndex].value);
					break;
			}
		}
	}

	tmseditor.ajax.send(url, submitstring);

	tmseditor.pending = true;
	
	return false;
};

TMS_AJAX_Editor.prototype.update = function()
{
	var AJAX = tmseditor.ajax.handler;

	if (AJAX.readyState == 4 && AJAX.status == 200)
	{
		document.body.style.cursor = 'auto';
		var templateedits = fetch_tags(AJAX.responseXML, 'templateedits')[0];
		fetch_object('tmsedit').innerHTML = '';
		fetch_object('tmsedits').innerHTML = tmseditor.ajax.fetch_data(templateedits);
		tmseditor.pending = false;

		if (fetch_tag_count(AJAX.responseXML, 'errors'))
		{
			alert(tmseditor.ajax.fetch_data(fetch_tags(AJAX.responseXML, 'errors')[0]));
		}

		if (is_ie)
		{
			AJAX.abort();
		}
	}

	return false;
};

var tmseditor = new TMS_AJAX_Editor();