<?php

// MGC Chatbox Evo : Permissions class
class MGCCbEvo_permissions
{
	// Registry var
	var $registry = null;
	
	// Permissions var
	var $permissions = null;

	// Constructor
	function MGCCbEvo_permissions(&$registry,&$permissions)
	{
		if (is_object($registry))
		{
			$this->registry =& $registry;
		}
		else
		{
			trigger_error(get_class($this) . '::Registry object is not an object', E_USER_ERROR);
		}
		
		$this->permissions =& $permissions;
	}
	
	// User can view chatbox even if he has not reached number of posts
	function can_view_if_not_enough_posts()
	{
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['canseeifnotenoughposts']);
	}
		
	// User can view chatbox even if he has not reached number of threads
	function can_view_if_not_enough_threads()
	{
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['canseeifnotenoughthreads']);
	}
	
	// User can view the chatbox permission check
	function can_view()
	{
		// Chatbox deactivated
		if (!$this->registry->options['mgc_cb_evo_active'])
		{
			return 0;
		}
	
		// Chatbox shall be idle in this style ?
		if (!empty($this->registry->options['mgc_cb_evo_styleids_hide']))
		{
			$styleids_array = explode(',',$this->registry->options['mgc_cb_evo_styleids_hide']);
	
			if (in_array($this->registry->userinfo['styleid'],$styleids_array))
			{
				return 0;
			}
		}
	
		// Check number of posts per 24H ?
		if ($this->permissions['mgc_cb_evo_nbmsg_perday_show'] > 0)
		{
			$getnbmsg = $this->registry->db->query_first("
				SELECT COUNT(postid) AS nbposts
				FROM " . TABLE_PREFIX . "post
				WHERE dateline>='" . (TIMENOW - 86400) . "' AND userid='" . $this->registry->userinfo['userid'] . "'
			");
	
			if (($getnbmsg['nbposts'] < $this->permissions['mgc_cb_evo_nbmsg_perday_show']) && !$this->can_view_if_not_enough_posts())
			{
				return false;
			}
		}
		
		// Check number of threads per 24H ?
		if ($this->permissions['mgc_cb_evo_nbthreads_perday_show'] > 0)
		{
			$getnbthreads = $this->registry->db->query_first("
				SELECT COUNT(threadid) AS nbthreads
				FROM " . TABLE_PREFIX . "thread
				WHERE dateline>='" . (TIMENOW - 86400) . "' AND postuserid='" . $this->registry->userinfo['userid'] . "'
			");
	
			if (($getnbthreads['nbthreads'] < $this->permissions['mgc_cb_evo_nbthreads_perday_show']) && !$this->can_view_if_not_enough_threads())
			{
				return false;
			}
		}		
	
		// Check number of posts ?
		if ($this->permissions['mgc_cb_evo_nbmsg_show'] > 0)
		{
			if (($this->registry->userinfo['posts'] <= $this->permissions['mgc_cb_evo_nbmsg_show']) && !$this->can_view_if_not_enough_posts())
			{
				return false;
			}
		}
	
		// Check user ban status
		if ($this->registry->userinfo['mgc_cb_evo_banned'])
		{
			return 0;
		}
		
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['canview']);
	}	
	
	// User can use the chatbox permission check
	function can_use()
	{	
		// Check number of posts per 24H ?
		if ($this->permissions['mgc_cb_evo_nbmsg_perday_show'] > 0)
		{
			$getnbmsg = $this->registry->db->query_first("
				SELECT COUNT(postid) AS nbposts
				FROM " . TABLE_PREFIX . "post
				WHERE dateline>='" . (TIMENOW - 86400) . "' AND userid='" . $this->registry->userinfo['userid'] . "'
			");
	
			if ($getnbmsg['nbposts'] < $this->permissions['mgc_cb_evo_nbmsg_perday_show'])
			{
				return false;
			}
		}
	
		// Check number of threads per 24H ?
		if ($this->permissions['mgc_cb_evo_nbthreads_perday_show'] > 0)
		{
			$getnbthreads = $this->registry->db->query_first("
				SELECT COUNT(threadid) AS nbthreads
				FROM " . TABLE_PREFIX . "thread
				WHERE dateline>='" . (TIMENOW - 86400) . "' AND postuserid='" . $this->registry->userinfo['userid'] . "'
			");
	
			if ($getnbthreads['nbthreads'] < $this->permissions['mgc_cb_evo_nbthreads_perday_show'])
			{
				return false;
			}
		}	
	
		// Check number of posts ?
		if ($this->permissions['mgc_cb_evo_nbmsg_show'] > 0)
		{
			if ($this->registry->userinfo['posts'] <= $this->permissions['mgc_cb_evo_nbmsg_show'])
			{
				return false;
			}
		}
	
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['canuse']);
	}	
	
	// User can manage the chatbox permission check
	function can_manage()
	{
   		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['canmanage']);
	}

	// User can view the IPs in the chatbox permission check
	function can_view_ips()
	{	
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['canviewip']);
	}

	// User can manage own chats permission check
	function can_manage_own_chats()
	{	
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['canmanageownchats']);
	}

	// User can view the archives permission check
	function can_view_archives()
	{	
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['canviewarchives']);
	}
	
	// User can download the archives permission check
	function can_download_archives()
	{	
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['candownloadarchives']);
	}

	// User can view prompt message in chatbox input field
	function can_view_promptmsg()
	{	
		 return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['showpromptmsg']);
	}	
	
	// User can sticky a chat
	function can_sticky_chat()
	{	
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['cansticky']);
	}	
	
	// User can use bbcodes if they are active
	function can_use_bbcodes()
	{
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['canusebbcode']);
	}	
	
	// User can user smilies if they are active
	function can_use_smilies()
	{	
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['canusesmilies']);
	}	
	
	// User can search within the chats
	function can_search()
	{
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['cansearch']);
	}
	
	// User can select default channel
	function can_select_default_channel()
	{		
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['canselectdefchan']);
	}	
	
	// User can view notifications in the chatbox
	function can_view_notifications()
	{
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['canviewnotifs']);
	}	
	
	function disable_refresh_upon_postlimit_reach()
	{
		return ($this->permissions['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['disablerefreshuponlimit']);
	}
	
	// Check if autorefresh should be activated (depends of max number of chats per day)
	function authorize_autorefresh($max_number_of_chats_reached)
	{	
		// No refresh
		if ($this->permissions['mgc_cb_evo_refreshrate'] == 0)
		{
			return 0;
		}
		else
		{
			// Max number of posts reached and disable refresh in that case option active
			if ($this->disable_refresh_upon_postlimit_reach() && $max_number_of_chats_reached)
			{
				return 0;
			}
			else
			{
				return 1;
			}
		}
	}	
	
	// Check if the user has access to the command passed as parameter
	function can_use_command($command)
	{
    	// Chatbox is not active or user can't access and use the chatbox => Error
	    if (! ($this->registry->options['mgc_cb_evo_active'] &&  $this->can_view() && $this->can_use()) )
	    {
    	    return 0;
	    }

		// Check usergroupids permissions
    	if (!empty($command['usergroupids']))
    	{
        	$usergroupids = explode(',',$command['usergroupids']);

	        if (in_array($this->registry->userinfo['usergroupid'],$usergroupids))
	        {
				return 1;
        	}

	        if (!empty($this->registry->userinfo['membergroupids']))
	        {
    	        $ugipds_array = explode(',', $this->registry->userinfo['membergroupids']);

        	    foreach ($ugipds_array as $index => $ugpid)
        	    {
            	    if (in_array($ugpid,$usergroupids))
            	    {
                	    return 1;
	                }
    	        }
        	}
	    }
		// Check specific users permissions
    	if (!empty($command['userids']))
    	{
        	$userids = explode(',',$command['userids']);

	        if (in_array($this->registry->userinfo['userid'],$userids))
	        {
    	        return 1;
        	}
	    }

    	return 0;
	}
	
	// Return number of chats per day limit
	function get_chats_perday_limit()
	{
		return $this->permissions['mgc_cb_evo_max_chats_perday'];
	}
	
	// Can see hidden users
	function can_see_hidden_users()
	{
		return ($this->registry->userinfo['permissions']['genericpermissions'] & $this->registry->bf_ugp_genericpermissions['canseehidden']);
	}
	
	// Return user refresh rate
	function get_refresh_rate()
	{
		return $this->permissions['mgc_cb_evo_refreshrate'];
	}
	
	// Can use the command which identifier is given as parameter
	function can_use_command_by_identifier($command_identifier)
	{
		// Get the command in the datastore
		foreach($this->registry->mgc_cb_evo_commands AS $command)
		{
			if ($command['identifier'] == $command_identifier)
			{
				$getpermissions = $command;
			}
		}
	
	    // It's time to check if the user has access to the command
	    $authorized = 0;
	
	    // Usergroupids
	    if (!empty($getpermissions['usergroupids'])) {
	        $ugipds_array = explode(',',$getpermissions['usergroupids']);
	
	        if (in_array($this->registry->userinfo['usergroupid'],$ugipds_array)) {
	            $authorized = 1;
	        }
	
	        if (!empty($this->registry->userinfo['membergroupids'])) {
	            $mgids_array = explode(',', $this->registry->userinfo['membergroupids']);
	
	            foreach ($mgids_array as $index => $mgpid)
	            {
	                if (in_array($mgpid,$ugipds_array))
	                {
	                    $authorized = 1;
	                }
	            }
	        }
	    }
	
	    // Userids if not already authorized
	    if (!$authorized && !empty($getpermissions['userids']))
	    {
	        $uids_array = explode(',',$getpermissions['userids']);
	        if (in_array($vbulletin->userinfo['userid'],$uids_array))
	        {
	            $authorized = 1;
	        }
	    }
	    return $authorized;
	}	
	
	// Can see hidden users
	function can_talk_to_bot()
	{
		return ($this->registry->userinfo['permissions']['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['cantalktobot']);
	}	
	
	// Can report a problematic chat
	function can_report()
	{
		return ($this->registry->userinfo['permissions']['mgc_cb_evo_permissions'] & $this->registry->bf_ugp_mgc_cb_evo_permissions['canreport']);
	}
	
	// User newthread/newpost notification authorization check
	function authorize_user_newthread_newpost_notif($userinfo)
	{
		// If userid filter not empty do it
		if (!empty($this->registry->options['mgc_cb_evo_newthread_newpost_fu']))
		{
			$authorized_userids = explode(',',$this->registry->options['mgc_cb_evo_newthread_newpost_fu']);
			return in_array($userinfo['userid'],$authorized_userids);
		}
		else if (!empty($this->registry->options['mgc_cb_evo_newthread_newpost_fugp']))
		{
			$authorized_usergroupids = explode(',',$this->registry->options['mgc_cb_evo_newthread_newpost_fugp']);
			
			// 1 - Usergroupid test
			if (in_array($userinfo['usergroupid'],$authorized_usergroupids))
			{
				return true;
			}
			
			// 2 - Member group test
			if (!empty($userinfo['membergroupids']))
			{
				$ugipds_array 	= explode(',', $userinfo['membergroupids']);		
				foreach ($ugipds_array as $index => $ugpid)
				{
					if (in_array($ugpid,$authorized_usergroupids))
					{
						return true;
					}
				}
			}	
			
			return false;
		}
		return true;
	}
	
	function check_flood()
	{
		if (empty($this->registry->options['mgc_cb_evo_antiflood_fugp']))
		{
			return true;
		}
		else
		{
			$authorized_usergroupids = explode(',',$this->registry->options['mgc_cb_evo_antiflood_fugp']);	
		
			// 1 - Usergroupid test
			if (in_array($this->registry->userinfo['usergroupid'],$authorized_usergroupids))
			{
				return false;
			}
			
			// 2 - Member group test
			if (!empty($this->registry->userinfo['membergroupids']))
			{
				$ugipds_array 	= explode(',', $this->registry->userinfo['membergroupids']);		
				foreach ($ugipds_array as $index => $ugpid)
				{
					if (in_array($ugpid,$authorized_usergroupids))
					{
						return false;
					}
				}
			}	
			
			return true;			
		}
	}
}

?>