<?php

// MGC Chatbox Evo : Core class
class MGCCbEvo_core
{
	// Registry var
	var $registry = null;

	// MGC Chatbox Evo permissions
	var $evo_permissions = null;

	// Constructor
	function MGCCbEvo_core(&$registry,&$permissions)
	{
		if (is_object($registry))
		{
			$this->registry =& $registry;
		}
		else
		{
			trigger_error(get_class($this) . '::Registry object is not an object', E_USER_ERROR);
		}
		
		require_once(DIR . '/mgc_cb_evo/classes/class_permissions.php');
		
		$this->evo_permissions 	=& new MGCCbEvo_permissions($registry,$permissions);
	}
	
	// Unserialize the user chatbox params and add it to the userinfo global var table
	function unserialize_user_params()
	{
		// If the table is empty -> set default values
		if (!empty($this->registry->userinfo['mgc_cb_evo_params']))
		{
			$unserialized_params = unserialize($this->registry->userinfo['mgc_cb_evo_params']);
	
			// Add the new variables to the userinfo table of the vbulletin object
			if (!empty($unserialized_params))
			{
				foreach ($unserialized_params as $key => $val)
				{
					$this->registry->userinfo["$key"] = $val;
				}
			}
		}
		else
		{
			$this->registry->userinfo['mgc_cb_evo_show'] = 1;
		}
	}	
	
	// Function to check wether chatbox shall be displayed or not
	function show_chatbox()
	{
		return ($this->registry->options['mgc_cb_evo_active'] && $this->registry->userinfo['mgc_cb_evo_show']);
	}
}

?>