<?php

define('INDMCHAT',1);

if (!class_exists('vB_DataManager'))
{
    exit;
}

class vB_DataManager_Mgccb_Chat extends vB_DataManager
{
    // Datamanager variables
    var $validfields = array
      (
       'chatid'     		=> array(TYPE_UINT, REQ_INCR, 	VF_METHOD,	'verify_nonzero'),
       'dateline' 			=> array(TYPE_UINT, REQ_YES),
       'chanid' 			=> array(TYPE_UINT, REQ_YES),
       'coidentifier'   	=> array(TYPE_STR, 	REQ_YES),
       'fromuid' 			=> array(TYPE_UINT, REQ_YES),
       'touid' 				=> array(TYPE_UINT, REQ_NO),
       'ctext' 				=> array(TYPE_STR, 	REQ_YES, 	'VF_METHOD'),
       'userip'    			=> array(TYPE_STR,  REQ_YES, 	VF_METHOD,	'verify_ipaddress'),
       'name'   			=> array(TYPE_STR, 	REQ_NO),
       'usergroupid'		=> array(TYPE_INT, 	REQ_YES),
       'displaygroupid'		=> array(TYPE_INT, 	REQ_YES),
       'hascustomavatar'	=> array(TYPE_INT, 	REQ_YES),
       'avatarpath'			=> array(TYPE_STR, 	REQ_YES),
       'avatardateline'		=> array(TYPE_INT, 	REQ_YES),
       'avwidth'			=> array(TYPE_INT, 	REQ_YES),
       'avheight'			=> array(TYPE_INT, 	REQ_NO),
       'avheight_thumb'		=> array(TYPE_INT, 	REQ_NO),
       'avwidth_thumb'		=> array(TYPE_INT, 	REQ_NO),
       'filedata_thumb'   	=> array(TYPE_STR, 	REQ_NO),
       'avatarid'			=> array(TYPE_INT, 	REQ_YES),
       'avatarrevision'		=> array(TYPE_INT, 	REQ_YES),
       'toname'   			=> array(TYPE_STR, 	REQ_NO),
       'tousergroupid'		=> array(TYPE_INT, 	REQ_NO),
       'todisplaygroupid'	=> array(TYPE_INT, 	REQ_NO),
       'tohascustomavatar'	=> array(TYPE_INT, 	REQ_NO),
       'toavatarpath'		=> array(TYPE_STR, 	REQ_NO),
       'toavatardateline'	=> array(TYPE_INT, 	REQ_NO),
       'toavwidth'			=> array(TYPE_INT, 	REQ_NO),
       'toavheight'			=> array(TYPE_INT, 	REQ_NO),
       'toavheight_thumb'	=> array(TYPE_INT, 	REQ_NO),
       'toavwidth_thumb'	=> array(TYPE_INT, 	REQ_NO),
       'tofiledata_thumb'   => array(TYPE_STR, 	REQ_NO),
       'toavatarid'			=> array(TYPE_INT, 	REQ_NO),
       'toavatarrevision'	=> array(TYPE_INT, 	REQ_NO),
	);

    var $table = 'mgc_cb_evo_chat';

    var $mgc_cb_evo_chat = array();

    // The raw chat
    var $raw_chat = "";
    
    // Bot answer
    var $bot_answer = "";

    // Commands permissions
    var $user_commands = array();

    // Action statuses
    var $action = "";

    // Variables for command management
    var $parse_bbcode 		= 1;
    var $accept_userpref 	= 1;
    var $contain_command 	= 0;

    function vB_DataManager_Mgccb_Chat(&$registry, $errtype = ERRTYPE_STANDARD)
    {
		parent::vB_DataManager($registry, $errtype);
    }

    // Commands retrieving from the database
    function retrieve_command_permissions()
    {
    	$count = 0;
    	
		if (is_array($this->registry->mgc_cb_evo_commands))
		{					
			foreach($this->registry->mgc_cb_evo_commands AS $command)
			{
				if (!empty($command['usergroupids']))
				{
					$command['usergroupids'] = explode(',',$command['usergroupids']);
				}
				else
				{
					$command['usergroupids'] = array();
				}
				
				if (!empty($command['userids']))
				{
					$command['userids'] = explode(',',$command['userids']);
				}
				else
				{
					$command['userids'] = array();
				}
									
				// Channel not active => next
				if ($command['active'] == 0)
				{
					continue;
				}
				
				// Test if user has permissions
				$hasaccess = 0;		
				// 1 - Usergroupid test
				if (is_array($command['usergroupids']) && in_array($this->registry->userinfo['usergroupid'],$command['usergroupids']))
				{
					$hasaccess = 1;
				}
				// 2 - Member group test
				if (!$hasaccess && !empty($this->registry->userinfo['membergroupids']))
				{
					$found 			= 0;
					$ugipds_array 	= explode(',', $this->registry->userinfo['membergroupids']);		
					foreach ($ugipds_array as $index => $ugpid)
					{
						if (in_array($ugpid,$command['usergroupids']))
						{
							$hasaccess = 1;
						}
					}
				}
				// 3 - Userid test
				if (!$hasaccess && is_array($command['userids']) && in_array($this->registry->userinfo['userid'],$command['userids']))
				{
					$hasaccess = 1;
				}
				// 4 - Skip channel if not
				if (!$hasaccess)
				{
					continue;
				}
				
				$this->user_commands[$count] =& $command['identifier'];
				$count++;
			}
		}
    }

    // Raw chat registration
    function set_raw_chat(&$sent_chat)
    {
        $this->raw_chat = &trim($sent_chat);
    }

    // Pre save chekings
    function pre_save()
    {
        global $vbphrase,$MGCCbEvoCore;

        // Check if the chat field was not empty ?
        if (($this->raw_chat != '0') && empty($this->raw_chat))
        {
            $this->construct_popup($vbphrase['mgc_cb_evo_enter_chat']);
            return;
        }

        // Check if only bbcodes
        $temp = strip_bbcode($this->raw_chat);
        if (($this->raw_chat != '0') && empty($temp))
        {
            $this->construct_popup($vbphrase['mgc_cb_evo_enter_chat']);
            return;
        }
        
        // If a command is entered and user has access to commands
        if ((substr($this->raw_chat,0,1) == "/") && sizeof($this->user_commands))
        {
            //--------------------------
            // ME command
            //--------------------------
            if ($this->check_and_parse_command_identifier("me",2))
            {
				include_once(DIR . '/mgc_cb_evo/commands/me_dm_code.php');
            }
            //--------------------------
            // Team command
            //--------------------------
            if ($this->check_and_parse_command_identifier("team",4))
            {
				include_once(DIR . '/mgc_cb_evo/commands/team_dm_code.php');
            }
            //--------------------------
            // Announcement command
            //--------------------------
            else if ($this->check_and_parse_command_identifier("announcement",12))
            {
				include_once(DIR . '/mgc_cb_evo/commands/announcement_dm_code.php');
            }
            //--------------------------
            // Ban command
            //--------------------------
            else if ($this->check_and_parse_command_identifier("ban",3))
            {
				include_once(DIR . '/mgc_cb_evo/commands/ban_dm_code.php');
            }
            //--------------------------
            // Del command
            //--------------------------
            else if ($this->check_and_parse_command_identifier("del",3))
            {
				include_once(DIR . '/mgc_cb_evo/commands/del_dm_code.php');
            }
            //--------------------------
            // Ignore command
            //--------------------------
            else if ($this->check_and_parse_command_identifier("ignore",6))
            {
				include_once(DIR . '/mgc_cb_evo/commands/ignore_dm_code.php');
            }
            //--------------------------
            // PM command
            //--------------------------
            else if ($this->check_and_parse_command_identifier("pm",2))
            {
				include_once(DIR . '/mgc_cb_evo/commands/pm_dm_code.php');
            }
            //--------------------------
            // Slap command
            //--------------------------
            else if ($this->check_and_parse_command_identifier("slap",4))
            {
				include_once(DIR . '/mgc_cb_evo/commands/slap_dm_code.php');
            }
        }
        else
        {
        	// Let's see if user talks to the bot if he has the rights to
        	if ($this->registry->options['mgc_cb_evo_bot_active'] && $MGCCbEvoCore->evo_permissions->can_talk_to_bot())
        	{
        		// Get bot phrases
        		$notfound = 1;
        		if (is_array($this->registry->mgc_cb_evo_bots))
        		{
	        		foreach($this->registry->mgc_cb_evo_bots AS $bot)
	        		{
	        			if (strcasecmp($bot['question'],$this->raw_chat) == 0)
	        			{      
	        				// Do some replacements
	        				$bot['answer'] = str_replace('{username}',htmlspecialchars($this->registry->userinfo['username']), $bot['answer']);
	        				$bot['answer'] = str_replace('{time}',vbdate($this->registry->options['timeformat'],TIMENOW,true,false), $bot['answer']);	        
	        				$bot['answer'] = str_replace('{date}',vbdate($this->registry->options['dateformat'],TIMENOW,false,false), $bot['answer']);
	        				// Save the bot answer for sending
	           				$this->bot_answer = $bot['answer'];
	        				$notfound	= 0;
	        			}
	        		}
	        	}
        	}
        }

		// Antiflood ?
		if ($this->registry->options['mgc_cb_evo_antiflood'] && $MGCCbEvoCore->evo_permissions->check_flood() && !empty($this->registry->options['mgc_cb_evo_antiflood_delay']))
		{
			$flooder = 0;
			
			// Manage non anonymous users
			if ($this->registry->userinfo['usergroupid'] != 1)
			{
				// Get user last message
				$userlastchat = $this->registry->db->query_first("
					SELECT dateline
					FROM " . TABLE_PREFIX . "mgc_cb_evo_chat
					WHERE fromuid='" . $this->registry->userinfo['userid'] . "'
					ORDER BY dateline DESC
				");
			}
			else if ($this->registry->options['mgc_cb_evo_ask_anonymous_name'])
			{
				// Get user last message
				$userlastchat = $this->registry->db->query_first("
					SELECT dateline
					FROM " . TABLE_PREFIX . "mgc_cb_evo_chat
					WHERE fromuid='" . $this->registry->userinfo['userid'] . "' AND name='" . $this->mgc_cb_evo_chat['name'] . "'
					ORDER BY dateline DESC
				");			
			}
				
			if ($userlastchat)
			{
				$lastchatdelay = TIMENOW - $userlastchat['dateline'];
				if ($lastchatdelay < $this->registry->options['mgc_cb_evo_antiflood_delay'])
				{
					$this->construct_popup(construct_phrase($vbphrase['mgc_cb_evo_flood_wait_x_seconds'], ($this->registry->options['mgc_cb_evo_antiflood_delay'] - $lastchatdelay) ));
					return;
				}
			}
		}

		// Parse BBCODES
        if ($this->parse_bbcode)
        {
            require_once(DIR . '/includes/class_bbcode.php');
            $parser 		= &new vB_BbCodeParser($this->registry, $this->construct_bbcode_tag_list(true));
            $parsed_chat 	= $parser->do_parse($this->raw_chat, false, $this->registry->options['mgc_cb_evo_smileys'], $this->registry->options['mgc_cb_evo_bbcode'], false, false, false);

            // Maximum number of allowed smilies reached => error
            if (substr_count($parsed_chat, "<img") > $this->registry->options['mgc_cb_evo_nbsmileys'])
            {
                $this->construct_popup(construct_phrase($vbphrase['mgc_cb_evo_too_much_smileys'],$this->registry->options['mgc_cb_evo_nbsmileys']));
                return;
            }

            // If URL BBCODE is authorized, we need to parse the url in the chat
            if ($this->registry->options['mgc_cb_evo_bbcode_url'])
            {
                require_once(DIR . '/includes/functions_newpost.php');
                $this->raw_chat = convert_url_to_bbcode($this->raw_chat);
            }
        }

        // Add the user preferences to the raw chat if they are allowed in the command
        if ($this->accept_userpref)
        {
            $this->add_user_pref_to_raw_chat();
        }

        // If no command => identifier at 0
        if (!$this->contain_command)
        {
            $this->set('coidentifier',0);
        }

        $timenow = TIMENOW;
        $this->do_set('dateline', $timenow);
        $this->do_set('fromuid', $this->registry->userinfo['userid']);
        $this->do_set('ctext', $this->raw_chat);

		// Get avatar info only if not anonymous
		if ($this->registry->userinfo['usergroupid'] != 1)
		{
			// Get from user info
			$userid = intval($this->registry->userinfo['userid']);
			if (substr($this->registry->options['templateversion'],0,3) != "3.6")
			{
				$sql_add_fields = ",customavatar.height_thumb AS avheight_thumb, customavatar.width_thumb AS avwidth_thumb, customavatar.filedata_thumb";
			}
			$getfromuser = $this->registry->db->query_first("
				SELECT
					u.userid,u.usergroupid,u.membergroupids,u.displaygroupid,
					avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,
					customavatar.width AS avwidth, customavatar.height AS avheight,u.avatarid,u.avatarrevision
					$sql_add_fields
				FROM " . TABLE_PREFIX . "user AS u
				LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = u.avatarid)
				LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = u.userid)
				WHERE u.userid='$userid'
			");

   			$this->do_set('usergroupid', $getfromuser['usergroupid']);
	        $this->do_set('displaygroupid', $getfromuser['displaygroupid']);
			$this->do_set('hascustomavatar',$getfromuser['hascustomavatar']);
			$this->do_set('avatarpath',$getfromuser['avatarpath']);
			$this->do_set('avatardateline',$getfromuser['avatardateline']);
			$this->do_set('avwidth',$getfromuser['avwidth']);
			$this->do_set('avheight',$getfromuser['avheight']);
			$this->do_set('avwidth_thumb',$getfromuser['avwidth_thumb']);
			$this->do_set('avheight_thumb',$getfromuser['avheight_thumb']);
			$this->do_set('filedata_thumb',$getfromuser['filedata_thumb']);
			$this->do_set('avatarid',$getfromuser['avatarid']);
			$this->do_set('avatarrevision',$getfromuser['avatarrevision']);

			if ($this->mgc_cb_evo_chat['coidentifier'] == 'pm')
			{
				$this->do_set('toname', $getuser['username']);
				$this->do_set('tousergroupid', $getuser['usergroupid']);
				$this->do_set('todisplaygroupid', $getuser['displaygroupid']);
				$this->do_set('tohascustomavatar',$getuser['hascustomavatar']);
				$this->do_set('toavatarpath',$getuser['avatarpath']);
				$this->do_set('toavatardateline',$getuser['avatardateline']);
				$this->do_set('toavwidth',$getuser['avwidth']);
				$this->do_set('toavheight',$getuser['avheight']);
				$this->do_set('toavwidth_thumb',$getuser['avwidth_thumb']);
				$this->do_set('toavheight_thumb',$getuser['avheight_thumb']);
				$this->do_set('tofiledata_thumb',$getuser['filedata_thumb']);
				$this->do_set('toavatarid',$getuser['avatarid']);
				$this->do_set('toavatarrevision',$getuser['avatarrevision']);
			}
		}
		else
		{
			$this->set('usergroupid', 0);
        	$this->set('displaygroupid', 0);
			$this->set('hascustomavatar',0);
			$this->set('avatarpath','');
			$this->set('avatardateline',0);
			$this->set('avwidth',0);
			$this->set('avheight',0);
			$this->set('avwidth_thumb',0);
			$this->set('avheight_thumb',0);
			$this->set('filedata_thumb','');
			$this->set('avatarid',0);
			$this->set('avatarrevision',0);
		}
    }

    function save()
    {
    	// Update user chat count if option is active
    	if ($this->registry->options['mgc_cb_evo_count_userchats'])
    	{
    		$this->registry->db->query_write("UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_nbchats=mgc_cb_evo_nbchats+1,mgc_cb_evo_lastchat='" . TIMENOW . "' WHERE userid='" . $this->registry->userinfo['userid'] . "'");
    	}
    	// Insert the chat
        $result = $this->db_insert(TABLE_PREFIX, 'mgc_cb_evo_chat', true);
    }
    
    function insert_bot_answer()
    {
    	// Check if a bot name is entered or need to get bot info
    	if (empty($this->registry->options['mgc_cb_evo_bot_name']))
    	{
			$getbotuser = $this->registry->db->query_first("
				SELECT
					u.username,u.userid,u.usergroupid,u.membergroupids,u.displaygroupid,
					avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustomavatar, customavatar.dateline AS avatardateline,
					customavatar.width AS avwidth, customavatar.height AS avheight,u.avatarid,u.avatarrevision
					$sql_add_fields
				FROM " . TABLE_PREFIX . "user AS u
				LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = u.avatarid)
				LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = u.userid)
				WHERE u.userid='" . $this->registry->options['mgc_cb_evo_bot_userid'] . "'
			");    	
			
			$this->registry->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "mgc_cb_evo_chat
				SET 
					dateline='" . (TIMENOW + 1) ."',
					name='" . $getbotuser['username'] . "',
					chanid='" . $this->mgc_cb_evo_chat['chanid'] . "',
					coidentifier='0',
					fromuid='" . $getbotuser['userid'] . "',
					ctext='bot:" . $this->registry->db->escape_string($this->bot_answer) . "',
					usergroupid='" . $getbotuser['usergroupid'] . "',
					displaygroupid='" . $getbotuser['displaygroupid'] . "',
					hascustomavatar='" . $getbotuser['hascustomavatar'] . "',
					avatarpath='" . $getbotuser['avatarpath'] . "',
					avatardateline='" . $getbotuser['avatardateline'] . "',
					avwidth='" . $getbotuser['avwidth'] . "',
					avheight='" . $getbotuser['avheight'] . "',
					avwidth_thumb='" . $getbotuser['avwidth_thumb'] . "',
					avheight_thumb='" . $getbotuser['avheight_thumb'] . "',
					filedata_thumb='" . $getbotuser['filedata_thumb'] . "',
					avatarid='" . $getbotuser['avatarid'] . "',
					avatarrevision='" . $getbotuser['avatarrevision'] . "' 				
			");	  			
    	}
    	else
    	{
			// If need insert bot answer
			$this->registry->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "mgc_cb_evo_chat
				SET 
					dateline='" . (TIMENOW + 1) ."',
					chanid='" . $this->mgc_cb_evo_chat['chanid'] . "',
					coidentifier='0',
					fromuid='0',
					ctext='bot:" . $this->registry->db->escape_string($this->bot_answer) . "',
					usergroupid='0',
					displaygroupid='0',
					hascustomavatar='0',
					avatarpath='0',
					avatardateline='0',
					avwidth='0',
					avheight='0',
					avwidth_thumb='0',
					avheight_thumb='0',
					filedata_thumb='0',
					avatarid='0',
					avatarrevision='0'      				
			");	      	
    	}    
    }

    // Popup message for UI display construction
    function construct_popup($error_msg,$dofullreload = 0)
    {
        // Construct popup
        $this->action = "mgc_cb_js_showpopup('" . addslashes_js($error_msg) . "','');";
        // Check if full reload needed
        if ($dofullreload)
        {
        		$this->action .= "exec_chatbox_clear(1);";
        }
    }

    // Building of the allowed bbcode array for the parsing function
    function construct_bbcode_tag_list($with_color)
    {
        $bbcode_list = array();

        if ($this->registry->options['mgc_cb_evo_bbcode'])
        {
            $bbcode_list['no_option']['b'] = array('html' => '<b>%1$s</b>', 'strip_empty' => true);
            $bbcode_list['no_option']['i'] = array('html' => '<i>%1$s</i>', 'strip_empty' => true);
            $bbcode_list['no_option']['u'] = array('html' => '<u>%1$s</u>', 'strip_empty' => true);
            if ($with_color)
            {
                $bbcode_list['option']['color'] = array('html' => '<font color="%2$s">%1$s</font>', 'option_regex' => '#^\#?\w+$#', 'strip_empty' => true);
            }
            $bbcode_list['option']['size'] = array('html' => '<font size="%2$s">%1$s</font>', 'option_regex' => '#^[0-9\+\-]+$#', 'strip_empty' => true);
            $bbcode_list['option']['font'] = array('html' => '<font face="%2$s">%1$s</font>', 'option_regex' => '#^[^["`\':]+$#', 'strip_empty' => true);
        }

        if ($this->registry->options['mgc_cb_evo_bbcode_url'])
        {
            $bbcode_list['no_option']['url'] = array('callback' => 'handle_bbcode_url', 'strip_empty' => true);
            $bbcode_list['option']['url'] = array('callback' => 'handle_bbcode_url', 'strip_empty' => true);
        }
        return $bbcode_list;
    }

    // Verifies that the given option can be selected by a user (ie. active in the acp)
    function is_userpref_active($userpref_name)
    {
        switch ($userpref_name)
        {
          case "font":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 1;
            break;
          case "size":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 2;
            break;
          case "color":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 4;
            break;
          case "b":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 8;
            break;
          case "i":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 16;
            break;
          case "u":
            return $this->registry->options['mgc_cb_evo_user_format_options'] & 32;
            break;
        }
    }

    // Add the user preferences to the raw chat
    function add_user_pref_to_raw_chat()
    {
        $endchat = '';
        if ($this->registry->userinfo['mgc_cb_evo_u'] && $this->is_userpref_active("u"))
        {
            $this->raw_chat = '[U]' . $this->raw_chat;
            $endchat = $endchat . '[/U]';
        }
        
        if ($this->registry->userinfo['mgc_cb_evo_i'] && $this->is_userpref_active("i"))
        {
            $this->raw_chat = '[I]' . $this->raw_chat;
            $endchat = $endchat . '[/I]';
        }
        
        if ($this->registry->userinfo['mgc_cb_evo_b'] && $this->is_userpref_active("b"))
        {
            $this->raw_chat = '[B]' . $this->raw_chat;
            $endchat = $endchat . '[/B]';
        }
        
        if ($this->registry->userinfo['mgc_cb_evo_size'] && $this->is_userpref_active("size"))
        {
            if ($this->registry->userinfo['mgc_cb_evo_size'] <= $this->registry->options['mgc_cb_evo_max_bbcode_size'])
            {
                $this->raw_chat = '[size=' . $this->registry->userinfo['mgc_cb_evo_size'] . ']' . $this->raw_chat;
            }
            else
            {
                $this->raw_chat = '[size=' . $this->registry->options['mgc_cb_evo_max_bbcode_size'] . ']' . $this->raw_chat;
            }
            $endchat = $endchat . '[/size]';
        }

        // User has selected a color
        if ($this->registry->userinfo['mgc_cb_evo_color'] && $this->is_userpref_active("color"))
        {
            $this->raw_chat = '[color=#' . $this->registry->userinfo['mgc_cb_evo_color'] . ']' . $this->raw_chat;
            $endchat = $endchat . '[/color]';
        }
        // Applies usergroup color if different from 000000
        else if(!empty($this->registry->userinfo['mgc_cb_evo_default_color']) && $this->registry->userinfo['mgc_cb_evo_default_color'] != "000000")
        {
            $this->raw_chat = '[color=#' . $this->registry->userinfo['mgc_cb_evo_default_color'] . ']' . $this->raw_chat;
            $endchat = $endchat . '[/color]';
        }
		
		// Font
        if ($this->registry->userinfo['mgc_cb_evo_font'] && $this->is_userpref_active("font"))
        {
            $this->raw_chat = '[font=' . $this->registry->userinfo['mgc_cb_evo_font'] . ']' . $this->raw_chat;
            $endchat = $endchat . '[/font]';
        }
        $this->raw_chat .= $endchat;
    }

    // Strip the command identifier from the chat
    function check_and_parse_command_identifier($command_identifier,$command_size)
    {
        // User hasn't access to that command
        if (!in_array($command_identifier,$this->user_commands))
        {
            return false;
        }

        // Retrieves only the command identifier
        $tempchat = strtolower($this->raw_chat);
        $tempchat = substr($tempchat,1,$command_size + 1);

        // Command not found
        if ($tempchat != $command_identifier . " ")
        {
            return false;
        }

        $this->contain_command = 1;

        // Strip the command from the chat
        $this->raw_chat = trim(substr($this->raw_chat, $command_size + 1));

        return true;
    }

    // Log action into database if log action option is active
    function log_action($phrase)
	{
		if ($this->registry->options['mgc_cb_evo_log_action'])
		{
			$this->registry->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "mgc_cb_evo_log
				SET dateline='" . TIMENOW . "',username='" . $this->registry->db->escape_string($this->registry->userinfo['username']) . "',
					ltext='" . $this->registry->db->escape_string($phrase) . "'
			");
		}
	}
}

?>