<?php

if (!defined('INDMCHAT'))
{
	echo "You can't include this file directly !";
	die;
}

// Get ban type
if ($this->raw_chat == "show")
{
    // Show currently banned users
    $this->action	= "mgc_cb_evo_cmd_ban_popup()";
    return;
}
else if (substr($this->raw_chat,0,3) == "on ")
{
    // Indefinitely ban user
    $ban_type = 1;
    $this->raw_chat = substr($this->raw_chat,3);
}
else if (substr($this->raw_chat,0,4) == "off ")
{
    // Unban user
    $ban_type 		= 0;
    $this->raw_chat = substr($this->raw_chat,4);
}
else if (substr($this->raw_chat,0,2) == "h ")
{
    // Ban user for a defined number of hours
    $ban_type 			= 2;
    $ban_time_factor 	= 3600;
    $this->raw_chat 	= trim(substr($this->raw_chat,2));
}
else if (substr($this->raw_chat,0,2) == "d ")
{
    // Ban user for a defined number of days
    $ban_type 			= 2;
    $ban_time_factor 	= 86400;
    $this->raw_chat 	= trim(substr($this->raw_chat,2));
}
else
{
    // Syntax error
    $this->construct_popup($vbphrase['mgc_cb_evo_syntax_error']);
    return;
}

// If Time ban, get entered time
if ($ban_type == 2)
{
	$getnextspace 	= strpos($this->raw_chat," ");
	$ban_time		= TIMENOW + (intval(substr($this->raw_chat,0,$getnextspace)) * $ban_time_factor);
	$this->raw_chat = substr($this->raw_chat,$getnextspace + 1);
}

// Userid specified
if (substr($this->raw_chat,0,4) == "uid ") 
{
    $userid = intval(trim(substr($this->raw_chat,4)));

    // Let's check if the user exists
    $getuser = $this->registry->db->query_first("
		SELECT username,userid,mgc_cb_evo_banned
		FROM " . TABLE_PREFIX . "user
		WHERE userid='$userid'
	");
}
else if (substr($this->raw_chat,0,6) == "uname ")
{
    $username = $this->registry->db->escape_string(substr($this->raw_chat,6));

    // Let's check if the user exists
    $getuser = $this->registry->db->query_first("
		SELECT username,userid,mgc_cb_evo_banned FROM " . TABLE_PREFIX . "user WHERE username='$username'
	");
}
else
{
    $this->construct_popup($vbphrase['mgc_cb_evo_syntax_error']);
    return;
}

// User tries to ban himself
if ($getuser['userid'] == $this->registry->userinfo['userid'])
{
	$this->construct_popup($vbphrase['mgc_cb_evo_cmd_ban_cant_ban_yourself']);
    return;
}

// User is not existing
if (!isset($getuser['userid']))
{
    $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ban_false_user']);
    return;
}

// User is not a protected one
if (!empty($this->registry->options['mgc_cb_evo_cmd_ban_protected_users']))
{
    if (in_array($getuser['userid'],explode(',',$this->registry->options['mgc_cb_evo_cmd_ban_protected_users'])))
    {
        $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ban_cant_ban_protected']);
        return;
    }
}

// When user tries to ban someone
if ($ban_type)
{
    // User is already in banned list
    if ($getuser['mgc_cb_evo_banned'])
    {
        $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ban_already_banned']);
        return;
    }

    // Let's ban the user
    $this->registry->db->query_write("
		UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_banned='1',mgc_cb_evo_bantime='" . (($ban_type == 2) ? $ban_time : 0) . "' WHERE userid='" . $getuser['userid'] . "'
	");

    $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ban_banned_success']);

    if ($this->registry->options['mgc_cb_evo_cmd_ban_mponban'])
    {
        $pmdm =& datamanager_init('PM', $this->registry, ERRTYPE_ARRAY);
        $pmdm->set('fromuserid', $this->registry->userinfo['userid']);
        $pmdm->set('fromusername', $this->registry->userinfo['username']);
        $pmdm->set('title', $this->registry->options['mgc_cb_evo_cmd_ban_mponban_title']);
        $pmdm->overridequota = true;
        if ($ban_type == 1)
        {
        	// Unlimited ban
        	$text = str_replace('{1}',$getuser['username'],$this->registry->options['mgc_cb_evo_cmd_ban_mponban_text']);
        }
        else
        {
        	// Limited ban
        	$endban_date = vbdate($this->registry->options['dateformat'], $ban_time, true);
			$endban_time = vbdate($this->registry->options['timeformat'], $ban_time);
			$text = str_replace('{1}',$getuser['username'],$this->registry->options['mgc_cb_evo_cmd_ban_mponband_text']);
			$text = str_replace('{2}',$endban_date . " " . $endban_time,$text);
        }
        $pmdm->set('message', $text);
        $pmdm->set_recipients($getuser['username'],$permissions);
        $pmdm->set('dateline', TIMENOW);
        $pmdm->save();
    }

    $this->log_action(construct_phrase($vbphrase['mgc_cb_evo_log_ban_x'],$getuser['username']));

    return;
}
else
{
    // User is banned
    if (!$getuser['mgc_cb_evo_banned'])
    {
        $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ban_not_banned']);
        return;
    }

    // Let's unban user
    $this->registry->db->query_write("
		UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_banned='0',mgc_cb_evo_bantime='0' WHERE userid='" . $getuser['userid'] . "'
	");

    $this->construct_popup($vbphrase['mgc_cb_evo_cmd_ban_unbanned_success']);

    $this->log_action(construct_phrase($vbphrase['mgc_cb_evo_log_unban_x'],$getuser['username']));

    return;
}

?>