<?php

require_once(DIR . '/mgc_cb_evo/classes/class_permissions.php');
require_once(DIR . '/includes/class_bbcode.php');

// MGC Chatbox Evo : Formatting chat class
class MGCCbEvo_formatting
{
	// Registry var
	var $registry = null;

	// MGCCbEvo core
	var $evo_core = null;
	
	// PM in tab chats formatting
	var $inpm = 0;
	
	// vB Version
	var $mgc_vbversion;

	// Constructor
	function MGCCbEvo_formatting(&$registry,&$evo_core)
	{
		if (is_object($registry))
		{
			$this->registry =& $registry;
		}
		else
		{
			trigger_error(get_class($this) . '::Registry object is not an object', E_USER_ERROR);
		}

		$this->evo_core	 		=& $evo_core;
		
		$this->mgc_vbversion 	= substr($this->registry->options['templateversion'],0,1);
	}
	
	// Construct the chatbox allowed bbcodes tags list
	function construct_bbcode_tag_list($with_color)
	{
		$bbcode_list = array();
	
		// Simple formatting bbcodes
		if ($this->registry->options['mgc_cb_evo_bbcode'])
		{
			$bbcode_list['no_option']['b'] = array('html' => '<b>%1$s</b>', 'strip_empty' => true);
			$bbcode_list['no_option']['i'] = array('html' => '<i>%1$s</i>', 'strip_empty' => true);
			$bbcode_list['no_option']['u'] = array('html' => '<u>%1$s</u>', 'strip_empty' => true);
			$bbcode_list['option']['size'] = array('html' => '<font size="%2$s">%1$s</font>','option_regex' => '#^[0-9\+\-]+$#', 'strip_empty' => true);
			$bbcode_list['option']['font'] = array('html' => '<font face="%2$s">%1$s</font>','option_regex' => '#^[^["`\':]+$#', 'strip_empty' => true);
			if ($with_color)
			{
				// Put color bbcode if authorized
				$bbcode_list['option']['color'] = array('html' => '<font color="%2$s">%1$s</font>', 'option_regex' => '#^\#?\w+$#', 'strip_empty' => true);
			}	
		}
		
		// Url bbcode
		if ($this->registry->options['mgc_cb_evo_bbcode_url'])
		{
			$bbcode_list['no_option']['url'] = array('callback' => 'handle_bbcode_url','strip_empty' => true);
			$bbcode_list['option']['url'] = array('callback' => 'handle_bbcode_url','strip_empty' => true);
		}
	
		// Email bbcode
		if ($this->registry->options['mgc_cb_evo_bbcode_email'])
		{
			$bbcode_list['no_option']['email'] = array('callback' => 'handle_bbcode_email','strip_empty' => true);
			$bbcode_list['option']['email'] = array('callback' => 'handle_bbcode_email','strip_empty' => true);
		}
	
		// Noparse bbcode
		if ($this->registry->options['mgc_cb_evo_bbcode_noparse'])
		{
			$bbcode_list['no_option']['noparse'] = array(
				'html' => '%1$s',
				'strip_empty' => true,
				'stop_parse' => true,
				'disable_smilies' => true
			);
		}
		
		// Quote bbcode
		if ($this->registry->options['mgc_cb_evo_bbcode_quote'])
		{
			$bbcode_list['no_option']['quote'] = array(
				'callback' => 'handle_bbcode_quote',
				'strip_empty' => true,
				'strip_space_after' => 2
			);
			$bbcode_list['option']['quote'] = array(
				'callback' => 'handle_bbcode_quote',
				'strip_empty' => true,
				'strip_space_after' => 2,
				'parse_option' => true
			);
		}
	
		return $bbcode_list;
	}
	
	// Decode data passed through htmlspecialchars function
	function decode_htmlspecialchars($string,$style=ENT_COMPAT)
	{
		$translation = array_flip(get_html_translation_table(HTML_SPECIALCHARS,$style));
	
		if($style === ENT_QUOTES)
		{
			$translation['&#039;'] = '\'';
		}
	
		return strtr($string,$translation);
	}	
	
	// Construct the chatbit display
	function construct_chat($chat, $parsebbcode, $commands_status, $channel_id,$alt = 'alt2',$static = 0,$showchanname = 0,$keywords = '')
	{
		global $permissions,$vbphrase,$vbcollapse,$stylevar,$show;
		global $style, $tempusagecache, $templateassoc;		
		global $mgc_cb_evo_floc;
		
		$vbulletin 	=& $this->registry;
	
		// Username management
		if ($chat['touid'] == 0)
		{
			// Normal command
			$username_prefix = "";
			
			if (!$chat['fromuid'])
			{
				if (substr($chat['ctext'],0,4) == "bot:")
				{
					// Bot
					$anonymous 	= 1;
					$formatbot	= 1;
					$user['username']   = $user['raw_username'] = $this->registry->options['mgc_cb_evo_bot_name'];				
					$chat['ctext'] = substr($chat['ctext'],4);
				}
				else
				{
					// Anonymous user
					$anonymous = 1;
					$formatbot = 0;
					if ($this->registry->options['mgc_cb_evo_ask_anonymous_name'] && !empty($chat['name']))
					{
						// Display entered name if option active
						$user['username']	= $user['raw_username'] = htmlspecialchars_uni($chat['name']);
					}
					else
					{
						// Display anonymouse name
						$user['username']   = $user['raw_username'] = $this->registry->options['mgc_cb_evo_anonymous_uname'];
					}
				}
			}
			else
			{
				if (substr($chat['ctext'],0,4) == "bot:")
				{
					$anonymous		        = 0;
					$formatbot				= 0;
					
					// Build username
					$user 					= array();
					$user['userid'] 		= $chat['fromuid'];
					$user['usergroupid']    = $chat['usergroupid'];
					$user['displaygroupid'] = $chat['displaygroupid'];
					$user['username'] 		= $user['raw_username'] = $chat['name'];
					$user['username'] 		= fetch_musername($user, 'displaygroupid');							
					
					$chat['ctext'] = substr($chat['ctext'],4);
				}
				else
				{
					$anonymous		        = 0;
					$formatbot				= 0;
					
					// Build username
					$user 					= array();
					$user['userid'] 		= $chat['fromuid'];
					$user['usergroupid']    = $chat['usergroupid'];
					$user['displaygroupid'] = $chat['displaygroupid'];
					$user['username'] 		= $user['raw_username'] = $chat['name'];
					$user['username'] 		= fetch_musername($user, 'displaygroupid');				
				}			
			}
		} 
		else
		{
			// Command from user to user		  
			$user = array();
			if ($chat['fromuid'] == $this->registry->userinfo['userid'] && !$this->inpm)
			{
				// Message sent by the user
				$username_prefix 		= $vbphrase['mgc_cb_evo_to'] . " ";
				$anonymous 		        	= 0;
				$formatbot					= 0;
				
				// Build username
				$user['userid'] 			= $chat['touid'];
				$user['usergroupid']    = $chat['tousergroupid'];
				$user['displaygroupid'] = $chat['todisplaygroupid'];
				$user['username'] 		= $user['raw_username'] = $chat['toname'];
				$user['username'] 		= fetch_musername($user, 'displaygroupid');
			}
			else
			{
				// Message sent to the user
				if (!$this->inpm)
				{
					$username_prefix 		= $vbphrase['mgc_cb_evo_from'] . " ";
				}
				else
				{
					$username_prefix 		= "";
				}
				$anonymous					= 0;
				$formatbot					= 0;
				
				// Build username
				$user['userid'] 		= $chat['fromuid'];
				$user['usergroupid']    = $chat['usergroupid'];
				$user['displaygroupid'] = $chat['displaygroupid'];
				$user['username'] 		= $user['raw_username'] = $chat['name'];
				$user['username'] 		= fetch_musername($user, 'displaygroupid');
			}
		}
		
		$user['raw_username_secured'] = addslashes($user['raw_username']);
	
		if ($this->registry->options['mgc_cb_evo_avatar_on'])
		{
			// Manage avatar if option active
			
			if ($anonymous)
			{
				// Show no avatar for anonymous users
		
				if ($this->mgc_vbversion < 4)
				{
					$avatarurl = $stylevar['imgdir_misc'] . '/mgc_cb_evo/noavatar.jpg';
				}
				else
				{
					$avatarurl = vB_Template_Runtime::fetchStyleVar('imgdir_misc') . '/mgc_cb_evo/noavatar.jpg';
				}				
			}
			else
			{
				// Get user avatar
				$chat['userid'] 	= $user['userid'];
				$avatarurl 			= $this->get_avatar($chat,0);
			}
		}	
	
		// Username display applies for all chats except the one with the me or slap command and the notifications
		if ($chat['coidentifier'] != 'me' && $chat['coidentifier'] != 'slap' && !$chat['iswarning'])
		{
			$user['username'] = str_replace("{1}",$user['username'],$this->registry->options['mgc_cb_evo_username_html']);
		}
		
		// Hide date/time var for notifications
		if ($chat['iswarning'] && $this->registry->options['mgc_cb_evo_notifications_display'])
		{
			$hidedatespecial = $this->registry->options['mgc_cb_evo_schat_hidedate'];
			$hidetimespecial = $this->registry->options['mgc_cb_evo_schat_hidetime'];
		}
		else
		{
			$hidedatespecial = 0;
			$hidetimespecial = 0;
		}
	
		// Display date
		if ($this->registry->options['mgc_cb_evo_do_yestoday'] && !$static)
		{
			if ($this->registry->options['mgc_cb_evo_show_date'] && !$hidedatespecial)
			{
				$date = vbdate($this->registry->options['dateformat'], $chat['dateline'],true,false);
			}
			else
			{
				$date = "";
			}
	
			// Display time
			if ($this->registry->options['mgc_cb_evo_show_time'] && !$hidetimespecial)
			{
				$time = vbdate($this->registry->options['timeformat'], $chat['dateline'],true,false);
			}
			else
			{
				$time = "";
			}
		}
		else
		{
			if ($static)
			{
				$date = vbdate($this->registry->options['mgc_cb_evo_archives_format_date'], $chat['dateline'],0,false);
			}
			else
			{
				if ($this->registry->options['mgc_cb_evo_show_date'] && !$hidedatespecial)
				{
					$date = vbdate($this->registry->options['mgc_cb_evo_format_date'], $chat['dateline'],0,false);
				}
				else
				{
					$date = "";
				}
			}
	
			// Display time
			if ($this->registry->options['mgc_cb_evo_show_time'] && !$hidetimespecial)
			{
				$time = vbdate($this->registry->options['mgc_cb_evo_format_time'], $chat['dateline'],false,false);
			}
			else
			{
				$time = "";
			}
		}
	
		// Chats management (Edit )
		if ($this->vbcollapse['collapseobj_mgc_chatbox'] == '')
		{
			// Chatbox not collapsed
			$show['mgc_cb_evo_mngt'] = $this->evo_core->evo_permissions->can_manage() || (($this->registry->userinfo['userid'] == $chat['fromuid']) && $this->evo_core->evo_permissions->can_manage_own_chats());
		}
		else
		{
			$show['mgc_cb_evo_mngt'] = 0;
		}
	
		if ($show['mgc_cb_evo_mngt'])
		{
			$chat_ondblclick = "ondblclick='mgc_cb_evo_inline_edit(this,$chat[chatid])'";
		}
		else
		{
			$chat_ondblclick = "";
		}
	
		// Chats management in static (Delete)
		if ($static && $this->evo_core->evo_permissions->can_manage())
		{
			$show['delete_column'] = true;
		}
	
		//** Chat display formatting **
		if ($parsebbcode)
		{
			// Bbcode parsing if bbcodes are active and the command is not the me command
			$parser 		= &new vB_BbCodeParser($this->registry, $this->construct_bbcode_tag_list(true));
			$chat['text'] 	= $parser->do_parse($chat['ctext'], false, $this->registry->options['mgc_cb_evo_smileys'], true,$this->registry->options['mgc_cb_evo_bbcode_img'], true, false);
		}
		else if ($this->registry->options['mgc_cb_evo_smileys'])
		{
			// Only parse smilies
			$parser 		= &new vB_BbcodeParser($this->registry, $this->construct_bbcode_tag_list(true));
			$chat['text'] 	= $parser->do_parse($chat['ctext'], false, true, false,$this->registry->options['mgc_cb_evo_bbcode_img'], true, false);
		}
		else
		{
			// Fetch censored text
			$chat['text'] = fetch_censored_text($chat['ctext']);
			$chat['text'] = htmlspecialchars($chat['ctext']);
		}
	
		// Specific display management for the me and slap commands
		if ($chat['coidentifier'] == 'me')
		{
			$show['mgc_cb_evo_username_column'] = 0;
			$chat['text'] 	= '<font color="#' . $this->registry->options['mgc_cb_evo_cmd_me_color'] . '"><b>* ' . $user['username'] . ' ' . $chat['text'] . '</b></font>';
		}
		else if ($chat['coidentifier'] == 'slap')
		{
			$show['mgc_cb_evo_username_column'] = 0;
			$text = str_replace("{1}",$user['username'],$this->registry->options['mgc_cb_evo_cmd_slap_phrase']);
			$text = str_replace("{2}",$chat['text'],$text);
			$chat['text'] 	= '<font color="#' . $this->registry->options['mgc_cb_evo_cmd_slap_color'] . '"><b>* ' . $text . '</b></font>';
		}
		else if ($chat['warningtype'] == 'thread')
		{
			$show['mgc_cb_evo_username_column'] = 1;
			$pos_coma 		= strpos($chat['text'],',');
			$threadid		= substr($chat['text'],0,$pos_coma);
			$threadtitle 	= $this->decode_htmlspecialchars(substr($chat['text'],$pos_coma + 1));
			$chat['text'] 	= construct_phrase($vbphrase['mgc_cb_evo_x_has_posted_newthread'],$this->registry->options['bburl'],$threadid,$threadtitle);
		}
		else if ($chat['warningtype'] == 'post')
		{
			$show['mgc_cb_evo_username_column'] = 1;
			$pos_coma1 		= strpos($chat['text'],',');
			$threadid		= substr($chat['text'],0,$pos_coma1);
			$chat['text'] 	= substr($chat['text'],$pos_coma1 + 1);
			$pos_coma2		= strpos($chat['text'],',');
			$postid			= substr($chat['text'],0,$pos_coma2);
			$threadtitle 	= $this->decode_htmlspecialchars(substr($chat['text'],$pos_coma2 + 1));
			$chat['text'] 	= construct_phrase($vbphrase['mgc_cb_evo_x_has_posted_newpost_inthread_y'],$this->registry->options['bburl'],$postid,$threadtitle);
		}
		else
		{
			$show['mgc_cb_evo_username_column'] = 1;
		}
		
		// If bot chat add format
		if ($formatbot)
		{
			$chat['text'] = str_replace("{1}",$chat['text'],$this->registry->options['mgc_cb_evo_bot_chats_format']);
		}
	
		// Add Team command prefix if needed
		if ($chat['coidentifier'] == 'team' && !empty($this->registry->options['mgc_cb_evo_cmd_team_prefix']))
		{
			$chat['text'] = $this->registry->options['mgc_cb_evo_cmd_team_prefix'] . '&nbsp;' . $chat['text'];
		}
	
		// Notifications display text hook
		($hook = vBulletinHook::fetch_hook('mgc_cb_evo_notifs_display_text')) ? eval($hook) : false;
	
		// Font class
		if ($chat['iswarning'])
		{
			if ($this->registry->options['mgc_cb_evo_schat_fontclass'])
			{
				$fontclass= "smallfont";
			}
			else
			{
				$fontclass = "normalfont";
			}
		}
		else
		{
			if ($this->registry->options['mgc_cb_evo_chat_fontclass'])
			{
				$fontclass= "smallfont";
			}
			else
			{
				$fontclass = "normalfont";
			}
		}

		// Some authorization for the menu
		$show['stickychat'] 		= $this->evo_core->evo_permissions->can_sticky_chat();
		$show['search_userchats'] 	= $this->evo_core->evo_permissions->can_search();
		$show['userip'] 			= $this->evo_core->evo_permissions->can_view_ips();
		$show['reportchat']			= $this->evo_core->evo_permissions->can_report();
	
		// Manage channel name if active
		if ($showchanname)
		{
			// General channel
			if ($chat['chanid'] == 0)
			{
				$channelname = $vbphrase['mgc_cb_evo_channel_gen'];
			}
			else
			{
				$channelname = htmlspecialchars_uni($chat['chantitle']);
			}
		}
	
		// Let's build the commands chatbit menu bit if user is not anonymous
		if ((!$anonymous || $formatbot) && !$chat['iswarning'])
		{
			$chatbox_menu_username = addslashes($user['raw_username']);	
			
			if ($this->mgc_vbversion < 4)
			{
				eval('$chatbit_menu .= "' . fetch_template('mgc_cb_evo_chatbit_menu') . '";');
			}
			else
			{
				if ($static)
				{
					$templater=vB_Template::create('mgc_cb_evo_archatbit_menu_vb4');
					$templater->register('chatbox_menu_username',$chatbox_menu_username);
					$templater->register('user',$user);
					$templater->register('chat',$chat);
					$templater->register('commands_status',$commands_status);
					$templater->register('static',$static);
					$templater->register('formatbot',$formatbot);
					$chatbit_menu = $templater->render();
				}
				else
				{
					$templater=vB_Template::create('mgc_cb_evo_chatbit_menu_vb4');
					$templater->register('chatbox_menu_username',$chatbox_menu_username);
					$templater->register('user',$user);
					$templater->register('chat',$chat);
					$templater->register('commands_status',$commands_status);
					$templater->register('static',$static);
					$templater->register('formatbot',$formatbot);
					$chatbit_menu = $templater->render();
				}
			}		
		}
	
		// Highlight keywords if option active and keywords provided
		if ($this->registry->options['mgc_cb_evo_highlight_searched_keywords'] && !empty($keywords))
		{
			$keywords 		= addslashes($keywords);
			$chat['text'] 	= preg_replace('/('.$keywords.')/i', "<span style=\"font-weight: bold;color: #FF0000; background-color: #" . $this->registry->options['mgc_cb_evo_highlight_searched_keywords_color'] . ";\">$1</span> ", $chat['text']);
		}
		
		// If PM in tab, we should have username click leading to channel change
		if ($commands_status['pm'] && $this->registry->options['mgc_cb_evo_cmd_pm_tabs'])
		{
			$show['mgc_cb_evo_pm_tabs'] = 1;
		}
	
		// Return the chat line or the chat columns array
		if ($static)
		{
			if ($this->mgc_vbversion < 4)
			{
				eval('$chat_txt .= "' . fetch_template('mgc_cb_evo_static_chatbit') . '";');
			}
			else
			{
				$templater=vB_Template::create('mgc_cb_evo_static_chatbit_vb4');
				$templater->register('chatbit_menu',$chatbit_menu);
				$templater->register('chat',$chat);				
				$templater->register('avatarurl',$avatarurl);
				$templater->register('date',$date);
				$templater->register('anonymous',$anonymous);
				$templater->register('username_prefix',$username_prefix);
				$templater->register('user',$user);
				$templater->register('showchanname',$showchanname);
				$templater->register('channelname',$channelname);
				$templater->register('chat_ondblclick',$chat_ondblclick);				
				$chat_txt = $templater->render();			
			}
			
			return $chat_txt;
		}
		else
		{
			if ($this->mgc_vbversion < 4)
			{
				eval('$chat_cols[col_avatar] .= "' . fetch_template('mgc_cb_evo_chatbit_col_avatar') . '";');
				eval('$chat_cols[col_chat]   .= "' . fetch_template('mgc_cb_evo_chatbit_col_chat') . '";');
				
				if ($this->registry->options['mgc_cb_evo_stickychat_replace_date'] && $chat['sticky'])
				{
					$chat_cols['col_date'] = "&nbsp; " . $vbphrase['mgc_cb_evo_important'];
				}
				else
				{
					eval('$chat_cols[col_date]   .= "' . fetch_template('mgc_cb_evo_chatbit_col_date') . '";');
				}
				
				if (!$chat['iswarning'])
				{
					eval('$chat_cols[col_atusername]	.= "' . fetch_template('mgc_cb_evo_chatbit_col_atusername') . '";');			
				}
				else
				{
					$chat_cols['col_atusername'] = "";
				}
				
				eval('$chat_cols[col_menu]   		.= "' . fetch_template('mgc_cb_evo_chatbit_col_menu') . '";');
				eval('$chat_cols[col_sticky] 		.= "' . fetch_template('mgc_cb_evo_chatbit_col_sticky') . '";');				
				eval('$chat_cols[col_uname]  		.= "' . fetch_template('mgc_cb_evo_chatbit_col_uname') . '";');				
			}
			else
			{
				$templater=vB_Template::create('mgc_cb_evo_chatbit_col_avatar_vb4');
				$templater->register('avatarurl',$avatarurl);
				$chat_cols['col_avatar'] = $templater->render();	
				
				
				$templater=vB_Template::create('mgc_cb_evo_chatbit_col_chat_vb4');
				$templater->register('fontclass',$fontclass);
				$templater->register('chat_ondblclick',$chat_ondblclick);
				$templater->register('chat',$chat);
				$chat_cols['col_chat'] = $templater->render();		
				
				
				if ($this->registry->options['mgc_cb_evo_stickychat_replace_date'] && $chat['sticky'])
				{
					$chat_cols['col_date'] = "&nbsp; " . $vbphrase['mgc_cb_evo_important'];
				}
				else
				{
					$templater=vB_Template::create('mgc_cb_evo_chatbit_col_date_vb4');
					$templater->register('fontclass',$fontclass);
					$templater->register('date',$date);
					$templater->register('time',$time);
					$chat_cols['col_date'] = $templater->render();		
				}
				
				if (!$chat['iswarning'])
				{
					$templater=vB_Template::create('mgc_cb_evo_chatbit_col_atusername_vb4');
					$templater->register('user',$user);
					$chat_cols['col_atusername'] = $templater->render();		
				}
				else
				{
					$chat_cols['col_atusername'] = "";
				}
				
				$templater=vB_Template::create('mgc_cb_evo_chatbit_col_menu_vb4');
				$templater->register('chatbit_menu',$chatbit_menu);
				$templater->register('chat',$chat);
				$chat_cols['col_menu'] = $templater->render();
				
				
				$templater=vB_Template::create('mgc_cb_evo_chatbit_col_sticky_vb4');
				$templater->register('chat',$chat);
				$chat_cols['col_sticky'] = $templater->render();

				$templater=vB_Template::create('mgc_cb_evo_chatbit_col_uname_vb4');
				$templater->register('fontclass',$fontclass);
				$templater->register('anonymous',$anonymous);
				$templater->register('username_prefix',$username_prefix);
				$templater->register('user',$user);
				$chat_cols['col_uname'] = $templater->render();				
			}
	
			// Remove html comments to avoid problem with vB templates name html comment in ajax
			foreach($chat_cols AS $key => $value)
			{
				$val = preg_replace('/<!--(.|\s)*?-->/', '', $value);
				$chat_cols[$key] = $val;
			}
	
			return $chat_cols;
		}
	}
	
	// Get user avatar from user information
	function get_avatar($userinfo,$touser)
	{
		global $stylevar;
		
		// Imgdir misc
		if ($this->mgc_vbversion < 4)
		{
			$imgdir_misc = $stylevar['imgdir_misc'];
		}
		else
		{
			$imgdir_misc = vB_Template_Runtime::fetchStyleVar('imgdir_misc');
		}
		
		// If touser is set, get touser info
		if ($touser)
		{
			$userinfo['avatarpath']			= $userinfo['toavatarpath'];
			$userinfo['avatarid']			= $userinfo['toavatarid'];
			$userinfo['hascustom']			= $userinfo['tohascustom'];
			$userinfo['hascustomavatar']	= $userinfo['tohascustomavatar'];
			$userinfo['userid']				= $userinfo['touid'];
			$userinfo['avatarrevision']		= $userinfo['toavatarrevision'];
			$userinfo['filedata_thumb']		= $userinfo['tofiledata_thumb'];
			$userinfo['avatardateline']		= $userinfo['toavatardateline'];
		}
	
		if (!empty($userinfo['avatarpath']))
		{
			// Non custom avatar
			if ($thumb)
			{
				if (@file_exists(DIR . '/images/avatars/thumbs/' . $userinfo['avatarid'] . '.gif'))
				{
					$avatarurl = 'images/avatars/thumbs/' . $userinfo['avatarid'] . '.gif';
				}
				else
				{
					$avatarurl = $userinfo['avatarpath'];
				}
			}
			else
			{
				$avatarurl = $userinfo['avatarpath'];
			}
		}
		else if ($userinfo['hascustom'] OR $userinfo['hascustomavatar'])
		{
			// User custom avatar
			if ($this->registry->options['usefileavatar'])
			{
				if ($thumb AND @file_exists($this->registry->options['avatarpath'] . "/thumbs/avatar$userinfo[userid]_$userinfo[avatarrevision].gif"))
				{
					$avatarurl = $this->registry->options['avatarurl'] . "/thumbs/avatar$userinfo[userid]_$userinfo[avatarrevision].gif";
				}
				else
				{
					$avatarurl =  $this->registry->options['avatarurl'] . "/avatar$userinfo[userid]_$userinfo[avatarrevision].gif";
				}
			}
			else
			{
				if ($thumb AND $userinfo['filedata_thumb'])
				{
					$avatarurl = 'image.php?' . $this->registry->session->vars['sessionurl'] . 'u=' . $userinfo['userid'] . "&amp;dateline=$userinfo[avatardateline]&amp;type=thumb";
				}
				else
				{
					$avatarurl = 'image.php?' . $this->registry->session->vars['sessionurl'] . 'u=' . $userinfo['userid'] . "&amp;dateline=$userinfo[avatardateline]";
				}
			}
		}
	
		// No avatar => show no avatar image
		if (empty($avatarurl))
		{
			$avatarurl = $imgdir_misc . '/mgc_cb_evo/noavatar.jpg';
		}
	
		return $avatarurl;
	}
	
}

?>