<?php

if (!defined('INDMCHAT'))
{
	echo "You can't include this file directly !";
	die;
}

// Purge chatbox
if ($this->raw_chat == "all")
{
    $this->registry->db->query_write("TRUNCATE TABLE " . TABLE_PREFIX . "mgc_cb_evo_chat");
    $this->registry->db->query_write("ALTER TABLE " . TABLE_PREFIX . "mgc_cb_evo_chat AUTO_INCREMENT = 0");
    $this->log_action($vbphrase['mgc_cb_evo_log_del_all']);
}
// All chats removal from the channel
else if ($this->raw_chat == "chan")
{
    $this->registry->db->query_write("
		DELETE
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat
		WHERE chanid='" . $this->mgc_cb_evo_chat['chanid'] . "'
	");
    $this->log_action(construct_phrase($vbphrase['mgc_cb_evo_log_del_chan_x'],$this->mgc_cb_evo_chat['chanid']));
}
// Removal of a user chats thanks to his userid
else if(substr($this->raw_chat,0,4) == "uid ")
{
    $userid = intval(trim(substr($this->raw_chat,4)));

    // Let's check if the user exists
    $getuser = $this->registry->db->query_first("SELECT userid,username FROM " . TABLE_PREFIX . "user WHERE userid='$userid'");
    if (!isset($getuser['userid']))
	{
		$this->construct_popup($vbphrase['mgc_cb_evo_cmd_del_false_user']);
		return;
	}

    $this->registry->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE fromuid='$userid' OR touid='$userid'");

    $this->log_action(construct_phrase($vbphrase['mgc_cb_evo_log_del_user_x'],$getuser['username']));
}
// Removal of a user chats thanks to his username
else if(substr($this->raw_chat,0,6) == "uname ")
{
    $username = trim(substr($this->raw_chat,6));

    // Let's check if the user exists
    $getuser = $this->registry->db->query_first("SELECT userid,username FROM " . TABLE_PREFIX . "user WHERE username='" . $this->registry->db->escape_string($username) . "'");
    if (!isset($getuser['userid']))
    {
        $this->construct_popup($vbphrase['mgc_cb_evo_cmd_del_false_user']);
        return;
    }

    $this->registry->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE fromuid='" . $getuser['userid'] . "' OR touid='" . $getuser['userid'] . "'");

    $this->log_action(construct_phrase($vbphrase['mgc_cb_evo_log_del_user_x'],$getuser['username']));
}
// Removal of the chats older than x days
else if (substr($this->raw_chat,0,5) == "days ")
{
    $days = intval(trim(substr($this->raw_chat,5)));
    if ($days <= 0)
    {
        $this->construct_popup($vbphrase['mgc_cb_evo_syntax_error']);
        return;
    }
    $dateline = mktime(0, 0, 0, date("m"), date("d"),   date("Y")) - ($days * 86400);

    $this->registry->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE dateline <= '$dateline'");

    $this->log_action(construct_phrase($vbphrase['mgc_cb_evo_log_del_day_x'],$days));
}
// Removal of a chat with its given chatid
else if (substr($this->raw_chat,0,7) == "chatid ")
{
    $chatid = intval(trim(substr($this->raw_chat,7)));

    // Let's check if the chat exists
    $getchat = $this->registry->db->query_first("
		SELECT chatid,username,ctext
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
		LEFT JOIN " . TABLE_PREFIX . "user AS u ON (c.fromuid=u.userid)
		WHERE chatid='$chatid'
	");
    if (!isset($getchat['chatid']))
    {
        $this->construct_popup($vbphrase['mgc_cb_evo_cmd_del_false_chat']);
        return;
    }

    $this->registry->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE chatid='$chatid'");

    $this->log_action(construct_phrase($vbphrase['mgc_cb_evo_log_del_chat_of_x_with_text_y'],$getchat['username'],$getchat['ctext']));
}
else
{
    $this->construct_popup($vbphrase['mgc_cb_evo_syntax_error']);
    return;
}

$this->construct_popup($vbphrase['mgc_cb_evo_cmd_del_success'],1);
return;

?>