<?php

// MGC Chatbox Evo : Misc class
class MGCCbEvo_misc
{
	// Registry var
	var $registry = null;
	
	// Vb version
	var $mgc_vbversion = 0;

	// Constructor
	function MGCCbEvo_misc(&$registry)
	{
		if (is_object($registry))
		{
			$this->registry =& $registry;
		}
		else
		{
			trigger_error(get_class($this) . '::Registry object is not an object', E_USER_ERROR);
		}
		
		$this->mgc_vbversion = substr($this->registry->options['templateversion'],0,1);
	}
	
	// Default channel selector construct
	function construct_default_channel_selector()
	{
		global $vbphrase;
		
		if (array_key_exists('mgc_cb_evo_uchanid',$this->registry->userinfo))
		{
			// User choice
			$select_val = $this->registry->userinfo['mgc_cb_evo_uchanid'];
		}
		else
		{
			// Usergroup default
			$select_val = $this->registry->userinfo['mgc_cb_evo_chanid'];
		}
	
		$channel_select = '<select name="mgc_cb_evo_uchanid" id="mgc_cb_evo_uchanid">';
		$channel_select .= '<option value="0" ' . (($select_val == 0) ?  "selected=\"selected\"" : "") . '>' . $vbphrase['mgc_cb_evo_channel_gen'] . '</option>';
	
		// Get channels
		if (is_array($this->registry->mgc_cb_evo_channels))
		{					
			foreach($this->registry->mgc_cb_evo_channels AS $channel)
			{
				if (!empty($channel['usergroupids']))
				{
					$channel['usergroupids'] = explode(',',$channel['usergroupids']);
				}
				else
				{
					$channel['usergroupids'] = array();
				}
				
				if (!empty($channel['userids']))
				{
					$channel['userids'] = explode(',',$channel['userids']);
				}	
				else
				{
					$channel['userids'] = array();
				}
									
				// Channel not active => next
				if ($channel['active'] == 0)
				{
					continue;
				}
				
				// Test if user has permissions
				$hasaccess = 0;		
				// 1 - Usergroupid test
				if (is_array($channel['usergroupids']) && in_array($this->registry->userinfo['usergroupid'],$channel['usergroupids']))
				{
					$hasaccess = 1;
				}
				// 2 - Member group test
				if (!$hasaccess && !empty($this->registry->userinfo['membergroupids']))
				{
					$found 			= 0;
					$ugipds_array 	= explode(',', $this->registry->userinfo['membergroupids']);		
					foreach ($ugipds_array as $index => $ugpid)
					{
						if (in_array($ugpid,$channel['usergroupids']))
						{
							$hasaccess = 1;
						}
					}
				}
				// 3 - Userid test
				if (!$hasaccess && is_array($channel['userids']) && in_array($this->registry->userinfo['userid'],$channel['userids']))
				{
					$hasaccess = 1;
				}
				// 4 - Skip channel if not
				if (!$hasaccess)
				{
					continue;
				}
				
				// Construct channel select bit
				if ($channel['chanid'] == $select_val)
				{
					$channel_select .= '<option value="' . $channel['chanid'] . '" selected="selected">' . $channel['title'] . '</option>';
				}
				else
				{
					$channel_select .= '<option value="' . $channel['chanid'] . '" >' . $channel['title'] . '</option>';
				}
			}
		}
	
		$channel_select .= '</select>';
	
		return $channel_select;
	}
	
	// Construct table column
	function construct_mgc_cb_evo_table_col($td_content,$td_width,$td_class = 'alt1',$tr_start = false, $tr_end = false, $td_align = 'left', $td_colspan = '0')
	{
	    global $style, $tempusagecache, $templateassoc, $stylevar;
		$vbulletin 	=& $this->registry;	
		
		if ($this->mgc_vbversion < 4)
		{
	    	eval('$table_col = "' . fetch_template('mgc_cb_evo_table_bit') . '";');
	    }
	    else
	    {
			$templater = vB_Template::create('mgc_cb_evo_table_bit_vb4');
			$templater->register('td_content',$td_content);
			$templater->register('td_width',$td_width);
			$templater->register('td_class',$td_class);
			$templater->register('tr_start',$tr_start);
			$templater->register('tr_end',$tr_end);
			$templater->register('td_align',$td_align);
			$templater->register('td_colspan',$td_colspan);
			$table_col = $templater->render();		    
	    }
	    
	    return $table_col;
	}
	
	// Construct table
	function construct_mgc_cb_evo_table($table_content)
	{
	    global $style, $tempusagecache, $templateassoc, $stylevar;
		$vbulletin 	=& $this->registry;	
	    
		if ($this->mgc_vbversion < 4)
		{
	    	eval('$table = "' . fetch_template('mgc_cb_evo_table') . '";');
	    }
	    else
	    {
			$templater = vB_Template::create('mgc_cb_evo_table_vb4');
			$templater->register('table_content',$table_content);
			$table = $templater->render();		    
	    }
	    	    
	    return $table;
	}
	
	// Construct table close popup row
	function consruct_mgc_cb_evo_table_row_close_popup($colspan = 2)
	{
	    global $style, $tempusagecache, $templateassoc, $stylevar,$vbphrase;
		$vbulletin 	=& $this->registry;	
	    return '<tr><td class="blockrow" align="center" ' . ($colspan ? 'colspan="' . $colspan . '"' : '') . '><input type="button" onclick=" return window.close();" tabindex="1" value="' . $vbphrase['mgc_cb_evo_close_popup'] . '" accesskey="s" /></td></tr>';
	}	
	
	// Get the number of chats of the user
	function get_user_number_of_chats() 
	{
		// Based on user counters ?
		if ($this->registry->options['mgc_cb_evo_count_userchats'])
		{
			$getnbchats['nbchats'] = $this->registry->userinfo['mgc_cb_evo_nbchats'];
		}
		else
		{
			$getnbchats = $this->registry->db->query_first("
			  SELECT COUNT(chatid) AS nbchats
			  FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
			  WHERE (fromuid='" . $this->registry->userinfo['userid'] . "')
		   ");
		}
	
	    return $getnbchats['nbchats'];
	}	
	
	// Get the number of chats in the chatbox (total or since last 24 hours)
	function get_number_of_chats($last24h = false)
	{
		$channel_ids = $this->get_user_channels();
		$command_ids = $this->get_user_commands();		

	    $getnbchats = $this->registry->db->query_first("
			SELECT COUNT(chatid) AS nbchats
			FROM " . TABLE_PREFIX . "mgc_cb_evo_chat
			WHERE
			  coidentifier IN($command_ids) AND chanid IN($channel_ids)
			  " . ($last24h ? "AND dateline>'" . (TIMENOW - (24 * 60    * 60)) . "'" : "") . "
			  AND (fromuid<>'0' AND (coidentifier<>'pm' OR (fromuid='" . $this->registry->userinfo['userid'] . "' OR touid='" . $this->registry->userinfo['userid'] . "')))
		");
	
	    return $getnbchats['nbchats'];
	}

	function get_top_x($dotable = false)
	{
	    global $vbphrase;
	    
	    $vbulletin 	=& $this->registry;	
		
		// Based on user table counters ?
		if ($this->registry->options['mgc_cb_evo_count_userchats'])
		{
			$get_top_x = $this->registry->db->query_read("
				 SELECT u.mgc_cb_evo_nbchats AS nbchats,u.userid,u.username,u.displaygroupid,u.usergroupid
				 FROM " . TABLE_PREFIX ."user AS u
				 ORDER BY nbchats DESC
				 LIMIT 0 , " . $this->registry->options['mgc_cb_evo_archives_stats_nbtopshouters'] . "
		   ");
		}
		else
		{
			$channel_ids = $this->get_user_channels();
			$command_ids = $this->get_user_commands();
	
			$get_top_x = $this->registry->db->query_read("
				 SELECT COUNT(chatid) AS nbchats,u.userid,u.username,u.displaygroupid,u.usergroupid
				 FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
				 LEFT JOIN " . TABLE_PREFIX ."user AS u ON (c.fromuid=u.userid)
				 WHERE
			  		coidentifier IN($command_ids) AND chanid IN($channel_ids)
				   	" . ($last24h ? "AND dateline>'" . (TIMENOW - (24 * 60 * 60)) . "'" : "") . "
				   	AND (fromuid<>'0' AND (c.coidentifier<>'pm' OR (fromuid='" . $this->registry->userinfo['userid'] . "' OR touid='" . $this->registry->userinfo['userid'] . "')))
				 GROUP BY c.fromuid
				 ORDER BY nbchats DESC
				 LIMIT 0 , " . $this->registry->options['mgc_cb_evo_archives_stats_nbtopshouters'] . "
		   ");
		}
	
	    $top_x = '';
	
		if ($this->mgc_vbversion < 4)
		{
		    // Do table in archives
		    if($dotable) 
		    {
		        if($this->registry->db->num_rows($get_top_x))
		        {
		            while($shouter = $this->registry->db->fetch_array($get_top_x))
		            {
		                $top_x .= '<tr><td class="alt2" width="100%" align="left">';
		                $top_x .= '<a style="text-decoration: none"  href="member.php?u=' . $shouter['userid'] . '">' . fetch_musername($shouter, 'displaygroupid') . '</a>';
		                $top_x .= '</td>';
		                $top_x .= '<td class="alt1" align="center">' . $shouter['nbchats'] . '</td></tr>';
		            }
		        }
		        else
		        {
		            $top_x = "<tr><td align='center' colspan='2'>" . $vbphrase['mgc_cb_evo_no_shouters'] . "</td></tr>";
		        }
		    }
		    else
		    {
		        if($this->registry->db->num_rows($get_top_x))
		        {
		            while($shouter = $this->registry->db->fetch_array($get_top_x))
		            {
		                $top_x .= '<a style="text-decoration: none"  href="member.php?u=' . $shouter['userid'] . '">' . fetch_musername($shouter, 'displaygroupid') . '</a>';
		                $top_x .= '&nbsp;(' . $shouter['nbchats'] . ')&nbsp;';
		            }
		        }
		        else
		        {
		            $top_x = $vbphrase['mgc_cb_evo_no_shouters'];
		        }
		    }
		}
		else
		{
		    // Do table in archives
		    if($dotable) 
		    {
		        if($this->registry->db->num_rows($get_top_x))
		        {
		            while($shouter = $this->registry->db->fetch_array($get_top_x))
		            {
		                $top_x .= '<tr class="blockrow"><td class="alt2" width="100%" align="left">';
		                $top_x .= '<a style="text-decoration: none"  href="member.php?u=' . $shouter['userid'] . '">' . fetch_musername($shouter, 'displaygroupid') . '</a>';
		                $top_x .= '</td>';
		                $top_x .= '<td class="alt1" align="center">' . $shouter['nbchats'] . '</td></tr>';
		            }
		        }
		        else
		        {
		            $top_x = "<tr><td align='center' colspan='2'>" . $vbphrase['mgc_cb_evo_no_shouters'] . "</td></tr>";
		        }
		    }
		    else
		    {
		        if($this->registry->db->num_rows($get_top_x))
		        {
		            while($shouter = $this->registry->db->fetch_array($get_top_x))
		            {
		                $top_x .= '<a style="text-decoration: none"  href="member.php?u=' . $shouter['userid'] . '">' . fetch_musername($shouter, 'displaygroupid') . '</a>';
		                $top_x .= '&nbsp;(' . $shouter['nbchats'] . ')&nbsp;';
		            }
		        }
		        else
		        {
		            $top_x = $vbphrase['mgc_cb_evo_no_shouters'];
		        }
		    }		
		}
	
	    return $top_x;
	}
	
	// Construct the forumhome stats row
	function construct_forumhome_stats()
	{
	    global $vbphrase;
	    return construct_phrase($vbphrase['mgc_cb_evo_stats_forumhome'],$this->registry->options['mgc_cb_stats_nbtopshouters'], $this->get_top_x(), $this->get_number_of_chats(), $this->get_number_of_chats(true), $this->get_user_number_of_chats());
	}

	// Debug function
	function writefile_debug($filename,$content)
	{
		if (!$handle = fopen($filename, 'w'))
		{
			exit;
		}
	
	    if (fwrite($handle, $content) === FALSE)
	    {
	        	exit;
	    }
	
	    fclose($handle);
	}	
	
	// Rebuild the commands datastore
	function build_commands_datastore()
	{
		$vbulletin =& $this->registry;
		$commands = $this->registry->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_command ORDER BY cid ASC");
		while ($command = $this->registry->db->fetch_array($commands))
		{
		    $commands_array[] = $command;
		}
		build_datastore('mgc_cb_evo_commands',serialize($commands_array),1);			
	}
	
	// Rebuild the channels datastores
	function build_channels_datastore()
	{
		$vbulletin =& $this->registry;	
		$channels = $this->registry->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_channel ORDER BY chanid ASC");
		while ($channel = $this->registry->db->fetch_array($channels))
		{
		    $channels_array[] = $channel;
		}
		build_datastore('mgc_cb_evo_channels',serialize($channels_array),1);
	}	
	
	// Rebuild the bots datastore
	function build_bots_datastore()
	{
		$vbulletin =& $this->registry;	
		$bots = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "mgc_cb_evo_bot");
		while ($bot = $this->registry->db->fetch_array($bots))
		{
		    $bots_array[] = $bot;
		}
		build_datastore('mgc_cb_evo_bots',serialize($bots_array),1);		
	}
	
	// Get the ids of the channels the user has access to
	function get_user_channels()
	{
		$channel_ids = array();
		$channel_ids[] = 0;
		
		if (is_array($this->registry->mgc_cb_evo_channels))
		{					
			foreach($this->registry->mgc_cb_evo_channels AS $channel)
			{
				if (!empty($channel['usergroupids']))
				{
					$channel['usergroupids'] = explode(',',$channel['usergroupids']);
				}
				else
				{
					$channel['usergroupids'] = array();
				}
				
				if (!empty($channel['userids']))
				{
					$channel['userids'] = explode(',',$channel['userids']);
				}	
				else
				{
					$channel['userids'] = array();
				}
									
				// Channel not active => next
				if ($channel['active'] == 0)
				{
					continue;
				}
				
				// Test if user has permissions
				$hasaccess = 0;		
				// 1 - Usergroupid test
				if (is_array($channel['usergroupids']) && in_array($this->registry->userinfo['usergroupid'],$channel['usergroupids']))
				{
					$hasaccess = 1;
				}
				// 2 - Member group test
				if (!$hasaccess && !empty($this->registry->userinfo['membergroupids']))
				{
					$found 			= 0;
					$ugipds_array 	= explode(',', $this->registry->userinfo['membergroupids']);		
					foreach ($ugipds_array as $index => $ugpid)
					{
						if (in_array($ugpid,$channel['usergroupids']))
						{
							$hasaccess = 1;
						}
					}
				}
				// 3 - Userid test
				if (!$hasaccess && is_array($channel['userids']) && in_array($this->registry->userinfo['userid'],$channel['userids']))
				{
					$hasaccess = 1;
				}
				// 4 - Skip channel if not
				if (!$hasaccess)
				{
					continue;
				}
				
				$channel_ids[] = $channel['chanid'];
			}
		}
		
		$channel_ids = implode(',',$channel_ids);
		
		return $channel_ids;
	}
	
	// Get the ids of the commands the user has access to
	function get_user_commands()
	{
		$command_ids[] = '0';
		
		if (is_array($this->registry->mgc_cb_evo_commands))
		{					
			foreach($this->registry->mgc_cb_evo_commands AS $command)
			{
				if (!empty($command['usergroupids']))
				{
					$command['usergroupids'] = explode(',',$command['usergroupids']);
				}
				else
				{
					$command['usergroupids'] = array();
				}
				
				if (!empty($command['userids']))
				{
					$command['userids'] = explode(',',$command['userids']);
				}
				else
				{
					$command['userids'] = array();
				}
									
				// Channel not active => next
				if ($command['active'] == 0)
				{
					continue;
				}
				
				// Test if user has permissions
				$hasaccess = 0;		
				// 1 - Usergroupid test
				if (is_array($command['usergroupids']) && in_array($this->registry->userinfo['usergroupid'],$command['usergroupids']))
				{
					$hasaccess = 1;
				}
				// 2 - Member group test
				if (!$hasaccess && !empty($this->registry->userinfo['membergroupids']))
				{
					$found 			= 0;
					$ugipds_array 	= explode(',', $this->registry->userinfo['membergroupids']);		
					foreach ($ugipds_array as $index => $ugpid)
					{
						if (in_array($ugpid,$command['usergroupids']))
						{
							$hasaccess = 1;
						}
					}
				}
				// 3 - Userid test
				if (!$hasaccess && is_array($command['userids']) && in_array($this->registry->userinfo['userid'],$command['userids']))
				{
					$hasaccess = 1;
				}
				// 4 - Skip channel if not
				if (!$hasaccess)
				{
					continue;
				}
				
				$command_ids[] = "'" . $command['identifier'] . "'";
			}
		}
		
		$command_ids = implode(',',$command_ids);
		
		return $command_ids;	
	}
}
?>