<?php

require_once(DIR . '/includes/class_bbcode.php');

// MGC Chatbox Evo : Display chat class
class MGCCbEvo_display
{
	// Registry var
	var $registry = null;
	
	// MGCCbEvo core
	var $evo_core = null;
	
	// Vb version
	var $mgc_vbversion = 0;

	// Constructor
	function MGCCbEvo_display(&$registry,&$evo_core)
	{
		if (is_object($registry))
		{
			$this->registry =& $registry;
		}
		else
		{
			trigger_error(get_class($this) . '::Registry object is not an object', E_USER_ERROR);
		}

		$this->evo_core	 		=& $evo_core;
		
		$this->mgc_vbversion 	= substr($this->registry->options['templateversion'],0,1);
	}
	
	// Construct the editor smilies selector
	function construct_editor_smilies_row()
	{	
		global $vbphrase;
		
		if ($this->registry->options['mgc_cb_evo_editor_nbsmileys'])
		{
		 	// Number of smilies to display different from 0
			if ($this->registry->options['mgc_cb_evo_editor_smileys_acporder'])
			{	
				// Acp order smilies
				$smilies = $this->registry->db->query_read("
					SELECT s.smilieid, s.smilietext, s.smiliepath, s.title
				  	FROM " . TABLE_PREFIX . "smilie AS s
					LEFT JOIN " . TABLE_PREFIX . "imagecategory AS cat ON (s.imagecategoryid=cat.imagecategoryid)
					ORDER BY cat.displayorder ASC,s.displayorder ASC
					LIMIT " . $this->registry->options['mgc_cb_evo_editor_nbsmileys']
				);
			}
			else if ($this->registry->options['mgc_cb_evo_editor_smileys_random'])
			{
				// Random smilies
				$smilies = $this->registry->db->query_read("
				  SELECT smilieid, smilietext, smiliepath, title
				  FROM " . TABLE_PREFIX . "smilie
				  ORDER BY RAND() LIMIT " . $this->registry->options['mgc_cb_evo_editor_nbsmileys']
				);
			}
			else
			{
				// Database added order smilies
				$smilies = $this->registry->db->query_read("
					SELECT smilieid, smilietext, smiliepath, title
					FROM " . TABLE_PREFIX . "smilie
					LIMIT " . $this->registry->options['mgc_cb_evo_editor_nbsmileys']
				);
			}
	
			$cb_smilies = '';
			$cnt_smilies = 0;
			
			if ($this->registry->db->num_rows($smilies))
			{
				while (($smiley = $this->registry->db->fetch_array($smilies)))
				{
					$textsmiley = str_replace("'", "\'", $smiley['smilietext']);
					$textsmiley = str_replace("\\", "\\\\", $textsmiley);
					$cb_smilies .= '<a href="#chatbox" onclick="return add_smiley_to_input(\'' . $textsmiley . '\');"><img src="' . $smiley['smiliepath'] . '" border="0" alt="' . $smiley['title'] . '" /></a> ';
				}
				return $cb_smilies;
			}
			else
			{
				return $vbphrase['mgc_cb_no_smileys'];
			}
		}
		else
		{
			return $vbphrase['mgc_cb_no_smileys'];
		}
	}	
	
	// Construct the font selector
	function construct_font_selector($fonts_list, $inprofile = false)
	{
		global $vbphrase;
	
		$userpref_val = $this->registry->userinfo['mgc_cb_evo_font'];
	
		if ($inprofile)
		{
			// Building a selector for the user cp
			$fonts_select = '<select name="mgc_cb_evo_font" id="mgc_cb_evo_font">';
			$fonts_select .= '<option value="0" ' . (($userpref_val == 0) ? "selected=\"selected\"" : "") . '" style="font-weight: bold">' . $vbphrase['use_forum_default'] . '</option>';
		}
		else
		{
			// Building a selector for the chatbox editor
			$fonts_select = '<select name="mgc_cb_evo_font" id="mgc_cb_evo_font" onchange="return configure_enhanced_format(this,\'font\');">';
			$fonts_select .= '<option value="Arial" ' . (($userpref_val == 0) ? "selected=\"selected\"" : "") . ' style="font-weight: bold">[' . $vbphrase['default'] . ']</option>';
		}
	
		foreach ($fonts_list as $id => $font)
		{
			if ($font == $userpref_val)
			{
				$fonts_select .= '<option style="font: 10px ' . strtolower($font) . ';" value="' . $font . '" selected="selected">' . $font . '</option>';
			}
			else
			{
				$fonts_select .= '<option style="font: 10px ' . strtolower($font) . ';" value="' . $font . '">' . $font . '</option>';
			}
		}
	
		$fonts_select .= '</select>';
		
		return $fonts_select;
	}	

	// Construct the size selector	
	function construct_size_selector($sizes_list, $inprofile = false)
	{
		global $vbphrase;
		
		$userpref_val = $this->registry->userinfo['mgc_cb_evo_size'];
	
		foreach ($sizes_list as $id => $size)
		{
			if ($size <= $this->registry->options['mgc_cb_evo_max_bbcode_size'])
			{
				if ($size == $userpref_val)
				{
					$sizes_selectbit .= '<option value="' . $size . '" selected="selected">' . $size . '</option>';
				}
				else
				{
					$sizes_selectbit .= '<option value="' . $size . '">' . $size . '</option>';
				}
			}
		}
		
		if ($inprofile)
		{
			// Building a selector for the user cp
			$sizes_select  = '<select name="mgc_cb_evo_size" id="mgc_cb_evo_size">';
			$sizes_select .= '<option value="0" ' . (($userpref_val == 0) ?"selected=\"selected\"" : "") . '" style="font-weight: bold">' . $vbphrase['use_forum_default'] . '</option>';
		}
		else
		{
			// Building a selector for the chatbox
			$sizes_select  = '<select name="mgc_cb_evo_size" id="mgc_cb_evo_size" onchange="return configure_enhanced_format(this,\'size\');">';
			$sizes_select .= '<option value="3" ' . ( ($select_val == 0) ? "selected=\"selected\"" : "" ) . ' style="font-weight: bold">[' . $vbphrase['default'] . ']</option>';
		}
	
		$sizes_select .= $sizes_selectbit;
		$sizes_select .= '</select>';
	
		return $sizes_select;
	}	
	
	// Construct the color selector
	function construct_color_selector($inprofile = false)
	{	
		global $vbphrase;
	
		if (!empty($this->registry->userinfo['mgc_cb_evo_color']))
		{
			// User default
			$select_val = $this->registry->userinfo['mgc_cb_evo_color'];
		}
		else if (!$inprofile && $this->registry->userinfo['mgc_cb_evo_default_color'])
		{
			// Usergroup default if different from 000000
			$select_val = $this->registry->userinfo['mgc_cb_evo_default_color'];
		}
	
		$colors_list = array(
			'#000000', '#A0522D', '#556B2F', '#006400', '#483D8B',
			'#000080', '#4B0082', '#2F4F4F', '#8B0000', '#FF8C00', '#808000', '#008000',
			'#008080', '#0000FF', '#708090', '#696969', '#FF0000', '#F4A460', '#9ACD32',
			'#2E8B57', '#48D1CC', '#4169E1', '#800080', '#808080', '#FF00FF', '#FFFF00',
			'#00FF00', '#00FFFF', '#00BFFF', '#9932CC', '#C0C0C0', '#FFC0CB', '#F5DEB3',
			'#FFFACD', '#98FB98', '#AFEEEE', '#ADD8E6', '#DDA0DD', '#FFFFFF'
		);
	
		if ($inprofile)
		{
			$colors_select = '<select name="mgc_cb_evo_color" id="mgc_cb_evo_color">';
			$colors_select .= '<option value="0" ' . (empty($select_val) ?  "selected=\"selected\"" : "") . '" style="font-weight: bold">' . $vbphrase['use_forum_default'] . '</option>';
		}
		else
		{
			$colors_select = '<select name="mgc_cb_evo_color" id="mgc_cb_evo_color" onchange="return configure_enhanced_format(this,\'color\');">';
			$colors_select .= '<option value="#' . $this->registry->userinfo['mgc_cb_evo_default_color'] . '" ' . (empty($select_val) ? "selected=\"selected\"" : "") . ' style="font-weight: bold">[' . $vbphrase['default'] . ']</option>';
		}
	
		foreach ($colors_list as $name => $val)
		{
			if ($val == '#' . $select_val)
			{
				$colors_select .= '<option value="' . $val . '" style="background-color: ' . $val . '; color: ' . $val . '" selected="selected">' . $val . '</option>';
			}
			else
			{
				$colors_select .= '<option value="' . $val . '" style="background-color: ' . $val . '; color: ' . $val . '">' . $val . '</option>';
			}
		}
	
		$colors_select .= '</select>';
	
		return $colors_select;
	}
	
	// Construct the BBCode editor line display
	function construct_editor_bbcode_row()
	{
		global $vbphrase,$vbcollapse,$stylevar;

		$vbulletin 	=& $this->registry;
		$bbcodes = '';
	
		// Imgdir misc
		if ($this->mgc_vbversion < 4)
		{
			$imgdir_misc = $stylevar['imgdir_misc'];
		}
		else
		{
			$imgdir_misc = vB_Template_Runtime::fetchStyleVar('imgdir_misc');
		}
		
		// Simple bbcode active 
		if ($this->registry->options['mgc_cb_evo_bbcode'])
		{
			if ($this->mgc_vbversion < 4)
			{
				// Get necessary templates
				foreach (array('editor_jsoptions_font', 'editor_jsoptions_size') as $template)
				{
					$string 	= fetch_template($template, 1, 0);
					$$template 	= preg_split('#\r?\n#s', $string, -1, PREG_SPLIT_NO_EMPTY);
				}
				$fontnames  = $editor_jsoptions_font;
				$fontsizes 	= $editor_jsoptions_size;
			}
			else
			{
				foreach(array('editor_jsoptions_font', 'editor_jsoptions_size') AS $template)
				{
					$templater = vB_Template::create($template);
					$string = $templater->render(true);
					$fonts = preg_split('#\r?\n#s', $string, -1, PREG_SPLIT_NO_EMPTY);
					foreach ($fonts AS $font)
					{
						if ($template == 'editor_jsoptions_font')
						{
							$fontnames[] = trim($font);
						}
						else
						{
							$fontsizes[] = trim($font);
						}
					}
				}		
			}
		
			// Font list
			$bbcodes .= $this->construct_font_selector($fontnames);
			
			// Sizes list
			$bbcodes .= '&nbsp;&nbsp;' . $this->construct_size_selector($fontsizes);
			
			// Colors selector 
			$bbcodes .= '&nbsp;&nbsp;' . $this->construct_color_selector();
			
			// B / I / U buttons
			if ($this->registry->userinfo['mgc_cb_evo_b'])
			{
				$bbcodes .= '&nbsp;<input type="image" id="bbcode_image_b" name="bold" style="vertical-align: middle;" src="' . $imgdir_misc . '/mgc_cb_evo/mgc_cb_evo_b_on.gif"  value="b" onclick="return configure_simple_format(\'b\');" />';
			}
			else
			{
				$bbcodes .= '&nbsp;<input type="image" id="bbcode_image_b" name="bold" style="vertical-align: middle;" src="' . $imgdir_misc . '/mgc_cb_evo/mgc_cb_evo_b_off.gif"  value="b" onclick="return configure_simple_format(\'b\');" />';
			}
			
			if ($this->registry->userinfo['mgc_cb_evo_i'])
			{
				$bbcodes .= '&nbsp;<input type="image" id="bbcode_image_i" name="italic" style="vertical-align: middle;" src="' . $imgdir_misc . '/mgc_cb_evo/mgc_cb_evo_i_on.gif" value="i" onclick="return configure_simple_format(\'i\');" />';
			}
			else
			{
				$bbcodes .= '&nbsp;<input type="image" id="bbcode_image_i" name="italic" style="vertical-align: middle;" src="' . $imgdir_misc . '/mgc_cb_evo/mgc_cb_evo_i_off.gif" value="i" onclick="return configure_simple_format(\'i\');" />';
			}
			
			if ($this->registry->userinfo['mgc_cb_evo_u'])
			{
				$bbcodes .= '&nbsp;<input type="image" id="bbcode_image_u" name="underlined" style="vertical-align: middle;" src="' . $imgdir_misc . '/mgc_cb_evo/mgc_cb_evo_u_on.gif"  value="u" onclick="return configure_simple_format(\'u\');" />';
			}
			else
			{
				$bbcodes .= '&nbsp;<input type="image" id="bbcode_image_u" name="underlined" style="vertical-align: middle;" src="' . $imgdir_misc . '/mgc_cb_evo/mgc_cb_evo_u_off.gif"  value="u" onclick="return configure_simple_format(\'u\');" />';
			}
		}
		
		if ($this->registry->options['mgc_cb_evo_bbcode_url'])
		{
			$bbcodes .= empty($bbcodes) ? '' : '&nbsp;';
			$bbcodes .= '<input type="image" name="url" style="vertical-align: middle;" src="' . $imgdir_misc . '/mgc_cb_evo/mgc_cb_evo_url.gif"  value="URL" onclick="return insert_bbcode_url();" />';
		}
		
		if ($this->registry->options['mgc_cb_evo_bbcode_email'])
		{
			$bbcodes .= empty($bbcodes) ? '' : '&nbsp;';
			$bbcodes .= '<input type="image" name="url" style="vertical-align: middle;" src="' . $imgdir_misc . '/mgc_cb_evo/mgc_cb_evo_email.gif"  value="EMAIL" onclick="return insert_bbcode_email();" />';
		}
		
		if ($vbulletin->options['mgc_cb_evo_bbcode_img']) 
		{
			$bbcodes .= empty($bbcodes) ? '' : '&nbsp;';
			$bbcodes .= '<input type="image" name="image" style="vertical-align: middle;" src="' . $imgdir_misc . '/mgc_cb_evo/mgc_cb_evo_img.gif" value="IMG" onclick="return insert_bbcode_img();" />';
		}
		
		$bbcodes .= '&nbsp;<input type="image" name="clear" style="vertical-align: middle;" src="' . $imgdir_misc . '/mgc_cb_evo/mgc_cb_evo_clear.gif" value="' . $vbphrase['mgc_cb_evo_clear_bbcode'] . '" onclick="return reset_bbcodes();" />';
		
		return $bbcodes;
	}
	
	function construct_autocompletion_array($command_identifier)
	{
	    global $vbphrase;
	
	    $autocompletion_js_array = array();
	
		// Command autocompletion
	    switch ($command_identifier)
	    {
	      case "announcement" :
	        $autocompletion_js_array[] = "\"/announcement " . $vbphrase['mgc_cb_evo_your_announcement'] . "\"";
	        $autocompletion_js_array[] = "\"/announcement remove\"";
	        break;
	      case "ban" :
	        $autocompletion_js_array[] = "\"/ban on uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
	        $autocompletion_js_array[] = "\"/ban on uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
	        $autocompletion_js_array[] = "\"/ban h " . $vbphrase['mgc_cb_evo_number_of_hours'] . " uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
	        $autocompletion_js_array[] = "\"/ban h " . $vbphrase['mgc_cb_evo_number_of_hours'] . " uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
	        $autocompletion_js_array[] = "\"/ban d " . $vbphrase['mgc_cb_evo_number_of_days'] . " uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
	        $autocompletion_js_array[] = "\"/ban d " . $vbphrase['mgc_cb_evo_number_of_days'] . " uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
	        $autocompletion_js_array[] = "\"/ban off uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
	        $autocompletion_js_array[] = "\"/ban off uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
	        $autocompletion_js_array[] = "\"/ban show\"";
	        break;
	      case "del" :
	        $autocompletion_js_array[] = "\"/del all\"";
	        $autocompletion_js_array[] = "\"/del chan\"";
	        $autocompletion_js_array[] = "\"/del days " . $vbphrase['mgc_cb_evo_number_of_days'] . "\"";
	        $autocompletion_js_array[] = "\"/del uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
	        $autocompletion_js_array[] = "\"/del uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
	        break;
	      case "ignore" :
	        $autocompletion_js_array[] = "\"/ignore on uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
	        $autocompletion_js_array[] = "\"/ignore on uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
	        $autocompletion_js_array[] = "\"/ignore off uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
	        $autocompletion_js_array[] = "\"/ignore off uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
	        $autocompletion_js_array[] = "\"/ignore show\"";
	        break;
	      case "me" :
	        $autocompletion_js_array[] = "\"/me " . $vbphrase['mgc_cb_evo_your_message'] . "\"";
	        break;
	      case "pm" :
	        $autocompletion_js_array[] = "\"/pm uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . " " . $vbphrase['mgc_cb_evo_your_message'] . "\"";
	        $autocompletion_js_array[] = "\"/pm uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . " " . $vbphrase['mgc_cb_evo_your_message'] . "\"";
	        $autocompletion_js_array[] = "\"/pm " . $vbphrase['mgc_cb_evo_your_message'] . "\"";
	        break;
	      case "slap" :
	        $autocompletion_js_array[] = "\"/slap uid " . $vbphrase['mgc_cb_evo_userid_utilisateur'] . "\"";
	        $autocompletion_js_array[] = "\"/slap uname " . $vbphrase['mgc_cb_evo_username_utilisateur'] . "\"";
	        break;
	      case "team" :
	      	$autocompletion_js_array[] = "\"/team " . $vbphrase['mgc_cb_evo_your_message'] . "\"";
	      	break;
	    }
	
	    return $autocompletion_js_array;
	}
	
	// Construct the js variables
	function construct_jsvars($autorefreshon,$chatboxlocation,$showpromptmsg,$autocompletion_js,$channelnames,$collapsestate,$chatbox_height)
	{
		global $vbphrase, $stylevar;
	
		// Stylevars
		if ($this->mgc_vbversion < 4)
		{
			$sv_left 		= $stylevar['left'];
			$sv_right 		= $stylevar['right'];
			$sv_imgdir_misc	= $stylevar['imgdir_misc'];
		}
		else
		{
			$sv_left 		= vB_Template_Runtime::fetchStyleVar('left');
			$sv_right 		= vB_Template_Runtime::fetchStyleVar('right');
			$sv_imgdir_misc	= vB_Template_Runtime::fetchStyleVar('imgdir_misc');
		}
	
		// Phrases
		$jsvars .= "var phrase_error_chat_in_process = \"" . $vbphrase['mgc_cb_evo_jserror_chat_in_progress'] . "\";";
		$jsvars .= "var phrase_enter_url = \"" . $vbphrase['mgc_cb_evo_js_enter_url'] . "\";\n";
		$jsvars .= "var phrase_enter_email = \"" . $vbphrase['mgc_cb_evo_js_enter_email'] . "\";\n";
		$jsvars .= "var phrase_enter_imgurl = \"" . $vbphrase['mgc_cb_evo_js_enter_imgurl'] . "\";\n";
		$jsvars .= "var phrase_already_editing = \"" . $vbphrase['mgc_cb_evo_already_editing'] . "\";\n";
		$jsvars .= "var phrase_edit_forbidden = \"" . $vbphrase['mgc_cb_evo_edit_forbidden'] . "\";\n";
		$jsvars .= "var phrase_inactive = \"" . $vbphrase['mgc_cb_evo_inactive'] . "\";\n";
		$jsvars .= "var phrase_enter_urltext = \""  . $vbphrase['mgc_cb_evo_js_enter_urltext'] . "\";\n";
		$jsvars .= "var phrase_enter_name = \"" . $vbphrase['mgc_cb_evo_js_enter_name'] . "\";\n";
		$jsvars .= "var phrase_error_name = \"" . $vbphrase['mgc_cb_evo_js_error_name'] . "\";\n";
		$jsvars .= "var phrase_ok = \"" . $vbphrase['mgc_cb_evo_ok'] . "\";\n";
		$jsvars .= "var phrase_yes = \"" . $vbphrase['yes'] . "\";\n";
		$jsvars .= "var phrase_no = \"" . $vbphrase['no'] . "\";\n";
		$jsvars .= "var phrase_save = \"" . $vbphrase['save'] . "\";\n";
		$jsvars .= "var phrase_cancel = \"" . $vbphrase['cancel'] . "\";\n";
		$jsvars .= "var phrase_enter_report_reason = \"" . $vbphrase['mgc_cb_evo_enter_report_reason'] . "\";\n";		
		$jsvars .= "var phrase_pm_maxtabs_reached = \"" . construct_phrase($vbphrase['mgc_cb_evo_pm_maxtabs_reached'],$this->registry->options['mgc_cb_evo_cmd_pm_maxtab']) . "\";\n";		
	
		// Options variables
		$jsvars	.= "var mgc_cb_evo_height = " . $chatbox_height . ";\n";
		$jsvars .= "var val_timeout = " . ($this->evo_core->evo_permissions->get_refresh_rate() * 1000) . ";\n";
		$jsvars .= "var mgc_cb_evo_pmtab_refresh_rate = " . ($this->registry->options['mgc_cb_evo_cmd_pm_tab_refresh_rate'] * 1000) . ";\n";
		$jsvars .= "var auto_refresh = " . $this->registry->options['mgc_cb_evo_refresh_active'] . ";\n";
		$jsvars .= "var chats_when_collapsed = " . $this->registry->options['mgc_cb_evo_nbchats_closed'] . ";\n";
		$jsvars .= "var chats_order = " . $this->registry->options['mgc_cb_evo_chats_order'] . ";\n";
		$jsvars .= "var inactive_mode = " . $this->registry->options['mgc_cb_evo_inactive_mode'] . ";\n";
		$jsvars .= "var inactive_mode_delay = " . ($this->registry->options['mgc_cb_evo_inactive_mode_delay'] * 60 * 1000) . ";\n";
		$jsvars .= "var bburl = \"" . $this->registry->options['bburl'] . "\";\n";
		$jsvars .= "var warn_active = " . $this->registry->options['mgc_cb_evo_channels_warning'] . ";\n";
		$jsvars .= "var cbavatar_on = " . $this->registry->options['mgc_cb_evo_avatar_on'] . ";\n";
		$jsvars .= "var cbalignchats = " . $this->registry->options['mgc_cb_evo_chats_align'] . ";\n";
		$jsvars .= "var cbaltcolors = " . $this->registry->options['mgc_cb_evo_alt_colors'] . ";\n";
		$jsvars .= "var warn_delay = " . ($this->registry->options['mgc_cb_evo_channels_warning_delay'] * 60 * 1000) . ";\n";
		$jsvars .= "var mgc_cb_evo_chat_valign = \"" . $this->registry->options['mgc_cb_evo_valign'] . "\";\n";
		$jsvars .= "var mgc_cb_evo_notif_display = " . ($this->evo_core->evo_permissions->can_view_notifications() ? $this->registry->options['mgc_cb_evo_notifications_display'] : 1) . ";\n";
		$jsvars .= "var hide_refreshimg = " . $this->registry->options['mgc_cb_evo_hide_refresh_img'] . ";\n";
		$jsvars .= "var mgc_cb_evo_yui_online = " . $this->registry->options['mgc_cb_evo_js_load_locally'] . ";\n";
		$jsvars .= "var mgc_cb_evo_left = \"" . $sv_left . "\";\n";
		$jsvars .= "var mgc_cb_evo_right = \"" . $sv_right . "\";\n";
		$jsvars .= "var imgdir_misc = \"" . $sv_imgdir_misc . "\";\n";
		$jsvars .= "var br_after_username = " . $this->registry->options['mgc_cb_evo_notifs_br_after_username'] . ";\n";
		$jsvars .= "var mgc_cb_evo_wysiwyg = " . $this->registry->options['mgc_cb_evo_wysiwyg'] . ";\n";
		$jsvars .= "var mgc_cb_evo_showtime = " . $this->registry->options['mgc_cb_evo_showtime'] . ";\n";
		$jsvars .= "var mgc_cb_evo_time_24hours = " . $this->registry->options['mgc_cb_evo_time_24hours_format'] . ";\n";
		$jsvars .= "var mgc_cb_evo_colspan = " . (($this->registry->options['mgc_cb_evo_editor_position'] == 0 || $this->registry->options['mgc_cb_evo_editor_position'] == 1) ? "2" : "3") .";\n";
		$jsvars .= "var mgc_cb_evo_pm_maxtab = " . $this->registry->options['mgc_cb_evo_cmd_pm_maxtab'] . ";\n";
		$jsvars .= "var mgc_cb_evo_filename = \"" . $this->registry->options['mgc_cb_evo_filename'] . ".php\";\n";
		$jsvars .= "var mgc_cb_evo_activate_atusername_icon = " . $this->registry->options['mgc_cb_evo_activate_atusername_icon'] . ";\n";
		
		// chat configuration parameters 
		if ($this->registry->userinfo['mgc_cb_evo_b'])
		{
			$jsvars .= "var mgc_cb_evo_ubbcode_b = 1;\n";
		}
		else
		{
			$jsvars .= "var mgc_cb_evo_ubbcode_b = 0;\n";	
		}
		
		if ($this->registry->userinfo['mgc_cb_evo_u'])
		{
			$jsvars .= "var mgc_cb_evo_ubbcode_u = 1;\n";
		}
		else
		{
			$jsvars .= "var mgc_cb_evo_ubbcode_u = 0;\n";	
		}	
		
		if ($this->registry->userinfo['mgc_cb_evo_i'])
		{
			$jsvars .= "var mgc_cb_evo_ubbcode_i = 1;\n";
		}
		else
		{
			$jsvars .= "var mgc_cb_evo_ubbcode_i = 0;\n";	
		}		
		
		$jsvars .= "var mgc_cb_evo_ubbcode_color 	= \"#" . $this->registry->userinfo['mgc_cb_evo_color'] . "\";\n";
		$jsvars .= "var mgc_cb_evo_ubbcode_font 	= \"" . $this->registry->userinfo['mgc_cb_evo_font'] . "\";\n";
		$jsvars .= "var mgc_cb_evo_ubbcode_size	= \"" . $this->registry->userinfo['mgc_cb_evo_size'] . "\";\n";
	 
	 	// Sound notification active 
	 	if ($this->registry->options['mgc_cb_evo_newmsg_sound'])
	 	{
	 		if ($this->registry->options['mgc_cb_evo_newmsg_sound_candisable'])
	 		{
	 			if ($this->registry->userinfo['mgc_cb_evo_sound_disable'])
	 			{
	 				$jsvars .= "var mgc_cb_evo_sound = 0;\n";
	 			}
	 			else
	 			{
	 				$jsvars .= "var mgc_cb_evo_sound = 1;\n";
	 			}
	  		}
	 		else
	 		{
	 			$jsvars .= "var mgc_cb_evo_sound = 1;\n";
	 		}
	 	}
	 	else
	 	{
	 		$jsvars .= "var mgc_cb_evo_sound = 0;\n";
	 	}
	
	 	// Channel sound notification active
	 	if ($this->registry->options['mgc_cb_evo_newmsg_channel_sound'])
	 	{
	 		if ($this->registry->options['mgc_cb_evo_newmsg_sound_candisable'])
	 		{
	 			if ($this->registry->userinfo['mgc_cb_evo_sound_disable'])
	 			{
	 				$jsvars .= "var mgc_cb_evo_sound_channel = 0;\n";
	 			}
	 			else
	 			{
	 				$jsvars .= "var mgc_cb_evo_sound_channel = 1;\n";
	 			}
	  		}
	 		else
	 		{
	 			$jsvars .= "var mgc_cb_evo_sound_channel = 1;\n";
	 		}
	 	}
	 	else
	 	{
	 		$jsvars .= "var mgc_cb_evo_sound_channel = 0;\n";
	 	}
	
	
	 	// Force anonymous to enter username before they chat
	 	if ($this->registry->options['mgc_cb_evo_ask_anonymous_name'] && ($this->registry->userinfo['usergroupid'] == 1))
	 	{
	 		$jsvars .= "var chatbox_ask_name = 1;\n";
	 	}
	 	else
	 	{
	 		$jsvars .= "var chatbox_ask_name = 0;\n";
	  	}
	
	  	// Whosonline refresh timeout
	  	if (!empty($this->registry->options['mgc_cb_evo_whoisonline_autorefresh']) && $this->registry->options['mgc_cb_evo_whoisonline_active'])
	  	{
	 		$jsvars .= "var whoisonline_active = 1;\n";
	 		$jsvars .= "var whoisonline_delay = " . ($this->registry->options['mgc_cb_evo_whoisonline_autorefresh'] * 1000 * 60) . ";\n";
	
			if (!$this->registry->options['mgc_cb_evo_whoisonline_showintab'])
			{
	      		$jsvars .= "var whoisonlineTimeout = setTimeout(\"get_online_users()\", whoisonline_delay);\n";
	    	}
	  	}
	
	  	// Inactive mode active on load
		if ($this->registry->options['mgc_cb_evo_inactive_mode'] && $this->registry->options['mgc_cb_evo_inactive_mode_onload'])
		{
			$jsvars .= "var chatbox_inactive = 1;\n";
			$jsvars .= "var idleTimeout = null;\n";
		}
		else
		{
			$jsvars .= "var chatbox_inactive = 0;\n";
	
			if ($this->registry->options['mgc_cb_evo_inactive_mode'])
			{
				// Idle timeout launch
				$jsvars .= "var idleTimeout = setTimeout(\"activate_idle_chatbox()\", inactive_mode_delay);\n";
			}
			else
			{
				$jsvars .= "var idleTimeout = null;\n";
			}
		}
	
		// Init actions management
		if (empty($collapsestate))
		{
			// Chatbox is not collapsed
			$jsvars .= "var mgc_cb_evo_iscollapsed = 0;\n";
	
			if (!$this->registry->options['mgc_cb_evo_inactive_mode'] || ($this->registry->options['mgc_cb_evo_inactive_mode'] && !$this->registry->options['mgc_cb_evo_inactive_mode_onload']))
			{
				$jsvars .= "var mgc_cb_evo_initstate = 1;\n";
			}
			else
			{
				$jsvars .= "var mgc_cb_evo_initstate = 0;\n";
			}
		}
		else
		{
			// Chatbox is collapsed
			$jsvars .= "var mgc_cb_evo_iscollapsed = 1;\n";
	
			// Show chats when collapsed
			if ($this->registry->options['mgc_cb_evo_nbchats_closed'])
			{
				$jsvars .= "var mgc_cb_evo_inistate = 1;\n";
			}
			else
			{
				$jsvars .= "var mgc_cb_evo_inistate = 0;\n";
			}
		}
	
	 	// vBulletin version
	 	$vbversion = substr($this->registry->options['templateversion'],0,1);
	 	
	 	if ($vbversion < 4)
	 	{
	 		$jsvars .= "var mgc_vb4 = 0;\n";
	 	}
	 	else
	 	{
	 		$jsvars .= "var mgc_vb4 = 1;\n";
	 	}
	 	
		$vbversion = substr($this->registry->options['templateversion'],0,3);
		if ($vbversion < 3.7)
		{
			$jsvars .= "var mgc_oldvb3 = 1;\n";
		}
		else
		{
			$jsvars .= "var mgc_oldvb3 = 0;\n";
		}
		
	 	// Function dependent configuration
		$jsvars .= "var mgc_cb_evo_autorefresh_on = " . $autorefreshon . ";\n";
	 	$jsvars .= "var mgc_cb_evo_jsloc = \"" . $chatboxlocation . "\";\n";
		$jsvars .= "var chat_input_prompt = " . $showpromptmsg . ";\n";
	
		// Autcompletion array
		if ($this->registry->options['mgc_cb_evo_act_autocompletion'] && !empty($autocompletion_js))
		{
			$jsvars .= "var chatAutocompletionarray = [" . $autocompletion_js . "];\n";
			$jsvars .= "var mgc_cb_evo_autocomplete_on = 1;\n";
		}
		else
		{
			$jsvars .= "var mgc_cb_evo_autocomplete_on = 0;\n";
		}
	
		// Disable refresh upon limit of fs
		if ($this->evo_core->evo_permissions->disable_refresh_upon_postlimit_reach())
		{
			$jsvars .= "var disablerefreshuponlimit = 1;\n";
		}
	 	else
	 	{
			$jsvars .= "var disablerefreshuponlimit = 0;\n";
	 	}
	
	 	// Channel names array
	 	if ($this->registry->options['mgc_cb_evo_show_channelname'])
	 	{
			$jsvars .= "var channelNamesArray = new Array();\n";
			foreach($channelnames AS $chanid => $channelname)
			{
				$jsvars .= "channelNamesArray[$chanid] = $channelname;\n";
			}
		}
	
		return $jsvars;
	}	
	
	function construct_mgc_cb_evo_jsinclude()
	{	
		$js = '';
		
		$vbversion = substr($this->registry->options['templateversion'],0,3);
		if ($vbversion < 3.7)
		{
			$vbversion = 1;
		}
		else
		{
			$vbversion = 0;
		}
	
		if ($this->registry->options['mgc_cb_evo_js_load_locally'])
		{
			if ($vbversion)
			{
				$js .= '<script type="text/javascript" src="http://yui.yahooapis.com/combo?2.7.0/build/yahoo-dom-event/yahoo-dom-event.js&2.7.0/build/connection/connection-min.js&2.7.0/build/animation/animation-min.js&2.7.0/build/datasource/datasource-min.js&2.7.0/build/autocomplete/autocomplete-min.js&2.7.0/build/element/element-min.js&2.7.0/build/button/button-min.js&2.7.0/build/container/container-min.js&2.7.0/build/tabview/tabview-min.js"></script>';
			}
			else
			{
				$js .= '<script type="text/javascript" src="http://yui.yahooapis.com/combo?2.7.0/build/animation/animation-min.js&2.7.0/build/datasource/datasource-min.js&2.7.0/build/autocomplete/autocomplete-min.js&2.7.0/build/element/element-min.js&2.7.0/build/button/button-min.js&2.7.0/build/container/container-min.js&2.7.0/build/tabview/tabview-min.js"></script>';
			}
		}
		else
		{
			if ($vbversion)
			{
				$js .= '<script type="text/javascript" src="mgc_cb_evo/clientscript/yui/combined/combined_oldvb-min.js"></script>';
			}
			else
			{
				$js .= '<script type="text/javascript" src="mgc_cb_evo/clientscript/yui/combined/combined-min.js"></script>';
			}
		}
	
		$js .= '<script type="text/javascript" src="mgc_cb_evo/clientscript/mgc_cb_evo_functions.js"></script>';
		return $js;
	}
	
	// Construct the chatbox display
	function construct_display($chatbox_height,$forumid = 'none') 
	{
		global $permissions,$vbphrase,$vbcollapse,$stylevar,$show;
		global $style, $tempusagecache, $templateassoc;		
		global $mgc_cb_evo_floc;
		
		$vbulletin 	=& $this->registry;	
		
		if ($vbulletin->userinfo['mgc_cb_evo_revalidate'])
		{
			@header("cache-Control: no-store, no-cache, must-revalidate");
			@header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "user
				SET mgc_cb_evo_revalidate='0'
				WHERE userid='" . $vbulletin->userinfo['userid'] . "'
			");
		}		
				
		// First load and inactive mode not activated by default => Update session table
		if (
			(!$this->registry->options['mgc_cb_evo_inactive_mode'] || ($this->registry->options['mgc_cb_evo_inactive_mode'] && !$this->registry->options['mgc_cb_evo_inactive_mode_onload'])) 
			&&
			$this->registry->options['mgc_cb_evo_whoisonline_active']
		) 
		{
			$this->registry->db->query_write("REPLACE INTO " . TABLE_PREFIX . "mgc_cb_evo_session SET userid='" . $this->registry->userinfo['userid'] . "',dateline='" . TIMENOW . "'");
		}
		
		// Retrieving of commands permissions to activate the autocompletion
		$autocompletion_js_array = array();
		if ($this->registry->options['mgc_cb_evo_act_autocompletion'])
		{
			// Get commands
			foreach ($this->registry->mgc_cb_evo_commands AS $command)
			{
				// Command inactive
				if (!$command['active'])
				{
					continue;
				}
				
				if ($this->evo_core->evo_permissions->can_use_command($command))
				{
					$show['mgc_cb_evo_command_' . $command['identifier']] = true;
		
					// If autocompletion is active, add commands tips to autocompletion array
					if ($this->registry->options['mgc_cb_evo_act_autocompletion'])
					{
						$append_array = $this->construct_autocompletion_array($command['identifier']);						
						$autocompletion_js_array = array_merge($autocompletion_js_array,$append_array);
					}
				}
				else
				{
					$show['mgc_cb_evo_command_' . $command['identifier']] = false;
				}
			}
			// Array not empty
			if (sizeof($autocompletion_js_array)) 
			{
				// Order table alphabetically
				sort($autocompletion_js_array);
				// Implode array
				$autocompletion_js = implode(',',$autocompletion_js_array);
			}
		}
		
		// Some chatbox permissions
		$show['mgc_cb_evo_promptmsg'] 	= ($this->evo_core->evo_permissions->can_view_promptmsg() && $this->registry->options['mgc_cb_evo_input_prompt']) ? 1 : 0;
		$show['mgc_cb_evo_smilies'] 	= 0;
		$show['mgc_cb_evo_bbcodes'] 	= 0;
		$show['mgc_cb_evo_archives']	= $this->evo_core->evo_permissions->can_view_archives();
		$show['mgc_cb_evo_notifs']		= $this->evo_core->evo_permissions->can_view_notifications();
		
		if ($show['mgc_cb_evo_command_pm'] && $this->registry->options['mgc_cb_evo_cmd_pm_tabs'])
		{
			$show['mgc_cb_evo_pm_tabs'] = 1;
		}
		else
		{
			$show['mgc_cb_evo_pm_tabs'] = 0;
		}
		
		// Check if user has limited number of chats per day limit
		if ($this->evo_core->evo_permissions->get_chats_perday_limit())
		{
			// Get user number of chats
			$getnbchats = $this->registry->db->query_first("
				SELECT COUNT(chatid) AS nbchats
				FROM " . TABLE_PREFIX . "mgc_cb_evo_chat
				WHERE dateline>='" . (TIMENOW - 86400) . "' AND fromuid='" . $vbulletin->userinfo['userid'] . "'
			");
		
			// Max number of chats reached => hide editor
			if ($getnbchats['nbchats'] >= $this->evo_core->evo_permissions->get_chats_perday_limit())
			{
				$warn_msg 						= $this->registry->options['mgc_cb_evo_msg_max_numberchatsperday_reached'];
				$max_number_of_chats_reached 	= 1;
				$show['mgc_cb_evo_editor'] 		= 0;
			}
			else
			{
				$max_number_of_chats_reached 	= 0;
				$show['mgc_cb_evo_editor'] 		= $this->evo_core->evo_permissions->can_use();
			}
		}
		else
		{
			$max_number_of_chats_reached 	= 0;
			$show['mgc_cb_evo_editor'] 		= $this->evo_core->evo_permissions->can_use();
		}
		
		// If editor line displayed
		if ($show['mgc_cb_evo_editor'])
		{
			// Smileys display if activated
			if ($this->evo_core->evo_permissions->can_use_smilies() && $this->registry->options['mgc_cb_evo_smileys'])
			{
				$smilies = $this->construct_editor_smilies_row();
				// Only show smilies if any
				if (!empty($smilies))
				{
					$show['mgc_cb_evo_smilies'] = 1;
				}
			}
			// BBCODE display if activated 
			if ($this->evo_core->evo_permissions->can_use_bbcodes() && ($this->registry->options['mgc_cb_evo_bbcode'] || $this->registry->options['mgc_cb_evo_bbcode_url'] || $this->registry->options['mgc_cb_evo_bbcode_email'] || $this->registry->options['mgc_cb_evo_bbcode_img']))
			{
				$bbcodes = $this->construct_editor_bbcode_row();
				$show['mgc_cb_evo_bbcodes'] = 1;
			}
		}
		
		// Construction of the channel list
		$channels_bit = '';

		if ($this->registry->options['mgc_cb_evo_show_channelname'])
		{
			$array_channelnames 		= array();
			$array_channelnames['0'] 	= "\"" . $vbphrase['mgc_cb_evo_channel_gen'] . "\"";
		}
		
		$default_channel = 0;			

		if (is_array($this->registry->mgc_cb_evo_channels))
		{					
			// Sorting of the table in chan order order
			$ordered_channels_array = array();
			foreach($this->registry->mgc_cb_evo_channels AS $channel)
			{
				$ordered_channels_array["$channel[chanorder]"] = $channel;
			}
			ksort($ordered_channels_array);
			
			// Construction of the chans links
			foreach($ordered_channels_array AS $channel)
			{
				if (!empty($channel['usergroupids']))
				{
					$channel['usergroupids'] = explode(',',$channel['usergroupids']);
				}
				else
				{
					$channel['usergroupids'] = array();
				}
				
				if (!empty($channel['userids']))
				{
					$channel['userids'] = explode(',',$channel['userids']);
				}	
				else
				{
					$channel['userids'] = array();
				}
									
				// Channel not active => next
				if ($channel['active'] == 0)
				{
					continue;
				}
				
				// Check if channel shall be shown on this page
				$show_chatbox = 1;
				switch(THIS_SCRIPT)
				{
					case "index":
						if ($channel['show_forumhome'] == 0)
						{
							$show_chatbox = 0;
						}
						break;
					case "forumdisplay":
						if ($channel['show_forumdisplay'] == 0)
						{
							continue;
						}
						else if (!empty($channel['filtered_forum']))
						{
							$forumids_array = explode(',',$channel['filtered_forum']);
							if (!in_array($forumid,$forumids_array))
							{
								$show_chatbox = 0;
							}
						}
						break;
					case "showthread":
						if ($channel['show_showthread'] == 0)
						{
							$show_chatbox = 0;
						}
						else if (!empty($channel['filtered_forum']))
						{
							$forumids_array = explode(',',$channel['filtered_forum']);
							if (!in_array($forumid,$forumids_array))
							{
								$show_chatbox = 0;
							}
						}						
						break;
					default:
						if (!empty($channel['hidden_pages']))
						{
							$hidden_pages_array = explode(',',$channel['hidden_pages']);
							if (!in_array(THIS_SCRIPT,$hidden_pages_array))
							{
								$show_chatbox = 0;
							}
						}	
						break;
				}			
				
				if (!$show_chatbox)
				{
					continue;
				}	
				
				// Test if user has permissions
				$hasaccess = 0;		
				// 1 - Usergroupid test
				if (is_array($channel['usergroupids']) && in_array($this->registry->userinfo['usergroupid'],$channel['usergroupids']))
				{
					$hasaccess = 1;
				}
				// 2 - Member group test
				if (!$hasaccess && !empty($this->registry->userinfo['membergroupids']))
				{
					$found 			= 0;
					$ugipds_array 	= explode(',', $this->registry->userinfo['membergroupids']);		
					foreach ($ugipds_array as $index => $ugpid)
					{
						if (in_array($ugpid,$channel['usergroupids']))
						{
							$hasaccess = 1;
						}
					}
				}
				// 3 - Userid test
				if (!$hasaccess && is_array($channel['userids']) && in_array($this->registry->userinfo['userid'],$channel['userids']))
				{
					$hasaccess = 1;
				}
				// 4 - Skip channel if not
				if (!$hasaccess)
				{
					continue;
				}
					
				// Channel display
				if ($this->registry->options['mgc_cb_evo_show_channelname'])
				{
					$array_channelnames["$channel[chanid]"] = "\"" . htmlspecialchars_uni($channel['title']) . "\"";
				}
				$channel_ids[] 		= $channel['chanid'];
				$channel['title'] 	= htmlspecialchars_uni($channel['title']);
				
				if ($this->mgc_vbversion < 4)
				{
					eval('$channels_bit .= "' . fetch_template('mgc_cb_evo_channel_button') . '";');
				}
				else
				{
					$templater=vB_Template::create('mgc_cb_evo_channel_button_vb4');
					$templater->register('channel',$channel);
					$channels_bit .= $templater->render();
				}
				
				// Default channel active (to check channel still active and usergroup still has access)
				if ($channel['chanid'] == $this->registry->userinfo['mgc_cb_evo_chanid'])
				{
					$default_channel = $channel['chanid'];
				}
			}
			// Channels id javascript array
			if (is_array($channel_ids))
			{
				$show['genchan'] = 1;
				$js_channels_ids_array = "var channels_ids = new Array(\"" . implode("\",\"",$channel_ids) . "\");\n";
			}
		}
	
		// User default channel : $default_channel contains the default usergroup channel, let's see if there is a user default channel
		if ($this->evo_core->evo_permissions->can_select_default_channel())
		{
			if (array_key_exists('mgc_cb_evo_uchanid',$this->registry->userinfo))
			{
				$default_channel = $this->registry->userinfo['mgc_cb_evo_uchanid'];
			}
		}
		
		// Chatbox announcement parsing
		if ($this->registry->options['mgc_cb_evo_bbcode_in_chatbox_announcement'])
		{
			require_once(DIR . '/includes/class_bbcode.php');			
			$parser =& new vB_BbCodeParser($this->registry, fetch_tag_list());
			$this->registry->options['mgc_cb_evo_announcement'] = $parser->do_parse($this->registry->options['mgc_cb_evo_announcement'], true, true, true, true, false, false);
		}
		
		// Who is online in the chatbox display
		if ($this->registry->options['mgc_cb_evo_whoisonline_active'])
		{
			$show['mgc_cb_evo_whoisonline'] = true;
			// Get whosonline only if not in a tab mode
			if (!$this->registry->options['mgc_cb_evo_whoisonline_showintab'])
			{
				// Inactive mode active and delay < session delay => inactive mode delay taken
				if ($this->registry->options['mgc_cb_evo_inactive_mode'] && $this->registry->options['mgc_cb_evo_inactive_mode_delay'] < $this->registry->options['mgc_cb_evo_whoisonline_delay'])
				{
					$dateline = TIMENOW - ($this->registry->options['mgc_cb_evo_inactive_mode_delay'] * 60);
				}
				else
				{
					$dateline = TIMENOW - ($this->registry->options['mgc_cb_evo_whoisonline_delay'] * 60);
				}
		
				$getusers = $this->registry->db->query_read("
					SELECT DISTINCT u.username,u.displaygroupid,u.userid,s.userid AS suserid,u.usergroupid,
					(u.options & " . $vbulletin->bf_misc_useroptions['invisible'] . ") AS invisible
					FROM " . TABLE_PREFIX . "mgc_cb_evo_session AS cbs
					LEFT JOIN " . TABLE_PREFIX . "user AS u ON (cbs.userid=u.userid)
					LEFT JOIN " . TABLE_PREFIX . "session AS s ON (cbs.userid=s.userid)
					WHERE cbs.dateline>='$dateline' AND cbs.userid!=0
				");
				
				if ($this->registry->db->num_rows($getusers))
				{
					$show['mgc_cb_evo_nouser_online'] = false;
					$users_online['nb'] = 0;
				
					$first = 1;
					while ($user = $this->registry->db->fetch_array($getusers))
					{
						// Manage the invisible users case
						if ($user['invisible'])
						{
							if ($this->evo_core->evo_permissions->can_see_hidden_users() OR $user['userid'] == $this->registry->userinfo['userid'])
							{
								if ($user['userid'])
								{
									$users_online['nb']++;
				
									if (!$first)
									{
										$users_online['list'] .= ', ';
									}
									else
									{
										$first = 0;
									}
			
									$users_online['list'] .= '<a href="member.php?u=' . $user['userid'] . '">' . fetch_musername($user,'displaygroupid') . '</a>*';
								}
							}
						}
						// Non invisible users
						else
						{
							if ($user['userid'])
							{
								$users_online['nb']++;
				
								if (!$first)
								{
									$users_online['list'] .= ', ';
								}
								else
								{
									$first = 0;
								}
				
								$users_online['list'] .= '<a href="member.php?u=' . $user['userid'] . '">' . fetch_musername($user,'displaygroupid') . '</a>';
							}
						}
					}
				}
			}
			else
			{
				$show['mgc_cb_evo_nouser_online'] = true;
			}
		}
			
		// Collapse reset for editor buttons if editor state is not kept
		if (true OR !$this->registry->options['mgc_cb_evo_keep_editor_state'])
		{
			// Do not collapse if bbcode editor shall be displayed by default 
			if (!$this->registry->options['mgc_cb_evo_bbcode_editor_default'])
			{
				$vbcollapse['collapseimg_mgc_cb_evo_bbcodes'] = "_collapsed";
				$vbcollapse['collapseobj_mgc_cb_evo_bbcodes'] = "display: none";
			}
			// Do not collapse if smilies editor shall be displayed by default
			if (!$this->registry->options['mgc_cb_evo_smilies_editor_default'])
			{
				$vbcollapse['collapseimg_mgc_cb_evo_smilies'] = "_collapsed";
				$vbcollapse['collapseobj_mgc_cb_evo_smilies'] = "display: none";
			}
			$vbcollapse['collapseimg_mgc_cb_evo_help'] = "_collapsed";
			$vbcollapse['collapseobj_mgc_cb_evo_help'] = "display: none";
		}		
		$vbcollapse['collapseimg_mgc_cb_evo_online'] = "_collapsed";
		$vbcollapse['collapseobj_mgc_cb_evo_online'] = "display: none";
		
		// Management of the chatbox width if notification activated and in a separate column
		if ($this->registry->options['mgc_cb_evo_notifications_display'] == 2)
		{
			if (!empty($this->registry->options['mgc_cb_evo_notif_column_width']) && $this->registry->options['mgc_cb_evo_notif_column_width'] != 0 && $this->registry->options['mgc_cb_evo_notif_column_width'] < 100)
			{
				$chatwidth  = 100 - $this->registry->options['mgc_cb_evo_notif_column_width'];
				$notifwidth = $this->registry->options['mgc_cb_evo_notif_column_width'];
			}
			else
			{
				// Default
				$chatwidth  = 75;
				$notifwidth = 25;
			}
		}
			
		// Chatbox forced as collapsed by default ?
		if ($vbulletin->options['mgc_cb_evo_force_default_collapsed'])
		{
			$vbcollapse['collapseimg_mgc_cb_evo'] = "_collapsed";
			$vbcollapse['collapseobj_mgc_cb_evo'] = "display: none";
		}
		
		$chatbox_autorefresh_on = $this->evo_core->evo_permissions->authorize_autorefresh($max_number_of_chats_reached);
		
		// Retrieval of js vars and file
		$mgc_cb_evo_js_vars		= "<script type=\"text/javascript\">\n";
		$mgc_cb_evo_js_vars		.= "<!--\n";
		$mgc_cb_evo_js_vars 	.= $this->construct_jsvars($chatbox_autorefresh_on,$mgc_cb_evo_floc,$show['mgc_cb_evo_promptmsg'],$autocompletion_js,$array_channelnames,$vbcollapse['collapseobj_mgc_cb_evo'],$chatbox_height);
		$mgc_cb_evo_js_vars 	.= $js_channels_ids_array . "\n";
		if (!empty($default_channel))
		{
			$mgc_cb_evo_js_vars	.= "var mgc_cb_evo_default_channel = " . $default_channel . ";\n";
		}
		else
		{
			$mgc_cb_evo_js_vars	.= "var mgc_cb_evo_default_channel = 0;\n";
		}
		$mgc_cb_evo_js_vars		.= "var mgc_cb_evo_pm_tabs_on = " . $show['mgc_cb_evo_pm_tabs'] . ";\n";
		$mgc_cb_evo_js_vars		.= "// -->";
		$mgc_cb_evo_js_vars		.= "</script>\n";
		$mgc_cb_evo_js_vars		.= $this->construct_mgc_cb_evo_jsinclude();		
		
		$mgc_cb_evo_colspan = ($this->registry->options['mgc_cb_evo_editor_position'] == 0 || $this->registry->options['mgc_cb_evo_editor_position'] == 1) ? "2" : "3";
		
		
		if ($this->mgc_vbversion < 4)
		{
			// Creation of the editor
			if ($show['mgc_cb_evo_bbcodes'])
			{
				eval('$mgc_cb_evo_bbcodes_row = "' . fetch_template('mgc_cb_evo_editor_bbcodes_row') . '";');
			}
		
			if ($show['mgc_cb_evo_smilies'])
			{
				eval('$mgc_cb_evo_smilies_row = "' . fetch_template('mgc_cb_evo_editor_smilies_row') . '";');
			}
			
			// Manage display of chatbox with input editor type (either above or under)
			if ($this->registry->options['mgc_cb_evo_editor_position'] == 0 || $this->registry->options['mgc_cb_evo_editor_position'] == 1)
			{
				$mgc_cb_evo_colspan 		= 2;
				$mgc_cb_evo_colspan_plus 	= 3;
				eval('$mgc_cb_evo_editor = "' . fetch_template('mgc_cb_evo_editor') . '";');
			}
			else
			{
				$mgc_cb_evo_colspan 		= 3;
				$mgc_cb_evo_colspan_plus 	= 4;
				eval('$mgc_cb_evo_editor = "' . fetch_template('mgc_cb_evo_editor_alternate') . '";');
			}
	
			// Finish constructing the chatbox display
			eval('$mgc_cb_evo_inner_opened = "' . fetch_template('mgc_cb_evo_inner_opened') . '";');
			eval('$mgc_cb_evo_inner_closed = "' . fetch_template('mgc_cb_evo_inner_closed') . '";');
			eval('$mgc_cb_evo_header = "' . fetch_template('mgc_cb_evo_header') . '";');
			eval('$mgc_cb_evo_jspopup = "' . fetch_template('mgc_cb_evo_jspopup') . '";');
			eval('$mgc_cb_evo = "' . fetch_template('mgc_cb_evo') . '";');
		}
		else
		{
			// Creation of the editor
			if ($show['mgc_cb_evo_bbcodes'])
			{		
				$templater=vB_Template::create('mgc_cb_evo_editor_bbcodes_row_vb4');
				$templater->register('bbcodes',$bbcodes);
				$mgc_cb_evo_bbcodes_row = $templater->render();
			}
			
			if ($show['mgc_cb_evo_smilies'])
			{
				$templater=vB_Template::create('mgc_cb_evo_editor_smilies_row_vb4');
				$templater->register('smilies',$smilies);
				$mgc_cb_evo_smilies_row = $templater->render();
			}
			
			// Manage display of chatbox with input editor type (either above or under)
			if ($this->registry->options['mgc_cb_evo_editor_position'] == 0 || $this->registry->options['mgc_cb_evo_editor_position'] == 1)
			{
				$templater=vB_Template::create('mgc_cb_evo_editor_vb4');
				$mgc_cb_evo_editor = $templater->render();
			}
			else
			{
				$templater=vB_Template::create('mgc_cb_evo_editor_alternate_vb4'); // TODO
				$mgc_cb_evo_editor = $templater->render();
			}
	
			// Chatbox inner			
			$show['mgc_cb_evo_inner_leftdiv'] 	= 0;
			$show['mgc_cb_evo_inner_righttdiv'] = 0;
			
			if ($this->registry->options['mgc_cb_evo_editor_position'] == 2)
			{
				$show['mgc_cb_evo_inner_leftdiv'] = 1;
				if (!empty($channels_bit))
				{
					$mgc_cb_evo_inner_sidediv_width = $this->registry->options['mgc_cb_evo_textarea_width'] + 30;
				}
				else
				{
					$mgc_cb_evo_inner_sidediv_width = $this->registry->options['mgc_cb_evo_textarea_width'];
				}
			}
			else if ($this->registry->options['mgc_cb_evo_editor_position'] == 3)
			{
				$show['mgc_cb_evo_inner_rightdiv'] = 1;
				if (!empty($channels_bit))
				{
					$mgc_cb_evo_inner_sidediv_width = $this->registry->options['mgc_cb_evo_textarea_width'] + 30;
				}
				else
				{
					$mgc_cb_evo_inner_sidediv_width = $this->registry->options['mgc_cb_evo_textarea_width'];
				}
			}
			else if (!empty($channels_bit))
			{
				$show['mgc_cb_evo_inner_leftdiv'] 	= 1;
				$mgc_cb_evo_inner_sidediv_width		= 30;
			}
			
			$templater=vB_Template::create('mgc_cb_evo_inner_opened_vb4');
			$templater->register('mgc_cb_evo_editor',$mgc_cb_evo_editor);
			$templater->register('mgc_cb_evo_bbcodes_row',$mgc_cb_evo_bbcodes_row);
			$templater->register('mgc_cb_evo_smilies_row',$mgc_cb_evo_smilies_row);
			$templater->register('channels_bit',$channels_bit);
			$templater->register('mgc_cb_evo_inner_sidediv_width',$mgc_cb_evo_inner_sidediv_width);
			$templater->register('warn_msg',$warn_msg);
			$templater->register('chatbox_height',$chatbox_height);
			$templater->register('chatwidth',$chatwidth);
			$templater->register('notifwidth',$notifwidth);
			$templater->register('users_online',$users_online);
			$mgc_cb_evo_inner_opened = $templater->render();			
			
			$templater=vB_Template::create('mgc_cb_evo_inner_closed_vb4');
			$mgc_cb_evo_inner_closed = $templater->render();
			
			$templater=vB_Template::create('mgc_cb_evo_header_vb4');
			$mgc_cb_evo_header = $templater->render();
			
			
			$templater=vB_Template::create('mgc_cb_evo_jspopup_vb4');
			$mgc_cb_evo_jspopup = $templater->render();
			
			$templater=vB_Template::create('mgc_cb_evo_vb4');
			$templater->register('mgc_cb_evo_js_vars',$mgc_cb_evo_js_vars);
			$templater->register('mgc_cb_evo_header',$mgc_cb_evo_header);
			$templater->register('mgc_cb_evo_inner_opened',$mgc_cb_evo_inner_opened);
			$templater->register('mgc_cb_evo_inner_closed',$mgc_cb_evo_inner_closed);
			$templater->register('mgc_cb_evo_jspopup',$mgc_cb_evo_jspopup);			
			$mgc_cb_evo = $templater->render();			
		}
		return $mgc_cb_evo;
	}
	
}

?>