<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~ E_NOTICE);

@header('Content-type: text/html; charset=windows-1252');

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'mgc_cb_evo'); // change this depending on your filename
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('pm', 'banning');

// get special data templates from the datastore
$specialtemplates = array('bbcodecache','smiliecache');

// pre-cache templates used by all actions
$globaltemplates = array(
	'GENERIC_SHELL',
	'mgc_cb_evo',
	'mgc_cb_evo_archives',
	'mgc_cb_evo_static_chatbit',
	'mgc_cb_evo_smilies',
	'mgc_cb_evo_help',
	'mgc_cb_evo_help_bit',
	'mgc_cb_evo_rules',
	'mgc_cb_evo_table',
	'mgc_cb_evo_table_bit',
	'mgc_cb_evo_search',
	'mgc_cb_evo_vb4',
	'mgc_cb_evo_archives_vb4',
	'mgc_cb_evo_static_chatbit_vb4',
	'mgc_cb_evo_smilies_vb4',
	'mgc_cb_evo_help_vb4',
	'mgc_cb_evo_help_bit_vb4',
	'mgc_cb_evo_rules_vb4',
	'mgc_cb_evo_table_vb4',
	'mgc_cb_evo_table_bit_vb4',
	'mgc_cb_evo_search_vb4'
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/class_bbcode.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// Chatbox active ?? 
if (!$vbulletin->options['mgc_cb_evo_active'])
{
	exit;
}

if (empty($_REQUEST['do']))
{
	if ($vbulletin->options['mgc_cb_evo_fullmode_active'])
	{
		$_REQUEST['do'] = "view_chatbox";
	}
	else
	{
		$_REQUEST['do'] = "view_archives";
	}
}

$mgc_vbversion = substr($vbulletin->options['templateversion'],0,1);

// Display archives
if ($_REQUEST['do'] == "view_archives")
{
	// Can access to chatbox and archives and is not banned 
	if (!($MGCCbEvoCore->evo_permissions->can_view() && $MGCCbEvoCore->evo_permissions->can_view_archives()))
	{
		print_no_permission();
	}

	$channel_id = $vbulletin->input->clean_gpc('r', 'channel_id', TYPE_UINT);

	require_once(DIR . '/mgc_cb_evo/classes/class_misc.php');        
	$MGCCbEvoMisc = new MGCCbEvo_misc($vbulletin);

	if (empty($channel_id))
	{
		$channel_id = 0;
	}
	
	// If channel id is provided, check if user has access to it
	if ($channel_id)
	{
		$user_channels = explode(',',$MGCCbEvoMisc->get_user_channels());
      
		if (!in_array($channel_id,$user_channels))
		{
			print_no_permission();
		}
		
		$user_channels = array();
	}
   
    // Retrieving of the commands permissions and status
    $identifier_array = array('\'0\'');

	if (is_array($vbulletin->mgc_cb_evo_commands))
	{					
		foreach($vbulletin->mgc_cb_evo_commands AS $command)
		{
			if (!empty($command['usergroupids']))
			{
				$command['usergroupids'] = explode(',',$command['usergroupids']);
			}
			else
			{
				$command['usergroupids'] = array();
			}
			
			if (!empty($command['userids']))
			{
				$command['userids'] = explode(',',$command['userids']);
			}	
			else
			{
				$command['userids'] = array();
			}
								
			// Channel not active => next
			if ($command['active'] == 0)
			{
				$commands_status["$command[identifier]"] = '0';
				continue;
			}
			
			// Test if user has permissions
			$hasaccess = 0;		
			// 1 - Usergroupid test
			if (is_array($command['usergroupids']) && in_array($vbulletin->userinfo['usergroupid'],$command['usergroupids']))
			{
				$hasaccess = 1;
			}
			// 2 - Member group test
			if (!$hasaccess && !empty($vbulletin->userinfo['membergroupids']))
			{
				$found 			= 0;
				$ugipds_array 	= explode(',', $vbulletin->userinfo['membergroupids']);		
				foreach ($ugipds_array as $index => $ugpid)
				{
					if (in_array($ugpid,$command['usergroupids']))
					{
						$hasaccess = 1;
					}
				}
			}
			// 3 - Userid test
			if (!$hasaccess && is_array($command['userids']) && in_array($vbulletin->userinfo['userid'],$command['userids']))
			{
				$hasaccess = 1;
			}
			// 4 - Skip channel if not
			if (!$hasaccess)
			{
				$commands_status["$command[identifier]"] = '0';
				continue;
			}
			
			$identifier_array[] = "'" . $command['identifier'] . "'";
			$commands_status["$command[identifier]"] = '1';
		}
	}

	// Building the chats retrieving query
			
	// Not private chats where clause       
	$where_clause = "chanid='$channel_id' AND coidentifier IN (" . implode(',',$identifier_array) . ") AND (touid='0' OR fromuid='" . $vbulletin->userinfo['userid'] . "'OR touid='" . $vbulletin->userinfo['userid'] . "')";      

	// Ignore command where clause       
	if ($commands_status['ignore'] && !empty($vbulletin->userinfo['mgc_cb_evo_ignored']))
	{
		$where_clause .= " AND fromuid NOT IN (" . $vbulletin->userinfo['mgc_cb_evo_ignored'] . ")";
		$where_clause .= " AND touid NOT IN (" . $vbulletin->userinfo['mgc_cb_evo_ignored'] . ")";
	}
	
	// Hide warning notifications 
	$where_clause .= " AND iswarning='0'";
	
	// Days limit 
	$dlimit = $vbulletin->input->clean_gpc('r', 'dlimit', TYPE_INT);	
	if ($dlimit == 0)
	{
		$dlimit = 1;
	}
	if ($dlimit != -1)
	{
		$dateline_limit = TIMENOW - ($dlimit * 86400);
		$where_clause .= " AND c.dateline>'" . $dateline_limit . "'";
	}

	$perpage = $vbulletin->options['mgc_cb_evo_archives_nbchats_per_page'];
	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);

	// Count of the chats 
	$getnbchats = $vbulletin->db->query_first("
		SELECT COUNT(chatid) AS nbchats
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
		WHERE $where_clause
	");     
  
	sanitize_pageresults($getnbchats['nbchats'], $pagenumber, $perpage, 100, 25);

	// page min / page max 
	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = $pagenumber * $perpage;
	if ($limitupper > $getnbchats['nbchats'])
	{
		$limitupper = $getnbchats['nbchats'];
		if ($limitlower > $getnbchats['nbchats'])
		{
			$limitlower = $getnbchats['nbchats'] - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		$limitlower = 1;
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $getnbchats['nbchats'], $vbulletin->options['bburl'] . '/mgc_cb_evo.php?' . $vbulletin->session->vars['sessionurl'] . 'do=view_archives&amp;channel_id=' . $channel_id. '&amp;dlimit=' . $dlimit);  

	// Retrieving of the chats 
	$chats = $vbulletin->db->query_read("
		SELECT c.*
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
		WHERE $where_clause
		ORDER BY c.dateline DESC
		LIMIT " . ($limitlower - 1) . ", $perpage
	");

	$chatids_array = array();

	if ($vbulletin->db->num_rows($chats))
	{
   		// Instantiate formatting class
		require_once(DIR . '/mgc_cb_evo/classes/class_formatting.php');
		$MGCCbEvoFormatting = new MGCCbEvo_formatting($vbulletin,$MGCCbEvoCore);	
	
		$parsebbcode = $vbulletin->options['mgc_cb_evo_bbcode'] || $vbulletin->options['mgc_cb_evo_bbcode_url'] || $vbulletin->options['mgc_cb_evo_bbcode_img'];
		$alt = 2;
		
		// Management in oldest first 
		if ($vbulletin->options['mgc_cb_evo_archives_chats_order'])
		{
			$cpt = $nbchats - 1;
			while ($chat = $vbulletin->db->fetch_array($chats))
			{      
         		$chatids_array[] = $chat['chatid'];         
            	$chats_table["$cpt"] = $MGCCbEvoFormatting->construct_chat($chat, $parsebbcode, $commands_status, $channel_id,$alt,1);
            	$chats_menu_register .= "vbmenu_register('test_+ $chat[chatid]');";
            	$cpt--;
            	// Row color alternate
				if ($vbulletin->options['mgc_cb_evo_alt_colors'])
				{
					if ($alt == 2)
					{
						$alt = 1;
					}
					else
					{
						$alt = 2;
					}
				}               
         	}
         	ksort($chats_table);
		}
		else
		{
			$cpt = 0;
			while ($chat = $vbulletin->db->fetch_array($chats))
			{
				$chatids_array[] = $chat['chatid'];
				$chats_table["$cpt"] = $MGCCbEvoFormatting->construct_chat($chat, $parsebbcode, $commands_status, $channel_id,$alt,1);
				$cpt++;
            	// Row color alternate
				if ($vbulletin->options['mgc_cb_evo_alt_colors'])
				{
					if ($alt == 2)
					{
						$alt = 1;
					}
					else
					{
						$alt = 2;
					}
				}                 
			}                                    
		}
      
		foreach($chats_table AS $id => $chat)
		{
			$chatbit .= $chat;
		}
	}
   
	// Stats 
	require_once(DIR . '/mgc_cb_evo/classes/class_misc.php');        
	$MGCCbEvoMisc         			= new MGCCbEvo_misc($vbulletin);    
	$mgc_cb_evo_stats['top_x']		= $MGCCbEvoMisc->get_top_x(true);
	$mgc_cb_evo_stats['chats']		= $MGCCbEvoMisc->get_number_of_chats();
	$mgc_cb_evo_stats['your_chats']	= $MGCCbEvoMisc->get_user_number_of_chats();
	$mgc_cb_evo_stats['chats_24h']	= $MGCCbEvoMisc->get_number_of_chats(true);
	
	// Set up some permissions
	$show['archives_download'] 	= $MGCCbEvoCore->evo_permissions->can_download_archives() && !empty($chatbit);
	$show['delete_column'] 		= $MGCCbEvoCore->evo_permissions->can_manage();
	$show['searchchatbox'] 		= $MGCCbEvoCore->evo_permissions->can_search();

	// Archive Type Select construction
	
	// Constructing the usergroupids REGEXP 
	$show['mgc_cb_evo_archive_type_select'] = false;
	
	// Multiples channel
	if (is_array($vbulletin->mgc_cb_evo_channels))
	{					
		foreach($vbulletin->mgc_cb_evo_channels AS $channel)
		{
			if (!empty($channel['usergroupids']))
			{
				$channel['usergroupids'] = explode(',',$channel['usergroupids']);
			}
			
			if (!empty($channel['userids']))
			{
				$channel['userids'] = explode(',',$channel['userids']);
			}	
								
			// Channel not active => next
			if ($channel['active'] == 0)
			{
				continue;
			}
			
			// Test if user has permissions
			$hasaccess = 0;		
			// 1 - Usergroupid test
			if (is_array($channel['usergroupids']) && in_array($vbulletin->userinfo['usergroupid'],$channel['usergroupids']))
			{
				$hasaccess = 1;
			}
			// 2 - Member group test
			if (!$hasaccess && !empty($vbulletin->userinfo['membergroupids']))
			{
				$found 			= 0;
				$ugipds_array 	= explode(',', $vbulletin->userinfo['membergroupids']);		
				foreach ($ugipds_array as $index => $ugpid)
				{
					if (in_array($ugpid,$channel['usergroupids']))
					{
						$hasaccess = 1;
					}
				}
			}
			// 3 - Userid test
			if (!$hasaccess && is_array($channel['userids']) && in_array($vbulletin->userinfo['userid'],$channel['userids']))
			{
				$hasaccess = 1;
			}
			// 4 - Skip channel if not
			if (!$hasaccess)
			{
				continue;
			}
			
			$user_channels[] = $channel;
		}
	}
      
	if (is_array($user_channels))
	{
		$show['mgc_cb_evo_archive_type_select'] = true;
		         
		if ($channel_id == -1)
		{  
			$navtext = $vbphrase['mgc_cb_evo_archives_main_channel'];
			$archive_selectbit = "<option value=\"0\" selected=\"selected\">$vbphrase[mgc_cb_evo_archives_main_channel]</option>";
		}
		else
		{
			$archive_selectbit = "<option value=\"0\">$vbphrase[mgc_cb_evo_archives_main_channel]</option>";
		}    
      
		foreach($user_channels AS $channelid)
		{
			if ($channel_id == $channel['chanid'])
			{       
				$navtext = construct_phrase($vbphrase['mgc_cb_evo_archives_of_x_channel'],$channel['title']);  
				$archive_selectbit .= "<option value=\"" . $channel['chanid'] . "\" selected=\"selected\">" . construct_phrase($vbphrase['mgc_cb_evo_archives_of_x_channel'],$channel['title']) . "</option>";
			}
			else
			{
				$archive_selectbit .= "<option value=\"" . $channel['chanid'] . "\">" . construct_phrase($vbphrase['mgc_cb_evo_archives_of_x_channel'],$channel['title']) . "</option>";
			}
		}
	}   

	$jsarray = "var chatids_array = [" . implode(',',$chatids_array) . "];";

	// Construct js calls
	$mgc_cb_evo_archives_js  = "<script type=\"text/javascript\">\n";
	$mgc_cb_evo_archives_js .= "var sessionurl = \"" . $vbulletin->session->vars['sessionurl_q'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var bburl = \"" . $vboptions['bburl'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var mgc_cb_evo_jsloc = \"" . $mgc_cb_evo_floc . "\";\n";
	$mgc_cb_evo_archives_js .= "var avataron = \"" . $vboptions['mgc_cb_evo_avatar_on'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var mgc_cb_evo_static = 1;\n";
	$mgc_cb_evo_archives_js .= "var phrase_error_chat_in_process = \"" . $vbphrase['mgc_cb_evo_jserror_chat_in_progress'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_enter_url = \"" . $vbphrase['mgc_cb_evo_js_enter_url'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_enter_email = \"" . $vbphrase['mgc_cb_evo_js_enter_email'] . "\";\n";   
  	$mgc_cb_evo_archives_js .= "var phrase_enter_imgurl = \"" . $vbphrase['mgc_cb_evo_js_enter_imgurl'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_already_editing = \"" . $vbphrase['mgc_cb_evo_already_editing'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_edit_forbidden = \"" . $vbphrase['mgc_cb_evo_edit_forbidden'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_inactive = \"" . $vbphrase['mgc_cb_evo_inactive'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_enter_urltext = \"" . $vbphrase['mgc_cb_evo_js_enter_urltext'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_enter_name = \"" . $vbphrase['mgc_cb_evo_js_enter_name'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_error_name = \"" . $vbphrase['mgc_cb_evo_js_error_name'] . "\";\n";	
	$mgc_cb_evo_archives_js .= "var phrase_ok = \"" . $vbphrase['mgc_cb_evo_ok'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_yes = \"" . $vbphrase['yes'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_no = \"" . $vbphrase['no'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_save = \"" . $vbphrase['save'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_cancel = \"" . $vbphrase['cancel'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_enter_report_reason = \"" . $vbphrase['mgc_cb_evo_enter_report_reason'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var avataron = " . $vbulletin->options['mgc_cb_evo_avatar_on'] . ";\n";
	$mgc_cb_evo_archives_js .= $jsarray;
	$mgc_cb_evo_archives_js .= "\n</script>\n";

	if ($vbulletin->options['mgc_cb_evo_js_load_locally'])
	{
		$mgc_cb_evo_archives_headjs = '<script type="text/javascript" src="http://yui.yahooapis.com/combo?2.7.0/build/animation/animation-min.js&2.7.0/build/datasource/datasource-min.js&2.7.0/build/autocomplete/autocomplete-min.js&2.7.0/build/element/element-min.js&2.7.0/build/button/button-min.js&2.7.0/build/container/container-min.js&2.7.0/build/tabview/tabview-min.js"></script>';
	}
	else
	{
		$mgc_cb_evo_archives_headjs = '<script type="text/javascript" src="mgc_cb_evo/clientscript/yui/combined/combined-min.js"></script>';
	}	
	
	$mgc_cb_evo_archives_js .= $mgc_cb_evo_archives_headjs;
	$mgc_cb_evo_archives_js .= "<script type=\"text/javascript\" src=\"" . $mgc_cb_evo_floc . "mgc_cb_evo/clientscript/mgc_cb_evo_static.js\"></script>";
	
    // Headinclude 
    $mgc_head = ''; 
    if ($vbulletin->options['mgc_cb_evo_js_load_locally']) 
    { 
        $mgc_head .= '<link rel="stylesheet" href="http://yui.yahooapis.com/combo?2.7.0/build/container/assets/skins/sam/container.css&2.7.0/build/button/assets/skins/sam/button.css">'; 
    } 
    else 
    { 
        $mgc_head .= '<link rel="stylesheet" href="mgc_cb_evo/clientscript/yui/container/assets/skins/sam/container.css" type="text/css">'; 
        $mgc_head .= '<link rel="stylesheet" href="mgc_cb_evo/clientscript/yui/button/assets/skins/sam/button.css" type="text/css">'; 
    } 
    $mgc_head .= '<link rel="stylesheet" href="mgc_cb_evo/clientscript/widget-skin.css" type="text/css">'; 
    $mgc_head .= '<link rel="stylesheet" href="mgc_cb_evo/clientscript/chatbox_tabs.css" type="text/css">'; 	
	
	// Colspan
	$colspan = 4;
	if ($vbulletin->options['mgc_cb_evo_avatar_on'])
	{
		$colspan++;
	}

	if ($show['delete_column'])
	{
		$colspan++;
	}
	
	// Print out template
	if ($mgc_vbversion < 4)
	{
		eval('$HTML = "' . fetch_template('mgc_cb_evo_archives') . '";');
	
		$navbits = array();
		$navbits[$parent] = $vbulletin->options['mgc_cb_evo_title'] . " : " . $vbphrase['mgc_cb_evo_archives'] . (!empty($navtext) ? ' : ' . $navtext : '');
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');
		
		$headinclude .= $mgc_head;	
		eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
	}
	else
	{
		$mgc_vbcsspath = 'css.php?styleid=' . $vbulletin->userinfo['styleid'] . '&amp;langid=' . LANGUAGEID . '&amp;d=' . $style['dateline'] . '&amp;sheet=';  
		$mgc_head .= '<link rel="stylesheet" href="' . $mgc_vbcsspath . 'mgc_cb_evo.css" type="text/css">'; 
		$headinclude .= $mgc_head;
		
		$templater=vB_Template::create('mgc_cb_evo_jspopup_vb4');
		$mgc_cb_evo_jspopup = $templater->render();		
			 	
		$templater = vB_Template::create('mgc_cb_evo_archives_vb4');
			$templater->register('mgc_cb_evo_archives_js', $mgc_cb_evo_archives_js);
			$templater->register('mgc_cb_evo_jspopup', $mgc_cb_evo_jspopup);
			$templater->register('mgc_cb_evo_stats', $mgc_cb_evo_stats);
			$templater->register('archive_selectbit', $archive_selectbit);
			$templater->register('chatbit', $chatbit);
			$templater->register('pagenav', $pagenav);
    		$templater->register('pagenumber', $pagenumber);
	    	$templater->register('perpage', $perpage);
			$templater->register('dlimit', $dlimit);
			$templater->register('channel_id', $channel_id);
			$templater->register('colspan', $colspan);
		$HTML = $templater->render();	
		
		$navbits = construct_navbits(array('' => $vbulletin->options['mgc_cb_evo_title'] . " : " . $vbphrase['mgc_cb_evo_archives']));
		$navbar = render_navbar_template($navbits);
		
		$templater = vB_Template::create('GENERIC_SHELL');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('HTML', $HTML);
			$templater->register('pagetitle', $vbulletin->options['mgc_cb_evo_title'] . " : " . $vbphrase['mgc_cb_evo_archives']);
		print_output($templater->render());		
	}
}

// Save archives
if ($_REQUEST['do'] == 'save_archives')
{
	$format     = $vbulletin->input->clean_gpc('r', 'format', TYPE_NOHTML);   
	$channel_id = $vbulletin->input->clean_gpc('r', 'channel_id', TYPE_UINT);
	
	if (!$MGCCbEvoCore->evo_permissions->can_download_archives())
	{
		print_no_permission();
	}
	
	require_once(DIR . '/includes/functions_file.php');
	require_once(DIR . '/mgc_cb_evo/classes/class_misc.php');        
	$MGCCbEvoMisc = new MGCCbEvo_misc($vbulletin);

	if (empty($channel_id))
	{
		$channel_id = 0;
	}
	
	// If channel id is provided, check if user has access to it
	if ($channel_id)
	{
		if (is_array($vbulletin->mgc_cb_evo_channels))
		{					
			foreach($vbulletin->mgc_cb_evo_channels AS $channel)
			{
				if (!empty($channel['usergroupids']))
				{
					$channel['usergroupids'] = explode(',',$channel['usergroupids']);
				}
				
				if (!empty($channel['userids']))
				{
					$channel['userids'] = explode(',',$channel['userids']);
				}	
									
				// Channel not active => next
				if ($channel['active'] == 0)
				{
					continue;
				}
				
				// Test if user has permissions
				$hasaccess = 0;		
				// 1 - Usergroupid test
				if (is_array($channel['usergroupids']) && in_array($vbulletin->userinfo['usergroupid'],$channel['usergroupids']))
				{
					$hasaccess = 1;
				}
				// 2 - Member group test
				if (!$hasaccess && !empty($vbulletin->userinfo['membergroupids']))
				{
					$found 			= 0;
					$ugipds_array 	= explode(',', $vbulletin->userinfo['membergroupids']);		
					foreach ($ugipds_array as $index => $ugpid)
					{
						if (in_array($ugpid,$channel['usergroupids']))
						{
							$hasaccess = 1;
						}
					}
				}
				// 3 - Userid test
				if (!$hasaccess && is_array($channel['userids']) && in_array($vbulletin->userinfo['userid'],$channel['userids']))
				{
					$hasaccess = 1;
				}
				// 4 - Skip channel if not
				if (!$hasaccess)
				{
					continue;
				}
				
				if ($channel['chanid'] == $channel_id)
				{
					$getchannel = $channel;
					$channel_found = 1;
				}
			}
		}
		
		if (!$channel_found)
		{
			print_no_permission();
		}		
	}
	
    // Retrieving of the commands permissions and status
    $identifier_array = array('\'0\'');

	if (is_array($vbulletin->mgc_cb_evo_commands))
	{					
		foreach($vbulletin->mgc_cb_evo_commands AS $command)
		{
			if (!empty($command['usergroupids']))
			{
				$command['usergroupids'] = explode(',',$command['usergroupids']);
			}
			
			if (!empty($command['userids']))
			{
				$command['userids'] = explode(',',$command['userids']);
			}	
								
			// Channel not active => next
			if ($command['active'] == 0)
			{
				$commands_status["$command[identifier]"] = '0';
				continue;
			}
			
			// Test if user has permissions
			$hasaccess = 0;		
			// 1 - Usergroupid test
			if (is_array($command['usergroupids']) && in_array($vbulletin->userinfo['usergroupid'],$command['usergroupids']))
			{
				$hasaccess = 1;
			}
			// 2 - Member group test
			if (!$hasaccess && !empty($vbulletin->userinfo['membergroupids']))
			{
				$found 			= 0;
				$ugipds_array 	= explode(',', $vbulletin->userinfo['membergroupids']);		
				foreach ($ugipds_array as $index => $ugpid)
				{
					if (in_array($ugpid,$command['usergroupids']))
					{
						$hasaccess = 1;
					}
				}
			}
			// 3 - Userid test
			if (!$hasaccess && is_array($command['userids']) && in_array($vbulletin->userinfo['userid'],$command['userids']))
			{
				$hasaccess = 1;
			}
			// 4 - Skip channel if not
			if (!$hasaccess)
			{
				$commands_status["$command[identifier]"] = '0';
				continue;
			}
			
			$identifier_array[] = "'" . $command['identifier'] . "'";
			$commands_status["$command[identifier]"] = '1';
		}
	}

	// Building the chats retrieving query
			
	// Not private chats where clause       
	$where_clause = "chanid='$channel_id' AND coidentifier IN (" . implode(',',$identifier_array) . ") AND (touid='0' OR fromuid='" . $vbulletin->userinfo['userid'] . "'OR touid='" . $vbulletin->userinfo['userid'] . "') AND iswarning='0'";  

	// Retrieving of the chats 
	$chats = $vbulletin->db->query_read("
		SELECT c.ctext,c.dateline,fromu.userid AS fromuserid,fromu.username AS fromusername,tou.userid AS touserid,tou.username AS tousername
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
		LEFT JOIN " . TABLE_PREFIX . "user AS fromu ON (c.fromuid=fromu.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS tou ON (c.touid=tou.userid)
		LEFT JOIN " . TABLE_PREFIX . "mgc_cb_evo_command AS co ON (c.coidentifier=co.identifier)
		WHERE $where_clause
		ORDER BY c.dateline DESC
	");

	// Error : no chats to download 
	if (!$db->num_rows($chats))
	{
		eval(standard_error(fetch_error('mgc_cb_evo_nochats_to_download')));
	}
   
	if ($channel_id)
	{
		$channel_name = $getchannel['title'];
	}
	else
	{
		$channel_name = $vbphrase['mgc_cb_evo_archives_main_channel'];
	}

	switch ($vbulletin->GPC['format'])
	{
		case 'txt':
			$txt = "################################################################################\r\n";
			$txt .= "MGC Chatbox EVO DUMP - $channel_name\r\n";
			$txt .= $vbulletin->options['bbtitle'] . ';' . $vbulletin->options['bburl'] . "\r\n";
			$txt .= vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], TIMENOW) . "\r\n";
			$txt .= "################################################################################\r\n\r\n";

			while ($chat = $vbulletin->db->fetch_array($chats))
			{
				$chat['ctext'] = fetch_censored_text($chat['ctext']);
				$txt .= "==========================================================\r\n";
				$txt .= vbdate($vbulletin->options['mgc_cb_evo_archives_format_date'], $chat['dateline'], false, false) . " - $chat[fromusername] : ";            
				$txt .= "$chat[ctext]\r\n";               
         	}
 			$txt .= "==========================================================\r\n";

			unset($chat);
			$vbulletin->db->free_result($getchats);

			// download the file
			file_download($txt, str_replace(array('\\', '/'), '-', "MGC_CHATBOX_EVO_DUMP_$channel_name-" .$vbulletin->userinfo['username'] . "-" . vbdate($vbulletin->options['dateformat'], TIMENOW) . '.txt'), 'text/plain');
			break;
		case 'csv':
			// column headers
			$csv = "$vbphrase[date],$vbphrase[username],$vbphrase[mgc_cb_evo_chats]\r\n";
		
			while ($chat = $vbulletin->db->fetch_array($chats))
			{
				$csv_chat['dateline'] = vbdate($vbulletin->options['mgc_cb_evo_archives_format_date'], $chat['dateline'], false, false);
				$csv_chat['username'] = $chat['fromusername'];                
				$csv_chat['ctext'] = fetch_censored_text($chat['ctext']);

				foreach ($csv_chat as $key => $val)
				{
					if (preg_match('/\,|"/siU', $val))
					{
						$csv_chat["$key"] = '"' . str_replace('"', '""', $val) . '"';
					}
				}

				// output the message row
				$csv .= implode(',', $csv_chat) . "\r\n";
			}
			
			unset($chat);
			$vbulletin->db->free_result($getchats);

			// download the file
			file_download($csv, str_replace(array('\\', '/'), '-', "MGC_CHATBOX_EVO_DUMP_$channel_name-" . $vbulletin->userinfo['username'] . "-" . vbdate($vbulletin->options['dateformat'], TIMENOW) . '.csv'), 'text/x-csv');
			break;
		case 'xml':
			require_once (DIR . '/includes/class_xml.php');
			$xml = new vB_XML_Builder($vbulletin);
			$xml->add_group('mgc_cb_evo_chats');

			while ($chat = $vbulletin->db->fetch_array($chats))
			{
				$xml_chat['dateline'] = vbdate($vbulletin->options['mgc_cb_evo_archives_format_date'], $chat['dateline'], false, false);
				$xml_chat['user'] = $chat['fromusername'];
				$xml_chat['ctext'] = fetch_censored_text($chat['ctext']);
				$xml->add_group('mgc_chatbox_chat');
				foreach ($xml_chat as $key => $val)
				{
					$xml->add_tag($key, $val);
				}
				$xml->close_group();
			}

			unset($chat);
			$vbulletin->db->free_result($getchats);

			$xml->close_group();

			$doc = "<?xml version=\"1.0\" encoding=\"$stylevar[charset]\"?>\r\n\r\n";
			$doc .= "<!-- MGC CHATBOX EVO XML DUMP - $channel_name -->";
			$doc .= "<!-- " . $vbulletin->options['bbtitle'] . ';' . $vbulletin->options['bburl'] . " -->\r\n";
			$doc .= '<!-- ' . vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], TIMENOW) . " -->\r\n\r\n";
			$doc .= $xml->output();
			$xml = null;

         	// download the file
         	file_download($doc, str_replace(array('\\', '/'), '-', "MGC_CHATBOX_EVO_DUMP_$channel_name-" . $vbulletin->userinfo['username'] . "-" . vbdate($vbulletin->options['dateformat'], TIMENOW) . '.xml'), 'text/xml');
			break;
		// unknown download format
		default:
			eval(standard_error(fetch_error('invalidid', $vbphrase['file_type'], $vbulletin->options['contactuslink'])));
	}
}

// Chatbox display in full mode 
if ($_REQUEST['do'] == "view_chatbox")
{
	// The user can't view the chatbox or full mode is not yet enabled ? 
	if (!$MGCCbEvoCore->evo_permissions->can_view() || !$vbulletin->options['mgc_cb_evo_fullmode_active'])
	{
		print_no_permission();
	}

	// Headinclude
	$head = '';
	if ($vbulletin->options['mgc_cb_evo_js_load_locally'])
	{
		$head .= '<link rel="stylesheet" href="http://yui.yahooapis.com/combo?2.7.0/build/container/assets/skins/sam/container.css&2.7.0/build/button/assets/skins/sam/button.css">';
	}
	else
	{
		$head .= '<link rel="stylesheet" href="mgc_cb_evo/clientscript/yui/container/assets/skins/sam/container.css" type="text/css">';
		$head .= '<link rel="stylesheet" href="mgc_cb_evo/clientscript/yui/button/assets/skins/sam/button.css" type="text/css">';
	}
	$head .= '<link rel="stylesheet" href="mgc_cb_evo/clientscript/widget-skin.css" type="text/css">';
	$head .= '<link rel="stylesheet" href="mgc_cb_evo/clientscript/chatbox_tabs.css" type="text/css">';
	
	if ($mgc_vbversion > 3)
	{
		$template_hook['headinclude_bottom_css'] .= $head; 
	}
	
	$headinclude .= $head;
	
	// Manage the sidebar creation if any
	if ($vbulletin->options['mgc_cb_evo_notifications_display'] == 3 || $vbulletin->options['mgc_cb_evo_notifications_display'] == 4)
	{
		if ($vbulletin->options['mgc_cb_evo_notifications_display'] == 3)	
		{	
			$mgc_cb_evo_sidebar_align = 'left';
			eval('$header .= "<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td valign=\"top\" style=\"padding-right: 15px\" width=\"' . $vbulletin->options['mgc_cb_evo_notif_sidebar_width'] . '\">' . fetch_template('mgc_cb_evo_notifs_sidebar') . '</td><td valign=\"top\">";');
			$footer = '</td></tr></table>' .  $footer;
		}
		else
		{
			$mgc_cb_evo_sidebar_align = 'right';
			$header .= "<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td valign=\"top\">";
			eval('$footer = "</td><td valign=\"top\" style=\"padding-left: 15px\" width=\"' . $vbulletin->options['mgc_cb_evo_notif_sidebar_width'] . '\">' . fetch_template('mgc_cb_evo_notifs_sidebar') . '</td></tr></table>' .  $footer . '";');
		}
	}	

	// Construct chatbox display
	require_once(DIR . '/mgc_cb_evo/classes/class_display.php');
	$MGCCbEvoDisplay    = new MGCCbEvo_display($vbulletin,$MGCCbEvoCore);
	$HTML         		= $MGCCbEvoDisplay->construct_display($vbulletin->options['mgc_cb_evo_fullmode_height']); 

	if ($mgc_vbversion < 4)
	{
		$navbits = array();
		$navbits[$parent] = $vbulletin->options['mgc_cb_evo_title'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');
	
		eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');	
	}
	else
	{	
		$navbits = construct_navbits(array('' => $vbulletin->options['mgc_cb_evo_title']));
		$navbar = render_navbar_template($navbits);
		
		$templater = vB_Template::create('GENERIC_SHELL');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('HTML', $HTML);
			$templater->register('pagetitle', $vbulletin->options['mgc_cb_evo_title']);
		print_output($templater->render());		
	}
}

// Help popup display 
if ($_REQUEST['do'] == "showhelp")
{
	if (!$MGCCbEvoCore->evo_permissions->can_view() && !$MGCCbEvoCore->evo_permissions->can_use())
	{
		print_no_permission();
	}
   
	// Retrieving of the commands help phrases
	if (is_array($vbulletin->mgc_cb_evo_commands))
	{					
		foreach($vbulletin->mgc_cb_evo_commands AS $command)
		{
			if (!empty($command['usergroupids']))
			{
				$command['usergroupids'] = explode(',',$command['usergroupids']);
			}
			
			if (!empty($command['userids']))
			{
				$command['userids'] = explode(',',$command['userids']);
			}	
								
			// Channel not active => next
			if ($command['active'] == 0)
			{
				continue;
			}
			
			// Test if user has permissions
			$hasaccess = 0;		
			// 1 - Usergroupid test
			if (is_array($command['usergroupids']) && in_array($vbulletin->userinfo['usergroupid'],$command['usergroupids']))
			{
				$hasaccess = 1;
			}
			// 2 - Member group test
			if (!$hasaccess && !empty($vbulletin->userinfo['membergroupids']))
			{
				$found 			= 0;
				$ugipds_array 	= explode(',', $vbulletin->userinfo['membergroupids']);		
				foreach ($ugipds_array as $index => $ugpid)
				{
					if (in_array($ugpid,$command['usergroupids']))
					{
						$hasaccess = 1;
					}
				}
			}
			// 3 - Userid test
			if (!$hasaccess && is_array($command['userids']) && in_array($vbulletin->userinfo['userid'],$command['userids']))
			{
				$hasaccess = 1;
			}
			// 4 - Skip channel if not
			if (!$hasaccess)
			{
				continue;
			}
			
			$helpphrase = $vbphrase["mgc_cb_evo_cmd_$command[identifier]_helptxt"];
			
			if ($mgc_vbversion < 4)
			{
				eval('$customhelp .= "' . fetch_template('mgc_cb_evo_help_bit') . '";');
			}
			else
			{
				$templater = vB_Template::create('mgc_cb_evo_help_bit_vb4');
				$templater->register('command', $command);
				$templater->register('helpphrase', $helpphrase);
				$customhelp .= $templater->render();				
			}
		}
	}
	
	if ($mgc_vbversion < 4)
	{
	 	eval('$HTML = "' . fetch_template('mgc_cb_evo_help') . '";');

		$header = '';
		$footer = '';
		eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
	}
	else
	{
	
		$vbcsspath = 'css.php?styleid=' . $vbulletin->userinfo['styleid'] . '&amp;langid=' . LANGUAGEID . '&amp;d=' . $style['dateline'] . '&amp;sheet=';  
		$head .= '<link rel="stylesheet" href="' . $vbcsspath . 'mgc_cb_evo.css" type="text/css">'; 
		$template_hook['headinclude_bottom_css'] .= $head; 
            
            	
		$templater = vB_Template::create('mgc_cb_evo_help_vb4');	
		$templater->register('customhelp', $customhelp);	
		$HTML = $templater->render();	
		
		
		$templater = vB_Template::create('GENERIC_SHELL');
		$header = '';
		$footer = '';
		$templater->register_page_templates();
		$templater->register('HTML', $HTML);
		print_output($templater->render());	
	}
}

if ($_POST['do'] == 'inline_remove_chats')
{
	if (!$MGCCbEvoCore->evo_permissions->can_manage())
	{
		print_no_permission();
	}
   
	$vbulletin->input->clean_array_gpc('p', array('delchat' => TYPE_ARRAY_STR));
   
	// No chats to remove 
	if (!$vbulletin->GPC['delchat'])
	{
		eval(standard_error(fetch_error('mgc_cb_evo_archives_no_chat_to_del')));      
	}
   
	// Remove chats
	$chatids = implode(',',array_keys($vbulletin->GPC['delchat']));
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "mgc_cb_evo_chat WHERE chatid IN($chatids)");
   
   	// Redirect
	$vbulletin->url = 'mgc_cb_evo.php?' . $vbulletin->session->vars['sessionurl'] . "do=view_archives";
	eval(print_standard_redirect('redirect_mgc_cb_evo_archives_chat_removed_successfully'));
}

// All smilies window 
if ($_REQUEST['do'] == "showsmilies")
{
	if ((!$MGCCbEvoCore->evo_permissions->can_view() && !$MGCCbEvoCore->evo_permissions->can_use()) || !$vbulletin->options['mgc_cb_evo_smileys'])
	{
		print_no_permission();
	}   

	// Retrieving smilies 
	$getsmilies = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "smilie ORDER BY displayorder ASC");
	if (!$vbulletin->db->num_rows($getsmilies))
	{
		print_no_permission();
	}
   
	$i = 0;
	$alt = 'alt1';
	
	while($smilie = $db->fetch_array($getsmilies))
	{
		if ($i == 0)
		{
			if ($mgc_vbversion < 4)
			{
				$smiliesbit .= "<tr>";
			}
			else
			{
				$smiliesbit .= "<tr class='blockrow'>";
			}
      	}
		
		$smiliesbit .= "<td class=\"$alt\" align=\"center\"><a href=\"javascript:insert_smilie_from_window('$smilie[smilietext]')\"><img src=\"$smilie[smiliepath]\" alt=\"\" border=\"0\"></a></td>";
		
		$i++;
		
		if ($alt == 'alt1')
		{
			$alt = 'alt2';
		}
		else
		{
			$alt = 'alt1';
		}
		
		if ($i == ($vbulletin->options['mgc_cb_evo_smilieswindow_numberof_column']))
		{
			$smiliesbit .= "</tr>";
			$i = 0;
			$alt = 'alt1';
		}
	}
	
	if ($i < ($vbulletin->options['mgc_cb_evo_smilieswindow_numberof_column']))
	{
		while($i < ($vbulletin->options['mgc_cb_evo_smilieswindow_numberof_column']))
		{
			$smiliesbit .= "<td class=\"$alt\"></td>";
			$i++;
		
			if ($alt == 'alt1')
			{
				$alt = 'alt2';
			}
			else
			{
				$alt = 'alt1';
			}
		}
		$smiliesbit .= "</tr>";
	}
	
	if ($mgc_vbversion < 4)
	{
		eval('print_output("' . fetch_template('mgc_cb_evo_smilies') . '");');
	}
	else
	{
	
		$vbcsspath = 'css.php?styleid=' . $vbulletin->userinfo['styleid'] . '&amp;langid=' . LANGUAGEID . '&amp;d=' . $style['dateline'] . '&amp;sheet=';  
		$head .= '<link rel="stylesheet" href="' . $vbcsspath . 'mgc_cb_evo.css" type="text/css">'; 
		
		$head .= '
			<script type="text/javascript">
			   function insert_smilie_from_window(smilietext)
			   {
			      childwindow = window;
			      window.opener.add_smiley_to_input(smilietext);
			      childwindow.focus();
			   }
			</script>		
		';
		
		$template_hook['headinclude_bottom_css'] .= $head; 
            
            	
		$templater = vB_Template::create('mgc_cb_evo_smilies_vb4');	
		$templater->register('smiliesbit', $smiliesbit);	
		$HTML = $templater->render();	
		
		
		$templater = vB_Template::create('GENERIC_SHELL');
		$header = '';
		$footer = '';
		$templater->register_page_templates();
		$templater->register('HTML', $HTML);
		print_output($templater->render());	
	}	
}

// Rules popup display 
if ($_REQUEST['do'] == "showrules")
{
	if ((!$MGCCbEvoCore->evo_permissions->can_view() && !$MGCCbEvoCore->evo_permissions->can_use()) || empty($vbulletin->options['mgc_cb_evo_rules']))
	{
		print_no_permission();
	}  
	
	
	if ($mgc_vbversion < 4)
	{
		eval('$HTML = "' . fetch_template('mgc_cb_evo_rules') . '";');
		$header = '';
		$footer = '';
		eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
	}
	else
	{
	
		$vbcsspath = 'css.php?styleid=' . $vbulletin->userinfo['styleid'] . '&amp;langid=' . LANGUAGEID . '&amp;d=' . $style['dateline'] . '&amp;sheet=';  
		$head .= '<link rel="stylesheet" href="' . $vbcsspath . 'mgc_cb_evo.css" type="text/css">'; 
		$template_hook['headinclude_bottom_css'] .= $head; 
            
            	
		$templater = vB_Template::create('mgc_cb_evo_rules_vb4');
		$HTML = $templater->render();	
		
		
		$templater = vB_Template::create('GENERIC_SHELL');
		$header = '';
		$footer = '';
		$templater->register_page_templates();
		$templater->register('HTML', $HTML);
		print_output($templater->render());	
	}
}

// Ignored users popup display 
if ($_REQUEST['do'] == "showignore")
{
	if (!$MGCCbEvoCore->evo_permissions->can_use_command_by_identifier('ignore'))
	{
		print_no_permission();
	}
	
	require_once(DIR . '/mgc_cb_evo/classes/class_misc.php');        
	$MGCCbEvoMisc = new MGCCbEvo_misc($vbulletin);
	
	if (empty($vbulletin->userinfo['mgc_cb_evo_ignored']))
	{
		$content	= $MGCCbEvoMisc->construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_ignored_list'],'100%','tcat',true, true, 'center');
		$content	.= $MGCCbEvoMisc->construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_no_ignored_user'],'100%','alt1',true, true, 'center');
		$content 	.= $MGCCbEvoMisc->consruct_mgc_cb_evo_table_row_close_popup(0);      
		$HTML 		= "<br />" . $MGCCbEvoMisc->construct_mgc_cb_evo_table($content);
	}
	else
	{
		// Retrieving of the users 
		$ignored_users = $vbulletin->db->query_read("
			SELECT username,userid,usergroupid,displaygroupid
			FROM " . TABLE_PREFIX . "user
			WHERE userid IN (" . $vbulletin->userinfo['mgc_cb_evo_ignored'] . ")
			ORDER BY username ASC
		");
      
		if (!$vbulletin->db->num_rows($ignored_users))
		{
			$content 	= $MGCCbEvoMisc->construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_ignored_list'],'100%','tcat',true, true, 'center');
			$content 	.= $MGCCbEvoMisc->construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_no_ignored_user'],'100%','alt1',true, true, 'center');
			$content 	.= $MGCCbEvoMisc->consruct_mgc_cb_evo_table_row_close_popup(0);
			$HTML 		= "<br />" . $MGCCbEvoMisc->construct_mgc_cb_evo_table($content);
		}
      
		$table_content = "";
      
		while($ignored_user = $vbulletin->db->fetch_array($ignored_users))
		{
			$table_content .= $MGCCbEvoMisc->construct_mgc_cb_evo_table_col("<a href='memberlist.php?$session[sessionurl]u=$ignored_user[userid]'>" .
			fetch_musername($ignored_user,'displaygroupid') . "</a>",'75%','alt1',true);       
			$table_content .= $MGCCbEvoMisc->construct_mgc_cb_evo_table_col("<a href='" . $vbulletin->options['bburl'] . "/mgc_cb_evo.php?" . $vbulletin->session->vars['sessionurl'] . "do=unignore&uid=" . $ignored_user['userid'] . "' nofollow border='0'>[" . $vbphrase['mgc_cb_evo_unignore'] . "]</a>", '25%','alt2', false, true, 'center');
        
		}
      
		// Table header 
		$table_header 	=  $MGCCbEvoMisc->construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_ignored_list'],'100%','tcat',true, true, 'center',2);
		$table_header 	.= $MGCCbEvoMisc->construct_mgc_cb_evo_table_col($vbphrase['username'],'75%','thead',true);
		$table_header 	.= $MGCCbEvoMisc->construct_mgc_cb_evo_table_col($vbphrase['action'],'25%','thead',false,true,'center');
      
		$table_footer 	=  $MGCCbEvoMisc->consruct_mgc_cb_evo_table_row_close_popup(2);
		$HTML 			= "<br />" . $MGCCbEvoMisc->construct_mgc_cb_evo_table($table_header . $table_content . $table_footer);
	}
   
	if ($mgc_vbversion < 4)
	{
		$header = '';
		$footer = '';
		eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
	}
	else
	{
	
		$vbcsspath = 'css.php?styleid=' . $vbulletin->userinfo['styleid'] . '&amp;langid=' . LANGUAGEID . '&amp;d=' . $style['dateline'] . '&amp;sheet=';  
		$head .= '<link rel="stylesheet" href="' . $vbcsspath . 'mgc_cb_evo.css" type="text/css">'; 
		$template_hook['headinclude_bottom_css'] .= $head; 
		
		$templater = vB_Template::create('GENERIC_SHELL');
		$header = '';
		$footer = '';
		$templater->register_page_templates();
		$templater->register('HTML', $HTML);
		print_output($templater->render());	
	}
}

// Unignore user 
if ($_REQUEST['do'] == 'unignore')
{
	if (!$MGCCbEvoCore->evo_permissions->can_use_command_by_identifier('ignore'))
	{
		print_no_permission();
	}
	
	$userid = $vbulletin->input->clean_gpc('r', 'uid', TYPE_UINT);
   
	// Lets check if the user exists 
	$getuser = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE userid='$userid'"); 
	if (!isset($getuser['userid']))
	{
		eval(standard_error(fetch_error('mgc_cb_evo_cmd_ignore_user_dont_exist')));
	}
   
	// Verify if the user is in the ignored list 
	if (empty($vbulletin->userinfo['mgc_cb_evo_ignored']))
	{
		eval(standard_error(fetch_error('mgc_cb_evo_cmd_ignore_user_not_ignored')));      
	}
	$ignored_users = explode(',',$vbulletin->userinfo['mgc_cb_evo_ignored']);
   
	if (!in_array($userid,$ignored_users))
	{
		eval(standard_error(fetch_error('mgc_cb_evo_cmd_ignore_user_not_ignored')));      
	}
	
	// Let's remove the user from the ignored list 
	foreach ($ignored_users as $index => $userid)
	{
		if ($userid == $getuser['userid'])
		{
			unset($ignored_users["$index"]);
		}
	}
   
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_ignored='" . implode(',',$ignored_users) . "' WHERE userid='" . $vbulletin->userinfo['userid'] . "'");

	$vbulletin->url = $vbulletin->options['bburl'] . '/mgc_cb_evo.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showignore';
	eval(print_standard_redirect('mgc_cb_evo_cmd_ignore_user_successfully_unignored'));   
}

// Show ban popup 
if ($_REQUEST['do'] == "showban")
{	
	if (!$MGCCbEvoCore->evo_permissions->can_use_command_by_identifier('ban'))
	{
		print_no_permission();
	}
	
	require_once(DIR . '/mgc_cb_evo/classes/class_misc.php');        
	$MGCCbEvoMisc = new MGCCbEvo_misc($vbulletin);	
	   
	// Retrieving of the users 
	$banned_users = $vbulletin->db->query_read("
		SELECT username,userid,usergroupid,displaygroupid
		FROM " . TABLE_PREFIX . "user
		WHERE mgc_cb_evo_banned='1'
		ORDER BY username ASC
	");   
   
	if (!$vbulletin->db->num_rows($banned_users))
	{
		$content 	=  $MGCCbEvoMisc->construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_bannedlist'],'100%','tcat',true, true, 'center');
		$content 	.= $MGCCbEvoMisc->construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_no_banned_user'],'100%','alt1',true, true, 'center');
		$content 	.= $MGCCbEvoMisc->consruct_mgc_cb_evo_table_row_close_popup(0);      
		$HTML 		= "<br />" . $MGCCbEvoMisc->construct_mgc_cb_evo_table($content);
   }
   else
   {
		$table_content = "";
      
		while($banned_user = $vbulletin->db->fetch_array($banned_users))
		{
			$table_content .= $MGCCbEvoMisc->construct_mgc_cb_evo_table_col("<a href='memberlist.php?$session[sessionurl]u=$banned_user[userid]'>" . fetch_musername($banned_user,'displaygroupid') . "</a>",'75%','alt1',true);
			$table_content .= $MGCCbEvoMisc->construct_mgc_cb_evo_table_col("<a href='" . $vbulletin->options['bburl'] . "/mgc_cb_evo.php?" . $vbulletin->session->vars['sessionurl'] . "do=unban&uid=" . $banned_user['userid'] . "' nofollow border='0'>[" . $vbphrase['mgc_cb_evo_unban'] . "]</a>", '25%','alt2', false, true, 'center');        
		}
      
		// Table header 
		$table_header =  $MGCCbEvoMisc->construct_mgc_cb_evo_table_col($vbphrase['mgc_cb_evo_bannedlist'],'100%','tcat',true, true, 'center',2);
		$table_header .= $MGCCbEvoMisc->construct_mgc_cb_evo_table_col($vbphrase['username'],'75%','thead',true);
		$table_header .= $MGCCbEvoMisc->construct_mgc_cb_evo_table_col($vbphrase['action'],'25%','thead',false,true,'center');
      
		$table_footer =  $MGCCbEvoMisc->consruct_mgc_cb_evo_table_row_close_popup(2);
		$HTML 		= "<br />" . $MGCCbEvoMisc->construct_mgc_cb_evo_table($table_header . $table_content . $table_footer);
	}
   
	if ($mgc_vbversion < 4)
	{
		$header = '';
		$footer = '';
		eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
	}
	else
	{
	
		$vbcsspath = 'css.php?styleid=' . $vbulletin->userinfo['styleid'] . '&amp;langid=' . LANGUAGEID . '&amp;d=' . $style['dateline'] . '&amp;sheet=';  
		$head .= '<link rel="stylesheet" href="' . $vbcsspath . 'mgc_cb_evo.css" type="text/css">'; 
		$template_hook['headinclude_bottom_css'] .= $head; 
		
		$templater = vB_Template::create('GENERIC_SHELL');
		$header = '';
		$footer = '';
		$templater->register_page_templates();
		$templater->register('HTML', $HTML);
		print_output($templater->render());	
	}
}

// Unban user 
if ($_REQUEST['do'] == 'unban')
{
	if (!$MGCCbEvoCore->evo_permissions->can_use_command_by_identifier('ban'))
	{
		print_no_permission();
	}

	$userid = $vbulletin->input->clean_gpc('r', 'uid', TYPE_UINT);
   	$getuser = $vbulletin->db->query_first("SELECT userid,mgc_cb_evo_banned FROM " . TABLE_PREFIX . "user WHERE userid='$userid'");
 	if (!isset($getuser['userid']))
	{
		eval(standard_error(fetch_error('mgc_cb_evo_cmd_ban_user_dont_exist')));
	}
      
	if (!$getuser['mgc_cb_evo_banned'])
	{
		eval(standard_error(fetch_error('mgc_cb_evo_cmd_ban_not_banned')));      
	}
  
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET mgc_cb_evo_banned='0' WHERE userid='" . $getuser['userid'] . "'");

	$vbulletin->url = $vbulletin->options['bburl'] . '/mgc_cb_evo.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showban';
	eval(print_standard_redirect('mgc_cb_evo_cmd_ignore_user_successfully_unbanned'));   
}

// Managment of the search requests 
if ($_REQUEST['do'] == 'search')
{
	if (!$MGCCbEvoCore->evo_permissions->can_view() && $MGCCbEvoCore->evo_permissions->can_search())
	{
		print_no_permission();
	} 
 
	$vbulletin->input->clean_array_gpc('r', array(
		'what' 			=> TYPE_NOHTML,
		'keywords' 		=> TYPE_NOHTML,
		'u'				=>	TYPE_UINT,
		'search_chanid'	=> TYPE_INT
	));
    
    // Retrieving of the commands permissions and status
    $identifier_array = array('\'0\'');

	if (is_array($vbulletin->mgc_cb_evo_commands))
	{					
		foreach($vbulletin->mgc_cb_evo_commands AS $command)
		{
			if (!empty($command['usergroupids']))
			{
				$command['usergroupids'] = explode(',',$command['usergroupids']);
			}
			
			if (!empty($command['userids']))
			{
				$command['userids'] = explode(',',$command['userids']);
			}	
								
			// Channel not active => next
			if ($command['active'] == 0)
			{
				$commands_status["$command[identifier]"] = '0';
				continue;
			}
			
			// Test if user has permissions
			$hasaccess = 0;		
			// 1 - Usergroupid test
			if (is_array($command['usergroupids']) && in_array($vbulletin->userinfo['usergroupid'],$command['usergroupids']))
			{
				$hasaccess = 1;
			}
			// 2 - Member group test
			if (!$hasaccess && !empty($vbulletin->userinfo['membergroupids']))
			{
				$found 			= 0;
				$ugipds_array 	= explode(',', $vbulletin->userinfo['membergroupids']);		
				foreach ($ugipds_array as $index => $ugpid)
				{
					if (in_array($ugpid,$command['usergroupids']))
					{
						$hasaccess = 1;
					}
				}
			}
			// 3 - Userid test
			if (!$hasaccess && is_array($command['userids']) && in_array($vbulletin->userinfo['userid'],$command['userids']))
			{
				$hasaccess = 1;
			}
			// 4 - Skip channel if not
			if (!$hasaccess)
			{
				$commands_status["$command[identifier]"] = '0';
				continue;
			}
			
			$identifier_array[] = "'" . $command['identifier'] . "'";
			$commands_status["$command[identifier]"] = '1';
		}
	}
	
	// Retrieving the channels permissions
	$channel_ids[] = 0;
	
	if (is_array($vbulletin->mgc_cb_evo_channels))
	{					
		foreach($vbulletin->mgc_cb_evo_channels AS $channel)
		{
			if (!empty($channel['usergroupids']))
			{
				$channel['usergroupids'] = explode(',',$channel['usergroupids']);
			}
			
			if (!empty($channel['userids']))
			{
				$channel['userids'] = explode(',',$channel['userids']);
			}	
								
			// Channel not active => next
			if ($channel['active'] == 0)
			{
				continue;
			}
			
			// Test if user has permissions
			$hasaccess = 0;		
			// 1 - Usergroupid test
			if (is_array($channel['usergroupids']) && in_array($vbulletin->userinfo['usergroupid'],$channel['usergroupids']))
			{
				$hasaccess = 1;
			}
			// 2 - Member group test
			if (!$hasaccess && !empty($vbulletin->userinfo['membergroupids']))
			{
				$found 			= 0;
				$ugipds_array 	= explode(',', $vbulletin->userinfo['membergroupids']);		
				foreach ($ugipds_array as $index => $ugpid)
				{
					if (in_array($ugpid,$channel['usergroupids']))
					{
						$hasaccess = 1;
					}
				}
			}
			// 3 - Userid test
			if (!$hasaccess && is_array($channel['userids']) && in_array($vbulletin->userinfo['userid'],$channel['userids']))
			{
				$hasaccess = 1;
			}
			// 4 - Skip channel if not
			if (!$hasaccess)
			{
				continue;
			}
			
			$channel_ids[] = $channel['chanid'];
			$channels_name["$channel[chanid]"] = $channel['title'];
		}
	}		    
      
	// User chats search 
	if ($vbulletin->GPC['what'] == 'userchats')
	{
		// Checks if user exists 
		$user = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE userid='" . $vbulletin->GPC['u'] . "'");
		if (!$user)
		{
			eval(standard_error(fetch_error('mgc_cb_evo_user_dont_exist')));   		
		}
	
		// Building the chats retrieving query
		$where_clause = "coidentifier IN (" . implode(',',$identifier_array) . ") AND chanid IN(" . implode(',',$channel_ids) . ") AND fromuid='" . $user['userid'] . "' AND touid='0'";
	
		// No newthread/newpost warning 
		$where_clause .= " AND iswarning='0'";
	}
	// Keywords search 
	else
	{
		if (empty($vbulletin->GPC['keywords']))
		{
	      eval(standard_error(fetch_error('mgc_cb_evo_nokeywords')));   		
		}
	
		// Not private chats where clause       
		$where_clause = "coidentifier IN (" . implode(',',$identifier_array) . ") AND chanid IN(" . implode(',',$channel_ids) . ") AND (touid='0' OR fromuid='" . $vbulletin->userinfo['userid'] . "'OR touid='" . $vbulletin->userinfo['userid'] . "')";      

		// Ignore command where clause       
		if ($commands_status['ignore'] && !empty($vbulletin->userinfo['mgc_cb_evo_ignored']))
		{
			$where_clause .= " AND fromuid NOT IN (" . $vbulletin->userinfo['mgc_cb_evo_ignored'] . ")";
			$where_clause .= " AND touid NOT IN (" . $vbulletin->userinfo['mgc_cb_evo_ignored'] . ")";
		}
		
		if ($vbulletin->GPC['search_chanid'] != -1)
		{
			$where_clause .= " AND chanid='" . $vbulletin->GPC['search_chanid'] . "'";	
		}
		
		// No newthread/newpost warning 
		$where_clause .= " AND iswarning='0'";
		
		// Content clause 
		$where_clause .= " AND ctext LIKE '%" . $vbulletin->db->escape_string($vbulletin->GPC['keywords']) . "%'";	
	}

	$perpage = $vbulletin->options['mgc_cb_evo_search_nbchats_per_page'];
	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);

	// Count of the chats 
	$getnbchats = $vbulletin->db->query_first("
		SELECT COUNT(chatid) AS nbchats
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
		WHERE $where_clause
		ORDER BY c.dateline DESC
	");     
  
	sanitize_pageresults($getnbchats['nbchats'], $pagenumber, $perpage, 100, 25);

	// page min / page max 
	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = $pagenumber * $perpage;
	if ($limitupper > $getnbchats['nbchats'])
	{
		$limitupper = $getnbchats['nbchats'];
		if ($limitlower > $getnbchats['nbchats'])
		{
			$limitlower = $getnbchats['nbchats'] - $perpage;
		}
	}
	if ($limitlower <= 0)
	{
		$limitlower = 1;
	}
	
	// User chats search 
	if ($vbulletin->GPC['what'] == 'userchats')
	{
		$pagenav = construct_page_nav($pagenumber, $perpage, $getnbchats['nbchats'], $vbulletin->options['bburl'] . '/mgc_cb_evo.php?' . $vbulletin->session->vars['sessionurl'] . 'do=search&amp;what=userchats&amp;u=' . $vbulletin->GPC['u']);  
	}
  	else
  	{
		$pagenav = construct_page_nav($pagenumber, $perpage, $getnbchats['nbchats'], $vbulletin->options['bburl'] . '/mgc_cb_evo.php?' . $vbulletin->session->vars['sessionurl'] . 'do=search&amp;what=keywords&amp;keywords=' . $vbulletin->GPC['keywords']); 
  	}
   
	// Check that we have at least 1 channel to activate channel name displays 
	if (count($channel_ids) > 1)
	{
		$show['channame'] = 1;
	}	  

	// Retrieving of the chats 
	$chats = $vbulletin->db->query_read("
		SELECT c.*
		FROM " . TABLE_PREFIX . "mgc_cb_evo_chat AS c
		WHERE $where_clause
		ORDER BY c.dateline DESC
		LIMIT " . ($limitlower - 1) . ", $perpage
  	");

	if ($vbulletin->db->num_rows($chats))
	{
   		// Instantiate formatting class
		require_once(DIR . '/mgc_cb_evo/classes/class_formatting.php');
		$MGCCbEvoFormatting = new MGCCbEvo_formatting($vbulletin,$MGCCbEvoCore);	
			
		$parsebbcode = $vbulletin->options['mgc_cb_evo_bbcode'] || $vbulletin->options['mgc_cb_evo_bbcode_url'] || $vbulletin->options['mgc_cb_evo_bbcode_img'];
      
		$alt = 2;
		$chatids_array = array();
		while ($chat = $vbulletin->db->fetch_array($chats))
		{
			$chatids_array[] = $chat['chatid'];
				
			// Channel name
			if ($chat['chanid'])
			{
				$chat['chantitle'] = $channels_name["$chat[chanid]"];
			}
				
			// Chatbit
			$chatbit .= $MGCCbEvoFormatting->construct_chat($chat, $parsebbcode, $commands_status, $channel_id,$alt,1,$show['channame'],$vbulletin->GPC['keywords']);
         
         	// Alternate row color
			if ($vbulletin->options['mgc_cb_evo_alt_colors'])
			{
				if ($alt == 2)
				{
					$alt = 1;
				}
				else
				{
					$alt = 2;
				}
			}                 
		}                                    
	}
      	
	// Can manage chatbox permission 
	$show['delete_column'] = $MGCCbEvoCore->evo_permissions->can_manage();

	if (is_array($chatids_array))
	{
		$jsarray = "var chatids_array = [" . implode(',',$chatids_array) . "];";
	}
	
	// Construct js calls
	$mgc_cb_evo_archives_js  = "<script type=\"text/javascript\">\n";
	$mgc_cb_evo_archives_js .= "var sessionurl = \"" . $vbulletin->session->vars['sessionurl_q'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var bburl = \"" . $vboptions['bburl'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var mgc_cb_evo_jsloc = \"" . $mgc_cb_evo_floc . "\";\n";
	$mgc_cb_evo_archives_js .= "var avataron = \"" . $vboptions['mgc_cb_evo_avatar_on'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var mgc_cb_evo_static = 1;\n";
	$mgc_cb_evo_archives_js .= "var phrase_error_chat_in_process = \"" . $vbphrase['mgc_cb_evo_jserror_chat_in_progress'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_enter_url = \"" . $vbphrase['mgc_cb_evo_js_enter_url'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_enter_email = \"" . $vbphrase['mgc_cb_evo_js_enter_email'] . "\";\n";   
  	$mgc_cb_evo_archives_js .= "var phrase_enter_imgurl = \"" . $vbphrase['mgc_cb_evo_js_enter_imgurl'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_already_editing = \"" . $vbphrase['mgc_cb_evo_already_editing'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_edit_forbidden = \"" . $vbphrase['mgc_cb_evo_edit_forbidden'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_inactive = \"" . $vbphrase['mgc_cb_evo_inactive'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_enter_urltext = \"" . $vbphrase['mgc_cb_evo_js_enter_urltext'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_enter_name = \"" . $vbphrase['mgc_cb_evo_js_enter_name'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_error_name = \"" . $vbphrase['mgc_cb_evo_js_error_name'] . "\";\n";	
	$mgc_cb_evo_archives_js .= "var phrase_ok = \"" . $vbphrase['mgc_cb_evo_ok'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_yes = \"" . $vbphrase['yes'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_no = \"" . $vbphrase['no'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_save = \"" . $vbphrase['save'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_cancel = \"" . $vbphrase['cancel'] . "\";\n";
	$mgc_cb_evo_archives_js .= "var phrase_enter_report_reason = \"" . $vbphrase['mgc_cb_evo_enter_report_reason'] . "\";\n";	
	$mgc_cb_evo_archives_js .= "var avataron = " . $vbulletin->options['mgc_cb_evo_avatar_on'] . ";\n";
	$mgc_cb_evo_archives_js .= $jsarray;
	$mgc_cb_evo_archives_js .= "\n</script>\n";

	if ($vbulletin->options['mgc_cb_evo_js_load_locally'])
	{
		$mgc_cb_evo_archives_headjs = '<script type="text/javascript" src="http://yui.yahooapis.com/combo?2.7.0/build/animation/animation-min.js&2.7.0/build/datasource/datasource-min.js&2.7.0/build/autocomplete/autocomplete-min.js&2.7.0/build/element/element-min.js&2.7.0/build/button/button-min.js&2.7.0/build/container/container-min.js&2.7.0/build/tabview/tabview-min.js"></script>';
	}
	else
	{
		$mgc_cb_evo_archives_headjs = '<script type="text/javascript" src="mgc_cb_evo/clientscript/yui/combined/combined-min.js"></script>';
	}	
	
	$mgc_cb_evo_archives_js .= $mgc_cb_evo_archives_headjs;
	$mgc_cb_evo_archives_js .= "<script type=\"text/javascript\" src=\"" . $mgc_cb_evo_floc . "mgc_cb_evo/clientscript/mgc_cb_evo_static.js\"></script>";
	
    // Headinclude 
    $mgc_head = ''; 
    if ($vbulletin->options['mgc_cb_evo_js_load_locally']) 
    { 
        $mgc_head .= '<link rel="stylesheet" href="http://yui.yahooapis.com/combo?2.7.0/build/container/assets/skins/sam/container.css&2.7.0/build/button/assets/skins/sam/button.css">'; 
    } 
    else 
    { 
        $mgc_head .= '<link rel="stylesheet" href="mgc_cb_evo/clientscript/yui/container/assets/skins/sam/container.css" type="text/css">'; 
        $mgc_head .= '<link rel="stylesheet" href="mgc_cb_evo/clientscript/yui/button/assets/skins/sam/button.css" type="text/css">'; 
    } 
    $mgc_head .= '<link rel="stylesheet" href="mgc_cb_evo/clientscript/widget-skin.css" type="text/css">'; 
    $mgc_head .= '<link rel="stylesheet" href="mgc_cb_evo/clientscript/chatbox_tabs.css" type="text/css">'; 		
	
	// Print out template
	if ($mgc_vbversion < 4)
	{
		eval('$HTML = "' . fetch_template('mgc_cb_evo_search') . '";');
	
		$headinclude .= $mgc_head;
	
		$navbits = array();
		$navbits[$parent] = $vbulletin->options['mgc_cb_evo_title'] . " : " . $vbphrase['search'] . (!empty($navtext) ? ' : ' . $navtext : '');
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');
	
		eval('print_output("' . fetch_template('GENERIC_SHELL') . '");');
	}
	else
	{
		$mgc_vbcsspath = 'css.php?styleid=' . $vbulletin->userinfo['styleid'] . '&amp;langid=' . LANGUAGEID . '&amp;d=' . $style['dateline'] . '&amp;sheet=';  
		$mgc_head .= '<link rel="stylesheet" href="' . $mgc_vbcsspath . 'mgc_cb_evo.css" type="text/css">'; 
		$headinclude .= $mgc_head;	
			 	
		$templater = vB_Template::create('mgc_cb_evo_search_vb4');
			$templater->register('mgc_cb_evo_archives_js', $mgc_cb_evo_archives_js);
			$templater->register('limitlower', $limitlower);
			$templater->register('limitupper', $limitupper);
			$templater->register('getnbchats', $getnbchats);
			$templater->register('chatbit', $chatbit);
			$templater->register('pagenav', $pagenav);
		$HTML = $templater->render();	
		
		$navbits = construct_navbits(array('' => $vbulletin->options['mgc_cb_evo_title'] . " : " . $vbphrase['search'] . (!empty($navtext) ? ' : ' . $navtext : '')));
		$navbar = render_navbar_template($navbits);
		
		$templater = vB_Template::create('GENERIC_SHELL');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('HTML', $HTML);
			$templater->register('pagetitle', $vbulletin->options['mgc_cb_evo_title'] . " : " . $vbphrase['search'] . (!empty($navtext) ? ' : ' . $navtext : ''));
		print_output($templater->render());		
	}	
}

?>