<?php
/**
 *
 * @package jvbPlugin
 * @version $Id: jvb_fcore.php, v 1.0 2008/07/25 15:37:17 koudanshi Exp $
 * @copyright (c) 2003-2008 BBPixel
 *
 * Minimum Requirement: PHP 4.3.3 | MySQL 4.1
 */

class jvb_fcore {

	var $_bbDBprefix;
	var $_jDB;
	var $_modsGroupsLimit = ",24,25";//Mods can not see Admin groups
	var $_jDBprefix = 'jos_';
	var $_product 	= "jvbPlugin";
	var $_version 	= "R15.37.5";
	var $_showMSG 	= 0;
	var $_debug 	= "<h2>jvbPlugin debug info:</h2>";

	function jvb_fcore ()
	{
		global $vbulletin, $showMSG;

		$this->_showMSG 	= $showMSG;
		$this->_bbDBprefix 	= $vbulletin->config['Database']['tableprefix'];

		//init joomla db
		$this->_jDB 		= new vB_Database($vbulletin);
	}


	//create an J connection ID
	function jConnID($site=array()) {

		$this->_jDB->connect($site['dbname'], $site['dbhost'], $site['dbport'], $site['dbuser'], $site['dbpass'], 0);
		$this->_jDBprefix = $site['dbprefix'];
	}
	/**
	 * Show news from bbpixel.com
	 *
	 */
	function getHomeNews() {

		$html = <<<EOF
	<br/>
	<div class="tablerow1" style="overflow:auto">
		<iframe src="" scrolling="auto" frameborder="0" style="border:0px;width:99%;padding:0px;margin:0px;height:100px;background:#E4EAF2"></iframe></div>
	</div>
EOF;
		return $html;
	}


	/**
	 * Get Joomla mainsite user info only
	 *
	 * @param Portal user name $userID
	 * @return User info array
	 */
	function getUser($userID=0)	{

	    $this->_debug .= "<p><b>Get Joomla user info:</b><p>";

		global $vbulletin, $db, $jvbConfigs;

		if (!$userID) return;

		//make a connection to Joomla db
		$this->jConnID($jvbConfigs);

		//start to deal with
		$sql = "SELECT * FROM {$this->_jDBprefix}users WHERE id={$userID} LIMIT 1";
		$this->_debug .= "</br><div> $sql </div>";
		$results = $this->_jDB->query($sql);
		$member = array();

		if ($this->_jDB->num_rows($results)){
			$member = $this->_jDB->fetch_array($results);
			//switch back to VB db
			$db->select_db($vbulletin->config['Database']['dbname']);
			return  $member;
		}

		$this->_debug .= "</br><div>Portal: no member with username=<b> $userID </b> </div>";
		//switch back to VB db
		$db->select_db($vbulletin->config['Database']['dbname']);
		return false;
	}


	/**
	 * Get groups list from Joomla mainsite only
	 *
	 * @return array of group name
	 */
	function getGroups() {

		$this->_debug .= "<p><b>Get Portal group:</b><p>";

		global $vbulletin, $db, $jvbConfigs;

		//make a connection to Joomla db
		$this->jConnID($jvbConfigs);

		//Get group
		if (VB_AREA != "AdminCP") {
			$gIDlimit = $this->_modsGroupsLimit;
		}

		$sql = "SELECT id, name FROM {$this->_jDBprefix}core_acl_aro_groups WHERE id NOT IN (17,28,29,30 $gID_limit)";
		$this->_debug .= "</br><div> $sql </div>";
		$results 	= $this->_jDB->query($sql);
		$groupsList = array();

		while($row = $this->_jDB->fetch_array($results)){
			$groupsList[$row['id']] .= $row['name'];
		}

		//switch back to VB db
		$db->select_db($vbulletin->config['Database']['dbname']);
		return $groupsList;
	}



	/**
	 * Update ALL subsites account - ACP section
	 *
	 */
	function doSaveUsersACP() {

		global $vbulletin, $db, $jvbConfigs;

		//clean input value
		$vbulletin->input->clean_array_gpc('p', array('cms' => TYPE_ARRAY));

		$jUser = array();
		$jUser['username'] 	= $vbulletin->GPC['user']['username'];
		$jUser['email'] 	= $vbulletin->GPC['user']['email'];
		$jUser['name'] 		= $vbulletin->GPC['cms']['name'];
		$jUser['gid'] 		= $vbulletin->GPC['cms']['groupid'];
		$jUser['usertype'] 	= $vbulletin->GPC['cms']['groupid'];
		$jUser['block'] 	= $vbulletin->GPC['cms']['block'];
		$jUser['sendEmail'] = $vbulletin->GPC['cms']['sendEmail'];

		$this->_debug .= "jname = {$jUser['name']} <br>";
		//do update
		if ($vbulletin->GPC['userid']) {
			$jUser['id'] = $vbulletin->GPC['userid'];

			if (!empty($vbulletin->GPC['password'])){
				$jUser['password'] = $vbulletin->GPC['password'];
			}

			//make a connection to Joomla db
			$this->jConnID($jvbConfigs);
			$this->saveUser($jUser);
			$this->saveUserGroup($jUser);
		} else {
			//do create new account
			$jUser['id']       		= $this->getNextUserID();
			$jUser['password'] 		= $vbulletin->GPC['password'];
			$jUser['registerDate'] 	= time();
			$jUser['lastvisitDate'] = time();
			$jUser['activation'] 	= '';
			$jUser['params'] 		= '';

			//make a connection to Joomla db
			$this->jConnID($jvbConfigs);
			$this->saveUser($jUser,1);
			$this->saveUserGroup($jUser,1);
		}
		$this->_debug .= "site db = {$site['dbname']} <br>";

		$db->select_db($vbulletin->config['Database']['dbname']);
	}



	/**
	 * Create ALL subsites account - client section
	 *
	 */
	function doRegisters($data=array()) {

		global $vbulletin, $db, $jvbConfigs, $regGroupID;

		$data['name']      		= $data['username'];
		$data['password']      	= md5("bbpixel");//add fake password due to VB JS issue Weird :(
		$data['gid'] 			= $regGroupID;
		$data['usertype'] 		= $data['gid'];
		$data['block'] 			= 0;
		$data['sendEmail']		= 1;
		$data['registerDate']	= time();
		$data['lastvisitDate']	= time();
		$data['activation']		= '';
		$data['params']			= '';

		//make a connection to Joomla db
		$this->jConnID($jvbConfigs);
		$this->saveUser($data,1);
		$this->saveUserGroup($data,1);

		$db->select_db($vbulletin->config['Database']['dbname']);
	}



	/**
	 * Update ALL subsites userCP email/password - client section
	 *
	 */
	function doUpdateUsersCP() {

		global $vbulletin, $db, $jvbConfigs;

		$jUser = array();
		$jUser['id'] = $vbulletin->userinfo['userid'];

		//make a connection to Joomla db
		$this->jConnID($jvbConfigs);

		// update password
		if (!empty($vbulletin->GPC['newpassword']) OR !empty($vbulletin->GPC['newpassword_md5'])) {
			$jUser['password'] = md5("bbpixel");  // weird md5 alreadly again due to VB JS pass hash :(
			$this->saveUser($jUser);
			$this->_debug .= "update ucp pass = {$jUser['password']} <Br>";
		}
		// update email only if user is not banned (see bug 2142) and email is changed
		if (!($permissions['genericoptions'] & $vbulletin->bf_ugp_genericoptions['isbannedgroup']) AND $vbulletin->GPC['email'] != $vbulletin->userinfo['email']) {
			$jUser['email'] = $vbulletin->GPC['email'];
			$this->saveUser($jUser);
		}
		$db->select_db($vbulletin->config['Database']['dbname']);
	}



	/**
	 * Update ALL subsites userCP options - client section
	 *
	 */
	function doUpdateOptionsCP() {

		global $vbulletin, $db, $jvbConfigs;

		$sendEmail = 1;

		if(!isset($vbulletin->GPC['options']['adminemail'])){
			$sendEmail = 0;
		}

		$jUser = array();
		$jUser['id'] = $vbulletin->userinfo['userid'];
		$jUser['sendEmail'] = $sendEmail;

		//make a connection to Joomla db
		$this->jConnID($jvbConfigs);
		$this->saveUser($jUser);
		$this->_debug .= "update ucp pass = {$jUser['password']} <Br>";

		$db->select_db($vbulletin->config['Database']['dbname']);
	}



	/**
	 * Rebuid passwords for ALL subsites
	 * Guarantee Joomla can run standalone in the future
	 * Apply when user password was updated/created from VB side.
	 *
	 */
	function doRebuildPasswords() {

		global $vbulletin, $db, $jvbConfigs;

		$userID 	= $vbulletin->userinfo['userid'];
		$fakePwd 	= md5('bbpixel');
		$newPwd 	= $this->buildPassword($vbulletin->GPC['vb_login_password']);

		$jUser = array();
		$jUser['id'] = $userID;
		$jUser['password'] = $newPwd;

		//make a connection to Joomla db
		$this->jConnID($jvbConfigs);

		$sql = "SELECT password FROM {$this->_jDBprefix}users WHERE id=$userID LIMIT 1";
		$results 	= $this->_jDB->query($sql);
		$row 		= $this->_jDB->fetch_array($results);
		$oldPwd 	= $row['password'];

		if ($oldPwd == $fakePwd) {
			$this->saveUser($jUser);
		}
		$db->select_db($vbulletin->config['Database']['dbname']);
	}


	/**
	 * VB passowrd recovery automatically
	 * Apply for accounts which were synchronized from Jooomla hash password.
	 *
	 */
	function recoveryPassword() {

		global $db, $vbulletin, $jvbConfigs;

		$inUsername 	= $vbulletin->GPC['vb_login_username'];
		$inUsername 	= $db->escape_string(strtolower(trim($inUsername)));
		$inPwd 			= trim($vbulletin->GPC['vb_login_password']);
		$fakePwd 		= md5('bbpixel');

		//get current BB info
		$sql = "SELECT userid, password, salt FROM ".TABLE_PREFIX."user WHERE LOWER(username)='$inUsername' LIMIT 1";
		$results 	= $db->query($sql);
		$bbRow 		= $db->fetch_array($results);

		//need to recovery now?
		if ($bbRow['password'] == $fakePwd) {
			//Checking if input password matched with Joomla one
			//make a connection to Joomla db
			$this->jConnID($jvbConfigs);

			$jsql 		= "SELECT password FROM {$this->_jDBprefix}users WHERE id=".intval($bbRow['userid'])." LIMIT 1";
			$jresults 	= $this->_jDB->query($jsql);
			$jRow		= $this->_jDB->fetch_array($jresults);
			$jPwd		= $jRow['password'];

			//Switch back to vb db
			$db->select_db($vbulletin->config['Database']['dbname']);

			$newBBpwd = "";

			//Checking if it uses old hash from old 1.0.12
			if ((strpos($jPwd, ':') == false) && $jPwd == md5($inPwd)) {
				//build BB password with md5_password
				$newBBpwd = md5($jPwd.$bbRow['salt']);
			}

			//Checking it uses new hash from 1.0.13
			list($hash, $salt) = explode(':', $jPwd);
			//Input password
			$cryptpass = md5($inPwd.$salt);

			if ($cryptpass == $hash) {//matched -> go on
				$newBBpwd = md5(md5($inPwd).$bbRow['salt']);
			}
			if (!empty($newBBpwd)) {
				$sql = "UPDATE ".TABLE_PREFIX."user SET password='".$db->escape_string($newBBpwd)."' WHERE userid=".intval($bbRow['userid'])."";
				$db->query($sql);
			}
		}
	}
	/**
	 * Create/Update user with buildable list
	 *
	 * @param array $data :: containt which field nanme, field value to do update
	 */
	function saveUser($data=array(), $isnew=0) {

		global $db;

		//build query
		$fields = "";
		$values = "";
		if ($data != null) {
			foreach ($data as $field => $value) {
				//buld register date
				if ($field == "registerDate") {
					$value = date("Y-m-d H:i:s", $value);
				}
				//build usertype
				if ($field == "usertype") {
					$value = $this->buildUsertype($value);
				}
				//convert to Joomla password type
				if ($field == "password") {
					$value = $this->buildPassword(trim($value));
				}
				//Clean value
				$value 	= $db->escape_string($value);
				//make sure we don't stuck with ID
				if (!$isnew ) {
					if ($field != "id")
						$fields .= "`$field`='$value',";
				} else {
					//create fields list
					$fields .= "`$field`,";
					$values .= "'$value',";
				}
			}
			$fields = rtrim($fields, ",");
			$values = rtrim($values, ",");
		}
		$userID = intval($data['id']);

		if (!$isnew) {
			$sql = "UPDATE {$this->_jDBprefix}users SET $fields WHERE id=$userID";
		} else {
			$sql = "INSERT INTO {$this->_jDBprefix}users ($fields) VALUES ($values)";
		}
		$this->_jDB->query($sql);
		$this->_debug .= "update sql = $sql <br>";
	}



	/**
	 * build usertype from groupID
	 *
	 * @param integer $groupID
	 * @return string
	 */
	function buildUsertype($groupID=0) {

		if (!$groupID) return;

		$sql = "SELECT name FROM {$this->_jDBprefix}core_acl_aro_groups WHERE id=$groupID LIMIT 1";
		$results 	= $this->_jDB->query($sql);
		$row		= $this->_jDB->fetch_array($results);
		$usertype 	= $row['name'];

		return $usertype;
	}



	/**
	 * Buid password
	 *
	 * @param string $password plain value
	 * @return unknown
	 */
	function buildPassword($password=null) {

		//don't build for md5 pass
		if (strlen($password) == 32) return $password;

		$salt = $this->genSalt(32);
		$password = md5($password.$salt).":".$salt;

		return $password;
	}



	/**
	 * generate Joomla Salt
	 *
	 * @param interger $length
	 * @return string salt
	 */
	function genSalt($length=8) {

		$salt = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
		$len = strlen($salt);
		$makesalt = '';
		mt_srand(10000000 * (double) microtime());

		for ($i = 0; $i < $length; $i ++) {
			$makesalt .= $salt[mt_rand(0, $len -1)];
		}
		return $makesalt;
	}



	/**
	 * *
	 * Get Max userid from VB
	 * @return int ID
	 */
	function getNextUserID () {

		global $db, $vbulletin;

		$db->select_db($vbulletin->config['Database']['dbname']);

		$sql = "SELECT MAX(userid) AS maxID FROM ".TABLE_PREFIX."user";
		$results 	= $db->query($sql);
		$row 		= 	$db->fetch_array($results);

		return $row['maxID'] + 1;
	}



	/**
	 * Update usergroup permission for 1 account
	 *
	 * @param Integer $userID
	 * @param Integer $groupID
	 */
	function saveUserGroup($data=array(), $isnew=0) {

		global $db;

		if ($data == null) return;

		if (!$isnew) {
			//get aro id
		    $sql = "SELECT id as aro_id FROM {$this->_jDBprefix}core_acl_aro WHERE value={$data['id']} LIMIT 1";
			$results 	= $this->_jDB->query($sql);
			$row 		= $this->_jDB->fetch_array($results);
			$aroID    	= intval($row['aro_id']);

			$sql = "UPDATE {$this->_jDBprefix}core_acl_groups_aro_map SET group_id={$data['gid']} WHERE aro_id=$aroID";
			$this->_jDB->query($sql);
		} else {

			$username = $db->escape_string(trim($data['username']));
			//acl_aro
			$sql = "INSERT INTO {$this->_jDBprefix}core_acl_aro (`id`, `section_value`, `value`, `order_value`, `name`, `hidden`) VALUES (NULL, 'users', {$data['id']}, '', '{$username}', '0') ";
			$this->_jDB->query($sql);
			$aroID = $this->_jDB->insert_id();
			//acl_groups_aro_map
			$sql = "INSERT INTO {$this->_jDBprefix}core_acl_groups_aro_map (`group_id`, `section_value`, `aro_id`) VALUES ({$data['gid']}, '', $aroID) ";
			$this->_jDB->query($sql);
		}
	}



	/**
	 * Delete user accounts of ALL subsites
	 *
	 * @param string $userIDs
	 */
	function doDeleteUsers($userIDs=null) {

		global $vbulletin, $db, $jvbConfigs;

		foreach ($jvbConfigs AS $site) {
			//make a connection to Joomla db
			$this->jConnID($jvbConfigs);
			$this->deleteUser($userIDs);
		}

		//switch to vb db
		$db->select_db($vbulletin->config['Database']['dbname']);
	}



	/**
	 * Delete a user account
	 *
	 * @param unknown_type $userIDs
	 */
	function deleteUser($userIDs=null) {

		if ($userIDs == null) return ;

		//build acro_id list
		$sql = "SELECT id FROM {$this->_jDBprefix}core_acl_aro WHERE value IN ($userIDs)";
		$results = $this->_jDB->query($sql);
		$aroList = "";
		$this->_debug .= "delete user sql = $sql <br>";
		while ($row = $this->_jDB->fetch_array($results)) {
			$aroList .= $row['id'].",";
		}
		$aroIDs = intval(rtrim($aroList, ","));

		$sqls = array();
		$sqls[] = "DELETE FROM {$this->_jDBprefix}users WHERE id IN ($userIDs)";
		$sqls[] = "DELETE FROM {$this->_jDBprefix}core_acl_aro WHERE value IN ($userIDs)";
		$sqls[] = "DELETE FROM {$this->_jDBprefix}core_acl_groups_aro_map WHERE aro_id IN ($aroIDs)";
		foreach ($sqls as $sql) {
			$this->_jDB->query($sql);
		}
		$this->_debug .= "aroID list = $aroIDs <br>";
	}



}





?>