<?php
/**
 *
 * @package jvbPlugin
 * @version $Id: jvb_core.php, v 1.0 2008/08/18 15:37:17 koudanshi Exp $
 * @copyright (c) 2003-2008 BBPixel
 *
 * Минимальные требования: PHP 4.3.3 | MySQL 4.1
 */

class jvb_core {

	var $_bbPath;
	var $_bbURL;
	var $_bbDBprefix;
	var $_bbCookiePrefix;
	var $_bbLicense;
	var $_styleid = 1;
	var $_wrapperID = 0;
	
	// Proxy behind
	var $_ipCheck			= 1;

	// VB database
	var $_bbDB;

	var $_userinfo = array();


	/**
	 * Constructor
	 *
	 * @return jvbme_core
	 */
	function jvb_core() {

		require_once ( JPATH_SITE.DS.'jvb_config.php' );
		require_once ( $bbPath.'/includes/config.php' );

		$this->_bbPath 			= $bbPath;
		$this->_bbURL 			= $bbURL;
		$this->_bbLicense	 	= $bbLicense;
		$this->_bbDBprefix 		= $config['Database']['tableprefix'];
		$this->_bbCookiePrefix 	= $config['Misc']['cookieprefix'];

		//Other config?
		$this->_styleid			= $styleid;
		$this->_wrapperID		= $wrapperID;
		$this->_ipCheck			= $ipCheck;

		//create VB database connection
		$this->bbConnID($config);

		$this->autoLogin();

		//Redirect to right where from
		$this->autoEngine();
	}



	/**
	 * create vb Database connection
	 *
	 * @param array $config : database info
	 */
	function bbConnID($config=array()) {

		jimport('joomla.database.database');
		jimport( 'joomla.database.table' );

		$options	= array ( 	'driver' 	=> 'mysql',
								'host' 		=> $config['MasterServer']['servername'].":".$config['MasterServer']['port'],
								'user' 		=> $config['MasterServer']['username'],
								'password' 	=> $config['MasterServer']['password'],
								'database' 	=> $config['Database']['dbname'],
								'prefix' 	=> $config['Database']['tableprefix']
							);

		$db =& JDatabase::getInstance( $options );

		if ( JError::isError($db) ) {
			jexit('Database Error: ' . $db->toString() );
		}

		if ($db->getErrorNum() > 0) {
			JError::raiseError(500 , 'JDatabase::getInstance: Could not connect to database <br/>' . 'joomla.library:'.$db->getErrorNum().' - '.$db->getErrorMsg() );
		}

		$this->_bbDB = $db;
	}



	/**
	 * check if we are already logged in vb?
	 *
	 */
	function autoLogin() {

		//init Joomla database
		$jDB =& JFactory::getDBO();

		//vb remember me checking
		$cookiesUserID 	= $this->getCookie("userid") 		? $this->getCookie("userid") 		: 0;
		$cookiesPwd 	= $this->getCookie("password") 		? $this->getCookie("password") 		: 0;
		$sessionHash	= $this->getCookie("sessionhash") 	? $this->getCookie("sessionhash") 	: 0;
		$sessionID 		= $this->genSessionID();
		$passed 		= false;

		//don't use cookies - due to hosting server limitation
		if (!$sessionHash) {
			$sql = "SELECT userid FROM {$this->_bbDBprefix}session WHERE idhash='{$sessionID}' AND userid > 0 LIMIT 1";
			$this->_bbDB->setQuery($sql);
			$userID = intval($this->_bbDB->loadResult($this->_bbDB));
		} else { //found cookies 
			//is logged in vb session database?
			$sql = "SELECT userid FROM {$this->_bbDBprefix}session WHERE idhash='{$sessionID}' AND userid > 0 AND sessionhash='$sessionHash' LIMIT 1";
			$this->_bbDB->setQuery($sql);
			$userID = intval($this->_bbDB->loadResult($this->_bbDB));
		}

		if ( $userID ) {
			$passed = true;
		}

		// or we go back from cookies?
		if ( $cookiesUserID ) {
			$sql = "SELECT password FROM {$this->_bbDBprefix}user WHERE userid=$cookiesUserID LIMIT 1";
			$this->_bbDB->setQuery($sql);

			$userPwd 		= $this->_bbDB->loadResult($this->_bbDB);
			$userHashPwd 	= md5($userPwd.$this->_bbLicense);

			if ( $cookiesPwd == $userHashPwd ) {
				$passed = true;
				$userID = $cookiesUserID;
			}
		}

		//okay, get joomla info
		if ($passed and $userID) {
			$sql = "SELECT id as userid, username, name, password, email FROM #__users WHERE id=$userID LIMIT 1";
			$jDB->setQuery($sql);
			$jUser = $jDB->loadAssoc();

			if ( !empty($jUser['userid']) ) {
				$this->_userinfo = $jUser;
			}
		}

		return false;
	}



	function autoEngine() {

		$option 	= JRequest::getVar('option');
		$task 		= JRequest::getVar('task');
		$view 		= JRequest::getVar('view');
		$redirect 	= JRequest::getVar('redirect');

		switch ($option) {
			case 'com_user':
				if ( $task == "logout" ) {
					header("Location: {$this->_bbURL}/login.php?do=logout&logouthash=".$this->getLogoutHash()."&redirect=$redirect");
					exit;
				}
				if ( $task == "register" ) {
					header("Location: {$this->_bbURL}/register.php?styleid=".$this->_styleid);
					exit;
				}
				if ( $view == "reset" ) {
					header("Location: {$this->_bbURL}/login.php?do=lostpw&styleid=".$this->_styleid);
					exit;
				}
				if ( $view == "remind" ) {
					header("Location: {$this->_bbURL}/register.php?do=requestemail&styleid=".$this->_styleid);
					exit;
				}
				if ( $task == "activate" or $view == "login" ) {
					header("Location: {$this->_bbURL}/login.php?styleid=".$this->_styleid);
					exit;
				}
				if ( $view == "user" and $task == "edit" ) {
					header("Location: {$this->_bbURL}/profile.php?do=editprofile&styleid=".$this->_styleid);
					exit;
				}
				break;
		}
	}



	/**
	 * get cookies of vb
	 *
	 * @param unknown_type $name
	 * @return unknown
	 */
	function getCookie($name="") {

		if (isset($_COOKIE[$this->_bbCookiePrefix.$name])) {
	    	return urldecode($_COOKIE[$this->_bbCookiePrefix.$name]);
	    }
    	return FALSE;
	}



	/**
	 * Get logout hash from DB
	 * @param Integer $user_id
	 * @return hash String
	 */

	function getLogoutHash () {

		if ( $userID = intval($this->_userinfo['userid']) ) {
			$sql = "SELECT userid, salt FROM ".$this->_bbDBprefix."user WHERE userid=$userID LIMIT 1";
			$this->_bbDB->setQuery($sql);
			$row = $this->_bbDB->loadRow();
			$logouthashRaw = sha1( $row[0] . sha1($row[1]) . sha1($this->_bbLicense) );
			$logouthash = time() . '-' . sha1(time() . $logouthashRaw);

			return $logouthash;
		}
		return "";
	}



	/**
	 * genertate vb session_id or idhash
	 *
	 * @return string sessionID
	 */
	function genSessionID() {

		$alt_ip = $_SERVER['REMOTE_ADDR'];

		if (isset($_SERVER['HTTP_CLIENT_IP'])) {
			$alt_ip = $_SERVER['HTTP_CLIENT_IP'];
		}
		else if (isset($_SERVER['HTTP_X_FORWARDED_FOR']) AND preg_match_all('#\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}#s', $_SERVER['HTTP_X_FORWARDED_FOR'], $matches)) {
			// make sure we dont pick up an internal IP defined by RFC1918
			foreach ($matches[0] AS $ip) {
				if (!preg_match("#^(10|172\.16|192\.168)\.#", $ip))	{
					$alt_ip = $ip;
					break;
				}
			}
		}
		else if (isset($_SERVER['HTTP_FROM'])) {
			$alt_ip = $_SERVER['HTTP_FROM'];
		}

		$length = $this->_ipCheck;
		$fetched_ip = implode('.', array_slice(explode('.', $alt_ip), 0, 4 - $length));
		$sessionID = md5($_SERVER['HTTP_USER_AGENT'] . $fetched_ip);

		return $sessionID;
	}


}

?>