(function($){
  var methods = {
    settings: {},
    slider: false,
    slidesCount: 0,
    autoPlay: function(){
      if(this.settings.direction == 'forward') this.goToNextSlide();
    },
    goToNextSlide: function(){
    // Переход к следующему слайду
      if(Math.abs(this.slider.children('div.slides-wrapper').position().left) > Math.abs(this.settings.slideWidth * this.slidesCount)){
        $("div.slides-wrapper").css("left", -this.settings.slideWidth);
      }
      sliderGoToPosition = this.slider.children('div.slides-wrapper').position().left - this.settings.slideWidth;
      this.slider.find('div.slides-wrapper').delay(this.settings.autoPlayEnable).animate({ left: sliderGoToPosition }, this.settings.duration, function(){
        if(methods.settings.autoPlayEnable > 0) methods.goToNextSlide();
      });
    }
  }

  $.fn.slider = function(options){
    var options = $.extend({
      'duration' : 200,
      'direction': 'forward',
      'slideWidth' : 190,
      'controlLeft': 'a.arrow-left',
      'controlRight': 'a.arrow-right',
      'additionalContent' : false,
      'repeat': false,
      'autoPlayEnable': 2000
    }, options);
    
    methods.settings = options;
    methods.slider = $(this);
    methods.slidesCount = methods.slider.find('div.slides-wrapper > div').size();
    
    $("div.slides-wrapper").prepend($("div.slide:last").clone());
    $("div.slides-wrapper").append($("div.slide").eq(1).clone());
    $("div.slides-wrapper").css('left', -options.slideWidth + 'px');
    if(options.autoPlayEnable > 0) methods.autoPlay();
    return this;
  };
})(jQuery);