<?php
/*======================================================================*\
|| #################################################################### ||
|| # Thumbs Up? v1.9 by Scandal for vBulletin 4.x.x                   # ||
|| #                                                                  # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Scandal @ vBulletin.org                          # ||
|| #                                                                  # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
// ######################## FUNCTIONS ####################################
function add_thumb($contentinfo, $contenttype, $data_id, $thumb)
{
  global $vbulletin;
  if (thumbed_already_check($contentinfo, $contenttype, $data_id)) {
      print_no_permission();
  }
  
  	$vbulletin->db->query_write("
  		INSERT INTO ". TABLE_PREFIX ."sc_thumbs_". $contenttype ."
  			(userid, username, dateline, thumb, $data_id, to_userid)
  		VALUES
  			('" . $vbulletin->userinfo['userid'] . "', 
        '" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "',
         " . TIMENOW . ",
          '" . $thumb . "',
          " . $contentinfo["$data_id"] .",
          " . $contentinfo['userid'] .")
  	");
    
    if ($thumb == 1) {
      $set_query_gave = 'sc_thumbs_up_gave = sc_thumbs_up_gave + 1';
      $set_query_received = 'sc_thumbs_up_received = sc_thumbs_up_received + 1'; 
    }
    else {
      $set_query_gave = 'sc_thumbs_down_gave = sc_thumbs_down_gave + 1';
      $set_query_received = 'sc_thumbs_down_received = sc_thumbs_down_received + 1';    
    }
    
    $vbulletin->db->query_write("
          UPDATE " . TABLE_PREFIX . "user
          SET $set_query_gave
          WHERE userid = ". $vbulletin->userinfo['userid'] ."
              ");
    $vbulletin->db->query_write("
          UPDATE " . TABLE_PREFIX . "user
          SET $set_query_received
          WHERE userid = ". $contentinfo['userid'] ."
              ");              
    ($hook = vBulletinHook::fetch_hook('thumbsup_add_thumb')) ? eval($hook) : false;
  return true;     
}

function remove_thumb($contentinfo, $contenttype, $data_id, $userid)
{
  global $vbulletin;
  if (!(thumbed_already_check($contentinfo, $contenttype, $data_id))) {
      print_no_permission();
  } 
  // get the type of thumb
  $array = $vbulletin->db->query_first("
      	SELECT thumb 
      	FROM ". TABLE_PREFIX ."sc_thumbs_". $contenttype ."
      	WHERE $data_id = $contentinfo[$data_id] AND userid = $userid
      	");
        
    if ($array['thumb'] == 1) {
      $set_query_gave = 'sc_thumbs_up_gave = sc_thumbs_up_gave - 1';
      $set_query_received = 'sc_thumbs_up_received = sc_thumbs_up_received - 1'; 
    }
    else {
      $set_query_gave = 'sc_thumbs_down_gave = sc_thumbs_down_gave - 1';
      $set_query_received = 'sc_thumbs_down_received = sc_thumbs_down_received - 1';    
    }
    
    $vbulletin->db->query_write("
          UPDATE " . TABLE_PREFIX . "user
          SET $set_query_gave
          WHERE userid = $userid
              ");
    $vbulletin->db->query_write("
          UPDATE " . TABLE_PREFIX . "user
          SET $set_query_received
          WHERE userid = ". $contentinfo['userid'] ."
              ");
                  
  // remove thumb           
  $vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."sc_thumbs_". $contenttype ." WHERE $data_id = $contentinfo[$data_id] AND userid = $userid");
  ($hook = vBulletinHook::fetch_hook('thumbsup_remove_thumb')) ? eval($hook) : false;
  return true;
}


// fetch thumbs info
function fetch_thumbs($id = 0, $ids = '', $contenttype, $data_id, $fetch_again = false)
{
	global $vbulletin;
	static $cache, $act;

  if ((!($cache) and !($act)) or ($fetch_again)) {
    $cache = array();
    // if guest, do not load the thumbs (return empty cache)
      if ($vbulletin->userinfo['usergroupid'] == 1) {
        return $cache;
      }
		if (empty($ids))
		{
			$ids[] = $id;
		}
       
    $thumbs = $vbulletin->db->query_read("SELECT * FROM " .TABLE_PREFIX. "sc_thumbs_". $contenttype ." WHERE $data_id IN (" . implode(',', $ids) . ") ORDER BY username ASC");
  		while ($thumb = $vbulletin->db->fetch_array($thumbs)) {
  			$cache[$thumb["$data_id"]][$thumb['userid']]['userid'] = $thumb['userid'];  
  			$cache[$thumb["$data_id"]][$thumb['userid']]['username'] = $thumb['username'];
  			$cache[$thumb["$data_id"]][$thumb['userid']]['dateline'] = $thumb['dateline'];
  			$cache[$thumb["$data_id"]][$thumb['userid']]["$data_id"] = $thumb["$data_id"];
        $cache[$thumb["$data_id"]][$thumb['userid']]['thumb'] = $thumb['thumb'];
        $cache[$thumb["$data_id"]][$thumb['userid']]['unread'] = $thumb['unread'];
  		}     
  }
  
	$act = true;
	return $cache[$id];
}

// build the list of users who give thumbs
function fetch_thumbers_bit($thumbs)
{
	global $vbulletin;

	$number_rows = count($thumbs);
  $list['users_minus_num'] = 0;
  $list['users_plus_num'] = 0;
	if ($number_rows > 0) {
		foreach ($thumbs AS $thumb) {
        if ($thumb['thumb'] == 1) {
        $templater = vB_Template::create('sc_thumbs_box_bit');
          $templater->register('thumb', $thumb);
        $list['users_plus'] .= $templater->render();   
         $list['users_plus_num'] = $list['users_plus_num'] + 1;    
        }
        elseif ($thumb['thumb'] == -1) {
        $templater = vB_Template::create('sc_thumbs_box_bit');
          $templater->register('thumb', $thumb);
        $list['users_minus'] .= $templater->render();      
         $list['users_minus_num'] = $list['users_minus_num'] + 1;
		    }
      }
    }

	return $list;
}

// Check if the input thumb is correct
function thumb_validation($thumb)
{
  global $vbulletin;
  if ($thumb == 1 OR ($thumb == -1 and $vbulletin->options['sc_thumbs_minus'])) {
   return true;
  }
  else {
   print_no_permission();
  }
}
// check if already thumbed and return an array with info
function thumbed_already_check($contentinfo, $contenttype, $data_id, $userid = 0, $fetch_again = false)
{
	global $vbulletin;
	$array = fetch_thumbs($contentinfo[$data_id], '', $contenttype, $data_id, $fetch_again);
	$userid != 0 ? $userid = $userid : $userid = $vbulletin->userinfo['userid'];

	if ($array[$userid]['thumb'] == 1) {
		$type['positive'] = true;
	}
  elseif ($array[$userid]['thumb'] == -1) {
    $type['negative'] = true;
  }
  else {
    return false;
  }
  
	return $type;
}

function notify_user($contentuserid)
{
  global $vbulletin;
  if ($vbulletin->options['sc_thumbs_notifications']) {
    $check = $vbulletin->db->query_first("
          SELECT sc_thumbs_notifact
          FROM " . TABLE_PREFIX . "user
          WHERE userid = ". $contentuserid ."
          ");  

    $self = $vbulletin->userinfo['userid'];
       if($check['sc_thumbs_notifact'] AND $self != $contentuserid){   
        $vbulletin->db->query_write("
              UPDATE " . TABLE_PREFIX . "user
              SET sc_thumbs_notifcnt = sc_thumbs_notifcnt + 1
              WHERE userid = ". $contentuserid ."
              ");
        ($hook = vBulletinHook::fetch_hook('thumbsup_notify_user')) ? eval($hook) : false;      
          }
  
  }
}

function un_notify_user($contentuserid)
{
  global $vbulletin;
  if ($vbulletin->options['sc_thumbs_notifications']) {
    $check = $vbulletin->db->query_first("
          SELECT sc_thumbs_notifact, sc_thumbs_notifcnt
          FROM " . TABLE_PREFIX . "user
          WHERE userid = ". $contentuserid ."
          "); 

    $self = $vbulletin->userinfo['userid']; 
       if($check['sc_thumbs_notifact'] AND $self != $contentuserid AND $check['sc_thumbs_notifcnt'] > 0){   
        $vbulletin->db->query_write("
              UPDATE " . TABLE_PREFIX . "user
              SET sc_thumbs_notifcnt = sc_thumbs_notifcnt - 1
              WHERE userid = ". $contentuserid ."
              ");
        ($hook = vBulletinHook::fetch_hook('thumbsup_un_notify_user')) ? eval($hook) : false;      
          }
  
  }
}
         
function can_thumb_check($contentinfo, $contenttype, $nopermission = false, $firstpostid = 0, $forumid = 0)
{
  global $vbulletin;
  
  // used for "only first post" function check
  if (isset($contentinfo['postid'])) {
    $data_id = 'postid';
  }
  else {
    $data_id = 'gmid';
  }
  
	if (!($vbulletin->userinfo['userid'] == 0 || is_a_banned_forum($forumid) || $contentinfo['isdeleted'] || is_in_banned_usergroup() || is_in_banned_list() || !limitation_per_day_check($contenttype) || !$vbulletin->options["sc_thumbs_option_$contenttype"] || (!($vbulletin->options['sc_thumbs_can_thumb_self']) && $contentinfo['userid'] == $vbulletin->userinfo['userid']) || ($vbulletin->options['sc_thumbs_only_first'] and !($contentinfo["$data_id"] == $firstpostid)))) {
		return true;
	}
     
  if ($nopermission) {
    print_no_permission();
  }
  else { 
    return false;
  }  
  
}

function limitation_per_day_check($contenttype)
{
  global $vbulletin;
  if ($vbulletin->options['sc_thumbs_max_per_day']) {
  		global $thumbs_today;
  
  		if ($thumbs_today === null)
  		{
  			$thumbs_today = $vbulletin->db->query_first("
                              SELECT COUNT(id) AS total 
                              FROM " .TABLE_PREFIX. "sc_thumbs_". $contenttype ."
                              WHERE userid = " . $vbulletin->userinfo['userid'] . "
                                  AND dateline > " . (TIMENOW - (60 * 60 * 24)) . "
                                ");
  		}
  
  		if ($vbulletin->options['sc_thumbs_max_per_day'] <= $thumbs_today['total'])
  		{
  			return false;
  		}
      
        
  }
  return true;
}

function is_in_banned_usergroup() 
{
  global $vbulletin;
	$banned_groups = explode(',',$vbulletin->options['sc_thumbs_banned_groups']);
  	if(in_array($vbulletin->userinfo['usergroupid'], $banned_groups)) {
  		return true;
  	}
  	else {
  		return false;
  	}
}

function is_in_banned_list() 
{
  global $vbulletin;
	$banned_userids = explode(',',$vbulletin->options['sc_thumbs_banned_userids']);
  	if(in_array($vbulletin->userinfo['userid'], $banned_userids)) {
  		return true;
  	}
  	else {
  		return false;
  	}
}

function is_a_banned_forum($forumid) 
{
  global $vbulletin; 
  if (!$forumid) {
    return false;
  }                   
	$banned_forumids = explode(',',$vbulletin->options['sc_thumbs_banned_forumids']);
  	if(in_array($forumid, $banned_forumids)) {
  		return true;
  	}
  	else {
  		return false;
  	}
}

function sc_fetch_picturecommentinfo($contentid)
{
  global $vbulletin;
    $info = $vbulletin->db->query_first("
          SELECT picturecomment.commentid, picturecomment.postuserid AS userid, picturecomment.filedataid AS pictureid, picturelegacy.primaryid AS albumid
          FROM " . TABLE_PREFIX . "picturecomment AS picturecomment
          LEFT JOIN " . TABLE_PREFIX . "picturelegacy AS picturelegacy ON (picturelegacy.attachmentid = picturecomment.filedataid)
          WHERE commentid = ". $contentid ."
          ");
  return $info;           
}

function sc_fetch_postinfo($contentid)
{
  global $vbulletin;
    $info = $vbulletin->db->query_first("
          SELECT postid, userid
          FROM " . TABLE_PREFIX . "post
          WHERE postid = ". $contentid ."
          ");
  return $info; 
} 

function sc_fetch_groupmessageinfo($contentid)
{
  global $vbulletin;
    $info = $vbulletin->db->query_first("
          SELECT groupmessage.gmid, groupmessage.postuserid AS userid, discussion.firstpostid 
          FROM " . TABLE_PREFIX . "groupmessage AS groupmessage
          LEFT JOIN " . TABLE_PREFIX . "discussion AS discussion USING (discussionid)
          WHERE gmid = ". $contentid ."
          ");
  return $info; 
}

function sc_fetch_visitormessageinfo($contentid)
{
  global $vbulletin;
    $info = $vbulletin->db->query_first("
          SELECT vmid, postuserid AS userid, userid AS profileid
          FROM " . TABLE_PREFIX . "visitormessage
          WHERE vmid = ". $contentid ."
          ");
  return $info; 
}

function sc_fetch_pictureinfo($contentid)
{
  global $vbulletin;
    $info = $vbulletin->db->query_first("
          SELECT attachment.attachmentid AS pictureid, attachment.userid AS userid, picturelegacy.primaryid AS albumid
          FROM " . TABLE_PREFIX . "attachment AS attachment
          LEFT JOIN " . TABLE_PREFIX . "picturelegacy AS picturelegacy USING (attachmentid)
          WHERE attachmentid = ". $contentid ."
          ");
  return $info;           
}

function sc_fetch_threadinfo($contentid)
{
  global $vbulletin;
    $info = $vbulletin->db->query_first("
          SELECT threadid, firstpostid, forumid
          FROM " . TABLE_PREFIX . "thread
          LEFT JOIN " . TABLE_PREFIX . "post AS post USING (threadid)
          WHERE postid = ". $contentid ."
          ");
  return $info; 
} 

function sc_fetch_nodeinfo($contentid)
{
  global $vbulletin;
    $info = $vbulletin->db->query_first("
          SELECT nodeid, userid
          FROM " . TABLE_PREFIX . "cms_node
          WHERE nodeid = ". $contentid ."
          ");
  return $info; 
} 

function sc_fetch_blogentryinfo($contentid)
{
  global $vbulletin;
    $info = $vbulletin->db->query_first("
          SELECT firstblogtextid AS blogtextid, userid
          FROM " . TABLE_PREFIX . "blog
          WHERE firstblogtextid = ". $contentid ."
          ");
  return $info; 
} 

function sc_fetch_blogcommentinfo($contentid)
{
  global $vbulletin;
    $info = $vbulletin->db->query_first("
          SELECT blogtextid, userid, blogid
          FROM " . TABLE_PREFIX . "blog_text
          WHERE blogtextid = ". $contentid ."
          ");
  return $info; 
} 

function delete_all_thumbs($contentinfo, $contenttype, $data_id)
{
	global $vbulletin;

	$thumbs = $vbulletin->db->query_read("SELECT * FROM " .TABLE_PREFIX. "sc_thumbs_". $contenttype ." WHERE $data_id = $contentinfo[$data_id] ORDER BY username");
	$rows = $vbulletin->db->num_rows($thumbs);
    
	if ($rows != 0)
	{
    // refresh of thumbs received/gave for user
          while ($thumb = $vbulletin->db->fetch_array($thumbs)) {
            if ($thumb['thumb'] == 1) {
              $set_query_gave = 'sc_thumbs_up_gave = sc_thumbs_up_gave - 1';
              $set_query_received = 'sc_thumbs_up_received = sc_thumbs_up_received - 1'; 
            }
            else {
              $set_query_gave = 'sc_thumbs_down_gave = sc_thumbs_down_gave - 1';
              $set_query_received = 'sc_thumbs_down_received = sc_thumbs_down_received - 1';    
            }
            
              $vbulletin->db->query_write("
                    UPDATE " . TABLE_PREFIX . "user
                    SET $set_query_gave
                    WHERE userid = ". $thumb['userid'] ."
                        ");
      
              $vbulletin->db->query_write("
                    UPDATE " . TABLE_PREFIX . "user
                    SET $set_query_received
                    WHERE userid = ". $thumb['to_userid'] ."
                        "); 
          } 
         
		 $vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."sc_thumbs_". $contenttype ." WHERE $data_id = $contentinfo[$data_id]");
     ($hook = vBulletinHook::fetch_hook('thumbsup_delete_all_thumbs')) ? eval($hook) : false; 
  }  
}

// after running this function (=when admin deletes a user or deletes user's ALL thumbs) you may run the recounters
function admin_delete_all_users_thumbs($contenttype, $userid) 
{
  global $vbulletin;
  ($hook = vBulletinHook::fetch_hook('thumbsup_admin_delete_all_users_thumbs')) ? eval($hook) : false;
  $vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."sc_thumbs_". $contenttype ." WHERE userid = $userid");
}

function admin_delete_all_contents_thumbs($contenttype, $contentid, $data_id) 
{
  global $vbulletin;
	$thumbs = $vbulletin->db->query_read("SELECT * FROM " .TABLE_PREFIX. "sc_thumbs_". $contenttype ." WHERE $data_id = $contentid ORDER BY username");
	$rows = $vbulletin->db->num_rows($thumbs);
	
  if ($rows != 0)
	{
    // refresh of thumbs received/gave for user
          while ($thumb = $vbulletin->db->fetch_array($thumbs)) {
            if ($thumb['thumb'] == 1) {
              $set_query_gave = 'sc_thumbs_up_gave = sc_thumbs_up_gave - 1';
              $set_query_received = 'sc_thumbs_up_received = sc_thumbs_up_received - 1'; 
            }
            else {
              $set_query_gave = 'sc_thumbs_down_gave = sc_thumbs_down_gave - 1';
              $set_query_received = 'sc_thumbs_down_received = sc_thumbs_down_received - 1';    
            }
            
              $vbulletin->db->query_write("
                    UPDATE " . TABLE_PREFIX . "user
                    SET $set_query_gave
                    WHERE userid = ". $thumb['userid'] ."
                        ");
      
              $vbulletin->db->query_write("
                    UPDATE " . TABLE_PREFIX . "user
                    SET $set_query_received
                    WHERE userid = ". $thumb['to_userid'] ."
                        "); 
          }
       $vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."sc_thumbs_". $contenttype ." WHERE $data_id = $contentid");
       ($hook = vBulletinHook::fetch_hook('thumbsup_admin_delete_all_contents_thumbs')) ? eval($hook) : false;    
   }        
    
}
?>
