<?php  
/*======================================================================*\
|| #################################################################### ||
|| # Thumbs Up? v1.9 by Scandal for vBulletin 4.x.x                   # ||
|| #                                                                  # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Scandal @ vBulletin.org                          # ||
|| #                                                                  # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'sc_thumbs_center');
define('CSRF_PROTECTION', true);  

// #################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array(); 

// pre-cache templates used by all actions
$globaltemplates = array(
	'sc_thumbs_navbar',
  'sc_thumbs_LATEST_RECEIVED_PAGE',
  'sc_thumbs_latest_bit'
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'gave' => array(
	'sc_thumbs_LATEST_GAVE_PAGE'
	),
	'stats' => array(
	'sc_thumbs_STATS_PAGE',
  'sc_thumbs_stats_bit'
	),
	'top' => array(
	'sc_thumbs_TOP_PAGE',
  'sc_thumbs_top_bit'
	),  
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php'); 

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if ($show['guest'])
{
	print_no_permission();
}
      
// Check ON/OFF field
if (!$vbulletin->options['sc_thumbs_onoff'])
{ 
  print_no_permission();  
}
  
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'received';
}
	
// ##################### LATEST THUMBS RECEIVED PAGE ###########################
if ($_REQUEST['do'] == 'received')
{ 

// Set notifications counter to 0
    $db->query_write("
      UPDATE " . TABLE_PREFIX . "user
      SET sc_thumbs_notifcnt = 0
      WHERE userid = ". $vbulletin->userinfo['userid'] ."
      ");
        
////////// fetch user thumbs received
$limit = $vbulletin->options['sc_thumbs_center_recent_number'];
$thumbsup_usernames_show = $vbulletin->options['sc_thumbs_plus_show'];
$thumbsdown_usernames_show = $vbulletin->options['sc_thumbs_minus_show'];
$viewtype = $vbulletin->input->clean_gpc('r', 'viewtype', TYPE_STR);  
$do = 'received';

switch ($viewtype) {
case "": 
        // fetch for POSTS
          if ($vbulletin->options['sc_thumbs_option_post']) {
              	$thumbs_posts_query = $db->query_read("
              		SELECT sc_thumbs_post.*, thread.title
              		FROM " . TABLE_PREFIX . "sc_thumbs_post AS sc_thumbs_post
                  LEFT JOIN " . TABLE_PREFIX . "post AS post USING (postid)
                  LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (thread.threadid = post.threadid)
              		WHERE post.userid = ". $vbulletin->userinfo['userid'] ."
              		ORDER BY sc_thumbs_post.dateline DESC
              		LIMIT $limit
              	");
                
                $count = 1;
                while ($post = $db->fetch_array($thumbs_posts_query)) {
                  $content['contenttype'] = 'post';
                  $content['contentid'] = $post['postid'];
                  $content['title'] = $post['title'];
                  $content['userid'] = $post['userid'];
                  $content['username'] = $post['username'];
                  $content['thumb'] = $post['thumb'];
                  $content['unread'] = $post['unread'];         
                  $content['date'] = vbdate("d-m-Y - H:i", $post['dateline']);
                  $thumb_ids[] = $post['id'];
                 
                  if (($content['thumb'] == 1 and $thumbsup_usernames_show) OR $vbulletin->userinfo['usergroupid'] == '6') {
                    $content['show_username'] = true;
                  }
                  elseif (($content['thumb'] == -1 and $thumbsdown_usernames_show) OR $vbulletin->userinfo['usergroupid'] == '6') {
                    $content['show_username'] = true;
                  }
                  
                    $templater = vB_Template::create('sc_thumbs_latest_bit');
                     $templater->register('count', $count);
                     $templater->register('content', $content);
                    $received_bits .= $templater->render();                  
                  unset($content);
                  $count++;            
                }
                
                // set all as read
               if($thumb_ids) {
                $db->query_write("
                  UPDATE " . TABLE_PREFIX . "sc_thumbs_post
                  SET unread = 0
                  WHERE id IN (" . implode(',', $thumb_ids) . ")
                  ");
               }              
                $db->free_result($thumbs_posts_query);
                unset($thumb_ids);                        
          }
        break;               
case "groupmessage":
        // fetch for SOCIAL GROUP MESSAGES  
          if ($vbulletin->options['sc_thumbs_option_groupmessage']) {
              	$thumbs_groupmessages_query = $db->query_read("
              		SELECT sc_thumbs_groupmessage.*, groupmessage.gmid, groupmessage.discussionid
              		FROM " . TABLE_PREFIX . "sc_thumbs_groupmessage AS sc_thumbs_groupmessage
                  LEFT JOIN " . TABLE_PREFIX . "groupmessage AS groupmessage USING (gmid)
              		WHERE groupmessage.postuserid = ". $vbulletin->userinfo['userid'] ."
              		ORDER BY sc_thumbs_groupmessage.dateline DESC
              		LIMIT $limit
              	");
                
                $count = 1;
                while ($groupmessage = $db->fetch_array($thumbs_groupmessages_query)) {
              		$title_q = $vbulletin->db->query_first("
              				SELECT groupmessage.title AS discussiontitle
              				FROM " . TABLE_PREFIX . "groupmessage as groupmessage
              				LEFT JOIN " . TABLE_PREFIX . "discussion AS discussion 
              					ON (discussion.firstpostid = groupmessage.gmid)
              				WHERE groupmessage.discussionid = " . $groupmessage['discussionid'] ."
              			");         
                  $content['contenttype'] = 'groupmessage';
                  $content['contentid'] = $groupmessage['gmid'];
                  $content['title'] = $title_q['discussiontitle'];
                  $content['userid'] = $groupmessage['userid'];
                  $content['username'] = $groupmessage['username'];
                  $content['thumb'] = $groupmessage['thumb'];
                  $content['unread'] = $groupmessage['unread'];
                  $content['date'] = vbdate("d-m-Y - H:i", $groupmessage['dateline']);
                  $thumb_ids[] = $groupmessage['id'];
                  
                  if (($content['thumb'] == 1 and $thumbsup_usernames_show) OR $vbulletin->userinfo['usergroupid'] == '6') {
                    $content['show_username'] = true;
                  }
                  elseif (($content['thumb'] == -1 and $thumbsdown_usernames_show) OR $vbulletin->userinfo['usergroupid'] == '6') {
                    $content['show_username'] = true;
                  }
                          
                    $templater = vB_Template::create('sc_thumbs_latest_bit');
                     $templater->register('count', $count);
                     $templater->register('content', $content);
                    $received_bits .= $templater->render();  
                  unset($content);
                  $count++;
                }
                
                // set all as read
              if($thumb_ids) {
                $db->query_write("
                  UPDATE " . TABLE_PREFIX . "sc_thumbs_groupmessage
                  SET unread = 0
                  WHERE id IN (" . implode(',', $thumb_ids) . ")
                  ");
               }            
                $db->free_result($thumbs_groupmessages_query);        
                unset($thumb_ids);
          }
          break;
case "visitormessage":
        // fetch for PROFILE VISITOR MESSAGES
          if ($vbulletin->options['sc_thumbs_option_visitormessage']) {
              	$thumbs_visitormessages_query = $db->query_read("
              		SELECT sc_thumbs_visitormessage.*, visitormessage.pagetext, visitormessage.userid AS profileid
              		FROM " . TABLE_PREFIX . "sc_thumbs_visitormessage AS sc_thumbs_visitormessage
                  LEFT JOIN " . TABLE_PREFIX . "visitormessage AS visitormessage USING (vmid)
              		WHERE visitormessage.postuserid = ". $vbulletin->userinfo['userid'] ."
              		ORDER BY sc_thumbs_visitormessage.dateline DESC
              		LIMIT $limit
              	");
                
                $count = 1;
                while ($visitormessage = $db->fetch_array($thumbs_visitormessages_query)) {
                  $content['contenttype'] = 'visitormessage';
                  $content['contentid'] = $visitormessage['vmid'];
                  $content['profileid'] = $visitormessage['profileid'];
                  $content['title'] = substr($visitormessage['pagetext'], 0, 60) . '...';
                  $content['userid'] = $visitormessage['userid'];
                  $content['username'] = $visitormessage['username'];
                  $content['thumb'] = $visitormessage['thumb'];
                  $content['unread'] = $visitormessage['unread'];         
                  $content['date'] = vbdate("d-m-Y - H:i", $visitormessage['dateline']);
                  $thumb_ids[] = $visitormessage['id'];
                  
                  if (($content['thumb'] == 1 and $thumbsup_usernames_show) OR $vbulletin->userinfo['usergroupid'] == '6') {
                    $content['show_username'] = true;
                  }
                  elseif (($content['thumb'] == -1 and $thumbsdown_usernames_show) OR $vbulletin->userinfo['usergroupid'] == '6') {
                    $content['show_username'] = true;
                  } 
                          
                    $templater = vB_Template::create('sc_thumbs_latest_bit');
                     $templater->register('count', $count);
                     $templater->register('content', $content);
                    $received_bits .= $templater->render();  
                  unset($content);
                  $count++;            
                }
                
                // set all as read
               if($thumb_ids) {
                $db->query_write("
                  UPDATE " . TABLE_PREFIX . "sc_thumbs_visitormessage
                  SET unread = 0
                  WHERE id IN (" . implode(',', $thumb_ids) . ")
                  ");
                }             
                $db->free_result($thumbs_visitormessages_query);
                unset($thumb_ids);                        
          }
          break;
case "picturecomment":
        // fetch for PICTURE COMMENTS
          if ($vbulletin->options['sc_thumbs_option_picturecomment']) {
              	$thumbs_picturecomments_query = $db->query_read("
              		SELECT sc_thumbs_picturecomment.*, picturecomment.pagetext, attachment.attachmentid, album.albumid
              		FROM " . TABLE_PREFIX . "sc_thumbs_picturecomment AS sc_thumbs_picturecomment
                  LEFT JOIN " . TABLE_PREFIX . "picturecomment AS picturecomment USING(commentid)
		              LEFT JOIN " . TABLE_PREFIX . "attachment AS attachment ON(attachment.filedataid = picturecomment.filedataid)		 
		              LEFT JOIN " . TABLE_PREFIX . "album AS album ON(attachment.contentid = album.albumid)                  
              		WHERE picturecomment.postuserid = ". $vbulletin->userinfo['userid'] ."
              		ORDER BY sc_thumbs_picturecomment.dateline DESC
              		LIMIT $limit
              	");
                
                $count = 1;
                while ($picturecomment = $db->fetch_array($thumbs_picturecomments_query)) {
                  $content['contenttype'] = 'picturecomment';
                  $content['contentid'] = $picturecomment['commentid'];
                  $content['albumid'] = $picturecomment['albumid'];
                  $content['pictureid'] = $picturecomment['attachmentid'];
                  $content['title'] = substr($picturecomment['pagetext'], 0, 60) . '...';
                  $content['userid'] = $picturecomment['userid'];
                  $content['username'] = $picturecomment['username'];
                  $content['thumb'] = $picturecomment['thumb'];
                  $content['unread'] = $picturecomment['unread'];         
                  $content['date'] = vbdate("d-m-Y - H:i", $picturecomment['dateline']);
                  $thumb_ids[] = $picturecomment['id'];
                  
                  if (($content['thumb'] == 1 and $thumbsup_usernames_show) OR $vbulletin->userinfo['usergroupid'] == '6') {
                    $content['show_username'] = true;
                  }
                  elseif (($content['thumb'] == -1 and $thumbsdown_usernames_show) OR $vbulletin->userinfo['usergroupid'] == '6') {
                    $content['show_username'] = true;
                  }
                           
                    $templater = vB_Template::create('sc_thumbs_latest_bit');
                     $templater->register('count', $count);
                     $templater->register('content', $content);
                     $received_bits .= $templater->render();
                  unset($content);
                  $count++;            
                }
                
                // set all as read
               if($thumb_ids) {
                $db->query_write("
                  UPDATE " . TABLE_PREFIX . "sc_thumbs_picturecomment
                  SET unread = 0
                  WHERE id IN (" . implode(',', $thumb_ids) . ")
                  ");
                }             
                $db->free_result($thumbs_picturecomments_query);
                unset($thumb_ids);                        
          }
          break;

case "picture":
        // fetch for PICTURE
          if ($vbulletin->options['sc_thumbs_option_picture']) {
              	$thumbs_picture_query = $db->query_read("
              		SELECT sc_thumbs_picture.*, attachment.caption, album.albumid
              		FROM " . TABLE_PREFIX . "sc_thumbs_picture AS sc_thumbs_picture
                  LEFT JOIN " . TABLE_PREFIX . "attachment AS attachment ON (attachment.attachmentid = sc_thumbs_picture.pictureid)
                  LEFT JOIN " . TABLE_PREFIX . "album AS album ON(attachment.contentid = album.albumid)
              		WHERE attachment.userid = ". $vbulletin->userinfo['userid'] ."
              		ORDER BY sc_thumbs_picture.dateline DESC
              		LIMIT $limit
              	");
                
                $count = 1;
                while ($picture = $db->fetch_array($thumbs_picture_query)) {
                  $content['contenttype'] = 'picture';
                  $content['contentid'] = $picture['pictureid'];
                  $content['albumid'] = $picture['albumid'];
                  $content['title'] = $picture['caption'];
                  $content['userid'] = $picture['userid'];
                  $content['username'] = $picture['username'];
                  $content['thumb'] = $picture['thumb'];
                  $content['unread'] = $picture['unread'];         
                  $content['date'] = vbdate("d-m-Y - H:i", $picture['dateline']);
                  $thumb_ids[] = $picture['id'];
                 
                  if ($content['title'] == '') {$content['title'] = $vbphrase['sc_thumbs_notitle'];}
                  
                  if (($content['thumb'] == 1 and $thumbsup_usernames_show) OR $vbulletin->userinfo['usergroupid'] == '6') {
                    $content['show_username'] = true;
                  }
                  elseif (($content['thumb'] == -1 and $thumbsdown_usernames_show) OR $vbulletin->userinfo['usergroupid'] == '6') {
                    $content['show_username'] = true;
                  }  
                         
                    $templater = vB_Template::create('sc_thumbs_latest_bit');
                     $templater->register('count', $count);
                     $templater->register('content', $content);
                     $received_bits .= $templater->render();
                  unset($content);
                  $count++;            
                }    
                
                // set all as read
               if($thumb_ids) {
                $db->query_write("
                  UPDATE " . TABLE_PREFIX . "sc_thumbs_picture
                  SET unread = 0
                  WHERE id IN (" . implode(',', $thumb_ids) . ")
                  ");
                }             
                $db->free_result($thumbs_picture_query);
                unset($thumb_ids);                        
          } 
          break;
          
case "node":
        // fetch for vBCMS ARTICLES
          if ($vbulletin->options['sc_thumbs_option_node']) {
              	$thumbs_node_query = $db->query_read("
              		SELECT sc_thumbs_node.*, cms_nodeinfo.nodeid, cms_nodeinfo.title
              		FROM " . TABLE_PREFIX . "sc_thumbs_node AS sc_thumbs_node
                  LEFT JOIN " . TABLE_PREFIX . "cms_nodeinfo AS cms_nodeinfo ON (cms_nodeinfo.nodeid = sc_thumbs_node.nodeid)
                  LEFT JOIN " . TABLE_PREFIX . "cms_node AS cms_node ON (cms_node.nodeid = cms_nodeinfo.nodeid)
              		WHERE cms_node.userid = ". $vbulletin->userinfo['userid'] ."
              		ORDER BY sc_thumbs_node.dateline DESC
              		LIMIT $limit
              	");
                
                $count = 1;
                while ($article = $db->fetch_array($thumbs_node_query)) {
                  $content['contenttype'] = 'node';
                  $content['contentid'] = $article['nodeid'];
                  $content['userid'] = $article['userid'];
                  $content['username'] = $article['username'];
                  $content['thumb'] = $article['thumb'];
                  $content['unread'] = $article['unread'];         
                  $content['date'] = vbdate("d-m-Y - H:i", $article['dateline']);
                  $content['title'] = $article['title']; 
                  $thumb_ids[] = $article['id'];
                  
                  if (($content['thumb'] == 1 and $thumbsup_usernames_show) OR $vbulletin->userinfo['usergroupid'] == '6') {
                    $content['show_username'] = true;
                  }
                  elseif (($content['thumb'] == -1 and $thumbsdown_usernames_show) OR $vbulletin->userinfo['usergroupid'] == '6') {
                    $content['show_username'] = true;
                  }  
                         
                    $templater = vB_Template::create('sc_thumbs_latest_bit');
                     $templater->register('count', $count);
                     $templater->register('content', $content);
                     $received_bits .= $templater->render();
                  unset($content);
                  $count++;            
                }    
                
                // set all as read
               if($thumb_ids) {
                $db->query_write("
                  UPDATE " . TABLE_PREFIX . "sc_thumbs_node
                  SET unread = 0
                  WHERE id IN (" . implode(',', $thumb_ids) . ")
                  ");
                }             
                $db->free_result($thumbs_node_query);
                unset($thumb_ids);                        
          } 
          break;
case "blog":   
        // fetch for BLOG ENTRIES AND COMMENTS
          if ($vbulletin->options['sc_thumbs_option_blog']) {
              	$thumbs_blog_query = $db->query_read("
              		SELECT sc_thumbs_blog.*, blog_text.title, blog_text.pagetext, blog_text.blogid, blog_text.blogtextid
              		FROM " . TABLE_PREFIX . "sc_thumbs_blog AS sc_thumbs_blog
                  LEFT JOIN " . TABLE_PREFIX . "blog_text AS blog_text USING (blogtextid)
              		WHERE blog_text.userid = ". $vbulletin->userinfo['userid'] ."
              		ORDER BY blog_text.dateline DESC
              		LIMIT $limit
              	");
                
                $count = 1;
                while ($blog = $db->fetch_array($thumbs_blog_query)) {
                  $content['contenttype'] = 'blog';                                    
                  if ($blog['title'] == '') {$content['title'] = substr($blog['pagetext'], 0, 60) . '...';}else {$content['title'] = $blog['title'];}
                  $content['contentid'] = $blog['blogtextid'];
                  $content['blogid'] = $blog['blogid'];
                  $content['userid'] = $blog['userid'];
                  $content['username'] = $blog['username'];
                  $content['thumb'] = $blog['thumb'];
                  $content['unread'] = $blog['unread'];         
                  $content['date'] = vbdate("d-m-Y - H:i", $blog['dateline']);
                  $thumb_ids[] = $blog['id'];
                  
                  if (($content['thumb'] == 1 and $thumbsup_usernames_show) OR $vbulletin->userinfo['usergroupid'] == '6') {
                    $content['show_username'] = true;
                  }
                  elseif (($content['thumb'] == -1 and $thumbsdown_usernames_show) OR $vbulletin->userinfo['usergroupid'] == '6') {
                    $content['show_username'] = true;
                  } 
                          
                    $templater = vB_Template::create('sc_thumbs_latest_bit');
                     $templater->register('count', $count);
                     $templater->register('content', $content);
                    $received_bits .= $templater->render();  
                  unset($content);
                  $count++;            
                }
                
                // set all as read
               if($thumb_ids) {
                $db->query_write("
                  UPDATE " . TABLE_PREFIX . "sc_thumbs_blog
                  SET unread = 0
                  WHERE id IN (" . implode(',', $thumb_ids) . ")
                  ");
                }             
                $db->free_result($thumbs_blog_query);
                unset($thumb_ids);                        
          }
          break;                    
}  
//////////////// navbar and output
	$navbits = construct_navbits(array(
		'' => $vbphrase['sc_thumbs_center_title']
	));
	$navbar = render_navbar_template($navbits);

/////////// build the thumbs up? Center navbar
   $templater = vB_Template::create('sc_thumbs_navbar');
    $templater->register('do', $do);
   $sc_thumbs_navbar = $templater->render();  

/// fetch stats "received"
    $received = $db->query_first("
      		SELECT sc_thumbs_up_received AS thumbsup, sc_thumbs_down_received AS thumbsdown 
      		FROM " . TABLE_PREFIX . "user AS user
      		WHERE userid = ". $vbulletin->userinfo['userid'] ."
      	");
        
    $received['total'] = $received['thumbsup'] + $received['thumbsdown'];
       
///////////////// extract LATEST THUMBS RECEIVED
	$templater = vB_Template::create('sc_thumbs_LATEST_RECEIVED_PAGE');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
    $templater->register('viewtype', $viewtype);
    $templater->register('sc_thumbs_navbar', $sc_thumbs_navbar); 
    $templater->register('received', $received);
    $templater->register('received_bits', $received_bits);
  print_output($templater->render());  
}



// ######################### LATEST THUMBS SENT PAGE #################################
if ($_REQUEST['do'] == 'gave')
{
////////// fetch user thumbs received
$limit = $vbulletin->options['sc_thumbs_center_recent_number'];
$content['show_username'] = true;
$viewtype = $vbulletin->input->clean_gpc('r', 'viewtype', TYPE_STR);  
$do = 'gave';

switch ($viewtype) {
case "":
        // fetch for POSTS
          if ($vbulletin->options['sc_thumbs_option_post']) {
              	$thumbs_posts_query = $db->query_read("
              		SELECT sc_thumbs_post.*, thread.title, post.userid AS postuserid, post.username AS postusername
              		FROM " . TABLE_PREFIX . "sc_thumbs_post AS sc_thumbs_post
                  LEFT JOIN " . TABLE_PREFIX . "post AS post USING (postid)
                  LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (thread.threadid = post.threadid)
              		WHERE sc_thumbs_post.userid = ". $vbulletin->userinfo['userid'] ."
              		ORDER BY sc_thumbs_post.dateline DESC
              		LIMIT $limit
              	");
                
                $count = 1;
                while ($post = $db->fetch_array($thumbs_posts_query)) {
                  $content['contenttype'] = 'post';
                  $content['contentid'] = $post['postid'];
                  $content['title'] = $post['title'];
                  $content['userid'] = $post['postuserid'];
                  $content['username'] = $post['postusername'];
                  $content['thumb'] = $post['thumb'];         
                  $content['date'] = vbdate("d-m-Y - H:i", $post['dateline']);
                  
                    $templater = vB_Template::create('sc_thumbs_latest_bit');
                    $templater->register('count', $count);
                    $templater->register('content', $content);
                    $gave_bits .= $templater->render(); 
                  $count++;            
                }
                             
                $db->free_result($thumbs_posts_query);
                              
          }
          break;
case "groupmessage":
        // fetch for SOCIAL GROUP MESSAGES  
          if ($vbulletin->options['sc_thumbs_option_groupmessage']) {
              	$thumbs_groupmessages_query = $db->query_read("
              		SELECT sc_thumbs_groupmessage.*, groupmessage.gmid, groupmessage.discussionid, groupmessage.postusername, groupmessage.postuserid
              		FROM " . TABLE_PREFIX . "sc_thumbs_groupmessage AS sc_thumbs_groupmessage
                  LEFT JOIN " . TABLE_PREFIX . "groupmessage AS groupmessage USING (gmid)
              		WHERE sc_thumbs_groupmessage.userid = ". $vbulletin->userinfo['userid'] ."
              		ORDER BY sc_thumbs_groupmessage.dateline DESC
              		LIMIT $limit
              	");
                
                $count = 1;
                while ($groupmessage = $db->fetch_array($thumbs_groupmessages_query)) {
              		$title_q = $vbulletin->db->query_first("
              				SELECT groupmessage.title AS discussiontitle
              				FROM " . TABLE_PREFIX . "groupmessage as groupmessage
              				LEFT JOIN " . TABLE_PREFIX . "discussion AS discussion 
              					ON (discussion.firstpostid = groupmessage.gmid)
              				WHERE groupmessage.discussionid = " . $groupmessage['discussionid'] ."
              			");         
                  $content['contenttype'] = 'groupmessage';
                  $content['contentid'] = $groupmessage['gmid'];
                  $content['title'] = $title_q['discussiontitle'];
                  $content['userid'] = $groupmessage['postuserid'];
                  $content['username'] = $groupmessage['postusername'];
                  $content['thumb'] = $groupmessage['thumb'];
                  $content['date'] = vbdate("d-m-Y - H:i", $groupmessage['dateline']);
                
                    $templater = vB_Template::create('sc_thumbs_latest_bit');
                    $templater->register('count', $count);
                    $templater->register('content', $content);
                    $gave_bits .= $templater->render(); 
                  $count++;
                }
                           
                $db->free_result($thumbs_groupmessages_query);        
          }
          break;
case "visitormessage":
        // fetch for PROFILE VISITOR MESSAGES
          if ($vbulletin->options['sc_thumbs_option_visitormessage']) {
              	$thumbs_visitormessages_query = $db->query_read("
              		SELECT sc_thumbs_visitormessage.*, visitormessage.pagetext, visitormessage.userid AS profileid, visitormessage.postuserid, visitormessage.postusername
              		FROM " . TABLE_PREFIX . "sc_thumbs_visitormessage AS sc_thumbs_visitormessage
                  LEFT JOIN " . TABLE_PREFIX . "visitormessage AS visitormessage USING (vmid)
              		WHERE sc_thumbs_visitormessage.userid = ". $vbulletin->userinfo['userid'] ."
              		ORDER BY sc_thumbs_visitormessage.dateline DESC
              		LIMIT $limit
              	");
                
                $count = 1;
                while ($visitormessage = $db->fetch_array($thumbs_visitormessages_query)) {
                  $content['contenttype'] = 'visitormessage';
                  $content['contentid'] = $visitormessage['vmid'];
                  $content['profileid'] = $visitormessage['profileid'];
                  $content['title'] = substr($visitormessage['pagetext'], 0, 60) . '...';
                  $content['userid'] = $visitormessage['postuserid'];
                  $content['username'] = $visitormessage['postusername'];
                  $content['thumb'] = $visitormessage['thumb'];         
                  $content['date'] = vbdate("d-m-Y - H:i", $visitormessage['dateline']);
                 
                    $templater = vB_Template::create('sc_thumbs_latest_bit');
                    $templater->register('count', $count);
                    $templater->register('content', $content);
                    $gave_bits .= $templater->render(); 
                  $count++;            
                }
                           
                $db->free_result($thumbs_visitormessages_query);                        
          }
          break;
case "picturecomment":          
        // fetch for PICTURE COMMENTS
          if ($vbulletin->options['sc_thumbs_option_picturecomment']) {
              	$thumbs_picturecomments_query = $db->query_read("
              		SELECT sc_thumbs_picturecomment.*, picturecomment.pagetext, attachment.attachmentid, album.albumid, picturecomment.postuserid, picturecomment.postusername
              		FROM " . TABLE_PREFIX . "sc_thumbs_picturecomment AS sc_thumbs_picturecomment
                  LEFT JOIN " . TABLE_PREFIX . "picturecomment AS picturecomment USING (commentid)
                  LEFT JOIN " . TABLE_PREFIX . "attachment AS attachment ON(attachment.filedataid = picturecomment.filedataid)
              		LEFT JOIN " . TABLE_PREFIX . "album AS album ON(attachment.contentid = album.albumid)
                  WHERE sc_thumbs_picturecomment.userid = ". $vbulletin->userinfo['userid'] ."
              		ORDER BY sc_thumbs_picturecomment.dateline DESC
              		LIMIT $limit
              	");
               
                $count = 1;
                while ($picturecomment = $db->fetch_array($thumbs_picturecomments_query)) {
                  $content['contenttype'] = 'picturecomment';
                  $content['contentid'] = $picturecomment['commentid'];
                  $content['albumid'] = $picturecomment['albumid'];
                  $content['pictureid'] = $picturecomment['attachmentid'];
                  $content['title'] = substr($picturecomment['pagetext'], 0, 60) . '...';
                  $content['userid'] = $picturecomment['postuserid'];
                  $content['username'] = $picturecomment['postusername'];
                  $content['thumb'] = $picturecomment['thumb'];         
                  $content['date'] = vbdate("d-m-Y - H:i", $picturecomment['dateline']);
                 
                    $templater = vB_Template::create('sc_thumbs_latest_bit');
                    $templater->register('count', $count);
                    $templater->register('content', $content);
                    $gave_bits .= $templater->render(); 
                  $count++;            
                }
                             
                $db->free_result($thumbs_picturecomments_query);                       
          }
          break;
case "picture":
        // fetch for PICTURE
          if ($vbulletin->options['sc_thumbs_option_picture']) {
              	$thumbs_picture_query = $db->query_read("
              		SELECT sc_thumbs_picture.*, attachment.caption, user.userid AS contentuserid, user.username AS contentusername, album.albumid
              		FROM " . TABLE_PREFIX . "sc_thumbs_picture AS sc_thumbs_picture
                  LEFT JOIN " . TABLE_PREFIX . "attachment AS attachment ON (attachment.attachmentid = sc_thumbs_picture.pictureid)
                  LEFT JOIN " . TABLE_PREFIX . "album AS album ON(attachment.contentid = album.albumid)
                  LEFT JOIN " . TABLE_PREFIX . "user AS user ON (attachment.userid = user.userid)
              		WHERE sc_thumbs_picture.userid = ". $vbulletin->userinfo['userid'] ."
              		ORDER BY sc_thumbs_picture.dateline DESC
              		LIMIT $limit
              	");
                        
                $count = 1;
                while ($picture = $db->fetch_array($thumbs_picture_query)) {
                  $content['contenttype'] = 'picture';
                  $content['contentid'] = $picture['pictureid'];
                  $content['albumid'] = $picture['albumid'];
                  $content['title'] = $picture['caption'];
                  $content['userid'] = $picture['contentuserid'];
                  $content['username'] = $picture['contentusername'];
                  $content['thumb'] = $picture['thumb'];         
                  $content['date'] = vbdate("d-m-Y - H:i", $picture['dateline']);
                  if ($content['title'] == '') {$content['title'] = $vbphrase['sc_thumbs_notitle'];}
                  
                    $templater = vB_Template::create('sc_thumbs_latest_bit');
                    $templater->register('count', $count);
                    $templater->register('content', $content);
                    $gave_bits .= $templater->render(); 
                  $count++;            
                }
                    
                $db->free_result($thumbs_picture_query);                        
          } 
          break;

case "node":
        // fetch for vBCMS ARTICLES
          if ($vbulletin->options['sc_thumbs_option_node']) {
              	$thumbs_nodes_query = $db->query_read("
              		SELECT sc_thumbs_node.*, cms_nodeinfo.nodeid, cms_nodeinfo.title, cms_node.userid AS postuserid, user.username AS postusername
              		FROM " . TABLE_PREFIX . "sc_thumbs_node AS sc_thumbs_node
                  LEFT JOIN " . TABLE_PREFIX . "cms_nodeinfo AS cms_nodeinfo ON (sc_thumbs_node.nodeid = cms_nodeinfo.nodeid)
              		LEFT JOIN " . TABLE_PREFIX . "cms_node AS cms_node ON (sc_thumbs_node.nodeid = cms_node.nodeid)
                  LEFT JOIN " . TABLE_PREFIX . "user AS user ON (cms_node.userid = user.userid)
                  WHERE sc_thumbs_node.userid = ". $vbulletin->userinfo['userid'] ."
              		ORDER BY sc_thumbs_node.dateline DESC
              		LIMIT $limit
              	");
                
                $count = 1;
                while ($article = $db->fetch_array($thumbs_nodes_query)) {
                  $content['contenttype'] = 'node';
                  $content['contentid'] = $article['nodeid'];
                  $content['title'] = $article['title'];
                  $content['userid'] = $article['postuserid'];
                  $content['username'] = $article['postusername'];
                  $content['thumb'] = $article['thumb'];         
                  $content['date'] = vbdate("d-m-Y - H:i", $article['dateline']);
                  
                    $templater = vB_Template::create('sc_thumbs_latest_bit');
                    $templater->register('count', $count);
                    $templater->register('content', $content);
                    $gave_bits .= $templater->render(); 
                  $count++;            
                }
                             
                $db->free_result($thumbs_nodes_query);
                              
          }
          break;
case "blog":   
        // fetch for BLOG ENTRIES AND COMMENTS
          if ($vbulletin->options['sc_thumbs_option_blog']) {
              	$thumbs_blog_query = $db->query_read("
              		SELECT sc_thumbs_blog.*, blog_text.title, blog_text.pagetext, blog_text.blogid, blog_text.blogtextid, user.username AS postusername, blog_text.userid AS postuserid
              		FROM " . TABLE_PREFIX . "sc_thumbs_blog AS sc_thumbs_blog
                  LEFT JOIN " . TABLE_PREFIX . "blog_text AS blog_text USING (blogtextid)
                  LEFT JOIN " . TABLE_PREFIX . "user AS user ON (blog_text.userid = user.userid)
              		WHERE sc_thumbs_blog.userid = ". $vbulletin->userinfo['userid'] ."
              		ORDER BY blog_text.dateline DESC
              		LIMIT $limit
              	");
                
                $count = 1;
                while ($blog = $db->fetch_array($thumbs_blog_query)) {
                  $content['contenttype'] = 'blog';                                    
                  if ($blog['title'] == '') {$content['title'] = substr($blog['pagetext'], 0, 60) . '...';}else {$content['title'] = $blog['title'];}
                  $content['contentid'] = $blog['blogtextid'];
                  $content['blogid'] = $blog['blogid'];
                  $content['userid'] = $blog['postuserid'];
                  $content['username'] = $blog['postusername'];
                  $content['thumb'] = $blog['thumb'];
                  $content['unread'] = $blog['unread'];         
                  $content['date'] = vbdate("d-m-Y - H:i", $blog['dateline']);
                        
                    $templater = vB_Template::create('sc_thumbs_latest_bit');
                     $templater->register('count', $count);
                     $templater->register('content', $content);
                    $gave_bits .= $templater->render();  
                  $count++;            
                } 
                
                $db->free_result($thumbs_blog_query);                              
          }
          break;                    
}
//////////////// navbar and output
	$navbits = construct_navbits(array(
		'' => $vbphrase['sc_thumbs_center_title']
	));
	$navbar = render_navbar_template($navbits);

/////////// build the thumbs up? Center navbar
   $templater = vB_Template::create('sc_thumbs_navbar');
    $templater->register('do', $do);
   $sc_thumbs_navbar = $templater->render();  

/// fetch stats "sent"   
    $gave = $db->query_first("
      		SELECT sc_thumbs_up_gave AS thumbsup, sc_thumbs_down_gave AS thumbsdown 
      		FROM " . TABLE_PREFIX . "user AS user
      		WHERE userid = ". $vbulletin->userinfo['userid'] ."
      	");    
    $gave['total'] = $gave['thumbsup'] + $gave['thumbsdown']; 
        
///////////////// extract LATEST THUMBS GAVE
	$templater = vB_Template::create('sc_thumbs_LATEST_GAVE_PAGE');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
    $templater->register('viewtype', $viewtype);
    $templater->register('sc_thumbs_navbar', $sc_thumbs_navbar); 
    $templater->register('gave', $gave);
    $templater->register('gave_bits', $gave_bits);
  print_output($templater->render());    
  
}

if ($_REQUEST['do'] == 'stats')
{

  if (!$vbulletin->options['sc_thumbs_stats'])
  { 
    print_no_permission();  
  }
  
$viewtype = $vbulletin->input->clean_gpc('r', 'viewtype', TYPE_STR);  
$do = 'stats';

/// fetch "my stats"
    $received = $db->query_first("
      		SELECT sc_thumbs_up_received AS thumbsup, sc_thumbs_down_received AS thumbsdown 
      		FROM " . TABLE_PREFIX . "user AS user
      		WHERE userid = ". $vbulletin->userinfo['userid'] ."
      	");
        
    $received['total'] = $received['thumbsup'] + $received['thumbsdown'];
        
    $gave = $db->query_first("
      		SELECT sc_thumbs_up_gave AS thumbsup, sc_thumbs_down_gave AS thumbsdown 
      		FROM " . TABLE_PREFIX . "user AS user
      		WHERE userid = ". $vbulletin->userinfo['userid'] ."
      	");    
    $gave['total'] = $gave['thumbsup'] + $gave['thumbsdown'];

/// fetch whole forum stats
    $whole = $db->query_first("
      		SELECT * 
      		FROM " . TABLE_PREFIX . "sc_thumbs_stats
      	");
    $whole['total'] = $whole['thumbsup_total'] + $whole['thumbsdown_total'];
    $whole['post_total'] = $whole['thumbsup_post'] + $whole['thumbsdown_post'];  
    $whole['visitormessage_total'] = $whole['thumbsup_visitormessage'] + $whole['thumbsdown_visitormessage'];
    $whole['picture_total'] = $whole['thumbsup_picture'] + $whole['thumbsdown_picture'];
    $whole['picturecomment_total'] = $whole['thumbsup_picturecomment'] + $whole['thumbsdown_picturecomment'];
    $whole['groupmessage_total'] = $whole['thumbsup_groupmessage'] + $whole['thumbsdown_groupmessage'];
    $whole['node_total'] = $whole['thumbsup_node'] + $whole['thumbsdown_node'];
    $whole['blog_total'] = $whole['thumbsup_blog'] + $whole['thumbsdown_blog'];
    
switch ($viewtype) {
case "": 
         $total = $whole['total'];
         $thumbsup = $whole['thumbsup_total']; 
         $thumbsdown = $whole['thumbsdown_total'];
         break;
case "post":
         $total = $whole['post_total'];
         $thumbsup = $whole['thumbsup_post']; 
         $thumbsdown = $whole['thumbsdown_post'];
         break;
case "visitormessage":
         $total = $whole['visitormessage_total'];
         $thumbsup = $whole['thumbsup_visitormessage']; 
         $thumbsdown = $whole['thumbsdown_visitormessage'];
         break;
case "picturecomment":
         $total = $whole['picturecomment_total'];
         $thumbsup = $whole['thumbsup_picturecomment']; 
         $thumbsdown = $whole['thumbsdown_picturecomment'];
         break;
case "groupmessage":
         $total = $whole['groupmessage_total'];
         $thumbsup = $whole['thumbsup_groupmessage']; 
         $thumbsdown = $whole['thumbsdown_groupmessage'];
         break;
case "picture": 
         $total = $whole['picture_total'];
         $thumbsup = $whole['thumbsup_picture']; 
         $thumbsdown = $whole['thumbsdown_picture'];
         break; 
case "node": 
         $total = $whole['node_total'];
         $thumbsup = $whole['thumbsup_node']; 
         $thumbsdown = $whole['thumbsdown_node'];
         break; 
case "blog": 
         $total = $whole['blog_total'];
         $thumbsup = $whole['thumbsup_blog']; 
         $thumbsdown = $whole['thumbsdown_blog'];
         break;                                    
}

  $templater = vB_Template::create('sc_thumbs_stats_bit');
   $templater->register('total', $total);
   $templater->register('thumbsup', $thumbsup);
   $templater->register('thumbsdown', $thumbsdown);
  $stat_bits = $templater->render();
  
      
//////////////// navbar and output
	$navbits = construct_navbits(array(
		'' => $vbphrase['sc_thumbs_center_title']
	));
	$navbar = render_navbar_template($navbits);

/////////// build the thumbs up? Center navbar
   $templater = vB_Template::create('sc_thumbs_navbar');
    $templater->register('do', $do);
   $sc_thumbs_navbar = $templater->render();  
  
///////////////// extract Statistics Page
	$templater = vB_Template::create('sc_thumbs_STATS_PAGE');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
    $templater->register('viewtype', $viewtype);
    $templater->register('sc_thumbs_navbar', $sc_thumbs_navbar);
    $templater->register('received', $received);
    $templater->register('gave', $gave); 
    $templater->register('whole', $whole);
    $templater->register('stat_bits', $stat_bits);
  print_output($templater->render());  

}


if ($_REQUEST['do'] == 'top')
{
  if (!$vbulletin->options['sc_thumbs_top'])
  { 
    print_no_permission();  
  }
////////// top thumbed content
$limit = $vbulletin->options['sc_thumbs_top_num'];
$viewtype = $vbulletin->input->clean_gpc('r', 'viewtype', TYPE_STR);  
$do = 'top';

switch ($viewtype) {
case "":
        $top_posts_up = $db->query_read("
            SELECT post.postid, post.userid, post.username, thread.title AS threadtitle, thread.forumid, sum1
            FROM " . TABLE_PREFIX . "post AS post INNER JOIN
            (
                SELECT postid, COUNT(thumb) AS sum1
                FROM " . TABLE_PREFIX . "sc_thumbs_post
                WHERE (FROM_UNIXTIME(dateline) > CURDATE() - INTERVAL 1 WEEK) AND (thumb = 1)
                GROUP BY postid
            ) tmp ON post.postid = tmp.postid
            LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (thread.threadid = post.threadid)
            ORDER BY sum1 DESC
            LIMIT $limit
          ");
      
        $count = 1;
        while ($post = $db->fetch_array($top_posts_up)) {
          if(fetch_permissions($post['forumid'])) {
           $content['contenttype'] = 'post';
           $content['contentid'] = $post['postid'];
           $content['title'] = $post['threadtitle'];
           $content['userid'] = $post['userid'];
           $content['username'] = $post['username'];
           $content['thumbs'] = $post['sum1'];
           
          $templater = vB_Template::create('sc_thumbs_top_bit');
            $templater->register('count', $count);
            $templater->register('content', $content);
            $top_bits .= $templater->render();
          $count++;
          }    
        }
       $db->free_result($top_posts_up); 
     break;
case "groupmessage":
        $top_groupmessages_up = $db->query_read("
            SELECT groupmessage.gmid, groupmessage.discussionid, groupmessage.postusername, groupmessage.postuserid, sum1
            FROM " . TABLE_PREFIX . "groupmessage AS groupmessage INNER JOIN
            (
                SELECT gmid, COUNT(thumb) AS sum1
                FROM " . TABLE_PREFIX . "sc_thumbs_groupmessage
                WHERE (FROM_UNIXTIME(dateline) > CURDATE() - INTERVAL 1 WEEK) AND (thumb = 1)
                GROUP BY gmid
            ) tmp ON groupmessage.gmid = tmp.gmid
            ORDER BY sum1 DESC
            LIMIT $limit
          ");
      
        $count = 1;
        while ($groupmessage = $db->fetch_array($top_groupmessages_up)) {
           $title_q = $vbulletin->db->query_first("
              SELECT groupmessage.title AS discussiontitle
              FROM " . TABLE_PREFIX . "groupmessage as groupmessage
              LEFT JOIN " . TABLE_PREFIX . "discussion AS discussion 
              ON (discussion.firstpostid = groupmessage.gmid)
              WHERE groupmessage.discussionid = " . $groupmessage['discussionid'] ."
              			");        
           $content['contenttype'] = 'groupmessage';
           $content['contentid'] = $groupmessage['gmid'];
           $content['title'] = $title_q['discussiontitle'];
           $content['userid'] = $groupmessage['postuserid'];
           $content['username'] = $groupmessage['postusername'];
           $content['thumbs'] = $groupmessage['sum1'];
           
          $templater = vB_Template::create('sc_thumbs_top_bit');
            $templater->register('count', $count);
            $templater->register('content', $content);
            $top_bits .= $templater->render();
          $count++;   
        }
       $db->free_result($top_groupmessages_up); 
     break;
case "visitormessage":
        $top_visitormessages_up = $db->query_read("
            SELECT visitormessage.vmid, visitormessage.pagetext, visitormessage.userid AS profileid, visitormessage.postuserid, visitormessage.postusername, sum1
            FROM " . TABLE_PREFIX . "visitormessage AS visitormessage INNER JOIN
            (
                SELECT vmid, COUNT(thumb) AS sum1
                FROM " . TABLE_PREFIX . "sc_thumbs_visitormessage
                WHERE (FROM_UNIXTIME(dateline) > CURDATE() - INTERVAL 1 WEEK) AND (thumb = 1)
                GROUP BY vmid
            ) tmp ON visitormessage.vmid = tmp.vmid
            ORDER BY sum1 DESC
            LIMIT $limit
          ");
      
        $count = 1;
        while ($visitormessage = $db->fetch_array($top_visitormessages_up)) {
                  $content['contenttype'] = 'visitormessage';
                  $content['contentid'] = $visitormessage['vmid'];
                  $content['profileid'] = $visitormessage['profileid'];
                  $content['title'] = substr($visitormessage['pagetext'], 0, 60) . '...';
                  $content['userid'] = $visitormessage['postuserid'];
                  $content['username'] = $visitormessage['postusername'];
                  $content['thumbs'] = $visitormessage['sum1'];         
           
          $templater = vB_Template::create('sc_thumbs_top_bit');
            $templater->register('count', $count);
            $templater->register('content', $content);
            $top_bits .= $templater->render();
          $count++;   
        }
       $db->free_result($top_visitormessages_up); 
     break;
case "picturecomment":
        $top_picturecomments_up = $db->query_read("
            SELECT picturecomment.commentid, picturecomment.pagetext, attachment.attachmentid, album.albumid, picturecomment.postuserid, picturecomment.postusername, sum1
            FROM " . TABLE_PREFIX . "picturecomment AS picturecomment INNER JOIN
            (
                SELECT commentid, COUNT(thumb) AS sum1
                FROM " . TABLE_PREFIX . "sc_thumbs_picturecomment
                WHERE (FROM_UNIXTIME(dateline) > CURDATE() - INTERVAL 1 WEEK) AND (thumb = 1)
                GROUP BY commentid
            ) tmp ON picturecomment.commentid = tmp.commentid
            LEFT JOIN " . TABLE_PREFIX . "attachment AS attachment ON(attachment.filedataid = picturecomment.filedataid)
            LEFT JOIN " . TABLE_PREFIX . "album AS album ON(attachment.contentid = album.albumid)
            ORDER BY sum1 DESC
            LIMIT $limit
          ");
      
        $count = 1;
        while ($comment = $db->fetch_array($top_picturecomments_up)) {        
           $content['contenttype'] = 'picturecomment';
           $content['contentid'] = $comment['commentid'];
           $content['albumid'] = $comment['albumid'];
           $content['pictureid'] = $comment['attachmentid'];
           $content['title'] = substr($comment['pagetext'], 0, 60) . '...'; 
           $content['userid'] = $comment['postuserid'];
           $content['username'] = $comment['postusername'];
           $content['thumbs'] = $comment['sum1'];
           
          $templater = vB_Template::create('sc_thumbs_top_bit');
            $templater->register('count', $count);
            $templater->register('content', $content);
            $top_bits .= $templater->render();
          $count++;   
        }
       $db->free_result($top_picturecomments_up); 
     break;  
case "picture":                  
        $top_pictures_up = $db->query_read("
            SELECT attachment.attachmentid, attachment.caption, user.userid AS contentuserid, user.username AS contentusername, album.albumid, sum1
            FROM " . TABLE_PREFIX . "attachment AS attachment INNER JOIN
            (
                SELECT pictureid, COUNT(thumb) AS sum1
                FROM " . TABLE_PREFIX . "sc_thumbs_picture
                WHERE (FROM_UNIXTIME(dateline) > CURDATE() - INTERVAL 1 WEEK) AND (thumb = 1)
                GROUP BY pictureid
            ) tmp ON attachment.attachmentid = tmp.pictureid
            LEFT JOIN " . TABLE_PREFIX . "album AS album ON(attachment.contentid = album.albumid)
            LEFT JOIN " . TABLE_PREFIX . "user AS user ON (attachment.userid = user.userid)
            ORDER BY sum1 DESC
            LIMIT $limit
          ");
      
        $count = 1;
        while ($picture = $db->fetch_array($top_pictures_up)) {        
           $content['contenttype'] = 'picture';
           $content['contentid'] = $picture['attachmentid'];
           $content['albumid'] = $picture['albumid'];
           $content['pictureid'] = $picture['attachmentid'];
           $content['title'] = $picture['caption']; 
           $content['userid'] = $picture['contentuserid'];
           $content['username'] = $picture['contentusername'];
           $content['thumbs'] = $picture['sum1'];
           if ($content['title'] == '') {$content['title'] = $vbphrase['sc_thumbs_notitle'];}
           
          $templater = vB_Template::create('sc_thumbs_top_bit');
            $templater->register('count', $count);
            $templater->register('content', $content);
            $top_bits .= $templater->render();
          $count++;   
        }
       $db->free_result($top_pictures_up); 
     break;
case "node":
        $top_nodes_up = $db->query_read("
            SELECT cms_nodeinfo.nodeid, cms_nodeinfo.title, cms_node.userid AS postuserid, user.username AS postusername, sum1
            FROM " . TABLE_PREFIX . "cms_nodeinfo AS cms_nodeinfo INNER JOIN
            (
                SELECT nodeid, COUNT(thumb) AS sum1
                FROM " . TABLE_PREFIX . "sc_thumbs_node
                WHERE (FROM_UNIXTIME(dateline) > CURDATE() - INTERVAL 1 WEEK) AND (thumb = 1)
                GROUP BY nodeid
            ) tmp ON cms_nodeinfo.nodeid = tmp.nodeid
            LEFT JOIN " . TABLE_PREFIX . "cms_node AS cms_node ON (cms_nodeinfo.nodeid = cms_node.nodeid)
            LEFT JOIN " . TABLE_PREFIX . "user AS user ON (cms_node.userid = user.userid)
            ORDER BY sum1 DESC
            LIMIT $limit
          ");
      
        $count = 1;
        while ($article = $db->fetch_array($top_nodes_up)) {
                  $content['contenttype'] = 'node';
                  $content['contentid'] = $article['nodeid'];
                  $content['title'] = $article['title'];
                  $content['userid'] = $article['postuserid'];
                  $content['username'] = $article['postusername'];
                  $content['thumbs'] = $article['sum1'];         
           
          $templater = vB_Template::create('sc_thumbs_top_bit');
            $templater->register('count', $count);
            $templater->register('content', $content);
            $top_bits .= $templater->render();
          $count++;   
        }
       $db->free_result($top_nodes_up); 
     break;
case "blog":
        $top_blogs_up = $db->query_read("
            SELECT blog_text.title, blog_text.pagetext, blog_text.blogid, blog_text.blogtextid, user.username AS postusername, blog_text.userid AS postuserid, sum1
            FROM " . TABLE_PREFIX . "blog_text AS blog_text INNER JOIN
            (
                SELECT blogtextid, COUNT(thumb) AS sum1
                FROM " . TABLE_PREFIX . "sc_thumbs_blog
                WHERE (FROM_UNIXTIME(dateline) > CURDATE() - INTERVAL 1 WEEK) AND (thumb = 1)
                GROUP BY blogtextid
            ) tmp ON blog_text.blogtextid = tmp.blogtextid
            LEFT JOIN " . TABLE_PREFIX . "user AS user ON (blog_text.userid = user.userid)
            ORDER BY sum1 DESC
            LIMIT $limit
          ");
      
        $count = 1;
        while ($blog = $db->fetch_array($top_blogs_up)) {
                  $content['contenttype'] = 'blog';
                  $content['contentid'] = $blog['blogtextid'];
                  $content['blogid'] = $blog['blogid'];
                  $content['title'] = substr($blog['pagetext'], 0, 60) . '...';
                  $content['userid'] = $blog['postuserid'];
                  $content['username'] = $blog['postusername'];
                  $content['thumbs'] = $blog['sum1'];         
           
          $templater = vB_Template::create('sc_thumbs_top_bit');
            $templater->register('count', $count);
            $templater->register('content', $content);
            $top_bits .= $templater->render();
          $count++;   
        }
       $db->free_result($top_blogs_up); 
     break;                             
}     
//////////////// navbar and output
	$navbits = construct_navbits(array(
		'' => $vbphrase['sc_thumbs_center_title']
	));
	$navbar = render_navbar_template($navbits);

/////////// build the thumbs up? Center navbar
   $templater = vB_Template::create('sc_thumbs_navbar');
    $templater->register('do', $do);
   $sc_thumbs_navbar = $templater->render();  
   
///////////////// extract TOP THUMBED PAGE
	$templater = vB_Template::create('sc_thumbs_TOP_PAGE');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
    $templater->register('viewtype', $viewtype);
    $templater->register('sc_thumbs_navbar', $sc_thumbs_navbar); 
    $templater->register('top_bits', $top_bits);
  print_output($templater->render());     
}    
?>



