<?php  
/*======================================================================*\
|| #################################################################### ||
|| # Thumbs Up? v1.9 by Scandal for vBulletin 4.x.x                   # ||
|| #                                                                  # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Scandal @ vBulletin.org                          # ||
|| #                                                                  # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'sc_thumbs');
define('CSRF_PROTECTION', true);
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array(); 

// pre-cache templates used by all actions
$globaltemplates = array(
	'sc_thumbs_box', 
  'sc_thumbs_box_bit'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_sc_thumbs.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################
$vbulletin->input->clean_array_gpc('r', array(
	'using_ajax'       => TYPE_BOOL,
  'securitytoken' => TYPE_STR,
  'contenttype' => TYPE_STR,
  'contentid' => TYPE_UINT,
  'thumb' => TYPE_INT
));

$using_ajax = $vbulletin->GPC['using_ajax'];
$securitytoken = $vbulletin->GPC['securitytoken'];
$contenttype = $vbulletin->GPC['contenttype'];
$contentid = $vbulletin->GPC['contentid'];
$thumb = $vbulletin->GPC['thumb'];

// check on/off field
  if (!$vbulletin->options['sc_thumbs_onoff']) {
  		print_no_permission();
  }
  
// check security
  if (!verify_security_token($securitytoken, $vbulletin->userinfo['securitytoken_raw'])) {
  		print_no_permission();
  }

// validate thumb input
  if ($_REQUEST['do'] == 'add') {
      thumb_validation($thumb);
  }
  
// ####################### ADD THUMB ##########################
if ($_REQUEST['do'] == 'add') {
  switch ($contenttype) {
    case "post": 
          $postinfo = sc_fetch_postinfo($contentid);
          $threadinfo = sc_fetch_threadinfo($contentid);
          can_thumb_check($postinfo, 'post', true, $threadinfo['firstpostid'], $threadinfo['forumid']);
                 
          $old = fetch_thumbs($postinfo['postid'], '', 'post', 'postid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
          
          add_thumb($postinfo, 'post', 'postid', $thumb);
          notify_user($postinfo['userid']);
          if ($using_ajax) {      
                $thumbs = fetch_thumbs($postinfo['postid'], '', 'post', 'postid', true);
                $can_thumb = can_thumb_check($postinfo, 'post', false, $threadinfo['firstpostid'], $threadinfo['forumid']);
                $type = thumbed_already_check($postinfo, 'post', 'postid');
                $list = fetch_thumbers_bit($thumbs);               
                if($thumb == 1){
                $amount_unformatted = $amount_unformatted + 1;
                }else {
                $amount_unformatted = $amount_unformatted - 1;
                }      
                $amount = vb_number_format($amount_unformatted);               
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;         
          }else {
            $vbulletin->url = "showthread.php?$session[sessionurl]p=$contentid";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }  
      break;
    case "visitormessage":
          $messageinfo = sc_fetch_visitormessageinfo($contentid);
          can_thumb_check($messageinfo, 'visitormessage', true); 
                
          $old = fetch_thumbs($messageinfo['vmid'], '', 'visitormessage', 'vmid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                               
          add_thumb($messageinfo, 'visitormessage', 'vmid', $thumb);
          notify_user($messageinfo['userid']);
          if ($using_ajax) {      
                $thumbs = fetch_thumbs($messageinfo['vmid'], '', 'visitormessage', 'vmid', true);
                $can_thumb = can_thumb_check($messageinfo, 'visitormessage', false);
                $type = thumbed_already_check($messageinfo, 'visitormessage', 'vmid');
                $list = fetch_thumbers_bit($thumbs);               
                if($thumb == 1){
                $amount_unformatted = $amount_unformatted + 1;
                }else {
                $amount_unformatted = $amount_unformatted - 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;         
          }else {             
            $vbulletin->url = "member.php?u=$messageinfo[profileid]&vmid=$messageinfo[vmid]#vmessage$messageinfo[vmid]";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }     
      break;
    case "groupmessage":
          $messageinfo = sc_fetch_groupmessageinfo($contentid);
          can_thumb_check($messageinfo, 'groupmessage', true, $messageinfo['firstpostid'], $threadinfo['forumid']); 
                
          $old = fetch_thumbs($messageinfo['gmid'], '', 'groupmessage', 'gmid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                               
          add_thumb($messageinfo, 'groupmessage', 'gmid', $thumb);
          notify_user($messageinfo['userid']);
          if ($using_ajax) {      
                $thumbs = fetch_thumbs($messageinfo['gmid'], '', 'groupmessage', 'gmid', true);
                $can_thumb = can_thumb_check($messageinfo, 'groupmessage', false, $messageinfo['firstpostid']);
                $type = thumbed_already_check($messageinfo, 'groupmessage', 'gmid');
                $list = fetch_thumbers_bit($thumbs);               
                if($thumb == 1){
                $amount_unformatted = $amount_unformatted + 1;
                }else {
                $amount_unformatted = $amount_unformatted - 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;         
          }else {
            $vbulletin->url = "group.php?do=discuss&gmid=$messageinfo[gmid]#gmessage$messageinfo[gmid]";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }      
      break;
    case "picturecomment":
          $commentinfo = sc_fetch_picturecommentinfo($contentid);
          can_thumb_check($commentinfo, 'picturecomment', true); 
                
          $old = fetch_thumbs($commentinfo['commentid'], '', 'picturecomment', 'commentid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                               
          add_thumb($commentinfo, 'picturecomment', 'commentid', $thumb);
          notify_user($commentinfo['userid']);
          if ($using_ajax) {      
                $thumbs = fetch_thumbs($commentinfo['commentid'], '', 'picturecomment', 'commentid', true);
                $can_thumb = can_thumb_check($commentinfo, 'picturecomment', false);
                $type = thumbed_already_check($commentinfo, 'picturecomment', 'commentid');
                $list = fetch_thumbers_bit($thumbs);               
                if($thumb == 1){
                $amount_unformatted = $amount_unformatted + 1;
                }else {
                $amount_unformatted = $amount_unformatted - 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;         
          }else {
            $vbulletin->url = "album.php?$session[sessionurl]albumid=$commentinfo[albumid]&pictureid=$commentinfo[pictureid]#picturecomment$commentinfo[commentid]";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }    
      break;
    case "picture":
          $pictureinfo = sc_fetch_pictureinfo($contentid);
          can_thumb_check($pictureinfo, 'picture', true); 
                
          $old = fetch_thumbs($pictureinfo['pictureid'], '', 'picture', 'pictureid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                               
          add_thumb($pictureinfo, 'picture', 'pictureid', $thumb);
          notify_user($pictureinfo['userid']);
          if ($using_ajax) {      
                $thumbs = fetch_thumbs($pictureinfo['pictureid'], '', 'picture', 'pictureid', true);
                $can_thumb = can_thumb_check($pictureinfo, 'picture', false);
                $type = thumbed_already_check($pictureinfo, 'picture', 'pictureid');
                $list = fetch_thumbers_bit($thumbs);               
                if($thumb == 1){
                $amount_unformatted = $amount_unformatted + 1;
                }else {
                $amount_unformatted = $amount_unformatted - 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;         
          }else {             
            $vbulletin->url = "album.php?albumid=$pictureinfo[albumid]&pictureid=$pictureinfo[pictureid]";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }      
      break;
    case "node":
          $nodeinfo = sc_fetch_nodeinfo($contentid);
          can_thumb_check($nodeinfo, 'node', true); 
                
          $old = fetch_thumbs($nodeinfo['nodeid'], '', 'node', 'nodeid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                               
          add_thumb($nodeinfo, 'node', 'nodeid', $thumb);
          notify_user($nodeinfo['userid']);
          if ($using_ajax) {      
                $thumbs = fetch_thumbs($nodeinfo['nodeid'], '', 'node', 'nodeid', true);
                $can_thumb = can_thumb_check($nodeinfo, 'node', false);
                $type = thumbed_already_check($nodeinfo, 'node', 'nodeid');
                $list = fetch_thumbers_bit($thumbs);               
                if($thumb == 1){
                $amount_unformatted = $amount_unformatted + 1;
                }else {
                $amount_unformatted = $amount_unformatted - 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;         
          }else {             
            $vbulletin->url = "content.php?$nodeinfo[nodeid]";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }      
      break;
    case "blogentry":
          $entryinfo = sc_fetch_blogentryinfo($contentid);
          can_thumb_check($entryinfo, 'blog', true); 
                
          $old = fetch_thumbs($entryinfo['blogtextid'], '', 'blog', 'blogtextid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                               
          add_thumb($entryinfo, 'blog', 'blogtextid', $thumb);
          notify_user($entryinfo['userid']);
          if ($using_ajax) {      
                $thumbs = fetch_thumbs($entryinfo['blogtextid'], '', 'blog', 'blogtextid', true);
                $can_thumb = can_thumb_check($entryinfo, 'blog', false);
                $type = thumbed_already_check($entryinfo, 'blog', 'blogtextid');
                $list = fetch_thumbers_bit($thumbs);               
                if($thumb == 1){
                $amount_unformatted = $amount_unformatted + 1;
                }else {
                $amount_unformatted = $amount_unformatted - 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;         
          }else {             
            $vbulletin->url = "blog.php?b=$entryinfo[blogtextid]";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }     
      break;
    case "blogcomment":
          $messageinfo = sc_fetch_blogcommentinfo($contentid);
          can_thumb_check($messageinfo, 'blog', true); 
                
          $old = fetch_thumbs($messageinfo['blogtextid'], '', 'blog', 'blogtextid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                               
          add_thumb($messageinfo, 'blog', 'blogtextid', $thumb);
          notify_user($messageinfo['userid']);
          if ($using_ajax) {      
                $thumbs = fetch_thumbs($messageinfo['blogtextid'], '', 'blog', 'blogtextid', true);
                $can_thumb = can_thumb_check($messageinfo, 'blog', false);
                $type = thumbed_already_check($messageinfo, 'blog', 'blogtextid');
                $list = fetch_thumbers_bit($thumbs);               
                if($thumb == 1){
                $amount_unformatted = $amount_unformatted + 1;
                }else {
                $amount_unformatted = $amount_unformatted - 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;         
          }else {              
            $vbulletin->url = "entry.php?b=$messageinfo[blogid]&bt=$messageinfo[blogtextid]";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }     
      break;                              
  }
}

// ####################### REMOVE THUMB #########################
if ($_REQUEST['do'] == 'remove') {
  switch ($contenttype) {
    case "post":
          $postinfo = sc_fetch_postinfo($contentid);
          $threadinfo = sc_fetch_threadinfo($contentid);
          
          $old = fetch_thumbs($postinfo['postid'], '', 'post', 'postid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                    
          remove_thumb($postinfo, 'post', 'postid', $vbulletin->userinfo['userid']);
          un_notify_user($postinfo['userid']);
          if ($using_ajax) { 
                $userid = $vbulletin->userinfo['userid'];
                $thumbs = fetch_thumbs($postinfo['postid'], '', 'post', 'postid', true);
                $can_thumb = can_thumb_check($postinfo, 'post', false, $threadinfo['firstpostid'], $threadinfo['forumid']);
                $type = thumbed_already_check($postinfo, 'post', 'postid');
                $list = fetch_thumbers_bit($thumbs);            
                if($old[$userid]['thumb'] == 1) {
                  $amount_unformatted = $amount_unformatted - 1;
                } else {
                  $amount_unformatted = $amount_unformatted + 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;           
          }else {
            $vbulletin->url = "showthread.php?$session[sessionurl]p=$contentid";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }  
      break;
    case "visitormessage":
          $messageinfo = sc_fetch_visitormessageinfo($contentid);
          
          $old = fetch_thumbs($messageinfo['vmid'], '', 'visitormessage', 'vmid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                    
          remove_thumb($messageinfo, 'visitormessage', 'vmid', $vbulletin->userinfo['userid']);
          un_notify_user($messageinfo['userid']);
          if ($using_ajax) { 
                $userid = $vbulletin->userinfo['userid'];
                $thumbs = fetch_thumbs($messageinfo['vmid'], '', 'visitormessage', 'vmid', true);
                $can_thumb = can_thumb_check($messageinfo, 'visitormessage', false);
                $type = thumbed_already_check($messageinfo, 'visitormessage', 'vmid');
                $list = fetch_thumbers_bit($thumbs);            
                if($old[$userid]['thumb'] == 1) {
                  $amount_unformatted = $amount_unformatted - 1;
                } else {
                  $amount_unformatted = $amount_unformatted + 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;           
          }else {
            $vbulletin->url = "member.php?u=$messageinfo[profileid]&vmid=$messageinfo[vmid]#vmessage$messageinfo[vmid]";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }     
      break;
    case "groupmessage":
          $messageinfo = sc_fetch_groupmessageinfo($contentid);
          
          $old = fetch_thumbs($messageinfo['gmid'], '', 'groupmessage', 'gmid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                    
          remove_thumb($messageinfo, 'groupmessage', 'gmid', $vbulletin->userinfo['userid']);
          un_notify_user($messageinfo['userid']);
          if ($using_ajax) { 
                $userid = $vbulletin->userinfo['userid'];
                $thumbs = fetch_thumbs($messageinfo['gmid'], '', 'groupmessage', 'gmid', true);
                $can_thumb = can_thumb_check($messageinfo, 'groupmessage', false, $messageinfo['firstpostid']);
                $type = thumbed_already_check($messageinfo, 'groupmessage', 'gmid');
                $list = fetch_thumbers_bit($thumbs);            
                if($old[$userid]['thumb'] == 1) {
                  $amount_unformatted = $amount_unformatted - 1;
                } else {
                  $amount_unformatted = $amount_unformatted + 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;           
          }else {
            $vbulletin->url = "group.php?do=discuss&gmid=$messageinfo[gmid]#gmessage$messageinfo[gmid]";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }     
      break;
    case "picturecomment":
          $commentinfo = sc_fetch_picturecommentinfo($contentid);
          
          $old = fetch_thumbs($commentinfo['commentid'], '', 'picturecomment', 'commentid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                    
          remove_thumb($commentinfo, 'picturecomment', 'commentid', $vbulletin->userinfo['userid']);
          un_notify_user($commentinfo['userid']);
          if ($using_ajax) { 
                $userid = $vbulletin->userinfo['userid'];
                $thumbs = fetch_thumbs($commentinfo['commentid'], '', 'picturecomment', 'commentid', true);
                $can_thumb = can_thumb_check($commentinfo, 'picturecomment', false);
                $type = thumbed_already_check($commentinfo, 'picturecomment', 'commentid');
                $list = fetch_thumbers_bit($thumbs);            
                if($old[$userid]['thumb'] == 1) {
                  $amount_unformatted = $amount_unformatted - 1;
                } else {
                  $amount_unformatted = $amount_unformatted + 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;           
          }else {
            $vbulletin->url = "album.php?$session[sessionurl]albumid=$commentinfo[albumid]&pictureid=$commentinfo[pictureid]#picturecomment$commentinfo[commentid]";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }      
      break;
    case "picture":
          $pictureinfo = sc_fetch_pictureinfo($contentid);
          
          $old = fetch_thumbs($pictureinfo['pictureid'], '', 'picture', 'pictureid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                    
          remove_thumb($pictureinfo, 'picture', 'pictureid', $vbulletin->userinfo['userid']);
          un_notify_user($pictureinfo['userid']);
          if ($using_ajax) { 
                $userid = $vbulletin->userinfo['userid'];
                $thumbs = fetch_thumbs($pictureinfo['pictureid'], '', 'picture', 'pictureid', true);
                $can_thumb = can_thumb_check($pictureinfo, 'picture', false);
                $type = thumbed_already_check($pictureinfo, 'picture', 'pictureid');
                $list = fetch_thumbers_bit($thumbs);            
                if($old[$userid]['thumb'] == 1) {
                  $amount_unformatted = $amount_unformatted - 1;
                } else {
                  $amount_unformatted = $amount_unformatted + 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;           
          }else {
            $vbulletin->url = "album.php?albumid=$pictureinfo[albumid]&pictureid=$pictureinfo[pictureid]";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }     
      break;
    case "node":
          $nodeinfo = sc_fetch_nodeinfo($contentid);
          
          $old = fetch_thumbs($nodeinfo['nodeid'], '', 'node', 'nodeid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                    
          remove_thumb($nodeinfo, 'node', 'nodeid', $vbulletin->userinfo['userid']);
          un_notify_user($nodeinfo['userid']);
          if ($using_ajax) { 
                $userid = $vbulletin->userinfo['userid'];
                $thumbs = fetch_thumbs($nodeinfo['nodeid'], '', 'node', 'nodeid', true);
                $can_thumb = can_thumb_check($nodeinfo, 'node', false);
                $type = thumbed_already_check($nodeinfo, 'node', 'nodeid');
                $list = fetch_thumbers_bit($thumbs);            
                if($old[$userid]['thumb'] == 1) {
                  $amount_unformatted = $amount_unformatted - 1;
                } else {
                  $amount_unformatted = $amount_unformatted + 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;           
          }else {
            $vbulletin->url = "content.php?$nodeinfo[nodeid]";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }     
      break;
    case "blogentry":
          $entryinfo = sc_fetch_blogentryinfo($contentid);
          
          $old = fetch_thumbs($entryinfo['blogtextid'], '', 'blog', 'blogtextid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                    
          remove_thumb($entryinfo, 'blog', 'blogtextid', $vbulletin->userinfo['userid']);
          un_notify_user($entryinfo['userid']);
          if ($using_ajax) { 
                $userid = $vbulletin->userinfo['userid'];
                $thumbs = fetch_thumbs($entryinfo['blogtextid'], '', 'blog', 'blogtextid', true);
                $can_thumb = can_thumb_check($entryinfo, 'blog', false);
                $type = thumbed_already_check($entryinfo, 'blog', 'blogtextid');
                $list = fetch_thumbers_bit($thumbs);            
                if($old[$userid]['thumb'] == 1) {
                  $amount_unformatted = $amount_unformatted - 1;
                } else {
                  $amount_unformatted = $amount_unformatted + 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;           
          }else {
            $vbulletin->url = "blog.php?b=$entryinfo[blogtextid]";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }     
      break; 
    case "blogcomment":
          $messageinfo = sc_fetch_blogcommentinfo($contentid);
          
          $old = fetch_thumbs($messageinfo['blogtextid'], '', 'blog', 'blogtextid', false);          
          $old_list = fetch_thumbers_bit($old);
          $amount_unformatted = $old_list['users_plus_num'] - $old_list['users_minus_num'];
                    
          remove_thumb($messageinfo, 'blog', 'blogtextid', $vbulletin->userinfo['userid']);
          un_notify_user($messageinfo['userid']);
          if ($using_ajax) { 
                $userid = $vbulletin->userinfo['userid'];
                $thumbs = fetch_thumbs($messageinfo['blogtextid'], '', 'blog', 'blogtextid', true);
                $can_thumb = can_thumb_check($messageinfo, 'blog', false);
                $type = thumbed_already_check($messageinfo, 'blog', 'blogtextid');
                $list = fetch_thumbers_bit($thumbs);            
                if($old[$userid]['thumb'] == 1) {
                  $amount_unformatted = $amount_unformatted - 1;
                } else {
                  $amount_unformatted = $amount_unformatted + 1;
                }      
                $amount = vb_number_format($amount_unformatted);
                $templater = vB_Template::create('sc_thumbs_box');
                  $templater->register('contenttype', $contenttype);
                  $templater->register('contentid', $contentid);
                  $templater->register('can_thumb', $can_thumb);
                  $templater->register('type', $type);
                  $templater->register('amount', $amount);
                  $templater->register('list', $list);
                $box = $templater->render();
                  echo $box;
                  exit;           
          }else {
            $vbulletin->url = "entry.php?b=$messageinfo[blogid]&bt=$messageinfo[blogtextid]";
		        eval(print_standard_redirect('redirect_sc_action_thumbs'));
          }     
      break;                            
  }
}

?>



