<?php
/*=====================================*\
|| ################################### ||
|| # Thumbs Up? v1.9 by Scandal      # ||
|| ################################### ||
\*=====================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
@set_time_limit(0);
ignore_user_abort(1);

// ##################### DEFINE IMPORTANT CONSTANTS #######################

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('maintenance');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_sc_thumbs.php');

// ADMIN FUNCTIONS
function build_thumbs_stats()
{
  global $vbulletin;
  $post = $vbulletin->db->query_first("
          		SELECT SUM(if(thumb = 1, 1, 0)) AS thumbsup, SUM(if(thumb = -1, 1, 0)) AS thumbsdown
          		FROM " . TABLE_PREFIX . "sc_thumbs_post  		
          		"); 
  $picture = $vbulletin->db->query_first("
          		SELECT SUM(if(thumb = 1, 1, 0)) AS thumbsup, SUM(if(thumb = -1, 1, 0)) AS thumbsdown
          		FROM " . TABLE_PREFIX . "sc_thumbs_picture  		
          		"); 
  $picturecomment = $vbulletin->db->query_first("
          		SELECT SUM(if(thumb = 1, 1, 0)) AS thumbsup, SUM(if(thumb = -1, 1, 0)) AS thumbsdown
          		FROM " . TABLE_PREFIX . "sc_thumbs_picturecomment  		
          		");
  $groupmessage = $vbulletin->db->query_first("
          		SELECT SUM(if(thumb = 1, 1, 0)) AS thumbsup, SUM(if(thumb = -1, 1, 0)) AS thumbsdown
          		FROM " . TABLE_PREFIX . "sc_thumbs_groupmessage  		
          		");
  $visitormessage = $vbulletin->db->query_first("
          		SELECT SUM(if(thumb = 1, 1, 0)) AS thumbsup, SUM(if(thumb = -1, 1, 0)) AS thumbsdown
          		FROM " . TABLE_PREFIX . "sc_thumbs_visitormessage  		
          		");
  $node = $vbulletin->db->query_first("
          		SELECT SUM(if(thumb = 1, 1, 0)) AS thumbsup, SUM(if(thumb = -1, 1, 0)) AS thumbsdown
          		FROM " . TABLE_PREFIX . "sc_thumbs_node  		
          		"); 
  $blog = $vbulletin->db->query_first("
          		SELECT SUM(if(thumb = 1, 1, 0)) AS thumbsup, SUM(if(thumb = -1, 1, 0)) AS thumbsdown
          		FROM " . TABLE_PREFIX . "sc_thumbs_blog  		
          		");                               
   
// validate results
if ($post['thumbsup'] == ''){$post['thumbsup'] = 0;}
if ($post['thumbsdown'] == ''){$post['thumbsdown'] = 0;}

if ($picture['thumbsup'] == ''){$picture['thumbsup'] = 0;}
if ($picture['thumbsdown'] == ''){$picture['thumbsdown'] = 0;}

if ($picturecomment['thumbsup'] == ''){$picturecomment['thumbsup'] = 0;}
if ($picturecomment['thumbsdown'] == ''){$picturecomment['thumbsdown'] = 0;}

if ($groupmessage['thumbsup'] == ''){$groupmessage['thumbsup'] = 0;}
if ($groupmessage['thumbsdown'] == ''){$groupmessage['thumbsdown'] = 0;}

if ($visitormessage['thumbsup'] == ''){$visitormessage['thumbsup'] = 0;}
if ($visitormessage['thumbsdown'] == ''){$visitormessage['thumbsdown'] = 0;}

if ($node['thumbsup'] == ''){$node['thumbsup'] = 0;}
if ($node['thumbsdown'] == ''){$node['thumbsdown'] = 0;}

if ($blog['thumbsup'] == ''){$blog['thumbsup'] = 0;}
if ($blog['thumbsdown'] == ''){$blog['thumbsdown'] = 0;}
// sums
$total['thumbsup'] = $post['thumbsup'] + $picture['thumbsup'] + $picturecomment['thumbsup'] + $groupmessage['thumbsup'] + $visitormessage['thumbsup'] + $node['thumbsup'] + $blog['thumbsup'];
$total['thumbsdown'] = $post['thumbsdown'] + $picture['thumbsdown'] + $picturecomment['thumbsdown'] + $groupmessage['thumbsdown'] + $visitormessage['thumbsdown'] + $node['thumbsdown'] + $blog['thumbsdown'];
               
// write the results to database 
	$results = $vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "sc_thumbs_stats
		SET	`thumbsup_post`=" . $post['thumbsup'] . ", 
        `thumbsdown_post`=" . $post['thumbsdown'] . ", 
        `thumbsup_picture`=" . $picture['thumbsup'] . ",
        `thumbsdown_picture`=" . $picture['thumbsdown'] . ",     
        `thumbsup_picturecomment`=" . $picturecomment['thumbsup'] . ",
        `thumbsdown_picturecomment`=" . $picturecomment['thumbsdown'] . ",
        `thumbsup_groupmessage`=" . $groupmessage['thumbsup'] . ",
        `thumbsdown_groupmessage`=" . $groupmessage['thumbsdown'] . ",
        `thumbsup_visitormessage`=" . $visitormessage['thumbsup'] . ",
        `thumbsdown_visitormessage`=" . $visitormessage['thumbsdown'] . ",
        `thumbsup_node`=" . $node['thumbsup'] . ",
        `thumbsdown_node`=" . $node['thumbsdown'] . ",
        `thumbsup_blog`=" . $blog['thumbsup'] . ",
        `thumbsdown_blog`=" . $blog['thumbsdown'] . ",                
        `thumbsup_total`=" . $total['thumbsup'] . ",
        `thumbsdown_total`=" . $total['thumbsdown'] . "
		 "); 

$vbulletin->db->free_result($post);      	  
$vbulletin->db->free_result($picture);
$vbulletin->db->free_result($picturecomment);
$vbulletin->db->free_result($groupmessage);
$vbulletin->db->free_result($visitormessage);
$vbulletin->db->free_result($node);
$vbulletin->db->free_result($blog);   
}

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminthreads'))
{
	print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['maintenance']);

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'recounters';
}

$vbulletin->input->clean_array_gpc('r', array(
	'perpage' => TYPE_UINT,
	'startat' => TYPE_UINT
));

// ################## RECOUNTERS PAGE ###############################
if ($_REQUEST['do'] == 'recounters')
{
	print_form_header('sc_thumbs_admin', 'sc_thumbs_sent');
	print_table_header($vbphrase['sc_thumbs_admin_sent'], 2, 0);
	print_description_row($vbphrase['sc_thumbs_admin_sent_help']);
	print_input_row($vbphrase['number_of_users_to_process_per_cycle'], 'perpage', 1000);
	print_submit_row($vbphrase['sc_thumbs_admin_update_amounts']);

	print_form_header('sc_thumbs_admin', 'sc_thumbs_received');
	print_table_header($vbphrase['sc_thumbs_admin_received'], 2, 0);
	print_description_row($vbphrase['sc_thumbs_admin_received_help']);
	print_input_row($vbphrase['number_of_users_to_process_per_cycle'], 'perpage', 1000);
	print_submit_row($vbphrase['sc_thumbs_admin_update_amounts']);
	
}

// ################## THUMBS EACH USER SENT ###############################
if ($_REQUEST['do'] == 'sc_thumbs_sent')
{
	if (empty($vbulletin->GPC['perpage']))
	{
		$vbulletin->GPC['perpage'] = 1000;
	}

	$finishat = $vbulletin->GPC['startat'] + $vbulletin->GPC['perpage'];

	echo '<p>' . $vbphrase['sc_thumbs_admin_sent'] . '</p>';

	$users = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "user
		WHERE userid >= " . $vbulletin->GPC['startat'] . " AND userid < $finishat
		ORDER BY userid
	");
  
	while ($user = $db->fetch_array($users))
	{
    if ($vbulletin->options['sc_thumbs_option_post']) {
     /// fetch for Posts
  		$post1 = $db->query_first("
  			SELECT COUNT(*) AS thumbsup 
        FROM " . TABLE_PREFIX . "sc_thumbs_post
  			WHERE userid = $user[userid] AND thumb = 1
  		");              
  		$post2 = $db->query_first("
  			SELECT COUNT(*) AS thumbsdown 
        FROM " . TABLE_PREFIX . "sc_thumbs_post
  			WHERE userid = $user[userid] AND thumb = -1
  		");
      
    }
        if (!($post1[thumbsup])){$post1[thumbsup] = 0;}
        if (!($post2[thumbsdown])){$post2[thumbsdown] = 0;}
   
   if ($vbulletin->options['sc_thumbs_option_picturecomment']) {     
     // fetch for Picturecomments     
  		$picturecomment1 = $db->query_first("
  			SELECT COUNT(*) AS thumbsup 
        FROM " . TABLE_PREFIX . "sc_thumbs_picturecomment
  			WHERE userid = $user[userid] AND thumb = 1
  		");
  		$picturecomment2 = $db->query_first("
  			SELECT COUNT(*) AS thumbsdown 
        FROM " . TABLE_PREFIX . "sc_thumbs_picturecomment
  			WHERE userid = $user[userid] AND thumb = -1
  		");
     }
       if (!($picturecomment1[thumbsup])){$picturecomment1[thumbsup] = 0;}
       if (!($picturecomment2[thumbsdown])){$picturecomment2[thumbsdown] = 0;}

   if ($vbulletin->options['sc_thumbs_option_visitormessage']) {
    // fetch for Visitormessages
  		$visitormessage1 = $db->query_first("
  			SELECT COUNT(*) AS thumbsup 
        FROM " . TABLE_PREFIX . "sc_thumbs_visitormessage
  			WHERE userid = $user[userid] AND thumb = 1
  		");
  		$visitormessage2 = $db->query_first("
  			SELECT COUNT(*) AS thumbsdown 
        FROM " . TABLE_PREFIX . "sc_thumbs_visitormessage
  			WHERE userid = $user[userid] AND thumb = -1
  		");
    }
       if (!($visitormessage1[thumbsup])){$visitormessage1[thumbsup] = 0;}
       if (!($visitormessage2[thumbsdown])){$visitormessage2[thumbsdown] = 0;}   
   
   if ($vbulletin->options['sc_thumbs_option_groupmessage']) {
   // fetch for Groupmessages
  		$groupmessage1 = $db->query_first("
  			SELECT COUNT(*) AS thumbsup 
        FROM " . TABLE_PREFIX . "sc_thumbs_groupmessage
  			WHERE userid = $user[userid] AND thumb = 1
  		");
  		$groupmessage2 = $db->query_first("
  			SELECT COUNT(*) AS thumbsdown 
        FROM " . TABLE_PREFIX . "sc_thumbs_groupmessage
  			WHERE userid = $user[userid] AND thumb = -1
  		");
    }
     if (!($groupmessage1[thumbsup])){$groupmessage1[thumbsup] = 0;}
     if (!($groupmessage2[thumbsdown])){$groupmessage2[thumbsdown] = 0;}   

   if ($vbulletin->options['sc_thumbs_option_picture']) {
   // fetch for Pictures
  		$picture1 = $db->query_first("
  			SELECT COUNT(*) AS thumbsup 
        FROM " . TABLE_PREFIX . "sc_thumbs_picture
  			WHERE userid = $user[userid] AND thumb = 1
  		");
  		$picture2 = $db->query_first("
  			SELECT COUNT(*) AS thumbsdown 
        FROM " . TABLE_PREFIX . "sc_thumbs_picture
  			WHERE userid = $user[userid] AND thumb = -1
  		");
    }
      if (!($picture1[thumbsup])){$picture1[thumbsup] = 0;}
      if (!($picture2[thumbsdown])){$picture2[thumbsdown] = 0;}   

   if ($vbulletin->options['sc_thumbs_option_node']) {
   // fetch for Articles
  		$node1 = $db->query_first("
  			SELECT COUNT(*) AS thumbsup 
        FROM " . TABLE_PREFIX . "sc_thumbs_node
  			WHERE userid = $user[userid] AND thumb = 1
  		");
  		$node2 = $db->query_first("
  			SELECT COUNT(*) AS thumbsdown 
        FROM " . TABLE_PREFIX . "sc_thumbs_node
  			WHERE userid = $user[userid] AND thumb = -1
  		");
    }
      if (!($node1[thumbsup])){$node1[thumbsup] = 0;}
      if (!($node2[thumbsdown])){$node2[thumbsdown] = 0;}  

   if ($vbulletin->options['sc_thumbs_option_blog']) {
   // fetch for Blogs
  		$blog1 = $db->query_first("
  			SELECT COUNT(*) AS thumbsup 
        FROM " . TABLE_PREFIX . "sc_thumbs_blog
  			WHERE userid = $user[userid] AND thumb = 1
  		");
  		$blog2 = $db->query_first("
  			SELECT COUNT(*) AS thumbsdown 
        FROM " . TABLE_PREFIX . "sc_thumbs_blog
  			WHERE userid = $user[userid] AND thumb = -1
  		");
    }
      if (!($blog1[thumbsup])){$blog1[thumbsup] = 0;}
      if (!($blog2[thumbsdown])){$blog2[thumbsdown] = 0;}          
   // TOTAL
   $total[thumbsup] = $post1[thumbsup] + $picturecomment1[thumbsup] + $visitormessage1[thumbsup] + $groupmessage1[thumbsup] + $picture1[thumbsup] + $node1[thumbsup] + $blog1[thumbsup];
   $total[thumbsdown] = $post2[thumbsdown] + $picturecomment2[thumbsdown] + $visitormessage2[thumbsdown] + $groupmessage2[thumbsdown] + $picture2[thumbsdown] + $node2[thumbsdown] + $blog2[thumbsdown]; 
   
   
   // write results to database             
		$db->query_write("
            UPDATE " . TABLE_PREFIX . "user
            SET sc_thumbs_up_gave = $total[thumbsup], sc_thumbs_down_gave = $total[thumbsdown]
            WHERE userid = $user[userid]
            ");

		echo construct_phrase($vbphrase['processing_x'], $user['userid']) . "<br />\n";
		vbflush();
	}

	if ($checkmore = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE userid >= $finishat LIMIT 1"))
	{
		print_cp_redirect("sc_thumbs_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=sc_thumbs_sent&startat=$finishat&pp=" . $vbulletin->GPC['perpage']);
		echo "<p><a href=\"sc_thumbs_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=sc_thumbs_sent&amp;startat=$finishat&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
	}
	else
	{
		define('CP_REDIRECT', 'sc_thumbs_admin.php');
		print_stop_message('sc_thumbs_updated_success');
	}
}


// ################## THUMBS EACH USER RECEIVED ###############################
if ($_REQUEST['do'] == 'sc_thumbs_received')
{
	if (empty($vbulletin->GPC['perpage']))
	{
		$vbulletin->GPC['perpage'] = 1000;
	}

	$finishat = $vbulletin->GPC['startat'] + $vbulletin->GPC['perpage'];

	echo '<p>' . $vbphrase['sc_thumbs_admin_received'] . '</p>';

	$users = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "user
		WHERE userid >= " . $vbulletin->GPC['startat'] . " AND userid < $finishat
		ORDER BY userid
	");
  
	while ($user = $db->fetch_array($users))
	{
    if ($vbulletin->options['sc_thumbs_option_post']) {
     /// fetch for Posts
  		$post1 = $db->query_first("
  			SELECT COUNT(*) AS thumbsup 
        FROM " . TABLE_PREFIX . "sc_thumbs_post
  			WHERE to_userid = $user[userid] AND thumb = 1
  		");              
  		$post2 = $db->query_first("
  			SELECT COUNT(*) AS thumbsdown 
        FROM " . TABLE_PREFIX . "sc_thumbs_post
  			WHERE to_userid = $user[userid] AND thumb = -1
  		");
      
    }
        if (!($post1[thumbsup])){$post1[thumbsup] = 0;}
        if (!($post2[thumbsdown])){$post2[thumbsdown] = 0;}
   
   if ($vbulletin->options['sc_thumbs_option_picturecomment']) {     
     // fetch for Picturecomments     
  		$picturecomment1 = $db->query_first("
  			SELECT COUNT(*) AS thumbsup 
        FROM " . TABLE_PREFIX . "sc_thumbs_picturecomment
  			WHERE to_userid = $user[userid] AND thumb = 1
  		");
  		$picturecomment2 = $db->query_first("
  			SELECT COUNT(*) AS thumbsdown 
        FROM " . TABLE_PREFIX . "sc_thumbs_picturecomment
  			WHERE to_userid = $user[userid] AND thumb = -1
  		");
     }
       if (!($picturecomment1[thumbsup])){$picturecomment1[thumbsup] = 0;}
       if (!($picturecomment2[thumbsdown])){$picturecomment2[thumbsdown] = 0;}

   if ($vbulletin->options['sc_thumbs_option_visitormessage']) {
    // fetch for Visitormessages
  		$visitormessage1 = $db->query_first("
  			SELECT COUNT(*) AS thumbsup 
        FROM " . TABLE_PREFIX . "sc_thumbs_visitormessage
  			WHERE to_userid = $user[userid] AND thumb = 1
  		");
  		$visitormessage2 = $db->query_first("
  			SELECT COUNT(*) AS thumbsdown 
        FROM " . TABLE_PREFIX . "sc_thumbs_visitormessage
  			WHERE to_userid = $user[userid] AND thumb = -1
  		");
    }
       if (!($visitormessage1[thumbsup])){$visitormessage1[thumbsup] = 0;}
       if (!($visitormessage2[thumbsdown])){$visitormessage2[thumbsdown] = 0;}   
   
   if ($vbulletin->options['sc_thumbs_option_groupmessage']) {
   // fetch for Groupmessages
  		$groupmessage1 = $db->query_first("
  			SELECT COUNT(*) AS thumbsup 
        FROM " . TABLE_PREFIX . "sc_thumbs_groupmessage
  			WHERE to_userid = $user[userid] AND thumb = 1
  		");
  		$groupmessage2 = $db->query_first("
  			SELECT COUNT(*) AS thumbsdown 
        FROM " . TABLE_PREFIX . "sc_thumbs_groupmessage
  			WHERE to_userid = $user[userid] AND thumb = -1
  		");
    }
     if (!($groupmessage1[thumbsup])){$groupmessage1[thumbsup] = 0;}
     if (!($groupmessage2[thumbsdown])){$groupmessage2[thumbsdown] = 0;}   

   if ($vbulletin->options['sc_thumbs_option_picture']) {
   // fetch for Pictures
  		$picture1 = $db->query_first("
  			SELECT COUNT(*) AS thumbsup 
        FROM " . TABLE_PREFIX . "sc_thumbs_picture
  			WHERE to_userid = $user[userid] AND thumb = 1
  		");
  		$picture2 = $db->query_first("
  			SELECT COUNT(*) AS thumbsdown 
        FROM " . TABLE_PREFIX . "sc_thumbs_picture
  			WHERE to_userid = $user[userid] AND thumb = -1
  		");
    }
      if (!($picture1[thumbsup])){$picture1[thumbsup] = 0;}
      if (!($picture2[thumbsdown])){$picture2[thumbsdown] = 0;}   

   if ($vbulletin->options['sc_thumbs_option_node']) {
   // fetch for Articles
  		$node1 = $db->query_first("
  			SELECT COUNT(*) AS thumbsup 
        FROM " . TABLE_PREFIX . "sc_thumbs_node
  			WHERE to_userid = $user[userid] AND thumb = 1
  		");
  		$node2 = $db->query_first("
  			SELECT COUNT(*) AS thumbsdown 
        FROM " . TABLE_PREFIX . "sc_thumbs_node
  			WHERE to_userid = $user[userid] AND thumb = -1
  		");
    }
      if (!($node1[thumbsup])){$node1[thumbsup] = 0;}
      if (!($node2[thumbsdown])){$node2[thumbsdown] = 0;}   

   if ($vbulletin->options['sc_thumbs_option_blog']) {
   // fetch for Blogs
  		$blog1 = $db->query_first("
  			SELECT COUNT(*) AS thumbsup 
        FROM " . TABLE_PREFIX . "sc_thumbs_blog
  			WHERE to_userid = $user[userid] AND thumb = 1
  		");
  		$blog2 = $db->query_first("
  			SELECT COUNT(*) AS thumbsdown 
        FROM " . TABLE_PREFIX . "sc_thumbs_blog
  			WHERE to_userid = $user[userid] AND thumb = -1
  		");
    }
      if (!($blog1[thumbsup])){$blog1[thumbsup] = 0;}
      if (!($blog2[thumbsdown])){$blog2[thumbsdown] = 0;} 
          
   // TOTAL
   $total[thumbsup] = $post1[thumbsup] + $picturecomment1[thumbsup] + $visitormessage1[thumbsup] + $groupmessage1[thumbsup] + $picture1[thumbsup] + $node1[thumbsup] + $blog1[thumbsup];
   $total[thumbsdown] = $post2[thumbsdown] + $picturecomment2[thumbsdown] + $visitormessage2[thumbsdown] + $groupmessage2[thumbsdown] + $picture2[thumbsdown] + $node2[thumbsdown] + $blog2[thumbsdown]; 
   
   // write results to database             
		$db->query_write("
            UPDATE " . TABLE_PREFIX . "user
            SET sc_thumbs_up_received = $total[thumbsup], sc_thumbs_down_received = $total[thumbsdown]
            WHERE userid = $user[userid]
            ");

		echo construct_phrase($vbphrase['processing_x'], $user['userid']) . "<br />\n";
		vbflush();
	}

	if ($checkmore = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE userid >= $finishat LIMIT 1"))
	{
		print_cp_redirect("sc_thumbs_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=sc_thumbs_received&startat=$finishat&pp=" . $vbulletin->GPC['perpage']);
		echo "<p><a href=\"sc_thumbs_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=sc_thumbs_received&amp;startat=$finishat&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
	}
	else
	{
		define('CP_REDIRECT', 'sc_thumbs_admin.php');
		print_stop_message('sc_thumbs_updated_success');
	}
}

if ($_REQUEST['do'] == 'special')
{
	print_form_header('sc_thumbs_admin', 'delete_all_users_thumbs');
	print_table_header($vbphrase['sc_thumbs_delete_all_users_thumbs'], 2, 0);
	print_description_row($vbphrase['sc_thumbs_delete_all_users_thumbs_help']);
	print_input_row($vbphrase['userid'], 'userid');
	print_submit_row($vbphrase['sc_thumbs_do_it']);

	print_form_header('sc_thumbs_admin', 'delete_content_thumbs');
	print_table_header($vbphrase['sc_thumbs_delete_all_contents_thumbs'], 2, 0);
	print_description_row($vbphrase['sc_thumbs_delete_all_contents_thumbs_help']);
	print_input_row($vbphrase['sc_thumbs_contentid'], 'contentid');
	$selectopts = array(
		'post' => $vbphrase['sc_thumbs_post'],
		'picture' => $vbphrase['sc_thumbs_picture'],
		'picturecomment' => $vbphrase['sc_thumbs_picturecomment'],
    'visitormessage' => $vbphrase['sc_thumbs_visitormessage'],
    'node' => $vbphrase['sc_thumbs_node'],
    'blog' => $vbphrase['sc_thumbs_blog'],
    'groupmessage' => $vbphrase['sc_thumbs_groupmessage'],
	);  
  print_select_row($vbphrase['sc_thumbs_contenttype'], 'contenttype', $selectopts);
	print_submit_row($vbphrase['sc_thumbs_do_it']);

	print_form_header('sc_thumbs_admin', 'rebuild_stats');
	print_table_header($vbphrase['sc_thumbs_rebuild_stats'], 2, 0);
	print_description_row($vbphrase['sc_thumbs_rebuild_stats_help']);
	print_submit_row($vbphrase['sc_thumbs_do_it']);
}

//
if ($_REQUEST['do'] == 'delete_content_thumbs')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'contentid' => TYPE_UINT,
    'contenttype' => TYPE_STR
	));

	$contentid = $vbulletin->GPC['contentid'];
  $contenttype = $vbulletin->GPC['contenttype'];
  
  switch ($contenttype) {
    case "post": $data_id = 'postid'; break;
    case "picturecomment": $data_id = 'commentid'; break;
    case "picture": $data_id = 'pictureid'; break;
    case "visitormessage": $data_id = 'vmid'; break;
    case "groupmessage": $data_id = 'gmid'; break;
    case "blog": $data_id = 'blogtextid'; break;
    case "node": $data_id = 'nodeid'; break;
  }
  
  admin_delete_all_contents_thumbs($contenttype, $contentid, $data_id);  
	echo '<p>' . $vbphrase['delete_content_thumbs'] . '</p>';
		echo construct_phrase($vbphrase['processing_x'], "$contenttype: $contentid") . "<br />\n";
		vbflush();

	define('CP_REDIRECT', 'sc_thumbs_admin.php?do=special');
	print_stop_message('sc_thumbs_updated_success');
}
//


if ($_REQUEST['do'] == 'delete_all_users_thumbs')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'userid' => TYPE_UINT
	));

	$userid = $vbulletin->GPC['userid'];
	echo '<p>' . $vbphrase['sc_thumbs_delete_all_users_thumbs'] . '</p>';

  admin_delete_all_users_thumbs('post', $userid);
  admin_delete_all_users_thumbs('picturecomment', $userid);
  admin_delete_all_users_thumbs('visitormessage', $userid);
  admin_delete_all_users_thumbs('groupmessage', $userid);
  admin_delete_all_users_thumbs('picture', $userid);
  admin_delete_all_users_thumbs('node', $userid);
  admin_delete_all_users_thumbs('blog', $userid);

		echo construct_phrase($vbphrase['processing_x'], $userid) . "<br />\n";
		vbflush();

	define('CP_REDIRECT', 'sc_thumbs_admin.php?do=special');
	print_stop_message('sc_thumbs_updated_success');
}

if ($_REQUEST['do'] == 'rebuild_stats')
{
    $phrase = 'Statistics';
    build_thumbs_stats();
        
		echo construct_phrase($vbphrase['processing_x'], $phrase) . "<br />\n";
		vbflush();

	define('CP_REDIRECT', 'sc_thumbs_admin.php?do=special');
	print_stop_message('sc_thumbs_updated_success');
}
print_cp_footer();
?>