<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package    alinks
 * @license    GPL
 * @version    $Id: statistics.php 42 2008-03-24 17:50:25Z sean $
 */
include($this->viewsDir . '/include.php');

$todayLong = date('F d Y') . ' 23:59';
$today = strtotime($todayLong);
$yesterday = $today - 86400;
$thirtyDaysAgo = $today - (86400 * 30);
$thisHour = time();
$pastHour = $thisHour - 3600;

// - Query for all the keyphrase clicks
$results = $this->Logger->query("SELECT * FROM alinks");

// - Find total number of clicks, which is the total number of results returned
$totalClicks = 0;
if (is_array($results) && !empty($results)) {
	$totalClicks = count($results);
}

// - Find the number of unique clicks
$totalUnique = 0;
if (is_array($results) && !empty($results)) {
	$foundIps = array();
	foreach ($results as $result) {
		$ip = $result['ip'];
		if (!in_array($ip, $foundIps)) {
			$totalUnqiue++;
			$foundIps[] = $ip;
		}
	}
}

// - Query the logs for clicks between yesterday and today
$result = $this->Logger->query("SELECT * FROM alinks WHERE timestamp <= '$today' AND timestamp > '$yesterday'");

// - Get total clicks for past 24 hours, which is the number of results returned
$totalClicksToday = 0;
if (is_array($result) && !empty($result)) {
	$totalClicksToday = count($result);
}

// - Query the log files for the past hour
$results = $this->Logger->query("SELECT * FROM alinks WHERE timestamp <= '$thisHour' AND timestamp > '$pastHour'");

// - Find the number of clicks in the past hour, and the number of unique clicks
$totalClicksThisHour = 0;
$totalUniqueHour = 0;
if (is_array($results) && !empty($results)) {
	$foundIps = array();
	$totalClicksThisHour = count($results);
	foreach ($results as $result) {
		$ip = $result['ip'];
		if (!in_array($ip, $foundIps)) {
			$totalUniqueHour++;
			$foundIps[] = $ip;
		}
	}
}

// - Finally query the log files for the past 30 days
$results = $this->Logger->query("SELECT * FROM alinks WHERE timestamp >= '$thirtyDaysAgo'");

// - Get the top 20 clicked keyphrases in the past 30 days
$topKeyphrases = array();
if (is_array($results) && !empty($results)) {
	foreach ($results as $result) {
		$keyphrase = $result['keyphrase'];
		if (!array_key_exists($keyphrase, $topKeyphrases)) {
			$topKeyphrases[$keyphrase] = 1;
		} else {
			$topKeyphrases[$keyphrase]++;
		}
		if (count($topKeyphrases) >= 20) break;
	}
	arsort($topKeyphrases);
}

// - Get all the keyphrases for the past 30 days
$allKeyphrases = array();
if (is_array($results) && !empty($results)) {
	foreach ($results as $result) {
		$keyphrase = $result['keyphrase'];
		if (!array_key_exists($keyphrase, $topKeyphrases)) {
			$allKeyphrases[$keyphrase] = 1;
		} else {
			$allKeyphrases[$keyphrase]++;
		}
	}
	arsort($allKeyphrases);
}

// - Get the number of clicks for the past hour, how many each hour, and how many unique
$hours = array();
$foundIps = array();
$totalUnqiue24Hour = 0;
$nHours = array();
if (is_array($results) && !empty($results)) {
	for ($i = 0; $i < 24; $i++) {
		foreach ($results as $result) {
			$first = $today - ($i * 3600);
			$second = $today - (($i + 1) * 3600);
			if ($result['timestamp'] <= $first && $result['timestamp'] > $second) {
				$hours[$i]++;
				$ip = $result['ip'];
				if (!in_array($ip, $foundIps)) {
					$totalUnqiue24Hour++;
					$foundIps[] = $ip;
				}
			}
		}
		if (empty($hours[$i])) $hours[$i] = 0;
	}
	
	$counter = 23;
	$totalClicksPast24 = 0;

	foreach ($hours as $hour) {
		$nHours['Clicks'][$counter] = $hour;
		$totalClicksPast24 += $hour;
		$counter--;
	}
}

// - Build graph data for the past 23 hours
$shourGraph = urlencode(serialize($nHours));
$hourTitle = 'Past 24 Hours';

// - Find number of clicks for the past week, how many clicks each day, and how many uniques
$days = array();
$foundIps = array();
$totalUnqiueWeek = 0;
if (is_array($results) && !empty($results)) {
	for ($i = 0; $i < 7; $i++) {
		foreach ($results as $result) {
			$first = $today - ($i * 86400);
			$second = $today - (($i + 1) * 86400);
			if ($result['timestamp'] <= $first && $result['timestamp'] > $second) {
				$days[$i]++;
				$ip = $result['ip'];
				if (!in_array($ip, $foundIps)) {
					$totalUnqiueWeek++;
					$foundIps[] = $ip;
				}
			}
		}
		if (empty($days[$i])) $days[$i] = 0;
	}
}

// - Total clicks for the past week
$totalClicksPastWeek = 0;
foreach ($days as $day) {
	$totalClicksPastWeek += $day;
}

// - Graph data for the past week
$weekGraph = array('Clicks' => $days);
$sWeekGraph = urlencode(serialize($weekGraph));
$weekTitle = 'Past 7 Days';

// - Find out how many clicks for the past month, how many each day, and how many uniques
$months = array();
$foundIps = array();
$totalUniqueMonth = 0;
if (is_array($results) && !empty($results)) {
	for ($i = 0; $i < 31; $i++) {
		foreach ($results as $result) {
			$first = $today - ($i * 86400);
			$second = $today - (($i + 1) * 86400);
			if ($result['timestamp'] <= $first && $result['timestamp'] > $second) {
				$months[$i]++;
				$ip = $result['ip'];
				if (!in_array($ip, $foundIps)) {
					$totalUniqueMonth++;
					$foundIps[] = $ip;
				}
			}
		}
		if (empty($months[$i])) $months[$i] = 0;
	}
}

// - Total clicks for the past month
$totalClicksPastMonth = 0;
foreach ($months as $month) {
	$totalClicksPastMonth += $month;
}

// - Graph data for the past month
$monthGraph = array('Clicks' => $months);
$sMonthGraph = urlencode(serialize($monthGraph));
$monthTitle = 'Past 30 Days';

?>
<div class="wrap">
<h2><?php echo $this->alinksLang->_('Statistics'); ?></h2>
<?php
if ($queryResults = $this->Model->getLastLogQuery()) {
	$queryHtml = $this->Model->getLastLogQueryHtml();
	echo $queryHtml;
} else {
	?>

	<div id="graphsbox">
		<div class="dbx-group" id="keyphrase-tools">
		
			<div id="summery" class="dbx-box">
				<h3 class="dbx-handle"><?php echo $this->alinksLang->_('Summery'); ?></h3>
				<div class="dbx-content">
					<table style="width: 100%;">
					<tr style="background-color: #FFF;">
					<td><strong><?php echo $this->alinksLang->_('Total Clicks'); ?></strong></td><td><?php echo $totalClicks; ?></td>
					</tr>
					<tr style="background-color: #EEE;">
					<td><strong><?php echo $this->alinksLang->_('Total Unique Clicks'); ?></strong></td><td><?php echo $totalUnqiue; ?></td>
					</tr>
					<tr style="background-color: #FFF;">
					<td><strong><?php echo $this->alinksLang->_('Total Clicks in the Past Hour'); ?></strong></td><td><?php echo $totalClicksThisHour; ?></td>
					</tr>
					<tr style="background-color: #EEE;">
					<td><strong><?php echo $this->alinksLang->_('Total Unique Clicks in the Past Hour'); ?></strong></td><td><?php echo $totalUniqueHour; ?></td>
					</tr>
					<tr style="background-color: #FFF;">
					<td><strong><?php echo $this->alinksLang->_('Total Clicks in the Past 24 Hours'); ?></strong></td><td><?php echo $totalClicksPast24; ?></td>
					</tr>
					<tr style="background-color: #EEE;">
					<td><strong><?php echo $this->alinksLang->_('Total Unique Clicks in the Past 24 Hours'); ?></strong></td><td><?php echo $totalUnqiue24Hour; ?></td>
					</tr>
					<tr style="background-color: #FFF;">
					<td><strong><?php echo $this->alinksLang->_('Total Clicks in the Past Week'); ?></strong></td><td><?php echo $totalClicksPastWeek; ?></td>
					</tr>
					<tr style="background-color: #EEE;">
					<td><strong><?php echo $this->alinksLang->_('Total Unique Clicks in the Past Week'); ?></strong></td><td><?php echo $totalUnqiueWeek; ?></td>
					</tr>
					<tr style="background-color: #FFF;">
					<td><strong><?php echo $this->alinksLang->_('Total Clicks in the Past Month'); ?></strong></td><td><?php echo $totalClicksPastMonth; ?></td>
					</tr>
					<tr style="background-color: #EEE;">
					<td><strong><?php echo $this->alinksLang->_('Total Unique Clicks in the Past Month'); ?></strong></td><td><?php echo $totalUniqueMonth; ?></td>
					</tr>
					</table>
				</div>
			</div>
			
			<div id="topkeyphrases" class="dbx-box">
				<h3 class="dbx-handle"><?php echo $this->alinksLang->_('Top 20 Keyphrases in the Past 30 Days'); ?></h3>
				<div class="dbx-content">
					<?php
					if ($topKeyphrases) {
						$counter = 0;
						echo "<table style='width: 100%;'>\r\n";
						echo "<tr><td><strong>" . $this->alinksLang->_('Keyphrase') . "</strong></td><td><strong>" . $this->alinksLang->_('Clicks') . "</strong></td></tr>\r\n";
						foreach($topKeyphrases as $keyphrase => $clicks) {
							if ($counter & 1) {
								$color = "#EEE;";
							} else {
								$color = "#FFF;";
							}
							echo "<tr style='background-color: $color'><td>$keyphrase</td><td>$clicks</td></tr>\r\n";
							$counter++;
						}
						echo "</table>\r\n";
					}
					?>
				</div>
			</div>
			
			<div id="allkeyphrases" class="dbx-box">
				<h3 class="dbx-handle"><?php echo $this->alinksLang->_('All Keyphrases in the Past 30 Days'); ?></h3>
				<div class="dbx-content">
					<div style="height: 200px; overflow: scroll;">
						<?php
						if ($allKeyphrases) {
							$counter = 0;
							echo "<table style='width: 100%;'>\r\n";
							echo "<tr><td><strong>" . $this->alinksLang->_('Keyphrase') . "</strong></td><td><strong>" . $this->alinksLang->_('Clicks') . "</strong></td></tr>\r\n";
							foreach($allKeyphrases as $keyphrase => $clicks) {
								if ($counter & 1) {
									$color = "#EEE;";
								} else {
									$color = "#FFF;";
								}
								echo "<tr style='background-color: $color'><td>$keyphrase</td><td>$clicks</td></tr>\r\n";
								$counter++;
							}
							echo "</table>\r\n";
						}
						?>
					</div>
				</div>
			</div>
			
			<div id="past24" class="dbx-box">
				<h3 class="dbx-handle"><?php echo $this->alinksLang->_('Past 24 Hours'); ?></h3>
				<div class="dbx-content">
					<img src="<?php echo $this->Model->alinks_classes_url; ?>/aLinksGraph.php?graphdata=<?php echo $shourGraph; ?>&title=<?php echo $hourTitle; ?>&graphmethod=24hourdistribution&scalelabel=Clicks" />
				</div>
			</div>
			
			<div id="past7" class="dbx-box">
				<h3 class="dbx-handle"><?php echo $this->alinksLang->_('Past 7 Days'); ?></h3>
				<div class="dbx-content">
					<img src="<?php echo $this->Model->alinks_classes_url; ?>/aLinksGraph.php?graphdata=<?php echo $sWeekGraph; ?>&title=<?php echo $weekTitle; ?>&graphmethod=pastxdays&scalelabel=Clicks" />
				</div>
			</div>
			
			<div id="past30" class="dbx-box">
				<h3 class="dbx-handle"><?php echo $this->alinksLang->_('Past 30 Days'); ?></h3>
				<div class="dbx-content">
					<img src="<?php echo $this->Model->alinks_classes_url; ?>/aLinksGraph.php?graphdata=<?php echo $sMonthGraph; ?>&title=<?php echo $monthTitle; ?>&graphmethod=pastxdays&scalelabel=Clicks" />
				</div>
			</div>
			
		</div>
	</div>
	<?php
}
?>
<form method="post">
<p><strong><?php echo $this->alinksLang->_('Query the log files'); ?>:</strong> <img src="<?php echo ALINKS_URL; ?>/images/help_s.png" alt="Help" class="alinks_helpicon" style="border: 0px; margin-left: 5px;" onclick="al_help('statistics-query');"/></p>
<input type="hidden" name="alinks_action" value="query" />
<textarea name="query" style="width: 100%;" rows="3"></textarea>
<p class="submit"><input type="submit" value="<?php echo $this->alinksLang->_('Submit Query'); ?> &raquo;" /></p>
</form>
</div>