<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package    alinks
 * @license    GPL
 * @version    $Id: aLinksXmlrpc.php 44 2008-03-24 18:00:53Z sean $
 */
/**
 * aLinks XML-RPC class
 *
 * Handles aLinks XML-RPC services
 */
class aLinksXmlrpc {

	/**
	 * The aLinksModel class object.
	 * @var obj
	 */
	var $alinksModel;
	
	/**
	 * Class constructor
	 *
	 * @param	obj	$alinksModel	The aLinksModel class object
	 * @return	void
	 */
	function aLinksXmlrpc(&$alinksModel) {
		$this->alinksModel = &$alinksModel;
	}
	
	/**
	 * Adds XML-RPC methods to WordPress's list of methods
	 *
	 * Adds aLinks XML-RPC methods to WordPress's list of XML-RPC methods so they can
	 * be called via WordPress's xmlrpc.php script.  This method shouldn't be called
	 * directly.  It's used with the add_filter() function.
	 *
	 * @param	array	$wp_methods	The array of WordPress's XML-RPC methods
	 * @return	array
	 */
	function addXmlRpc($wp_methods) {
		$methods = array	(
						'alinks.ping' => 				array(&$this, 'ping'),
						'alinks.getKeyphrases' => 		array(&$this, 'getKeyphrases'),
						'alinks.getKeyphraseById' => 	array(&$this, 'getKeyphraseById'),
						'alinks.getModuleType' => 		array(&$this, 'getModuleType'),
						'alinks.newKeyphrase' => 		array(&$this, 'newKeyphrase'),
						'alinks.updateKeyphrase' => 	array(&$this, 'updateKeyphrase'),
						'alinks.deleteKeyphrase' => 	array(&$this, 'deleteKeyphrase'),
						'alinks.queryLogs' => 			array(&$this, 'queryLogs')
						);
		return array_merge($wp_methods, $methods);
	}
	
	/**
	 * Delets a keyphrase by ID
	 *
	 * Will delete the keyphrase that has the given ID
	 */
	function deleteKeyphrase($args) {
		if (!$this->checkUnPw($args[0], $args[1])) {
			return new IXR_Error(403, 'Bad login/pass combination.');
		}
		return $this->alinksModel->deleteKeyphrase($args[2]);
	}
	
	/**
	 * Updates a keyphrase by ID
	 *
	 * Will update a keyphrase's data for the given ID
	 */
	function updateKeyphrase($args) {
		if (!$this->checkUnPw($args[0], $args[1])) {
			return new IXR_Error(403, 'Bad login/pass combination.');
		}
		return $this->alinksModel->updateKeyphrase($args[2], $args[3], $args[4], $args[5]);
	}
	
	/**
	 * Adds a new keyphrase
	 *
	 * Adds a new keyphrase to the users keyphrase list.
	 */
	function newKeyphrase($args) {
		if (!$this->checkUnPw($args[0], $args[1])) {
			return new IXR_Error(403, 'Bad login/pass combination.');
		}
		return $this->alinksModel->newKeyphrase($args[2], $args[3], $args[4], $args[5]);
	}
	
	/**
	 * Gets the module type used by a keyphrase
	 *
	 * Given the ID of a keyphrase, returns the module that keyphrase is using.
	 */
	function getModuleType($args) {
		if (!$this->checkUnPw($args[0], $args[1])) {
			return new IXR_Error(403, 'Bad login/pass combination.');
		}
		return $this->alinksModel->getModuleType($args[2]);
	}
	
	/**
	 * Returns a keyphrase's data for a given ID
	 *
	 * Returns the data for the keyphrase that has the given ID
	 */
	function getKeyphraseById($args) {
		if (!$this->checkUnPw($args[0], $args[1])) {
			return new IXR_Error(403, 'Bad login/pass combination.');
		}
		return $this->alinksModel->getKeyphraseById($args[2]);
	}
	
	/**
	 * Returns all defined keyphrases
	 *
	 * Returns all the keyphrases and their data that have been defined
	 */
	function getKeyphrases($args) {
		if (!$this->checkUnPw($args[0], $args[1])) {
			return new IXR_Error(403, 'Bad login/pass combination.');
		}
		return $this->alinksModel->getKeyphraseList();
	}
	
	/**
	 * Returns log file query results for the given query
	 *
	 * Returns the results for a given query.
	 */
	function queryLogs($args) {
		if (!$this->checkUnPw($args[0], $args[1])) {
			return new IXR_Error(403, 'Bad login/pass combination.');
		}
		$alinksLogger = new aLinksLogger(ALINKS_LOG_PATH);
		return $alinksLogger->query($args[2]);
	}
	
	/**
	 * Pings the aLinks XML-RPC server.
	 */
	function ping($args) {
		return 'pong';
	}
	
	/**
	 * Checks if a user's username and password is valid
	 */
	function checkUnPw($username, $password) {
		return $this->alinksModel->checkUnPw($username, $password);
	}
}