<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package   alinks
 * @license   GPL
 * @version   $Id: aLinksForms.php 44 2008-03-24 18:00:53Z sean $
 */
/**
 * aLinks forms class
 *
 * Used to general form elements from PHP arrays describing the form.  Those PHP arrays
 * generally come from the module XML files.
 */
class aLinksForms {

	/**
	 * The generated form HTML.
	 * @var string
	 */
	var $html;
	
	/**
	 * Sets the array to use to generate the form
	 *
	 * This method should be called before the get() or show() methods.  This method actually
	 * builds the form HTML and stores it in the $html property, which is used by the get()
	 * and show() methods.  Returns TRUE if the form was created, or FALSE on failure.
	 *
	 * @param	array	$define		The array of form input instructions
	 * @param	mixed	$value		The value to give to the generated input element
	 * @param	string	$frame		The browser frame to use for some JavaScript bits
	 * @param	bool		$useTable	Should the form elements be inside table cells
	 * @return	bool
	 */
	function set($define, $value = null, $frame = '', $useTable = false) {

		if (!is_array($define) || empty($define['label']) || empty($define['input'])) {
			return false;
		}

		switch ($define['input']['type']) {
			case 'text':
				if ($useTable) {
					$this->html = "<tr valign=\"top\">\r\n<th scope=\"row\">{$define['label']}:</th>\r\n";
					$this->html .= '<td>' . $this->makeText($define['input'], $value, $frame) . "</td>\r\n</tr>\r\n";
				} else {
					$this->html = '<p><strong>' . $define['label'] . ':</strong> ' . $this->makeText($define['input'], $value, $frame) . '</p>';
				}
				break;
			case 'select':
				if ($useTable) {
					$this->html = "<tr valign=\"top\">\r\n<th scope=\"row\">{$define['label']}:</th>\r\n";
					$this->html .= '<td>' . $this->makeSelect($define['input'], $define['option'], $value, $frame) . "</td>\r\n</tr>\r\n";
				} else {
					$this->html = '<p><strong>' . $define['label'] . ':</strong> ' . $this->makeSelect($define['input'], $define['option'], $value, $frame) . '</p>';
				}
				break;
			case 'checkbox':
				if ($useTable) {
					$this->html = "<tr valign=\"top\">\r\n<th scope=\"row\">{$define['label']}:</th>\r\n";
					$this->html .= '<td>' . $this->makeCheckbox($define['input'], $value, $frame) . "</td>\r\n</tr>\r\n";
				} else {
					$this->html = '<p><strong>' . $define['label'] . ':</strong> ' . $this->makeCheckbox($define['input'], $value, $frame) . '</p>';
				}
				break;
		}
		return true;
	}
	
	/**
	 * Creates a checkbox element
	 *
	 * Generates the HTML for a checkbox, and returns it.
	 *
	 * @param	array	$input		Array with instructions for building the element
	 * @param	mixed	$userValue	Value to be used in the element
	 * @param	string	$frame		The browser frame to use for some JavaScript bits
	 * @return	string
	 */
	function makeCheckbox($input, $userValue = null, $frame = '') {
		$name = $input['name'];
		if ($value) {
			$userValue = 'checked="checked"';
		}
		
		if (!empty($input['value'])) {
			$value = 'checked="checked"';
		} else {
			$value = '';
		}
		
		if ($userValue) {
			$value = 'checked="checked"';
		}
		
		$html = '<input type="checkbox" name="' . $name . '" ' . $value . ' onfocus="' . $frame . 'currentElement = this;"/>';
		return $html;
	}
	
	/**
	 * Creates a text element
	 *
	 * Generates the HTML for a text, and returns it.
	 *
	 * @param	array	$input		Array with instructions for building the element
	 * @param	mixed	$userValue	Value to be used in the element
	 * @param	string	$frame		The browser frame to use for some JavaScript bits
	 * @return	string
	 */
	function makeText($input, $userValue = null, $frame = '') {
		$name = $input['name'];
		if (!empty($input['size'])) {
			$size = $input['size'];
		} else {
			$size = "30";
		}
		if (!empty($input['value'])) {
			$value = $input['value'];
		} else {
			$value = '';
		}
		
		if ($userValue) {
			$value = $userValue;
		}
		
		$html = '<input type="text" name="' . $name . '" size="' . $size . '" value="' . $value . '" onfocus="' . $frame . 'currentElement = this;"/>';
		return $html;
	}
	
	/**
	 * Creates a select dropdown menu element
	 *
	 * Generates the HTML for a select dropdown menu, and returns it.
	 *
	 * @param	array	$input		Array with instructions for building the element
	 * @param	array	$options		Array of options for the select menu
	 * @param	mixed	$userValue	Value to be used in the element
	 * @param	string	$frame		The browser frame to use for some JavaScript bits
	 * @return	string
	 */
	function makeSelect($input, $options, $userValue = null, $frame = '') {
		$name = $input['name'];
		$value = $input['value'];
		
		$html = '<select name="' . $name . '" onfocus="' . $frame . 'currentElement = this;">';
		foreach ($options as $option) {
			$html .= '<option value="' . $option['value'] . '"';
			
			if ($value == $option['value'] && !$userValue) {
				$html .= ' selected="selected"';
			}
			
			if (!empty($userValue) && $userValue == $option['value']) {
				$html .= ' selected="selected"';
			}
			
			$html .= '>' . $option['label'] . '</option>';
		}
		$html .= '</select>';
		return $html;
	}
	
	/**
	 * Returns the generated form HTML
	 *
	 * @return	string
	 */
	function get() {
		return $this->html;
	}
	
	/**
	 * Displays the generated form HTML.
	 *
	 * @return	void
	 */
	function show() {
		echo $this->html;
	}
}