<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package    alinks
 * @license    GPL
 * @version    $Id: aLinksController.php 44 2008-03-24 18:00:53Z sean $
 */
/**
 * aLinks controller class
 *
 * This is the main controller class used by aLinks.
 */
class aLinksController extends aLinksApp {

	/**
	 * An array of views that have been created by
	 * the controller.
	 * @var array
	 */
	var $views;
	
	/**
	 * The aLinksLang object to translate strings.
	 * @var obj
	 */
	var $alinksLang;
	
	/**
	 * The aLinksModel class object.
	 * @var obj
	 */
	var $alinksModel;
	
	/**
	 * Is the extra html, link image string, etc
	 * already set.
	 * @var bool
	 */
	var $theContentSet = false;
	
	/**
	 * Array of found keyphrases for each post.
	 * @var array
	 */
	var $keyphrasesFound = array();
	
	/**
	 * Class constructor
	 *
	 * @param	obj	$alinksModel		The aLinksModel class object
	 * @param	obj	$alinksStruct		The aLinksStruct class object
	 * @return	void
	 */
	function aLinksController(&$alinksModel, &$alinksStruct) {

		$this->extractTo($this, $alinksStruct->getAll());
		$this->alinksLang = 		& new aLinksLang($this->alinks_languages_path);
		$this->alinksModel = 		& $alinksModel;
		$this->alinksXmlrpc = 		& new aLinksXmlrpc($this->alinksModel);
		$this->keyphrases = 		$this->alinksModel->getKeyphraseList(null, true);
		$this->alinksModules = 	& new aLinksModules;
		$this->modules = 			$this->alinksModules->getModules();
		$this->settings = 		$this->alinksModel->getAllSettings();
		
		add_action('wp_head', 			array(&$this, 'wpHead'));
		add_filter('xmlrpc_methods', 	array(&$this->alinksXmlrpc, 'addXmlRpc'));
		add_filter('the_content', 		array(&$this, 'theContent'), 1);
		
		$this->Dashboard = 	& aLinksView::create	(
											1, 
											$this->alinks_views, 
											$this->alinks_classes_path, 
											'dashboard',
											$this->alinksLang->_('aLinks'), 
											$this->alinksLang->_('aLinks'), 
											$this, $this->alinksLang,
											$this->alinksModel
												);
			
		$this->Settings = 	& aLinksView::create	(
											0, 
											$this->alinks_views,
											$this->alinks_classes_path, 
											'settings', 
											$this->alinksLang->_('aLinks Settings'), 
											$this->alinksLang->_('Settings'), 
											$this, $this->alinksLang,
											$this->alinksModel
												);
			
		$this->Keyphrases = 	& aLinksView::create	(
											0, 
											$this->alinks_views, 
											$this->alinks_classes_path, 
											'keyphrases', 
											$this->alinksLang->_('aLinks Keyphrases'), 
											$this->alinksLang->_('Keyphrases'), 
											$this, 
											$this->alinksLang,
											$this->alinksModel
												);
			
		$this->Stats =		& aLinksView::create	(
											0, 
											$this->alinks_views,
											$this->alinks_classes_path, 
											'statistics', 
											$this->alinksLang->_('aLinks Statistics'), 
											$this->alinksLang->_('Statistics'), 
											$this, 
											$this->alinksLang,
											$this->alinksModel
												);
			
		$this->Modules = 		& aLinksView::create	(
											0, 
											$this->alinks_views, 
											$this->alinks_classes_path, 
											'modules', 
											$this->alinksLang->_('aLinks Modules'), 
											$this->alinksLang->_('Modules'), 
											$this, 
											$this->alinksLang,
											$this->alinksModel
												);
			
		$this->ImportExport = 	& aLinksView::create	(
											0, 
											$this->alinks_views, 
											$this->alinks_classes_path, 
											'importexport',
											$this->alinksLang->_('aLinks Import / Export'), 
											$this->alinksLang->_('Import / Export'), 
											$this, 
											$this->alinksLang,
											$this->alinksModel
												);
			
		$this->Help = 		& aLinksView::create	(
											0, 
											$this->alinks_views, 
											$this->alinks_classes_path, 
											'help', 
											$this->alinksLang->_('aLinks Help'), 
											$this->alinksLang->_('Help'), 
											$this, 
											$this->alinksLang,
											$this->alinksModel
												);
	}
	
	/**
	 * Adds JavaScript to the main document head
	 *
	 * Adds the JavaScript needed for click tracking, to the head of the main
	 * document.
	 *
	 * @return	void
	 */
	function wpHead() {
		$this->notifyObjects('aLinksController::wpHead', 'WP-Head-Started');
		if ($this->settings['clicktracking'] || $this->settings['newwindow']) {
			if (!$this->settings['clicktracking']) {
				?>
				<script type="text/javascript">
					function alinks_click(link) {
						<?php
						if ($this->settings['newwindow']) {
							echo "link.target = '_blank';\r\n";
						}
						?>
						return true;
					}
				</script>
				<?php
			} else {
				?>
				<script type="text/javascript">
					var alinks_link;
					var trackImage = new Image();
					function alinks_click(link) {
						var keyphrase = link.innerHTML;
						trackImage.src = '<?php echo $this->alinks_classes_url; ?>/aLinksAjax.php?log=' + keyphrase;
						<?php
						if ($this->settings['newwindow']) {
							echo "link.target = '_blank';\r\n";
						}
						?>
						pause(1000);
						return true;
					}
						
					function pause(numberMillis) {
					    var now = new Date();
					    var exitTime = now.getTime() + numberMillis;
					    while (true) {
							now = new Date();
							if (now.getTime() > exitTime) return;
						}
					}
				</script>
				<?php
			}
		}
		$this->notifyObjects('aLinksController::wpHead', 'WP-Head-Finished');
	}
	
	/**
	 * Lets a created view object register itself with the controller
	 *
	 * Whenever a new view object is created, the objects constructor will call this method
	 * which "registers" the view object with the controller.  This way the controller always
	 * knows which views are created.
	 *
	 * @param	array	$view	Array of information about the view being registered
	 * @return	void
	 */
	function registerView($view) {
		$this->views[$view['view']] = $view['obj'];
		$this->notifyObjects('aLinksController::registerView', 'View-Registered::' . $view['view']);
	}
	
	/**
	 * Sets content values
	 *
	 * Content values are the bits for extra HTML, the external link icon, etc.  These values
	 * should be set once instead of each time a post is parsed.  Returns if the values
	 * are already set.
	 *
	 * @return	void
	 */
	function setTheContentValues() {

		if ($this->theContentSet) return;
		
		if (empty($this->settings['maxlinks'])) {
			$this->maxLinks = -1;
		} else {
			$this->maxLinks = $this->settings['maxlinks'];
		}
		
		if (empty($this->settings['casesensitive'])) {
			$this->caseSensitive = 'i';
		} else {
			$this->caseSensitive = '';
		}
		
		$this->extraHtml = '';
		
		if (!empty($this->settings['cssclass'])) {
			$this->extraHtml .= ' class="' . $this->settings['cssclass'] . '"';
		}
		
		if (!empty($this->settings['customhtmljs'])) {
			$this->extraHtml .= ' ' . $this->settings['customhtmljs'];
		}
		
		if (!empty($this->settings['clicktracking']) || !empty($this->settings['newwindow'])) {
			$this->extraHtml .= ' onclick="return alinks_click(this);"';
		}
		
		if (!empty($this->settings['linkimage'])) {
			$this->imageHtml = ' style="padding-right: 13px; background: url(' . $this->settings['linkimage'] . ') center right no-repeat;"';
		}
		$this->theContentSet = true;
		$this->notifyObjects('aLinksController::setTheContentValues', 'Content-Set');
	}
	
	/**
	 * The heart of aLinks, this method linkifies the keyphrases in a post
	 *
	 * This method is called for each post by the add_filter('the_content') filter.  This method
	 * is the *main* method in aLinks, as it does the actual keyphrase linking.  Returns the
	 * content of the post with keyphrases linkified.
	 *
	 * @param	string	$content	The post content
	 * @return	string
	 */
	function theContent($content) {
		global $post;
		
		$this->setTheContentValues();
		if (!$this->modules) {
			return $content;
		}
		
		$foundKeyphrases = array();
		
		if (empty($this->keyphrases)) {
			return $content;
		}
		
		/** Loop through each keyphrase, looking for each one in the post */
		foreach ($this->keyphrases as $keyphrase) {
			
			if (stristr($keyphrase['keyphrase'], '&#')) {
				$seemsUTF8 = true;
				$keyphrase['keyphrase'] = encodeUtfEnt($keyphrase['keyphrase']);
			} else {
				$seemsUTF8 = false;
				$keyphrase['keyphrase'] = utf8_encode($keyphrase['keyphrase']);
			}

			if(get_magic_quotes_gpc() || get_magic_quotes_runtime()) {
				$keyphrase['keyphrase'] = stripslashes($keyphrase['keyphrase']);
			}
			
			/** Skip the rest if the keyphrase isn't even in the post */
			if (!stristr($content, $keyphrase['keyphrase'])) {
				continue;
			}

			if (isset($foundKeyphrases[$keyphrase['keyphrase']])) {
				$foundKeyphrases[$keyphrase['keyphrase']]++;
			} else {
				$foundKeyphrases[$keyphrase['keyphrase']] = 1;
			}
			
			if ($foundKeyphrases[$keyphrase['keyphrase']] > ($this->maxLinks + 1) && $this->maxLinks != -1) {
				continue;
			}

			/** Find the module needed for this particular keyphrase */
			$mod = strtolower($keyphrase['module']);
			$obj = &$this->modules[$mod]['obj'];

			if (!is_object($obj)) {
				continue;
			}
			
			$obj->setExtraHtml($this->extraHtml);
			$obj->setImageHtml($this->imageHtml);
			$obj->setSettings($this->settings);
			$obj->setDatabase($this->alinksModel->wpdb, $this->alinksModel->table_prefix);
			$obj->setRealKeyphrase($keyphrase['keyphrase']);
			$name = strtolower($obj->getName());
			
			$obj->setOptions(get_option('alinks_mod_' . $name));
			
			$defines = $keyphrase['defines'];
			$defines = unserialize($defines);

			if (!$obj->checkAll($defines)) {
				continue;
			}

			$this->keyphrasesFound[$post->ID][] = array('keyphrase' => $keyphrase['keyphrase'], 'obj' => &$obj);
			
			/** Build patterns and replacements for the regexp coming later */
			if ($seemsUTF8) {
				// Unicode doesn't like the word boundry `\b` modifier, so can't use that
				$patterns[] = '~(?!((<.*?)|(<a.*?)))('. $keyphrase['keyphrase'] . ')(?!(([^<>]*?)>)|([^>]*?</a>))~s' . $this->caseSensitive;
			} else {
				$patterns[] = '~(?!((<.*?)|(<a.*?)))(\b'. $keyphrase['keyphrase'] . '\b)(?!(([^<>]*?)>)|([^>]*?</a>))~s' . $this->caseSensitive;
			}
			$replacements[] = $obj->doPhrase($post, '\4', $keyphrase['description'], $defines);

		}
		
		if (!empty($replacements)) {
			$content = preg_replace($patterns, $replacements, $content, 1);
		}
		$this->notifyObjects('aLinksController::theContent', 'Content-Parsed::' . $post->ID);
		return $content;
	}
}