<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package    alinks
 * @license    GPL
 * @version    $Id: aLinksApp.php 44 2008-03-24 18:00:53Z sean $
 */
/**
 * aLinks app class
 *
 * Parent class that has commonly used methods.
 */
class aLinksApp {

	/**
	 * Array of objects that want to be notified
	 * of an event.
	 * @var array
	 */
	var $notifyObjs = array();
	
	/**
	 * Extracts an array into a class property
	 *
	 * Similar to PHP's extract() function, but this one puts the extracted variables
	 * into the local scope of a class, as class properties.
	 *
	 * @param	obj		$to		The object to extract the properties to
	 * @param	array	$data	The array of values
	 * @return	void
	 */
	function extractTo(&$to, $data) {
		foreach ($data as $key => $value) {
			$to->$key = $value;
		}
	}
	
	/**
	 * Adds a message to the message "queue"
	 *
	 * Adds a message to the $_SESSION variable to be displayed in WordPress's admin
	 * panel using that fading message box thing.  The session variable is used so that
	 * messages will get passed to other methods in the package even after a redirect
	 * or some similar type of action.
	 * Returns FALSE if there are no sessions started, and TRUE if the message was successfully
	 * added.
	 *
	 * @param	string	$message	The message to display
	 * @param	bool		$warning	Set to TRUE if this is a warning message that should be
	 *							displayed in red.
	 * @param	bool
	 */
	function addSessionMessage($message, $warning = false) {

		if (!isset($_SESSION)) {
			return false;
		}

		if (!empty($_SESSION['alinks_messages'])) {
			$oldMessages = $_SESSION['alinks_messages'];
			$oldMessages = unserialize($oldMessages);
		} else {
			$oldMessages = array();
		}
		if ($warning == true) {
			$warning = '1';
		}
		$newMessage = array('message' => $message, 'warning' => $warning);
		$oldMessages[] = $newMessage;
		$nArray = serialize($oldMessages);
		$_SESSION['alinks_messages'] = $nArray;
		return true;
	}
	
	/**
	 * Display any messages in the message "queue"
	 *
	 * If there are any messages in waiting to be displayed, this method will display
	 * them using WordPress's fading message box.  Messages are stored in session variables.
	 * Returns FALSE if there is no session, if the "wait" element is set, or if there are
	 * no messages to be displayed.  Returns TRUE if messages are displayed.
	 * This method can be called staticly using aLinksController::showSessionMessages().
	 *
	 * @return	bool
	 */
	function showSessionMessages() {
		if (!isset($_SESSION)) {
			return false;
		}
		
		if (!empty($_SESSION['alinks_wait'])) {
			unset($_SESSION['alinks_wait']);
			return false;
		}
		if (empty($_SESSION['alinks_messages'])) {
			return false;
		}
		$oldMessages = $_SESSION['alinks_messages'];
		$messages = unserialize($oldMessages);

		for ($i = 0; $i < count($messages); $i++) {
			if ($messages[$i]['warning']) {
				echo '<div id="message" class="updated fade-ff0000"><p><strong>' . $messages[$i]['message'] . '</strong></p></div>';
			} else {
				echo '<div id="message" class="updated fade"><p><strong>' . $messages[$i]['message'] . '</strong></p></div>';
			}
		}
		unset($_SESSION['alinks_messages']);
		return true;
	}
	
	/**
	 * Adds an instruction to redirect URLs in the sessions variable
	 *
	 * Adds an instruction to the sessions variable, which tells aLinks to redirect to
	 * another URL.  This method also sets the "wait" element in the sessions variable.  The
	 * wait element tells other methods that store and retrieve data from the sessions
	 * array, to wait till the next time the page is loaded to do their action.  This is
	 * a hack because the message queue system will loose messages after a redirect.
	 * Returns FALSE if there is no session started, and TRUE if the redirct instruction
	 * was added.
	 *
	 * @param	string	$url		The URL to redirect to
	 * @return	bool
	 */
	function addSessionRedirect($url) {
		if (!isset($_SESSION)) {
			return false;
		}
		
		$_SESSION['alinks_redirect'] = $url;
		$_SESSION['alinks_wait'] = 1;
		return true;
	}
	
	/**
	 * Do any redirects in the session variable
	 *
	 * If there are any URL redirect instructions in the session variable, this method
	 * will redirect to the URL in the instruction.  Returns FALSE if there are no
	 * redirect instructions in the sessions variable, and returns void if a redirect
	 * was put into the HTTP header.
	 *
	 * @return	bool
	 */
	function doSessionRedirect() {
		if (!isset($_SESSION['alinks_redirect'])) {
			return false;
		}

		$url = $_SESSION['alinks_redirect'];
		unset($_SESSION['alinks_redirect']);
		header("Location: $url");
	}
	
	/**
	 * Recursively delets directories and files in them
	 *
	 * Used similar to PHP's rmdir() function, but this also deletes any files in
	 * the directory, and any directories in the directory.
	 *
	 * @param	string	$dir		The directory to delete
	 * @return	mixed
	 */
	function removeDir($dir) {
		if (!is_readable($dir)) return;
		$handle = opendir($dir);
		while (false!==($item = readdir($handle))) {
			if($item != '.' && $item != '..') {
				if(is_dir($dir.'/'.$item)) {
					$this->removeDir($dir.'/'.$item);
				} else {
					unlink($dir.'/'.$item);
				}
			}
		}
		closedir($handle);
		if(rmdir($dir)) {
			$success = true;
		}
		return $success;
	}
	
	/**
	 * Strip slashes from an array
	 *
	 * Similar to PHP's stripslashes() function, except this method works on deep multidimentional
	 * arrays.
	 *
	 * @param	mixed	$value	The array or single value to strip slashes from
	 * @return	mixed
	 */
	function stripSlashesDeep($value) {
	   $value = is_array($value) ? array_map(array(&$this, 'stripSlashesDeep'), $value) : stripslashes($value);
	   return $value;
	}
	
	/**
	 * Gets a list of directories in a top directory
	 *
	 * Scans through the given directory and returns an array of
	 * all sub directories.  Returns FALSE on failure.
	 *
	 * @param	string	$dir	The name of the directory to scan
	 * @return	mixed
	 */
	function getDirs($dir) {
	    if(is_dir($dir)) {
			$dirlist = opendir($dir);
			while(($file = readdir($dirlist)) !== false) {
				if(is_dir($dir . '/' . $file) && $file != '.' && $file != '..') {
					$dirs[] = $file;
				}
			}
	        return $dirs;
		} else {
			return false;
			break;
		}
	}
	
	/**
	 * Lets objects register with the class to be notified of events.
	 *
	 * @param	obj	$obj		The object to be notified
	 * @return	void
	 */
	function notifyMe(&$obj) {
		$this->notifyObjs[] = &$obj;
		return true;
	}
	
	/**
	 * Notifies registered objects of an event.
	 *
	 * @param	string	$method	The method the event occured in
	 * @param	string	$message	A message describing the event
	 * @return	void
	 */
	function notifyObjects($method, $message) {
		if (empty($this->notifyObjs)) {
			return false;
		}
		foreach ($this->notifyObjs as $obj) {
			if (method_exists($obj, 'notify')) {
				$obj->notify($method, $message, $this);
			}
		}
	}
	
	function notify($method, $message) {
	}
}