<?php
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package   alinks
 * @license   GPL
 * @version   $Id: aLinksAjax.php 44 2008-03-24 18:00:53Z sean $
 */
include_once('../../../../wp-config.php');

/**
 * aLinks Ajax class
 *
 * Used for Ajax request, and the click tracking.
 */
class aLinksAjax extends aLinksApp {
	
	var $alinksModel;
	
	function aLinksAjax(&$alinksModel) {
		$this->alinksModel = &$alinksModel;
		
		$contents = file_get_contents('php://input');
		if (!empty($contents)) {
			$this->doPost($contents);
		}
		
		if ($_GET['log']) {
			$this->logKeyphrase($_GET['log']);
			$this->sendXml = false;
		}
	}
	
	function doPost($contents) {
		if(get_magic_quotes_gpc() || get_magic_quotes_runtime()) {
			$contents = $this->stripSlashesDeep($contents);
		}
		parse_str($contents);
		switch ($action) {
			case 'log_keyphrase':
				$this->logKeyphrase($keyphrase);
				break;
		}
	}
	
	function logKeyphrase($keyphrase) {
		$alinksLogger = new aLinksLogger(ALINKS_LOG_PATH);
		$ip = $_SERVER['REMOTE_ADDR'];
		$timestamp = time();
		if ($this->alinksModel->getSetting('offsethours')) {
			$offset = $this->alinksModel->getSetting('offsethours');
			$timestamp += ($offset * 3600);
		}
		echo $alinksLogger->query("INSERT INTO alinks VALUES('$keyphrase', '$timestamp', '$ip')");
		$this->notifyObjects('aLinksAjax::logKeyphrase', 'Keyphrase-Logged::' . $keyphrase);
	}

}
new aLinksAjax($alinksModel);