<?php
/**
Plugin Name: aLinks
Plugin URI: http://www.headzoo.com/alinks
Description: A WordPress plugin that automatically links keywords in your blog post.
Author: Sean Hickey
Version: 1.0rc2
Author URI: http://www.headzoo.com
*/
/**
 * aLinks WordPress Plugin
 *
 * A WordPress plugin that automatically links keywords in your
 * blog post.
 *
 * @author    Sean Hickey <seanhickey@gmail.com>
 * @package   alinks
 * @license   GPL
 * @version   $Id: alinks.php 53 2008-03-24 18:29:33Z sean $
 */

if (!isset($_SESSION)) {
	session_start();
}

define('ALINKS_VERSION',			.99); // <-- .99 == 1.0rc2
define('ALINKS_PATH', 				ABSPATH . 			'wp-content/plugins/alinks');
define('ALINKS_URL',				get_option('siteurl') . 	'/wp-content/plugins/alinks');
define('ALINKS_CLASSES_PATH', 		ALINKS_PATH . 		'/classes');
define('ALINKS_CLASSES_URL',		ALINKS_URL .			'/classes');
define('ALINKS_FUNCTIONS_PATH', 	ALINKS_PATH . 		'/functions');
define('ALINKS_VIEWS', 			ALINKS_PATH . 		'/views');
define('ALINKS_LANGUAGES_PATH', 	ALINKS_PATH . 		'/languages');
define('ALINKS_MODULES_PATH', 		ALINKS_PATH . 		'/modules');
define('ALINKS_MODULES_URL',		ALINKS_URL . 			'/modules');
define('ALINKS_JS_URL', 			ALINKS_URL . 			'/js');
define('ALINKS_TMP_PATH',			ALINKS_PATH . 		'/tmp');
define('ALINKS_LOG_PATH',			ALINKS_PATH . 		'/logs');

require(ALINKS_FUNCTIONS_PATH . '/hacks.php');
require(ALINKS_FUNCTIONS_PATH . '/unicode.php');
require(ALINKS_CLASSES_PATH . '/aLinksApp.php');
require(ALINKS_CLASSES_PATH . '/aLinksModel.php');
require(ALINKS_CLASSES_PATH . '/aLinksController.php');
require(ALINKS_CLASSES_PATH . '/aLinksView.php');
require(ALINKS_CLASSES_PATH . '/aLinksLang.php');
require(ALINKS_CLASSES_PATH . '/aLinksModules.php');
require(ALINKS_CLASSES_PATH . '/aLinksKeyphrases.php');
require(ALINKS_CLASSES_PATH . '/aLinksXml.php');
require(ALINKS_CLASSES_PATH . '/aLinksForms.php');
require(ALINKS_CLASSES_PATH . '/aLinksImportExport.php');
require(ALINKS_CLASSES_PATH . '/aLinksLogger.php');
require(ALINKS_CLASSES_PATH . '/aLinksXmlrpc.php');
require(ALINKS_CLASSES_PATH . '/aLinksStruct.php');

$alinksStruct = new aLinksStruct;
$alinksStruct->add('alinks_path', 			ALINKS_PATH);
$alinksStruct->add('alinks_url', 			ALINKS_URL);
$alinksStruct->add('alinks_classes_path', 	ALINKS_CLASSES_PATH);
$alinksStruct->add('alinks_classes_url', 	ALINKS_CLASSES_URL);
$alinksStruct->add('alinks_functions_path',	ALINKS_FUNCTIONS_PATH);
$alinksStruct->add('alinks_views', 			ALINKS_VIEWS);
$alinksStruct->add('alinks_languages_path', 	ALINKS_LANGUAGES_PATH);
$alinksStruct->add('alinks_modules_path', 	ALINKS_MODULES_PATH);
$alinksStruct->add('alinks_modules_url', 	ALINKS_MODULES_URL);
$alinksStruct->add('alinks_js_url', 			ALINKS_JS_URL);
$alinksStruct->add('alinks_tmp_path', 		ALINKS_TMP_PATH);
$alinksStruct->add('alinks_log_path', 		ALINKS_LOG_PATH);

global $wpdb, $table_prefix;
$alinksModel = new aLinksModel($wpdb, $table_prefix, $alinksStruct);
$alinksController = new aLinksController($alinksModel, $alinksStruct);
aLinksApp::doSessionRedirect();